label thereturn:

    $ renpy.pause(1.5)

    show bg car
    with Dissolve(5.0)

    window show dissolve

    i "We tossed the supplies in the trunk and piled into the same car that Sal's friend was driving when he gave us a ride back to town a few nights ago."

    i "Just being in that car again brought it all back to the front of our minds. It was a silent, sobering reminder of what had happened, and what we were about to do."

    i "Even though it was the fine chariot that had ushered us to safety, the intensity of that evening was still lingering in it somehow."

    i "The vague unease grew stronger as we rode toward the forest, congealing into a translucent red-black energy that thickened the air around us."
    
    i "It hurt to breathe it in. I forced myself to, to face the reality of the situation."


    stop music fadeout 5.0
    
    window hide dissolve

    show bg black 
    with Dissolve (3.0)

    $ renpy.pause(1.0)

    window show dissolve

    i "The drive back was quiet, and really, what was there to say?"

    i "Nothing but the sound of the engine and tires against asphalt took the place of two very uncomfortable peoples' silence."

    i "Soon enough, Sal turned off the main road and came to a stop just outside the wooded area we'd emerged from a few evenings ago."

    i "She cut the engine and took the key out of the ignition, sliding it into her pocket."

    i "For a few moments the both of us sat there as if waiting for the other to make the first move."

    i "Just as I was about to open my mouth and say something, Sal unfroze and threw open her door."

    s "We're going to have to hoof it the rest of the way."

    s "I don't wanna take this thing all the way in and not be able to get it back out without the help of a tow truck or something."

    i "I nodded silently, sliding my hand down to the handle of the passenger seat door, pulling it slowly and pushing the door open."

    play music "sound/music/The Warehouse.ogg" fadein 5.5

    window hide dissolve

    show bg sky
    with Dissolve(3.0)

    window show dissolve

    i "We made our way to the back of the car and Sal popped the trunk."

    i "She silently removed the few items we'd be using to take care of this, one by one."

    i "Her backpack, which contained the supplies we'd need to clean the blood, and a large shovel that sent chills down my spine when she pulled it out."

    s "Guess we already kinda know the way, huh?"

    i "It was a weak attempt at humor, but one I completely understood."

    t "We even get to take in the beautiful sights this time 'round."

    i "It wasn't working, and we both knew it, so we quietly turned toward the trail and began the short trek to the warehouse."

    window hide dissolve

    show bg trail
    with Dissolve(2.0)

    $ renpy.pause(3.0, hard=True)

    show bg forest
    with Dissolve(2.0)

    $ renpy.pause(3.0, hard=True)

    show bg warehousedoorfar
    with Dissolve(2.0)

    window show dissolve

    i "It wasn't long before the abandoned warehouse revealed itself through the trees and we found ourselves right back where all of this started."

    i "Not that we'd really stopped to admire it or anything on the way out, but getting a look at it after the fact... it certainly gave off an imposing vibe. I wanted to turn back immediately."
    
    show sal2_scas
    with dissolve

    s "Shit..."

    s "Didn't even close the damn place up when we left.  That was careless."

    i "I wasn't sure how to respond."
    
    show sal2_conf
    with dissolve
    hide sal2_scas

    s "Let's just hope nobody got here before we did..."

    i "I followed closely behind Sal as we approached the building to have a look inside..."
    
    hide sal2_conf
    with dissolve

    window hide dissolve

    show bg warehousedoorclose
    with Dissolve(2.0)

    $ renpy.pause(3.0, hard=True)

    show bg warehouse
    with Dissolve(2.0)

    $ renpy.pause(2.0, hard=True)

    window show dissolve

    i "As we stepped into the main warehouse-ey part of the... well... warehouse, I found myself surprised at how {i}still{/i} the place felt."

    i "It was obviously quiet, save for the sound of our footsteps as we moved around, but there was something... {w=1.0}different."

    i "When Sal and I had made our escape, I remembered the suffocating atmosphere, the nagging ringing in my ears, and brief moments of static I could still feel all the way up until we'd pushed the door open to leave."

    i "Aside from the slight haze of dust in the air from what had to be years of non-use and neglect, this seemed like any normal ordinary warehouse."

    i "Sal seemed more intense as she surveyed the area."
    
    i "She craned her neck, looking the room up and down and intensely concentrated as if she was...{w=1.0} less looking for something and more{w=1.0} listening."

    i "I heard her murmur quietly..."
    
    show sal2_cons
    with dissolve

    s "...not here..."

    t "What?"
    
    s "...they're not here..."
    
    t "Sal, what?"
    
    show sal2_conf
    with dissolve
    hide sal2_cons

    i "Her attention snapped back to me."

    s "Huh? Oh, uh, nothing. By the way..."

    i "She held out a weird object toward me."

    s "You're probably gonna wanna put this on."

    i "I was confused for a moment before I realized what it was."

    i "A respirator."

    s "It's... {w=1.0}not gonna be very pleasant down there. I don't even know how well these things will hold up, but something's better than nothing."

    i "I silently nodded toward her as I took the respirator, adjusted the elastic band around my head, and pulled the mask down over my face."

    s "Oh yeah, hold on..."

    i "She rested the handle of the shovel against her side as she dug into her backpack, removed two sets of latex gloves, and tossed one of them to me."

    s "Put those on."

    i "I followed her simple order without question, putting the gloves on, knowing full well why I'd be needing them."

    i "Another pregnant pause filled the moment as we looked around the room at nothing in particular. Sal slipped one backpack strap over her left shoulder."

    s "Alright. Let's...{w=1.0} do this..."
    
    hide sal2_conf
    with dissolve    

    i "Slipping her mask on as she lead the way further into the musty warehouse, Sal craned her neck looking around for exactly where it was we needed to go."

    i "Even though we'd managed to get ourselves out of here, we weren't intimately familiar with the place. It took us a few moments to find the right set of stairs that led down to our former holding area."

    i "Sal approached the stairs to begin her descent, then stopped in her tracks."
    
    show sal2_bref
    with dissolve

    s "Tocco...{w=1.0} I mean it..."

    s "You don't have to come down here with me."

    i "I didn't say a word."

    i "It wasn't that I was trying to show any kind of hot-blooded resolve to see this thing through. It was more that, to me, there wasn't any going back at this point."

    i "I wasn't prepared for it, but I knew exactly what we were stepping into."

    i "Going with whatever answer she inferred my silence to be, Sal took the first step down with me following close behind her."
    
    stop music fadeout 10.0
    
    hide sal2_bref
    with dissolve

    window hide dissolve

    show bg staircase
    with Dissolve(3.0)

    window show dissolve

    i "As she reached the final step she stopped just short of the doorway to the basement."

    i "I looked down and saw her balling her fists at her sides."

    t "Sal..."

    s "Just... {w=1.0}give me a minute, okay?"

    i "Her tone was stern, but I could hear a subtle crack in her voice. This was churning her insides just as much as it was mine."

    i "She stood in front of me for what felt like a few minutes, breathing heavily and muttering to herself. In reality it was probably only a dozen or so seconds."

    i "My anxiety got the best of me."

    i "She may have wanted to stand there and try to psych herself up, but every second that passed I was only balling up inside even harder."

    i "Fight or flight was going to win this moment."

    i "Without a word, I gently pulled Sal to the side of the small stairwell and moved past her through the doorway."

    s "H-Hey! Wait!"
    
    window hide
    
    show bg black
    with Dissolve(3.0)
    
    $renpy.pause(1.0)

    i "{cps=30}Ignoring her protests, I passed through the open door... {w=1.0}and found myself back where it all began.{/cps}"
    
    $renpy.pause(2.0)
    
    window hide

    show bg darkroom
    with Dissolve(3.5)

    $renpy.pause(2.0)

    window show dissolve

    i "{cps=30}The gravity of knowing where I stood hit me all at once.{/cps}"

    i "{cps=30}This was where I was...{w=1.0} meant to die.{/cps}"

    i "The notion paralyzed me as my mind raced, trying to come to grips with things."

    i "That said, much like the upper level of the warehouse, something down here felt...{w=1.0} {i}different.{/i}"

    i "Even though the lighting was just as I'd remembered it, the room seemed somewhat brighter as my eyes began to take in more of the surroundings."

    i "On instinct, my hands shot up to cover my ears. But there was no reason to do so."

    i "There was no static...{w=1.0} no headache...{w=1.0} no ringing..."

    i "The basement was suspended in a cloud of silence, which was something I never imagined I'd associate with this place."

    i "I heard Sal finally take the last step down and enter the room behind me, tapping me on the shoulder and whispering in my ear."
    
    show sal2_bref
    with dissolve

    s "Hey... you okay?"
    
    i "I responded, mirroring her hushed tone."

    t "Y-yeah... I'm fine."

    t "I was just, wondering how long that oil lamp was gonna keep burning."

    s "Headache? {w=1.0}Ringing? {w=1.0}Anything?"
    
    i "She blazed right past my quip. I shook my head quickly, knowing she was worried."

    i "There was...{w=1.0} really no hiding our feelings at this point."

    i "The...{w=1.0} {i}incident{/i}{w=1.0} had happened a bit further into the room, to the right side of the entryway."

    i "There was no escaping it any longer..."
    
    play music "sound/music/The Burial.ogg" fadein 10.0
    
    window hide dissolve
    
    show sal2_bres
    with dissolve
    hide sal2_bref

    $ renpy.pause(2.5)

    window show dissolve

    i "Just as she was when we left, Lori laid motionless, face down on the floor atop an immense pool of blood."
    
    i "It had dried in the past few days. There was no question she was dead."

    i "Despite what I'd seen in my nightmares, there was no bloodied monster Lori that was going to kill me or make me kill someone else."

    i "I looked to Sal to gauge her reaction. It wasn't much different than mine."

    i "We stood silent for a moment, both unsure of where we should progress from here. A much more complex set of thoughts and emotions had risen to the top of our minds that neither of us were sure how to deal with."
    
    show sal2_bref
    with dissolve
    hide sal2_bres

    s "We have to get started."

    i "She still spoke in a whisper, probably wanting to keep the place as quiet as possible, despite the fact that nobody else was around and we weren't followed."

    s "We'll get her last. Right now, let's just clear the room of everything we can."

    t "Right."
    
    hide sal2_bref
    with dissolve

    i "With that, Sal's attention turned immediately toward the doorway we'd just entered from."

    window hide dissolve

    show bg camera
    with Dissolve(2.0)

    window show dissolve

    i "The camera."

    i "It'd captured everything that happened here."

    i "{i}Everything.{/i}"

    i "It was just another reminder to make it all sink in."

    i "What gruesome scenes had this camera recorded?"

    i "It wasn't lost on me that it had also seen this hellish nightmare's first escapees, and ultimately witnessed the death of its orchestrator as well."

    i "For some reason, it wasn't the guns or the knives that put it all into perspective for me."

    i "It was that little eye on the door that had beheld things I didn't even want to imagine."

    window hide dissolve

    show bg darkroom
    with Dissolve(2.0)

    window show dissolve

    i "Sal made quick work of unmounting the contraption from the door.  It was almost like she was familiar with that kinda thing, but there wasn't much reason to dwell on it."

    i "She stuffed the camera and any of its loose wiring into her backpack and turned her attention back to the room."
    
    show sal2_bref
    with dissolve

    s "Knives, gun, broken cellphone. Anything else?"

    i "I paused and thought for a moment."

    t "She had a syringe. I think she dropped it."

    s "Right, right."

    s "I don't know where it woulda went, so keep an eye out."

    t "Sure."
    
    hide sal2_bref
    with dissolve

    i "With that, we went our separate ways in the room to investigate."

    i "The last I'd seen Lori with the syringe was when she threatened me, so I made my way to the wall she'd backed me into and looked around the floor."

    i "It was easier to find than I thought, especially given the relatively poor lighting."

    i "I bent over and carefully picked the syringe up by the barrel, holding it delicately between my fingers."

    t "Sal!"

    i "Speaking barely above a whisper I called out to her."

    t "Found it!"

    i "Sal hurriedly made her way over to me, taking a moment to eye the syringe."
    
    show sal2_bref
    with dissolve

    s "No cap?"

    t "No, I didn't see one."

    s "Okay."

    i "Sal carefully took the syringe from between my fingers, aiming the needle away from the both of us and pressing the plunger to eject whatever liquid the barrel had been storing."

    s "Gonna have to be real careful with this."

    i "She slipped her backpack off her shoulder, opened it up, and dug around inside it for a few moments. She eventually pulled out what looked like a few wash rags and used them to carefully wrap the needle."
    
    i "She then shuffled some things around in her bag, and stuffed the syringe deeply into it."

    s "It'll do for now."

    t "Okay."

    s "I also found the uhhh...{w=1.0} bloody knife."

    s "Don't really imagine you wanna see that though."

    t "No...{w=1.0} not particularly."
    
    hide sal2_bref
    with dissolve

    i "We wordlessly separated once again."

    i "Given how big the upper facility was, the basement seemed much smaller than one would think."

    i "The diminished lighting gave the room a slightly larger look than it actually possessed, and it didn't take long to find the things we needed to."

    i "I located the parts of my smashed cellphone rather easily."

    i "Given how violently I'd thrown it against the wall and the sorry state it was in, I couldn't be sure I'd found all of it. But I didn't think anyone would be suspicious of a stray fragment or two."

    i "A small glint caught my eye, forcing my gaze down and to the right."

    i "I wasn't surprised when I'd fully processed what it was."
    
    i "The gun."

    i "I didn't know exactly where Sal had thrown it when we were last here. It felt like someone was having a really good laugh at me being the one to find it."

    i "I watched Sal retrieve the other knife from the opposite side of the room and slip it into her pack. Then I snapped my fingers and motioned for her to come over."
    
    show sal2_bres
    with dissolve

    i "She made her way toward me, stopping just short of the spot on the ground my eyes were directing her to."

    i "Sal inhaled and exhaled sharply, looking up at the ceiling, clearly more affected by this than anything else so far."

    i "For obvious reasons, neither of us wanted to touch it."

    i "We just stood there, silently looking at one another and back to the gun again."

    s "God..."

    i "Sal laboriously knelt to one knee, picking the gun up by the grip."

    i "Without a word, she aimed gun's barrel to the ground and pressed her thumb against the magazine release button on the side of the grip, ejecting what appeared to be a mostly full clip."

    i "She didn't stop to count or eject any of the unspent ammo, and simply tossed the magazine into her backpack."

    i "After that, she pulled the slide back, turned the gun upside down, and checked the chamber with a closer look to ensure that it was fully unloaded."

    i "When she was sure the gun was clear, she pushed the slide back into position and, just like all the other dangerous things so far, stuffed it into her backpack."

    i "I also handed her the scraps of cellphone I'd managed to recover which, of course, saw the same treatment."

    t "So...{w=1.0} what are we doing with all this stuff?"

    i "Sal stopped and thought for a moment."
    
    show sal2_bref
    with dissolve
    hide sal2_bres

    s "We're taking it with us."

    t "What!?"

    i "For the first time someone had spoken above a whisper, but I was quickly shushed by Sal."

    s "I don't like leaving anything on-site that could be traced back to us."

    t "So, what are we doing with it?"

    i "Sal reached over and put her hand on my shoulder. A small reassurance that she at least {i}felt{/i} like she knew what she was doing."

    s "The knives and syringe are easy. I can clean those up and dump them anywhere, any time."

    s "I got a friend who can get rid of the gun, too. No one will ever know we were anywhere near it."

    i "I didn't really have anything to say to that."

    i "She'd...{w=1.0} really thought all this out."

    s "Did you have anything in your coat that may have fallen out while we were down here?"

    t "No...{w=1.0} I{w=1.0} don't think so."
    
    show sal2_bres
    with dissolve
    hide sal2_bref

    s "Alright..."

    s "Well..."

    t "Yeah..."

    i "The simple one-word exchanges said all they needed to."

    i "We knew what we had to do, and neither of us were looking forward to it."

    i "Stalling wasn't gonna make it any easier..."
    
    hide sal2_bres
    with dissolve

    window hide dissolve

    show bg basement_door
    with Dissolve (2.0)

    $ renpy.pause(3.0)

    window show dissolve

    i "We slowly approached Lori's corpse, stopping in front of it to decide on a course of action."
    
    show sal2_bref
    with dissolve

    s "...I need to check her."

    t "W-what?"

    s "To see if she's got anything on her that might link her to us."

    i "I bit my lower lip and exhaled..."
    
    show sal2_bres
    with dissolve
    hide sal2_bref

    s "I...{w=1.0} might need some help getting her over."

    i "I just nodded. What else was I gonna do?"
    
    hide sal2_bres
    with dissolve

    i "The respirators Sal had brought were helping to keep the scent out, but being this close, it wasn't hard to tell that the stench of death was strong."

    i "Sal knelt down near Lori's upper torso while I took a place near her midsection."

    i "She reached over and grabbed Lori's shoulder and arm."
    
    show sal2_bref
    with dissolve

    s "Okay, so...{w=1.0} I need you to get up under her waist and hip and just push her over, following my motion."

    t "Y...{w=1.0} yeah."

    s "Alright...{w=1.0} One.{w=1.0} Two.{w=1.0} Three."
    
    hide sal2_bref
    with dissolve

    i "Sal tried to pull Lori's body over using her arm and shoulder, then pushed her by the chest once the shifting weight had allowed us to move her onto her side."

    i "Lori had always seemed petite to me, but I quickly learned that the term \"dead weight\" had some real meaning."

    i "Getting her onto her back wasn't as difficult as getting the process started, as we simply let her weight and gravity pull her back down."
    
    window hide dissolve
    
    play sound "sound/sfx_body.wav"

    $ renpy.pause(1.5, hard=True)
    
    window show dissolve

    i "Her back crashed to the floor and a sickening thud reverberated throughout the room. Both of us instinctively recoiled."

    i "I scurried backwards and to my feet trying not to fall, and Sal did much the same, stumbling a few steps backward and bracing herself against the wall."

    i "Once I'd regained my composure, I again slowly approached Lori's body."

    i "I'd been to funerals before. I knew what dead bodies looked like."

    i "This was...{w=1.0} much different."

    i "At a funeral, the body's all gussied up to look its best, even with the lack of color in the skin and all."

    i "Lori looked...{w=1.0} {i}miserable{/i}."

    i "The still expression she wore on her face looked as if she'd died in utter agony, or at least that's what my brain was telling me the longer I fixated on her."

    i "Dried blood covered the corners of her mouth, no doubt from the wound she'd suffered from being shot."

    i "Was she...{w=1.0} still alive when we left?"

    i "Did she just...{w=1.0} slowly bleed out all alone in this cold, dirty basement?"

    i "..."

    i "{i}What were your...{w=1.0} last moments like...?{/i}"

    i "{i}Did you...{w=1.0} regret any of this?{/i}"

    i "Before I could dwell too much on those matters, Sal once again approached Lori's corpse, kneeling beside her and taking a deep breath before slipping her hands into each of her pants pockets."

    i "She was doing her best not to even look as she hastily rummaged around, finally retrieving an item from the front right pants pocket."

    i "She paused for a moment and rose to her feet, bringing me whatever it was she'd fished out."

    i "It was Lori's cellphone."
    
    show sal2_bref
    with dissolve

    s "I dunno if there's anything on this you might wanna keep. We can give it a charge and let you look before disposing of it if you want."

    i "I weakly eyed the phone, pondering if anything on the device would be worth keeping."

    i "Pictures? {w=1.0}Old texts?{w=1.0}"

    i "What would any of it really mean?"

    i "The Lori I knew was gone...{w=1.0} if she ever even existed in the first place."

    t "No."

    t "Get rid of it."

    i "Sal popped the back off of the phone, removing its battery, SIM card, and SD card before tossing it all in her backpack."

    s "Alright, then."

    s "That should be everything."

    s "We'll take care of her first, then come back and scrub this area down."

    i "I nodded."

    s "Let's go...{w=1.0} dig a hole then."
    
    hide sal2_bref
    with dissolve

    window hide dissolve

    show bg staircase
    with Dissolve(2.0)

    $ renpy.pause(2.5)

    show bg warehouse
    with Dissolve(2.0)

    $ renpy.pause(2.5)

    show bg warehousedoorclose
    with Dissolve(2.0)

    $ renpy.pause(2.5)

    show bg forest
    with Dissolve(2.0)

    $ renpy.pause(2.5)

    window show dissolve

    i "We made our way back outside into the fresh air, able to remove our respirators and catch a bit of a breather."

    i "Though nothing we'd done yet was all that physically exhausting, it was taxing nonetheless, and we both needed a moment to find ourselves."

    i "After a few minutes, we surveyed the area behind the warehouse for a place to dig, opting for a spot about ten or so feet away from the building. The ground seemed loose enough to dig into, but sturdy enough to hold shape."

    window hide dissolve

    show bg shovel
    with Dissolve(3.0)

    window show dissolve

    i "Without much in the way of preparation, Sal slipped her backpack from her shoulder, grasped the shovel's handle with both hands, and dug into the ground."

    play sound "sound/sfx_shovel.wav"

    i "She'd apparently only had time to prepare one shovel, so we were going to have to take it in shifts, especially given that her arm wound was still fairly fresh."

    i "As the sun beat down on us, I lost track of time between my shifts at digging the hole and trying to numb my mind to what we were doing."

    i "After a while, our actions started to feel automatic."

    i "Digging in, tossing dirt out, trading off..."

    i "We had no real way to measure how deep we'd gone, and Sal stopped checking her phone after the two-hour mark."

    i "It wasn't until I saw the shovel flung up out of the hole by Sal that I realized she was likely satisfied with the hole's depth."

    s "This should be good."

    i "I offered her my hand, helping her up out of the makeshift grave we'd spent the last God-knows-how-many hours completing, and we made our way back into the warehouse."

    stop sound fadeout 3.0

    window hide dissolve

    show bg warehousedoorclose
    with Dissolve(2.0)

    $ renpy.pause(2.5)

    show bg warehouse
    with Dissolve(2.0)

    $ renpy.pause(2.5)

    show bg staircase
    with Dissolve(2.0)

    $ renpy.pause(2.5)

    show bg darkroom
    with Dissolve(2.0)

    $ renpy.pause(2.5)

    window show dissolve

    i "We'd already spent enough time back at this hellish place, so we went back inside without stalling."

    i "Transporting Lori's body out of the warehouse wasn't going to be an easy task, but we handled things as best we could, given the circumstances."

    i "Given Sal's arm injury, I opted to carry Lori by her torso and arms, while Sal took her legs."

    i "At the very least, we didn't have to carry her far. The only tricky part was negotiating the stairwell, but we more or less had as straight a shot to the grave as we could get."

    window hide dissolve

    show bg staircase
    with Dissolve(2.0)

    $ renpy.pause(2.5)

    show bg warehouse
    with Dissolve(2.0)

    $ renpy.pause(2.5)

    show bg warehousedoorclose
    with Dissolve(2.0)

    $ renpy.pause(2.5)

    show bg forest
    with Dissolve(2.0)

    $ renpy.pause(2.5)

    window show dissolve

    i "Once we'd gotten her outside, we carefully lowered Lori's body into the grave."

    i "It took more than a little bit of sophisticated coordination to get her into the hole and flat on her back just right."

    i "We could have just tossed her in any old way, and thinking on her actions, that was probably what she did to her victims. But I figured Sal wanted to show at least a tiny amount of respect for my sake."

    i "Once we'd finished resting her body in the ground and climbed out of the hole ourselves, we both paused for a brief moment beside the grave to look at her one last time."

    i "A moment of silence."
    
    i "Again, more than she'd likely ever afforded any of her victims, but a courtesy I felt Sal wanted to show."
    
    show sal2_bres
    with dissolve

    stop music fadeout 5.0

    s "Ummm... Tocco..."

    s "I...{w=1.0} ummm...{w=1.0} well..."

    s "Is there...{w=1.0} anything you'd like to say...{w=1.0} ya know...{w=1.0} before we..."

    i "Choking back the tears I'd let build up this entire time as best I could, I stared out through the trees, taking in the vibrance of the warm, evening sky."
    
    hide sal2_bres
    with dissolve

    window hide dissolve

    $ renpy.pause(3.5)

    show bg black

    window show dissolve

    $ renpy.pause(2.5, hard=True)

    narrator "{cps=5}Goodbye, Lori.{/cps}"
    
    $ renpy.pause(6)
    
    jump salleaves
