/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.jxinput;

import de.hardcode.jxinput.JXInputDevice;
import de.hardcode.jxinput.directinput.DirectInputDevice;
import de.hardcode.jxinput.event.JXInputEventManager;
import de.hardcode.jxinput.keyboard.JXKeyboardInputDevice;
import de.hardcode.jxinput.virtual.JXVirtualInputDevice;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;

public class JXInputManager {
    private static long mTimeOfLastUpdate;
    private static final ArrayList mDevices;
    private static final ArrayList mDIDevices;
    private static final ArrayList mVirtualDevices;
    private static final ArrayList mKBDevices;

    private JXInputManager() {
    }

    public static int getNumberOfDevices() {
        return mDevices.size();
    }

    public static JXInputDevice getJXInputDevice(int n) {
        if (n >= mDevices.size()) {
            return null;
        }
        return (JXInputDevice)mDevices.get(n);
    }

    public static synchronized void reset() {
        int n;
        JXInputEventManager.reset();
        mDevices.clear();
        mVirtualDevices.clear();
        mDIDevices.clear();
        DirectInputDevice.reset();
        for (n = 0; n < DirectInputDevice.getNumberOfDevices(); ++n) {
            DirectInputDevice directInputDevice = new DirectInputDevice(n);
            mDevices.add(directInputDevice);
            mDIDevices.add(directInputDevice);
        }
        DirectInputDevice.update();
        n = mKBDevices.size();
        for (int i = 0; i < n; ++i) {
            ((JXKeyboardInputDevice)mKBDevices.get(i)).shutdown();
        }
        mKBDevices.clear();
    }

    public static void updateFeatures() {
        long l = System.currentTimeMillis();
        long l2 = l - mTimeOfLastUpdate;
        DirectInputDevice.update();
        Iterator iterator = mVirtualDevices.iterator();
        while (iterator.hasNext()) {
            ((JXVirtualInputDevice)iterator.next()).update(l2);
        }
        mTimeOfLastUpdate = l;
        JXInputEventManager.trigger();
    }

    public static long getLastUpdateTime() {
        return mTimeOfLastUpdate;
    }

    public static JXKeyboardInputDevice createKeyboardDevice() {
        JXKeyboardInputDevice jXKeyboardInputDevice = new JXKeyboardInputDevice();
        mDevices.add(jXKeyboardInputDevice);
        mKBDevices.add(jXKeyboardInputDevice);
        return jXKeyboardInputDevice;
    }

    public static JXKeyboardInputDevice createKeyboardDevice(Component component) {
        JXKeyboardInputDevice jXKeyboardInputDevice = new JXKeyboardInputDevice(component);
        mDevices.add(jXKeyboardInputDevice);
        mKBDevices.add(jXKeyboardInputDevice);
        return jXKeyboardInputDevice;
    }

    public static void deleteKeyboardDevice(JXKeyboardInputDevice jXKeyboardInputDevice) {
        mDevices.remove(jXKeyboardInputDevice);
        mKBDevices.remove(jXKeyboardInputDevice);
        jXKeyboardInputDevice.shutdown();
    }

    public static JXVirtualInputDevice createVirtualDevice() {
        JXVirtualInputDevice jXVirtualInputDevice = new JXVirtualInputDevice();
        mDevices.add(jXVirtualInputDevice);
        mVirtualDevices.add(jXVirtualInputDevice);
        return jXVirtualInputDevice;
    }

    public static void deleteVirtualDevice(JXVirtualInputDevice jXVirtualInputDevice) {
        mDevices.remove(jXVirtualInputDevice);
        mVirtualDevices.remove(jXVirtualInputDevice);
    }

    static {
        mDevices = new ArrayList();
        mDIDevices = new ArrayList();
        mVirtualDevices = new ArrayList();
        mKBDevices = new ArrayList();
        JXInputManager.reset();
    }
}

