/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.jxinput.directinput;

import de.hardcode.jxinput.Axis;
import de.hardcode.jxinput.Button;
import de.hardcode.jxinput.Directional;
import de.hardcode.jxinput.JXInputDevice;
import de.hardcode.jxinput.directinput.DIAxis;
import de.hardcode.jxinput.directinput.DIButton;
import de.hardcode.jxinput.directinput.DIDirectional;
import de.hardcode.jxinput.directinput.DirectInputDriver;

public class DirectInputDevice
implements JXInputDevice {
    int mDeviceIdx;
    private DIAxis[] mAxes;
    private DIButton[] mButtons;
    private DIDirectional[] mDirectionals;

    public static int getNumberOfDevices() {
        if (DirectInputDriver.isAvailable()) {
            return DirectInputDriver.getNumberOfDevices();
        }
        return 0;
    }

    public static void update() {
        if (DirectInputDriver.isAvailable()) {
            DirectInputDriver.nativeupdate();
        }
    }

    public DirectInputDevice(int n) {
        this.mDeviceIdx = n;
        this.init();
    }

    public static void reset() {
        if (DirectInputDriver.isAvailable()) {
            DirectInputDriver.reset();
        }
    }

    private final void init() {
        int n;
        this.mAxes = new DIAxis[this.getMaxNumberOfAxes()];
        this.mButtons = new DIButton[this.getMaxNumberOfButtons()];
        this.mDirectionals = new DIDirectional[this.getMaxNumberOfDirectionals()];
        for (n = 0; n < this.mAxes.length; ++n) {
            if (!DirectInputDriver.isAxisAvailable(this.mDeviceIdx, n)) continue;
            this.mAxes[n] = new DIAxis(this.mDeviceIdx, n);
        }
        for (n = 0; n < this.mButtons.length; ++n) {
            if (!DirectInputDriver.isButtonAvailable(this.mDeviceIdx, n)) continue;
            this.mButtons[n] = new DIButton(this.mDeviceIdx, n);
        }
        for (n = 0; n < this.mDirectionals.length; ++n) {
            if (!DirectInputDriver.isDirectionalAvailable(this.mDeviceIdx, n)) continue;
            this.mDirectionals[n] = new DIDirectional(this.mDeviceIdx, n);
        }
    }

    public String getName() {
        String string = DirectInputDriver.getName(this.mDeviceIdx);
        if (null == string) {
            return "Win32 DirectInput Joystick";
        }
        return string;
    }

    public int getNumberOfButtons() {
        return DirectInputDriver.getNumberOfButtons(this.mDeviceIdx);
    }

    public int getNumberOfAxes() {
        return DirectInputDriver.getNumberOfAxes(this.mDeviceIdx);
    }

    public int getNumberOfDirectionals() {
        return DirectInputDriver.getNumberOfDirectionals(this.mDeviceIdx);
    }

    public int getMaxNumberOfButtons() {
        return DirectInputDriver.getMaxNumberOfButtons();
    }

    public int getMaxNumberOfAxes() {
        return DirectInputDriver.getMaxNumberOfAxes();
    }

    public int getMaxNumberOfDirectionals() {
        return DirectInputDriver.getMaxNumberOfDirectionals();
    }

    public Axis getAxis(int n) {
        return this.mAxes[n];
    }

    public Button getButton(int n) {
        return this.mButtons[n];
    }

    public Directional getDirectional(int n) {
        return this.mDirectionals[n];
    }
}

