/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.jxinput.directinput;

import de.hardcode.jxinput.directinput.Log;

class DirectInputDriver {
    private static final String NATIVE_LIB_NAME = "jxinput";
    static boolean sIsOperational = false;
    private static double[][] sAxisValues;
    private static boolean[][] sButtonStates;
    private static int[][] sDirectionalValues;

    private static final void init() {
        sIsOperational = false;
        if (DirectInputDriver.nativeinit()) {
            int n = DirectInputDriver.getNumberOfDevices();
            sAxisValues = new double[n][DirectInputDriver.getMaxNumberOfAxes()];
            sButtonStates = new boolean[n][DirectInputDriver.getMaxNumberOfButtons()];
            sDirectionalValues = new int[n][DirectInputDriver.getMaxNumberOfDirectionals()];
            DirectInputDriver.bind();
            sIsOperational = true;
        }
    }

    private DirectInputDriver() {
    }

    private static native boolean nativeinit();

    private static native void nativeexit();

    private static native void bind();

    static native int getNumberOfDevices();

    static native String getName(int var0);

    static native int getNumberOfAxes(int var0);

    static native int getNumberOfButtons(int var0);

    static native int getNumberOfDirectionals(int var0);

    static native int getMaxNumberOfAxes();

    static native int getMaxNumberOfButtons();

    static native int getMaxNumberOfDirectionals();

    static native boolean isAxisAvailable(int var0, int var1);

    static native String getAxisName(int var0, int var1);

    static native int getAxisType(int var0, int var1);

    static native boolean isButtonAvailable(int var0, int var1);

    static native String getButtonName(int var0, int var1);

    static native int getButtonType(int var0, int var1);

    static native boolean isDirectionalAvailable(int var0, int var1);

    static native String getDirectionalName(int var0, int var1);

    static native void nativeupdate();

    public static boolean isAvailable() {
        return sIsOperational;
    }

    static void shutdown() {
        DirectInputDriver.nativeexit();
        sAxisValues = null;
        sButtonStates = null;
        sDirectionalValues = null;
    }

    static void reset() {
        DirectInputDriver.shutdown();
        DirectInputDriver.init();
    }

    static double getAxisValue(int n, int n2) {
        return sAxisValues[n][n2];
    }

    static boolean getButtonState(int n, int n2) {
        return sButtonStates[n][n2];
    }

    static int getDirection(int n, int n2) {
        return sDirectionalValues[n][n2];
    }

    public static void main(String[] stringArray) {
        if (!sIsOperational) {
            return;
        }
        for (int i = 0; i < 5000; ++i) {
            DirectInputDriver.nativeupdate();
        }
        DirectInputDriver.shutdown();
    }

    static {
        try {
            System.loadLibrary(NATIVE_LIB_NAME);
            DirectInputDriver.init();
        }
        catch (SecurityException securityException) {
            Log.logger.warning("Native library jxinput not loaded due to a SecurityException.");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Log.logger.info("Native library jxinput not loaded due to an UnsatisfiedLinkError.");
        }
    }
}

