/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.jxinput.event;

import de.hardcode.jxinput.Axis;
import de.hardcode.jxinput.Button;
import de.hardcode.jxinput.Directional;
import de.hardcode.jxinput.JXInputManager;
import de.hardcode.jxinput.event.JXInputAxisEvent;
import de.hardcode.jxinput.event.JXInputAxisEventListener;
import de.hardcode.jxinput.event.JXInputButtonEvent;
import de.hardcode.jxinput.event.JXInputButtonEventListener;
import de.hardcode.jxinput.event.JXInputDirectionalEvent;
import de.hardcode.jxinput.event.JXInputDirectionalEventListener;
import java.util.ArrayList;

public class JXInputEventManager {
    private static final ArrayList mAxisEventListeners = new ArrayList();
    private static final ArrayList mButtonEventListeners = new ArrayList();
    private static final ArrayList mDirectionalEventListeners = new ArrayList();
    private static autotrigger mAutoTrigger = null;

    private JXInputEventManager() {
    }

    public static void reset() {
        mAxisEventListeners.clear();
        mButtonEventListeners.clear();
        mDirectionalEventListeners.clear();
    }

    public static void trigger() {
        Object object;
        int n;
        int n2 = mAxisEventListeners.size();
        for (n = 0; n < n2; ++n) {
            object = (axislistener)mAxisEventListeners.get(n);
            ((axislistener)object).checkTrigger();
        }
        n2 = mButtonEventListeners.size();
        for (n = 0; n < n2; ++n) {
            object = (buttonlistener)mButtonEventListeners.get(n);
            ((buttonlistener)object).checkTrigger();
        }
        n2 = mDirectionalEventListeners.size();
        for (n = 0; n < n2; ++n) {
            object = (directionallistener)mDirectionalEventListeners.get(n);
            ((directionallistener)object).checkTrigger();
        }
    }

    public static void setTriggerIntervall(int n) {
        if (null != mAutoTrigger) {
            JXInputEventManager.mAutoTrigger.mFinish = true;
            try {
                mAutoTrigger.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        mAutoTrigger = null;
        if (n > 0) {
            mAutoTrigger = new autotrigger(n);
            mAutoTrigger.start();
        }
    }

    public static void addListener(JXInputAxisEventListener jXInputAxisEventListener, Axis axis, double d) {
        mAxisEventListeners.add(new axislistener(jXInputAxisEventListener, axis, d));
    }

    public static void addListener(JXInputAxisEventListener jXInputAxisEventListener, Axis axis) {
        mAxisEventListeners.add(new axislistener(jXInputAxisEventListener, axis, axis.getResolution()));
    }

    public static void removeListener(JXInputAxisEventListener jXInputAxisEventListener) {
        mAxisEventListeners.remove(jXInputAxisEventListener);
    }

    public static void addListener(JXInputButtonEventListener jXInputButtonEventListener, Button button) {
        mButtonEventListeners.add(new buttonlistener(jXInputButtonEventListener, button));
    }

    public static void removeListener(JXInputButtonEventListener jXInputButtonEventListener) {
        mButtonEventListeners.remove(jXInputButtonEventListener);
    }

    public static void addListener(JXInputDirectionalEventListener jXInputDirectionalEventListener, Directional directional, double d) {
        mDirectionalEventListeners.add(new directionallistener(jXInputDirectionalEventListener, directional, d));
    }

    public static void addListener(JXInputDirectionalEventListener jXInputDirectionalEventListener, Directional directional) {
        mDirectionalEventListeners.add(new directionallistener(jXInputDirectionalEventListener, directional, directional.getResolution()));
    }

    public static void removeListener(JXInputDirectionalEventListener jXInputDirectionalEventListener) {
        mDirectionalEventListeners.remove(jXInputDirectionalEventListener);
    }

    private static final class autotrigger
    extends Thread {
        boolean mFinish = false;
        final int mDelay;

        autotrigger(int n) {
            this.mDelay = n;
        }

        public void run() {
            while (!this.mFinish) {
                try {
                    Thread.sleep(this.mDelay);
                    JXInputManager.updateFeatures();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static class directionallistener {
        final JXInputDirectionalEventListener mListener;
        final double mValueTreshold;
        final JXInputDirectionalEvent mEvent;
        double mLastValueFired = 0.0;
        boolean mLastCenteredFired = true;
        int mLastDirectionFired = 0;

        directionallistener(JXInputDirectionalEventListener jXInputDirectionalEventListener, Directional directional, double d) {
            this.mListener = jXInputDirectionalEventListener;
            this.mValueTreshold = d;
            this.mEvent = new JXInputDirectionalEvent(directional);
        }

        final void checkTrigger() {
            boolean bl;
            double d = this.mEvent.getDirectional().getValue();
            int n = this.mEvent.getDirectional().getDirection();
            boolean bl2 = this.mEvent.getDirectional().isCentered();
            double d2 = d - this.mLastValueFired;
            int n2 = n - this.mLastDirectionFired;
            boolean bl3 = bl = this.mLastCenteredFired != bl2;
            if (Math.abs(d2) >= this.mValueTreshold || Math.abs(n2) > 0 || bl) {
                this.mLastValueFired = d;
                this.mLastDirectionFired = n;
                this.mLastCenteredFired = bl2;
                this.mEvent.mValueDelta = d2;
                this.mEvent.mDirectionDelta = n2;
                this.mListener.changed(this.mEvent);
            }
        }
    }

    private static class buttonlistener {
        final JXInputButtonEventListener mListener;
        final JXInputButtonEvent mEvent;
        boolean mLastValueFired = false;

        buttonlistener(JXInputButtonEventListener jXInputButtonEventListener, Button button) {
            this.mListener = jXInputButtonEventListener;
            this.mEvent = new JXInputButtonEvent(button);
        }

        final void checkTrigger() {
            boolean bl = this.mEvent.getButton().getState();
            if (bl != this.mLastValueFired) {
                this.mLastValueFired = bl;
                this.mListener.changed(this.mEvent);
            }
        }
    }

    private static class axislistener {
        final JXInputAxisEventListener mListener;
        final double mTreshold;
        final JXInputAxisEvent mEvent;
        double mLastValueFired = 0.0;

        axislistener(JXInputAxisEventListener jXInputAxisEventListener, Axis axis, double d) {
            this.mListener = jXInputAxisEventListener;
            this.mTreshold = d;
            this.mEvent = new JXInputAxisEvent(axis);
        }

        final void checkTrigger() {
            double d = this.mEvent.getAxis().getValue();
            double d2 = d - this.mLastValueFired;
            if (Math.abs(d2) >= this.mTreshold) {
                this.mLastValueFired = d;
                this.mEvent.mDelta = d2;
                this.mListener.changed(this.mEvent);
            }
        }
    }
}

