/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.jxinput.j3d;

import de.hardcode.jxinput.JXInputManager;
import de.hardcode.jxinput.j3d.DeviceConfiguration;
import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import javax.media.j3d.SensorRead;
import javax.media.j3d.Transform3D;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class J3DInputDevice
implements InputDevice {
    private Vector3d mPosition = new Vector3d();
    private Transform3D mNewTransform = new Transform3D();
    private Transform3D mRotTransX = new Transform3D();
    private Transform3D mRotTransY = new Transform3D();
    private Transform3D mRotTransZ = new Transform3D();
    private Vector3d mInitPos = new Vector3d(0.0, 0.0, 0.0);
    private Sensor mSensor = new Sensor((InputDevice)this);
    private SensorRead mSensorRead = new SensorRead();
    private DeviceConfiguration mConfig;

    public J3DInputDevice(DeviceConfiguration deviceConfiguration) {
        this.mConfig = deviceConfiguration;
        this.setNominalPositionAndOrientation();
    }

    public void close() {
    }

    public int getProcessingMode() {
        return 4;
    }

    public Sensor getSensor(int n) {
        return this.mSensor;
    }

    public int getSensorCount() {
        return 1;
    }

    public boolean initialize() {
        return true;
    }

    public void pollAndProcessInput() {
        JXInputManager.updateFeatures();
        this.mSensorRead.setTime(JXInputManager.getLastUpdateTime());
        this.mRotTransX.rotX(this.mConfig.getRotational(0));
        this.mRotTransY.rotY(this.mConfig.getRotational(1));
        this.mRotTransZ.rotZ(this.mConfig.getRotational(2));
        this.mPosition.set(this.mConfig.getTranslational(0), this.mConfig.getTranslational(1), this.mConfig.getTranslational(2));
        this.mNewTransform.set(this.mPosition);
        this.mNewTransform.mul(this.mRotTransX);
        this.mNewTransform.mul(this.mRotTransY);
        this.mNewTransform.mul(this.mRotTransZ);
        this.mSensorRead.set(this.mNewTransform);
        this.mSensor.setNextSensorRead(this.mSensorRead);
    }

    public void processStreamInput() {
    }

    public void setNominalPositionAndOrientation() {
        this.mSensorRead.setTime(JXInputManager.getLastUpdateTime());
        this.mRotTransX.rotX(0.0);
        this.mRotTransY.rotY(0.0);
        this.mRotTransZ.rotZ(0.0);
        this.mPosition.set((Tuple3d)this.mInitPos);
        this.mNewTransform.set(this.mPosition);
        this.mNewTransform.mul(this.mRotTransX);
        this.mNewTransform.mul(this.mRotTransY);
        this.mNewTransform.mul(this.mRotTransZ);
        this.mSensorRead.set(this.mNewTransform);
        this.mSensor.setNextSensorRead(this.mSensorRead);
    }

    public void setProcessingMode(int n) {
        if (n != 4) {
            throw new IllegalArgumentException("Processing mode must be NON_BLOCKING");
        }
    }
}

