/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.jxinput.keyboard;

import de.hardcode.jxinput.Axis;
import de.hardcode.jxinput.Button;
import de.hardcode.jxinput.Directional;
import de.hardcode.jxinput.JXInputDevice;
import de.hardcode.jxinput.keyboard.InvalidKeyCodeException;
import de.hardcode.jxinput.keyboard.KeyButton;
import de.hardcode.jxinput.keyboard.KeyboardDriver;
import java.awt.Component;

public class JXKeyboardInputDevice
implements JXInputDevice {
    private static final String DEVICENAME = "Swing Keyboard";
    private final KeyboardDriver mDriver = new KeyboardDriver();
    private Component mComponent = null;
    private int mMaxIdxCreated = 0;

    public JXKeyboardInputDevice() {
    }

    public JXKeyboardInputDevice(Component component) {
        this.listenTo(component);
    }

    public final void listenTo(Component component) {
        this.shutdown();
        this.mComponent = component;
        this.mComponent.addKeyListener(this.mDriver);
    }

    public final void shutdown() {
        if (null != this.mComponent) {
            this.mComponent.removeKeyListener(this.mDriver);
        }
    }

    public Button createButton(int n) {
        if (0 > n || 256 < n) {
            throw new InvalidKeyCodeException();
        }
        KeyButton keyButton = this.mDriver.getButton(n);
        if (null == keyButton) {
            keyButton = new KeyButton(n);
            this.mDriver.registerKeyButton(keyButton);
            if (n > this.mMaxIdxCreated) {
                this.mMaxIdxCreated = n;
            }
        }
        return keyButton;
    }

    public void removeButton(Button button) {
        this.mDriver.unregisterKeyButton((KeyButton)button);
    }

    public Axis getAxis(int n) {
        return null;
    }

    public Button getButton(int n) {
        return this.mDriver.getButton(n);
    }

    public Directional getDirectional(int n) {
        return null;
    }

    public int getMaxNumberOfAxes() {
        return 0;
    }

    public int getMaxNumberOfButtons() {
        return this.mMaxIdxCreated + 1;
    }

    public int getMaxNumberOfDirectionals() {
        return 0;
    }

    public String getName() {
        return DEVICENAME;
    }

    public int getNumberOfAxes() {
        return 0;
    }

    public int getNumberOfButtons() {
        return this.mDriver.getNumberOfButtons();
    }

    public int getNumberOfDirectionals() {
        return 0;
    }
}

