/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.jxinput.keyboard;

import de.hardcode.jxinput.keyboard.InvalidKeyCodeException;
import de.hardcode.jxinput.keyboard.KeyButton;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

class KeyboardDriver
implements KeyListener {
    int mNumberOfKeysObserved = 0;
    KeyButton[] mKeysObserved = new KeyButton[256];

    final int getNumberOfButtons() {
        return this.mNumberOfKeysObserved;
    }

    final boolean registerKeyButton(KeyButton keyButton) {
        int n = keyButton.getKeyCode();
        if (0 > n || 256 < n) {
            throw new InvalidKeyCodeException();
        }
        if (null == this.mKeysObserved[n]) {
            this.mKeysObserved[n] = keyButton;
            ++this.mNumberOfKeysObserved;
            return true;
        }
        return false;
    }

    final void unregisterKeyButton(KeyButton keyButton) {
        int n = keyButton.getKeyCode();
        if (0 > n || 256 < n) {
            throw new InvalidKeyCodeException();
        }
        if (null != this.mKeysObserved[keyButton.getKeyCode()]) {
            this.mKeysObserved[n] = null;
            --this.mNumberOfKeysObserved;
        }
    }

    final KeyButton getButton(int n) {
        if (0 > n || 256 < n) {
            throw new InvalidKeyCodeException();
        }
        return this.mKeysObserved[n];
    }

    public void keyPressed(KeyEvent keyEvent) {
        KeyButton keyButton = this.getButton(keyEvent.getKeyCode());
        if (null != keyButton) {
            keyButton.setIsPressed(true);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        KeyButton keyButton = this.getButton(keyEvent.getKeyCode());
        if (null != keyButton) {
            keyButton.setIsPressed(false);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

