/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.jxinput.test;

import de.hardcode.jxinput.Axis;
import de.hardcode.jxinput.Button;
import de.hardcode.jxinput.Directional;
import de.hardcode.jxinput.JXInputDevice;
import de.hardcode.jxinput.test.AxisListener;
import de.hardcode.jxinput.test.ButtonListener;
import de.hardcode.jxinput.test.DirectionalListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;

public class JXInputDevicePanel
extends JPanel {
    private static final Font AXIS_SLIDER_FONT = new Font("Verdana", 0, 9);
    private final JXInputDevice mDev;
    private final ArrayList mAxisSliders = new ArrayList();
    private final ArrayList mButtonCheckboxes = new ArrayList();
    private final ArrayList mDirectionalLabels = new ArrayList();
    private JPanel mAxesPanel;
    private JPanel mAxesPanelContainer;
    private JScrollPane mButtonScrollPane;
    private JPanel mButtonsPanel;
    private JPanel mDirectionalPanel;

    public JXInputDevicePanel(JXInputDevice jXInputDevice) {
        this.mDev = jXInputDevice;
        this.initComponents();
        this.initFromDevice();
    }

    void initFromDevice() {
        if (null != this.mDev) {
            int n;
            JComponent jComponent;
            int n2;
            ((GridLayout)this.mAxesPanel.getLayout()).setRows(this.mDev.getNumberOfAxes());
            for (n2 = 0; n2 < this.mDev.getMaxNumberOfAxes(); ++n2) {
                if (null == this.mDev.getAxis(n2)) continue;
                AxisSlider axisSlider = new AxisSlider(this.mDev.getAxis(n2));
                jComponent = new JLabel(this.mDev.getAxis(n2).getName());
                ((JLabel)jComponent).setVerticalAlignment(1);
                ((JLabel)jComponent).setHorizontalAlignment(0);
                jComponent.setPreferredSize(new Dimension(90, 0));
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)jComponent, "West");
                jPanel.add((Component)axisSlider, "Center");
                this.mAxesPanel.add(jPanel);
                this.mAxisSliders.add(axisSlider);
                new AxisListener(this.mDev.getAxis(n2));
            }
            n2 = this.mDev.getNumberOfButtons();
            ((GridLayout)this.mButtonsPanel.getLayout()).setRows(n2);
            for (n = 0; n < n2; ++n) {
                if (null == this.mDev.getButton(n)) continue;
                jComponent = new ButtonCheckbox(this.mDev.getButton(n));
                this.mButtonCheckboxes.add(jComponent);
                this.mButtonsPanel.add(jComponent);
                new ButtonListener(this.mDev.getButton(n));
            }
            ((GridLayout)this.mDirectionalPanel.getLayout()).setRows(this.mDev.getNumberOfDirectionals() / 2);
            for (n = 0; n < this.mDev.getMaxNumberOfDirectionals(); ++n) {
                if (null == this.mDev.getDirectional(n)) continue;
                jComponent = new DirectionalLabel(this.mDev.getDirectional(n));
                this.mDirectionalLabels.add(jComponent);
                this.mDirectionalPanel.add(jComponent);
                new DirectionalListener(this.mDev.getDirectional(n));
            }
        }
    }

    public void update() {
        Iterator iterator = this.mAxisSliders.iterator();
        while (iterator.hasNext()) {
            ((AxisSlider)iterator.next()).update();
        }
        iterator = this.mButtonCheckboxes.iterator();
        while (iterator.hasNext()) {
            ((ButtonCheckbox)iterator.next()).update();
        }
        iterator = this.mDirectionalLabels.iterator();
        while (iterator.hasNext()) {
            ((DirectionalLabel)iterator.next()).update();
        }
    }

    private void initComponents() {
        this.mAxesPanelContainer = new JPanel();
        this.mAxesPanel = new JPanel();
        this.mDirectionalPanel = new JPanel();
        this.mButtonScrollPane = new JScrollPane();
        this.mButtonsPanel = new JPanel();
        this.setLayout(new BorderLayout(2, 2));
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                JXInputDevicePanel.this.OnShow(componentEvent);
            }
        });
        this.mAxesPanelContainer.setLayout(new BorderLayout());
        this.mAxesPanelContainer.setBorder(BorderFactory.createBevelBorder(0));
        this.mAxesPanel.setLayout(new GridLayout(1, 1, 0, 20));
        this.mAxesPanelContainer.add((Component)this.mAxesPanel, "North");
        this.add((Component)this.mAxesPanelContainer, "Center");
        this.mDirectionalPanel.setLayout(new GridLayout(1, 1));
        this.mDirectionalPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.add((Component)this.mDirectionalPanel, "South");
        this.mButtonsPanel.setLayout(new GridLayout(1, 1));
        this.mButtonsPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.mButtonScrollPane.setViewportView(this.mButtonsPanel);
        this.add((Component)this.mButtonScrollPane, "East");
    }

    private void OnShow(ComponentEvent componentEvent) {
    }

    private class DirectionalLabel
    extends JLabel {
        Directional mDirectional;
        int mCurrent;

        DirectionalLabel(Directional directional) {
            super(directional.getName());
            this.mCurrent = 0;
            this.mDirectional = directional;
        }

        void update() {
            int n = this.mDirectional.getDirection();
            if (n != this.mCurrent) {
                this.setText(this.mDirectional.getName() + ":  " + (this.mDirectional.isCentered() ? "-" : Integer.toString(n)));
                this.mCurrent = n;
            }
        }
    }

    private class ButtonCheckbox
    extends JCheckBox {
        Button mButton;

        ButtonCheckbox(Button button) {
            super(button.getName());
            this.setEnabled(false);
            this.mButton = button;
        }

        void update() {
            boolean bl = this.mButton.getState();
            if (bl != this.isSelected()) {
                this.setSelected(bl);
            }
        }
    }

    private class AxisSlider
    extends JSlider {
        Axis mAxis;

        AxisSlider(Axis axis) {
            super(2 == axis.getType() ? 0 : -100, 100);
            this.setMajorTickSpacing(2 == axis.getType() ? 25 : 50);
            this.setMinorTickSpacing(5);
            this.setPaintTicks(true);
            this.setPaintLabels(true);
            this.setEnabled(false);
            Dictionary dictionary = this.getLabelTable();
            Enumeration enumeration = dictionary.elements();
            while (enumeration.hasMoreElements()) {
                JLabel jLabel = (JLabel)enumeration.nextElement();
                jLabel.setFont(AXIS_SLIDER_FONT);
                jLabel.setSize(32, 12);
                jLabel.setHorizontalAlignment(2);
            }
            this.mAxis = axis;
        }

        void update() {
            int n = (int)(this.mAxis.getValue() * 100.0);
            if (n != this.getValue()) {
                this.setValue(n);
                this.setToolTipText(this.mAxis.getName() + ": " + Double.toString(this.mAxis.getValue()));
            }
        }
    }
}

