/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.jxinput.test;

import de.hardcode.jxinput.Button;
import de.hardcode.jxinput.JXInputDevice;
import de.hardcode.jxinput.JXInputManager;
import de.hardcode.jxinput.keyboard.JXKeyboardInputDevice;
import de.hardcode.jxinput.test.JXInputDevicePanel;
import de.hardcode.jxinput.virtual.JXVirtualInputDevice;
import de.hardcode.jxinput.virtual.VirtualAxis;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.SoftBevelBorder;

public class JXInputTestDialog
extends JDialog
implements ActionListener {
    private JXKeyboardInputDevice mKeyboardDevice = null;
    private JXVirtualInputDevice mVirtualDevice = null;
    Button mButtonUp;
    Button mButtonDown;
    Button mButtonLeft;
    Button mButtonRight;
    Button mButtonFire;
    Button mButtonSpace;
    private JButton mButtonReset;
    private JTabbedPane mDevicesTabbedPane;
    private JLabel mLabelNoDevice;
    private JPanel mMainPanel;

    public JXInputTestDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.configureKeyboardInputDevice();
        this.configureVirtualInputDevice();
        this.initDevicePanels();
        this.pack();
        this.mMainPanel.requestFocus();
        new Timer(50, this).start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JXInputManager.updateFeatures();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (int i = 0; i < JXInputTestDialog.this.mDevicesTabbedPane.getComponentCount(); ++i) {
                    ((JXInputDevicePanel)JXInputTestDialog.this.mDevicesTabbedPane.getComponent(i)).update();
                }
            }
        });
    }

    void configureKeyboardInputDevice() {
        this.mKeyboardDevice = JXInputManager.createKeyboardDevice();
        this.mKeyboardDevice.createButton(27);
        this.mKeyboardDevice.createButton(112);
        this.mKeyboardDevice.createButton(113);
        this.mKeyboardDevice.createButton(114);
        this.mKeyboardDevice.createButton(115);
        this.mKeyboardDevice.createButton(37);
        this.mKeyboardDevice.createButton(39);
        this.mKeyboardDevice.createButton(38);
        this.mKeyboardDevice.createButton(40);
        this.mKeyboardDevice.createButton(33);
        this.mKeyboardDevice.createButton(34);
        this.mButtonSpace = this.mKeyboardDevice.createButton(32);
        this.mButtonLeft = this.mKeyboardDevice.createButton(65);
        this.mButtonRight = this.mKeyboardDevice.createButton(68);
        this.mButtonDown = this.mKeyboardDevice.createButton(83);
        this.mButtonUp = this.mKeyboardDevice.createButton(87);
        this.mKeyboardDevice.listenTo(this.mMainPanel);
    }

    void configureVirtualInputDevice() {
        this.mVirtualDevice = JXInputManager.createVirtualDevice();
        Button button = JXInputManager.getJXInputDevice(0).getButton(0);
        VirtualAxis virtualAxis = this.mVirtualDevice.createAxis(0);
        virtualAxis.setButtons(this.mButtonRight, this.mButtonLeft);
        virtualAxis.setName("x: A-D");
        VirtualAxis virtualAxis2 = this.mVirtualDevice.createAxis(1);
        virtualAxis2.setButtons(this.mButtonUp, this.mButtonDown);
        virtualAxis2.setSpringSpeed(0.0);
        virtualAxis2.setName("y: S|W");
        VirtualAxis virtualAxis3 = this.mVirtualDevice.createAxis(6);
        virtualAxis3.setIncreaseButton(this.mButtonSpace);
        virtualAxis3.setTimeFor0To1(2000);
        virtualAxis3.setName("<space>");
        virtualAxis3.setType(2);
        if (null != button) {
            virtualAxis3 = this.mVirtualDevice.createAxis(7);
            virtualAxis3.setIncreaseButton(button);
            virtualAxis3.setTimeFor0To1(2000);
            virtualAxis3.setName("JoyButton 0");
        }
    }

    void initDevicePanels() {
        int n = JXInputManager.getNumberOfDevices();
        this.mLabelNoDevice.setVisible(n == 0);
        this.mDevicesTabbedPane.setVisible(n != 0);
        for (int i = 0; i < n; ++i) {
            JXInputDevice jXInputDevice = JXInputManager.getJXInputDevice(i);
            if (null == jXInputDevice) continue;
            JXInputDevicePanel jXInputDevicePanel = new JXInputDevicePanel(jXInputDevice);
            this.mDevicesTabbedPane.addTab(jXInputDevice.getName(), jXInputDevicePanel);
        }
    }

    private void initComponents() {
        this.mMainPanel = new JPanel();
        this.mLabelNoDevice = new JLabel();
        this.mDevicesTabbedPane = new JTabbedPane();
        this.mButtonReset = new JButton();
        this.setTitle("JXInput (C) 2001-2006 HARDCODE Dev.");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JXInputTestDialog.this.closeDialog(windowEvent);
            }
        });
        this.mMainPanel.setLayout(new BorderLayout(10, 0));
        this.mLabelNoDevice.setHorizontalAlignment(0);
        this.mLabelNoDevice.setText("No JXInputDevice available!");
        this.mLabelNoDevice.setBorder(new SoftBevelBorder(0));
        this.mMainPanel.add((Component)this.mLabelNoDevice, "North");
        this.mDevicesTabbedPane.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JXInputTestDialog.this.mDevicesTabbedPaneFocusGained(focusEvent);
            }
        });
        this.mMainPanel.add((Component)this.mDevicesTabbedPane, "Center");
        this.mButtonReset.setText("Reset ");
        this.mButtonReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JXInputTestDialog.this.mButtonResetActionPerformed(actionEvent);
            }
        });
        this.mMainPanel.add((Component)this.mButtonReset, "South");
        this.getContentPane().add((Component)this.mMainPanel, "Center");
        this.pack();
    }

    private void mButtonResetActionPerformed(ActionEvent actionEvent) {
        while (this.mDevicesTabbedPane.getTabCount() > 0) {
            this.mDevicesTabbedPane.removeTabAt(0);
        }
        JXInputManager.reset();
        this.configureKeyboardInputDevice();
        this.configureVirtualInputDevice();
        this.initDevicePanels();
        this.pack();
        this.mMainPanel.requestFocus();
    }

    private void mDevicesTabbedPaneFocusGained(FocusEvent focusEvent) {
        this.mMainPanel.requestFocus();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        new JXInputTestDialog((Frame)new JFrame(), true).setVisible(true);
    }
}

