/*
 * Decompiled with CFR 0.152.
 */
package de.hardcode.jxinput.virtual;

import de.hardcode.jxinput.Axis;
import de.hardcode.jxinput.Button;
import java.security.InvalidParameterException;

public class VirtualAxis
implements Axis {
    private int mType = 0;
    private final int mID;
    private String mName = "VirtualAxis";
    private double mCurrentValue = 0.0;
    private Button mButtonIncrease = null;
    private Button mButtonDecrease = null;
    private double mSpeed = 0.002;
    private double mSpringSpeed = 0.002;

    public VirtualAxis(int n) {
        this.mID = n;
    }

    public void setType(int n) {
        if (1 != n && 0 != n && 2 != n) {
            throw new InvalidParameterException("Invalid type for axis!");
        }
        this.mType = n;
    }

    final void update(long l) {
        double d;
        double d2 = this.mSpeed * (double)l;
        double d3 = this.mSpringSpeed * (double)l;
        boolean bl = null != this.mButtonIncrease && this.mButtonIncrease.getState();
        boolean bl2 = null != this.mButtonDecrease && this.mButtonDecrease.getState();
        boolean bl3 = bl || bl2;
        double d4 = 0.0;
        if (bl) {
            d4 += d2;
        }
        if (bl2) {
            d4 -= d2;
        }
        this.mCurrentValue += d4;
        if (this.mCurrentValue > 0.0 && !bl) {
            d3 = Math.min(this.mCurrentValue, d3);
            this.mCurrentValue -= d3;
        }
        if (this.mCurrentValue < 0.0 && !bl2) {
            d3 = Math.min(-this.mCurrentValue, d3);
            this.mCurrentValue += d3;
        }
        if (this.mCurrentValue > 1.0) {
            this.mCurrentValue = 1.0;
        }
        double d5 = d = 2 == this.mType ? 0.0 : -1.0;
        if (this.mCurrentValue < d) {
            this.mCurrentValue = d;
        }
    }

    public final void setIncreaseButton(Button button) {
        if (null == button) {
            throw new InvalidParameterException("Button may not be null!");
        }
        this.mButtonIncrease = button;
    }

    public final void setButtons(Button button, Button button2) {
        if (null == button || null == button2) {
            throw new InvalidParameterException("Buttons may not be null!");
        }
        this.mButtonIncrease = button;
        this.mButtonDecrease = button2;
    }

    public final void setSpeed(double d) {
        this.mSpeed = d;
    }

    public final void setSpringSpeed(double d) {
        this.mSpringSpeed = d;
    }

    public final void setTimeFor0To1(int n) {
        this.mSpeed = 0 >= n ? 0.0 : 1.0 / (double)n;
    }

    public final void setTimeFor1To0(int n) {
        this.mSpringSpeed = 0 >= n ? 0.0 : 1.0 / (double)n;
    }

    public final void setName(String string) {
        this.mName = string;
    }

    public String getName() {
        return this.mName;
    }

    public double getResolution() {
        return 1.52587890625E-5;
    }

    public int getType() {
        return this.mType;
    }

    public double getValue() {
        return this.mCurrentValue;
    }

    public boolean hasChanged() {
        return true;
    }
}

