/*
 * Decompiled with CFR 0.152.
 */
package supermario;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import supermario.game.Game;
import supermario.game.Textures;
import supermario.game.sprites.misc.Firebar;
import supermario.game.sprites.misc.Platform;

public class Utilities {
    public static Textures textures;
    private static final byte[] cypher;
    private static final ImageIcon icon;
    private static BufferedImage letterBImage;
    public static String BLANK_CURSOR_DESCRIPTION;
    public static Cursor blankCursor;
    public static Cursor defaultCursor;
    private static double oscXPeriod;
    private static double oscYPeriod;
    private static double ticks;
    private static int pulsingIndex;
    private static double firebarThetaSlow;
    private static double firebarThetaFast;
    private static double firebarTicksSlow;
    private static double firebarTicksFast;
    private static int fireballImageIndex;
    private static double fireballTicks;
    private static boolean pulseGettingDarker;
    private static int backupPulsingIndex;
    private static boolean backupGettingDarker;
    private static double backupTicks;

    public static String setDefaultLookAndFeel() {
        try {
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                return UIManager.getSystemLookAndFeelClassName();
            }
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            return UIManager.getCrossPlatformLookAndFeelClassName();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return "";
        }
    }

    private static ImageIcon initIcon() {
        try {
            return new ImageIcon(Utilities.decrypt(Utilities.getBytes("images/icon", Game.class)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setIcon(Frame frame) {
        if (icon != null) {
            frame.setIconImage(icon.getImage());
        }
    }

    public static void showAbout(Component component) {
        String about = "<html><b>Super Mario Bros. NES Game & Builder</b></html>";
        about = about + "\r\nRelease on 9/22/2015. Version 7.54";
        about = about + "\r\n<html>All rights to <b>Nintendo\u00ae</b></html>";
        about = about + "\r\nBy Andrew Kellogg";
        about = about + "\r\nemail: AirmanAJK@yahoo.com";
        about = about + "\r\n\r\nDedicated to my wife Nicole.";
        JOptionPane.showMessageDialog(component, about, "About", 0, icon);
    }

    private static byte[] getCypher() {
        try {
            return String.valueOf(new char[]{'M', 'a', 'r', 'i', 'o', 's'}).getBytes(Game.ENCODING);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] getBytes(String path, Class c) throws Exception {
        BufferedInputStream bufStream = new BufferedInputStream(c.getResourceAsStream(path));
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        int b = 0;
        b = bufStream.read();
        while (b != -1) {
            byteStream.write(b);
            b = bufStream.read();
        }
        bufStream.close();
        byteStream.close();
        return byteStream.toByteArray();
    }

    public static byte[] decrypt(byte[] bytes) {
        int pos = 0;
        for (int bytePos = 0; bytePos < bytes.length; ++bytePos) {
            bytes[bytePos] = (byte)(bytes[bytePos] ^ cypher[pos++ % cypher.length]);
        }
        return bytes;
    }

    public static int getDisplayNumber(Frame comp) {
        int i;
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = environment.getScreenDevices();
        if (!comp.isVisible()) {
            GraphicsDevice defaultDevice = environment.getDefaultScreenDevice();
            for (i = 0; i < devices.length; ++i) {
                if (!defaultDevice.equals(devices[i])) continue;
                return i;
            }
        }
        Rectangle[] deviceBounds = new Rectangle[devices.length];
        for (i = 0; i < devices.length; ++i) {
            deviceBounds[i] = devices[i].getConfigurations()[0].getBounds();
        }
        Integer[] intersectionAreas = new Integer[deviceBounds.length];
        int maxArea = 0;
        int maxDisplay = 0;
        Point screenLoc = comp.getLocationOnScreen();
        Rectangle compRect = new Rectangle(screenLoc.x, screenLoc.y, comp.getWidth(), comp.getHeight());
        for (int i2 = 0; i2 < intersectionAreas.length; ++i2) {
            if (!compRect.intersects(deviceBounds[i2])) continue;
            Rectangle intersection = compRect.intersection(deviceBounds[i2]);
            intersectionAreas[i2] = intersection.width * intersection.height;
            if (intersectionAreas[i2] <= maxArea) continue;
            maxArea = intersectionAreas[i2];
            maxDisplay = i2;
        }
        return maxDisplay;
    }

    public static Rectangle getDisplayBounds(int displayNumber) {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = environment.getScreenDevices();
        return devices[displayNumber].getConfigurations()[0].getBounds();
    }

    public static Point getFrameCenter(Frame comp) {
        Point screenLoc = comp.getLocationOnScreen();
        return new Point(screenLoc.x + comp.getWidth() / 2, screenLoc.y + comp.getHeight() / 2);
    }

    public static void centerOnPoint(Frame comp, Point p) {
        comp.setLocation(p.x - comp.getWidth() / 2, p.y - comp.getHeight() / 2);
    }

    public static void centerOnDisplay(Frame comp) {
        Rectangle displayRect = Utilities.getDisplayBounds(Utilities.getDisplayNumber(comp));
        int x = displayRect.x + displayRect.width / 2 - comp.getWidth() / 2;
        int y = displayRect.y + displayRect.height / 2 - comp.getHeight() / 2;
        comp.setLocation(x, y);
    }

    public static void correctScreenLocation(Frame comp) {
        Rectangle displayRect = Utilities.getDisplayBounds(Utilities.getDisplayNumber(comp));
        Point compLoc = comp.getLocationOnScreen();
        Point newScreenLoc = new Point(compLoc);
        if (compLoc.x < displayRect.x) {
            newScreenLoc.x = displayRect.x;
        } else if (compLoc.x + comp.getWidth() > displayRect.x + displayRect.width) {
            newScreenLoc.x = displayRect.x + displayRect.width - comp.getWidth();
        }
        if (compLoc.y < displayRect.y) {
            newScreenLoc.y = displayRect.y;
        } else if (compLoc.y + comp.getHeight() > displayRect.y + displayRect.height) {
            newScreenLoc.y = displayRect.y + displayRect.height - comp.getHeight();
        }
        if (!compLoc.equals(newScreenLoc)) {
            comp.setLocation(newScreenLoc);
        }
    }

    public static void takeSnapshot(Game game) {
        game.audio.play(19);
        game.takingSnapshot = true;
        game.snapshotTrans = 0.9f;
        game.takeSnapshot = false;
        BufferedImage screenshot = new BufferedImage(Game.renderWidth, Game.renderHeight, 5);
        Graphics2D g2D = (Graphics2D)screenshot.getGraphics();
        game.level.draw(g2D);
        game.drawOverlay(g2D);
        try {
            ImageIO.write((RenderedImage)screenshot, "png", new File(game.lastGameName + "_" + System.currentTimeMillis() + ".png"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void drawAtTile(Graphics2D g2D, Image image, int xTile, int yTile) {
        g2D.drawImage(image, 8 * xTile, 8 * yTile, null);
    }

    public static void drawTextAtTiles(Graphics2D g2D, String text, int xTile, int yTile) {
        Utilities.drawText(g2D, text, xTile * 8, yTile * 8, null, 1.0f);
    }

    public static void drawTextAtTiles(Graphics2D g2D, String text, int xTile, int yTile, Color color, float composite) {
        Utilities.drawText(g2D, text, xTile * 8, yTile * 8, color, composite);
    }

    public static void drawTextAtPixels(Graphics2D g2D, String text, int xPixel, int yPixel) {
        Utilities.drawText(g2D, text, xPixel, yPixel, null, 1.0f);
    }

    public static void drawTextAtPixels(Graphics2D g2D, String text, int xPixel, int yPixel, Color color, float composite) {
        Utilities.drawText(g2D, text, xPixel, yPixel, color, composite);
    }

    private static void drawText(Graphics2D g2D, String text, int xPixel, int yPixel, Color color, float composite) {
        text = text.toUpperCase();
        char[] chars = text.toLowerCase().toCharArray();
        Image[] textImages = new Image[text.length()];
        for (int i = 0; i < chars.length; ++i) {
            ImageIcon ii = Utilities.textures.symbols.get(Character.valueOf(chars[i]));
            textImages[i] = ii == null ? Utilities.textures.symbols.get(Character.valueOf('\ufffb')).getImage() : ii.getImage();
        }
        Graphics2D bGraphics = (Graphics2D)letterBImage.getGraphics();
        for (int i = 0; i < textImages.length; ++i) {
            if (color == null && composite == 1.0f) {
                g2D.drawImage(textImages[i], xPixel, yPixel, null);
            } else {
                bGraphics.setComposite(AlphaComposite.getInstance(3));
                bGraphics.fillRect(0, 0, 8, 8);
                bGraphics.setComposite(AlphaComposite.getInstance(5, 1.0f));
                bGraphics.drawImage(textImages[i], 0, 0, null);
                bGraphics.setComposite(AlphaComposite.getInstance(5, composite));
                bGraphics.setColor(color);
                bGraphics.fillRect(0, 0, 8, 8);
                g2D.drawImage((Image)letterBImage, xPixel, yPixel, null);
            }
            xPixel += 8;
        }
    }

    public static void updatePeriodicTheta(double delta) {
        firebarTicksSlow += delta;
        firebarThetaSlow = (firebarTicksSlow %= Firebar.FIREBAR_PERIOD_SLOW) / Firebar.FIREBAR_PERIOD_SLOW * 2.0 * Math.PI;
        firebarTicksFast += delta;
        firebarThetaFast = (firebarTicksFast %= Firebar.FIREBAR_PERIOD_FAST) / Firebar.FIREBAR_PERIOD_FAST * 2.0 * Math.PI;
    }

    public static double getPeriodicTheta(boolean fastFirebar) {
        if (fastFirebar) {
            return firebarThetaFast;
        }
        return firebarThetaSlow;
    }

    public static void resetSynchronizedSprites() {
        oscYPeriod = 0.0;
        oscXPeriod = 0.0;
        firebarThetaFast = 0.0;
        firebarThetaSlow = 0.0;
        firebarTicksFast = 0.0;
        firebarTicksSlow = 0.0;
    }

    public static void updateFireballImageIndex(double delta) {
        if ((fireballTicks += delta) > 70.0) {
            if (++fireballImageIndex == 4) {
                fireballImageIndex = 0;
            }
            fireballTicks -= 70.0;
        }
    }

    public static void updateOscillatingPlatformPeriods(double delta) {
        oscXPeriod = (oscXPeriod + delta) % (double)Platform.TOTAL_OSC_X_PERIOD;
        oscYPeriod = (oscYPeriod + delta) % (double)Platform.TOTAL_OSC_Y_PERIOD;
    }

    public static double getXPlatformOscillationPeriod() {
        return oscXPeriod;
    }

    public static double getYPlatformOscillationPeriod() {
        return oscYPeriod;
    }

    public static void updatePulsingImageIndex(double delta) {
        ticks += delta;
        if (pulsingIndex == 0) {
            if (ticks >= 380.0) {
                ++pulsingIndex;
                pulseGettingDarker = true;
                ticks -= 380.0;
            }
        } else if (pulsingIndex == 1) {
            if (ticks >= 140.0) {
                pulsingIndex = pulseGettingDarker ? ++pulsingIndex : --pulsingIndex;
                ticks -= 140.0;
            }
        } else if (pulsingIndex == 2 && ticks >= 140.0) {
            --pulsingIndex;
            pulseGettingDarker = false;
            ticks -= 140.0;
        }
    }

    public static int getPulsingImageIndex() {
        return pulsingIndex;
    }

    public static void savePulsingState() {
        backupPulsingIndex = pulsingIndex;
        backupGettingDarker = pulseGettingDarker;
        backupTicks = ticks;
    }

    public static void restorePulsingState() {
        pulsingIndex = backupPulsingIndex;
        pulseGettingDarker = backupGettingDarker;
        ticks = backupTicks;
    }

    public static void resetPulsingImageIndex() {
        pulsingIndex = 0;
        pulseGettingDarker = true;
        ticks = 0.0;
    }

    static {
        cypher = Utilities.getCypher();
        icon = Utilities.initIcon();
        letterBImage = new BufferedImage(8, 8, 2);
        BLANK_CURSOR_DESCRIPTION = "invisibleCursor";
        blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(new BufferedImage(16, 16, 2), new Point(0, 0), BLANK_CURSOR_DESCRIPTION);
        defaultCursor = Cursor.getDefaultCursor();
        pulseGettingDarker = true;
    }
}

