/*
 * Decompiled with CFR 0.152.
 */
package supermario.builder;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import supermario.builder.BuilderFrame;
import supermario.builder.Item;
import supermario.builder.PropertiesPanel;

public final class Button
extends JButton
implements ActionListener {
    private BuilderFrame frame;
    public Item item;
    public String title;
    public String description;
    public ImageIcon iconImage;
    public ImageIcon placedImage;

    public Button(BuilderFrame frame, ImageIcon iconImage, ImageIcon placedImage, String title, String description) {
        this.frame = frame;
        this.iconImage = iconImage;
        this.setFont(frame.plain);
        this.setIcon(iconImage);
        this.placedImage = placedImage == null ? iconImage : placedImage;
        this.title = title;
        this.description = description;
        this.setToolTipText(description);
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.addActionListener(this);
    }

    public void setItem(Item item) {
        this.item = item;
        if (this.title == null) {
            this.title = item.name;
        }
        this.setText(this.title);
    }

    public void setImages(ImageIcon icon, ImageIcon placed) {
        this.setIcon(icon);
        this.iconImage = icon;
        this.placedImage = placed != null ? placed : icon;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.frame.levelPanel.item = this.item;
        if (this.item != null && !this.item.isWarpable()) {
            this.frame.changePropertiesPanel(new PropertiesPanel(this.frame, this.item.propertiesType, this.item));
        } else {
            this.frame.changePropertiesPanel(new PropertiesPanel(this.frame, 1, null));
        }
    }
}

