/*
 * Decompiled with CFR 0.152.
 */
package supermario.builder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import supermario.builder.BuilderFrame;
import supermario.builder.PropertiesPanel;
import supermario.builder.TextBox;

public class GameListPanel
extends JPanel {
    private BuilderFrame frame;
    private JLabel authorLabel;
    private JLabel levelLabel;
    public JCheckBox hasPasswordCheckBox;
    private TextBox authorText;
    private JPasswordField passwordText;
    private JButton addLevel;
    private JButton deleteLevel;
    private JButton moveUp;
    private JButton moveDown;
    public JList<String> levelsList;
    private JButton testLevelButton;
    private JButton selectorButton;
    private JButton copyLevelButton;
    public static final String DEFAULT_AUTHOR_NAME = "ANONYMOUS";
    public static final int V_SPACER = 2;
    public static final int H_SPACER = 1;
    public static final int MAX_LEVELS = 1000;
    public static final int MAX_PASSWORD_CHARACTERS = 8;

    public GameListPanel(BuilderFrame frame) {
        this.frame = frame;
        this.setBackground(Color.WHITE);
        this.setLayout(new GridBagLayout());
        this.initAuthor();
        this.initPassword();
        this.initLevelButtons();
        this.initLevelsList();
        this.initBottomLevelButtons();
    }

    public void reset() {
        this.authorText.setText(DEFAULT_AUTHOR_NAME);
        this.repopulate(-1);
    }

    public void withoutPassword() {
        this.passwordText.setText("");
        this.passwordText.setEnabled(false);
        this.hasPasswordCheckBox.setSelected(false);
    }

    public void withPassword(String password) {
        this.passwordText.setText(password);
        this.passwordText.setEnabled(true);
        this.hasPasswordCheckBox.setSelected(true);
    }

    public String getAuthorName() {
        if (this.authorText.getText().isEmpty()) {
            return DEFAULT_AUTHOR_NAME;
        }
        return this.authorText.getText();
    }

    public String getPassword() {
        String password = String.valueOf(this.passwordText.getPassword());
        while (password.length() < 8) {
            password = password + " ";
        }
        return password;
    }

    public void setAuthorName(String author) {
        this.authorText.setText(author);
    }

    public String[] getLevelsList(boolean padWithSpace) {
        String[] names = new String[this.frame.levelPanel.levels.length];
        for (int i = 0; i < this.frame.levelPanel.levels.length; ++i) {
            names[i] = this.frame.levelPanel.levels[i].getTitle();
            if (!padWithSpace) continue;
            names[i] = " " + names[i];
        }
        return names;
    }

    public void repopulate(int selectedIndex) {
        String[] names = this.getLevelsList(false);
        if (names.length == 0) {
            names = new String[]{""};
        }
        this.levelsList.setListData((String[])names);
        if (selectedIndex >= 0) {
            this.selectLevel(selectedIndex);
        }
    }

    public void selectLevel(int selectedLevel) {
        this.levelsList.setSelectedIndex(selectedLevel);
        this.levelsList.ensureIndexIsVisible(selectedLevel);
    }

    private void initAuthor() {
        this.authorLabel = new JLabel("Game Author:");
        this.authorLabel.setFont(this.frame.bold);
        GridBagConstraints authorLabelConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 2, 0), 0, 0);
        this.add((Component)this.authorLabel, authorLabelConstraints);
        this.authorText = new TextBox(20, false, true, false);
        this.authorText.setFont(this.frame.boxFont);
        this.authorText.setText(DEFAULT_AUTHOR_NAME);
        this.authorText.setToolTipText("The author of the game that is displayed between levels...");
        GridBagConstraints authorTextConstraints = new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 2, 10), 0, 0);
        this.add((Component)this.authorText, authorTextConstraints);
    }

    private void initPassword() {
        this.hasPasswordCheckBox = new JCheckBox("Password");
        this.hasPasswordCheckBox.setFont(this.frame.boxFont);
        this.hasPasswordCheckBox.setFont(this.frame.bold);
        this.hasPasswordCheckBox.setOpaque(false);
        this.hasPasswordCheckBox.setSelected(false);
        this.hasPasswordCheckBox.setToolTipText("If the game is password protected to prevent tampering...");
        this.hasPasswordCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GameListPanel.this.hasPasswordCheckBox.isSelected()) {
                    GameListPanel.this.passwordText.setEnabled(true);
                } else {
                    GameListPanel.this.passwordText.setText("");
                    GameListPanel.this.passwordText.setEnabled(false);
                }
            }
        });
        GridBagConstraints hasPasswordCheckBoxConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 2, 1), 0, 0);
        this.add((Component)this.hasPasswordCheckBox, hasPasswordCheckBoxConstraints);
        this.passwordText = TextBox.getPasswordTextBox(8, false, false);
        this.passwordText.setEnabled(false);
        this.passwordText.setToolTipText("A password to prevent others from modifying the game...");
        GridBagConstraints passwordTextConstraints = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 1, 2, 10), 0, 0);
        this.add((Component)this.passwordText, passwordTextConstraints);
    }

    private void initLevelButtons() {
        this.levelLabel = new JLabel("Levels:");
        this.levelLabel.setFont(this.frame.bold);
        GridBagConstraints levelLabelConstraints = new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 2, 0), 0, 0);
        this.add((Component)this.levelLabel, levelLabelConstraints);
        this.addLevel = new JButton("  Add  ");
        this.addLevel.setToolTipText("Inserts a new level at the currently selected position...");
        this.addLevel.setFont(this.frame.bold);
        this.addLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean success = ((GameListPanel)GameListPanel.this).frame.levelPanel.newLevel(GameListPanel.this.levelsList.getSelectedIndex(), -1);
                if (!success) {
                    JOptionPane.showMessageDialog(GameListPanel.this.frame, "Max levels exceeded. What kind of game are you making?!", "Max Levels Exceeded", 2);
                    return;
                }
                ((GameListPanel)GameListPanel.this).frame.levelPanel.modified = true;
                ((GameListPanel)GameListPanel.this).frame.levelPanel.setLevelScheme();
                GameListPanel.this.frame.clearStacks();
                GameListPanel.this.frame.changePropertiesPanel(new PropertiesPanel(GameListPanel.this.frame, 2, null));
            }
        });
        GridBagConstraints addLevelConstraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 2, 1), 0, 0);
        this.add((Component)this.addLevel, addLevelConstraints);
        this.deleteLevel = new JButton("Delete");
        this.deleteLevel.setToolTipText("Deletes the currently selected level...");
        this.deleteLevel.setFont(this.frame.bold);
        this.deleteLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((GameListPanel)GameListPanel.this).frame.levelPanel.deleteLevel(GameListPanel.this.levelsList.getSelectedIndex())) {
                    ((GameListPanel)GameListPanel.this).frame.levelPanel.modified = true;
                    GameListPanel.this.frame.clearStacks();
                }
                GameListPanel.this.frame.changePropertiesPanel(new PropertiesPanel(GameListPanel.this.frame, 1, null));
            }
        });
        GridBagConstraints deleteLevelConstraints = new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 1, 2, 0), 0, 0);
        this.add((Component)this.deleteLevel, deleteLevelConstraints);
        this.moveDown = new JButton("\u25bc");
        this.moveDown.setToolTipText("Moves the currently selected level down one position...");
        this.moveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((GameListPanel)GameListPanel.this).frame.levelPanel.shiftLevelDown(GameListPanel.this.levelsList.getSelectedIndex())) {
                    ((GameListPanel)GameListPanel.this).frame.levelPanel.modified = true;
                }
            }
        });
        GridBagConstraints moveDownConstraints = new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 1, 2, 0), 0, 0);
        this.add((Component)this.moveDown, moveDownConstraints);
        this.moveUp = new JButton("\u25b2");
        this.moveUp.setToolTipText("Moves the currently selected level up one position...");
        this.moveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((GameListPanel)GameListPanel.this).frame.levelPanel.shiftLevelUp(GameListPanel.this.levelsList.getSelectedIndex())) {
                    ((GameListPanel)GameListPanel.this).frame.levelPanel.modified = true;
                }
            }
        });
        GridBagConstraints moveUpConstraints = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 2, 1), 0, 0);
        this.add((Component)this.moveUp, moveUpConstraints);
    }

    private void initLevelsList() {
        DefaultListModel<String> list = new DefaultListModel<String>();
        list.add(0, "");
        this.levelsList = new JList(list);
        this.levelsList.setFont(this.frame.boxFont);
        this.levelsList.setSelectionMode(0);
        this.levelsList.setLayoutOrientation(0);
        this.levelsList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (((GameListPanel)GameListPanel.this).frame.levelPanel.levels.length > 0) {
                    int selectedIndex = ((JList)e.getSource()).getSelectedIndex();
                    if (((GameListPanel)GameListPanel.this).frame.levelPanel.level == null || ((GameListPanel)GameListPanel.this).frame.levelPanel.level.levelNumber != selectedIndex) {
                        GameListPanel.this.frame.clearStacks();
                        ((GameListPanel)GameListPanel.this).frame.levelPanel.switchToLevel(selectedIndex);
                    }
                    GameListPanel.this.frame.changePropertiesPanel(new PropertiesPanel(GameListPanel.this.frame, 2, null));
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.levelsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedIndex;
                if (((GameListPanel)GameListPanel.this).frame.levelPanel.levels.length > 0 && (selectedIndex = ((JList)e.getSource()).getSelectedIndex()) >= 0) {
                    if (((GameListPanel)GameListPanel.this).frame.levelPanel.level == null || ((GameListPanel)GameListPanel.this).frame.levelPanel.level.levelNumber != selectedIndex) {
                        ((GameListPanel)GameListPanel.this).frame.levelPanel.switchToLevel(selectedIndex);
                        GameListPanel.this.frame.clearStacks();
                    }
                    GameListPanel.this.frame.changePropertiesPanel(new PropertiesPanel(GameListPanel.this.frame, 2, null));
                }
            }
        });
        GridBagConstraints levelsListConstraints = new GridBagConstraints(0, 6, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 2, 2, 2), 0, 0);
        JScrollPane levelsListScroller = new JScrollPane(this.levelsList, 20, 30);
        levelsListScroller.setPreferredSize(new Dimension(1, 1));
        levelsListScroller.getVerticalScrollBar().setUnitIncrement(7);
        this.add((Component)levelsListScroller, levelsListConstraints);
    }

    private void initBottomLevelButtons() {
        this.testLevelButton = new JButton("Test Lvl");
        this.testLevelButton.setFont(this.frame.bold);
        this.testLevelButton.setToolTipText("Runs a game starting at the selected level...");
        this.testLevelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GameListPanel.this.frame.testLevel();
            }
        });
        GridBagConstraints testLevelButtonConstraints = new GridBagConstraints(0, 7, 2, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 2, 0), 0, 0);
        this.add((Component)this.testLevelButton, testLevelButtonConstraints);
        this.selectorButton = new JButton();
        this.selectorButton.setToolTipText("Sets the selector tool which can both move items and change properties...");
        this.selectorButton.setIcon(this.frame.textures.iconPointer);
        this.selectorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((GameListPanel)GameListPanel.this).frame.miscPanel.pointer.doClick();
            }
        });
        GridBagConstraints selectorButtonConstraints = new GridBagConstraints(1, 7, 1, 0, 1.0, 0.0, 13, 0, new Insets(0, 0, 2, 0), 0, 0);
        this.add((Component)this.selectorButton, selectorButtonConstraints);
        this.copyLevelButton = new JButton("+");
        this.copyLevelButton.setToolTipText("Copies the selected level and inserts it into the game...");
        this.copyLevelButton.setForeground(Color.BLUE);
        this.copyLevelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((GameListPanel)GameListPanel.this).frame.levelPanel.level == null) {
                    return;
                }
                boolean success = ((GameListPanel)GameListPanel.this).frame.levelPanel.newLevel(((GameListPanel)GameListPanel.this).frame.levelPanel.level.levelNumber + 1, ((GameListPanel)GameListPanel.this).frame.levelPanel.level.levelNumber);
                if (!success) {
                    JOptionPane.showMessageDialog(GameListPanel.this.frame, "Max levels exceeded. What kind of game are you making?!", "Max Levels Exceeded", 2);
                    return;
                }
                ((GameListPanel)GameListPanel.this).frame.levelPanel.modified = true;
                ((GameListPanel)GameListPanel.this).frame.levelPanel.setLevelScheme();
                GameListPanel.this.frame.clearStacks();
                GameListPanel.this.frame.changePropertiesPanel(new PropertiesPanel(GameListPanel.this.frame, 2, null));
            }
        });
        GridBagConstraints copyLevelButtonConstraints = new GridBagConstraints(0, 7, 1, 0, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0);
        this.add((Component)this.copyLevelButton, copyLevelButtonConstraints);
    }
}

