/*
 * Decompiled with CFR 0.152.
 */
package supermario.builder;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import supermario.Utilities;
import supermario.builder.BuilderFrame;
import supermario.builder.Level;
import supermario.builder.TextBox;
import supermario.game.Game;

public class IO {
    private BuilderFrame frame;
    public String workingPath;
    public String lastAccessedFileName = "";
    public boolean hasWorkingPath;
    private static final String lineBreak = "\r\n";
    public static final String MANDATORY_GAME_FILE_EXTENSION = ".mario";
    public static final String MANDATORY_PROGRAM_FILE_EXTENSION = ".jar";
    public static final String MANDATORY_ZIP_FILE_EXTENSION = ".zip";

    public IO(BuilderFrame frame) {
        this.frame = frame;
    }

    public GameData getGameData(int startingLevel) throws Exception {
        char[][] charData = new char[this.frame.levelPanel.levels.length][];
        for (int i = 0; i < charData.length; ++i) {
            charData[i] = this.frame.levelPanel.levels[i].getLevelChars();
        }
        return new GameData(charData, this.frame.gameListPanel.getAuthorName(), startingLevel, this.lastAccessedFileName.isEmpty() ? "Unsaved Game" : this.lastAccessedFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportGame(String path) {
        try {
            File file = new File(URLDecoder.decode(this.ensureFileExtension(path, MANDATORY_PROGRAM_FILE_EXTENSION), Game.ENCODING));
            if (file.exists()) {
                int answer = JOptionPane.showConfirmDialog(this.frame, "Are you sure you want to overwrite this file?\r\n(" + file.getName() + ")", "File Already Exists", 0, 2);
                if (answer != 0) {
                    return;
                }
                if (!file.delete()) {
                    throw new RuntimeException("Can't overwrite current file.");
                }
            }
            this.frame.setEnabled(false);
            File tempGame = File.createTempFile("autostart", "mario");
            this.writeZipFile(tempGame);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(tempGame));
            int b = inStream.read();
            while (b != -1) {
                bOut.write(b);
                b = inStream.read();
            }
            bOut.close();
            inStream.close();
            byte[] autostartBytes = bOut.toByteArray();
            tempGame.delete();
            JarFile sourceJar = new JarFile(this.frame.game.input.jarFile);
            JarOutputStream jarOut = new JarOutputStream(new FileOutputStream(file));
            Enumeration<JarEntry> jarEntries = sourceJar.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry entry = jarEntries.nextElement();
                InputStream entryInputStream = sourceJar.getInputStream(entry);
                jarOut.putNextEntry(entry);
                byte[] buffer = new byte[1024];
                int bytesRead = 0;
                while ((bytesRead = entryInputStream.read(buffer)) != -1) {
                    jarOut.write(buffer, 0, bytesRead);
                }
                jarOut.closeEntry();
            }
            JarEntry autostartEntry = new JarEntry("supermario/game/autostart.mario");
            jarOut.putNextEntry(autostartEntry);
            jarOut.write(autostartBytes);
            jarOut.closeEntry();
            jarOut.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frame, "There was a problem saving the game.\r\nYou may not have write priviledges to the specified file or directory.", "Save Error", 0);
            e.printStackTrace();
        }
        finally {
            this.frame.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportImages(String path) {
        try {
            File file = new File(URLDecoder.decode(this.ensureFileExtension(path, MANDATORY_ZIP_FILE_EXTENSION), Game.ENCODING));
            if (file.exists()) {
                int answer = JOptionPane.showConfirmDialog(this.frame, "Are you sure you want to overwrite this file?\r\n(" + file.getName() + ")", "File Already Exists", 0, 2);
                if (answer != 0) {
                    return;
                }
                if (!file.delete()) {
                    throw new RuntimeException("Can't overwrite current file.");
                }
            }
            this.frame.setEnabled(false);
            ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(file));
            zipOut.setLevel(9);
            BufferedOutputStream bStream = new BufferedOutputStream(zipOut);
            for (int i = 0; i < this.frame.levelPanel.levels.length; ++i) {
                zipOut.putNextEntry(new ZipEntry(i + 1 + ".png"));
                BufferedImage bImage = this.frame.levelPanel.levels[i].getLevelImage();
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bImage, "png", byteStream);
                bStream.write(byteStream.toByteArray());
                bStream.flush();
                zipOut.closeEntry();
            }
            zipOut.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frame, "There was a problem saving the level images.\r\nYou may not have write priviledges to the specified file or directory.", "Save Error", 0);
            e.printStackTrace();
        }
        finally {
            this.frame.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeGame(boolean newSave) {
        if (!this.hasWorkingPath || this.workingPath.isEmpty()) {
            throw new RuntimeException("No working path has been specified to save a game.");
        }
        this.workingPath = this.ensureFileExtension(this.workingPath, MANDATORY_GAME_FILE_EXTENSION);
        try {
            int answer;
            File file = new File(this.workingPath);
            if (file.exists() && newSave && (answer = JOptionPane.showConfirmDialog(this.frame, "Are you sure you want to overwrite this file?\r\n(" + file.getName() + ")", "File Already Exists", 0, 2)) != 0) {
                this.hasWorkingPath = false;
                return;
            }
            this.writeZipFile(file);
            this.frame.levelPanel.modified = false;
            String filename = file.getName();
            this.lastAccessedFileName = filename.substring(0, filename.length() - MANDATORY_GAME_FILE_EXTENSION.length());
            this.frame.setTitle("Super Mario Bros. Game Builder" + (this.lastAccessedFileName.isEmpty() ? "" : " - " + this.lastAccessedFileName));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frame, "There was a problem saving the game.\r\nYou may not have write priviledges to the specified file or directory, or something went wrong.", "Save Error", 0);
            e.printStackTrace(System.out);
        }
    }

    private void writeZipFile(File file) throws Exception {
        byte[][] entryData = new byte[this.frame.levelPanel.levels.length + 1][];
        String[] entryNames = new String[entryData.length];
        entryData[0] = this.createMetaDataBytes();
        entryNames[0] = "metaData";
        for (int i = 0; i < this.frame.levelPanel.levels.length; ++i) {
            entryData[i + 1] = this.frame.levelPanel.levels[i].getLevelBytes();
            entryNames[i + 1] = this.padStringToSize(String.valueOf(i), 3);
        }
        ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(file));
        zipOut.setLevel(9);
        BufferedOutputStream bStream = new BufferedOutputStream(zipOut);
        for (int i = 0; i < entryData.length; ++i) {
            zipOut.putNextEntry(new ZipEntry(entryNames[i]));
            bStream.write(entryData[i]);
            bStream.flush();
            zipOut.closeEntry();
        }
        zipOut.close();
    }

    private byte[] createMetaDataBytes() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        outStream.write(String.valueOf(this.frame.levelPanel.levels.length + lineBreak).getBytes(Game.ENCODING));
        outStream.write((this.frame.gameListPanel.getAuthorName() + lineBreak).getBytes(Game.ENCODING));
        if (this.frame.gameListPanel.hasPasswordCheckBox.isSelected() && !this.frame.gameListPanel.getPassword().trim().isEmpty()) {
            outStream.write((String.valueOf(1) + lineBreak).getBytes(Game.ENCODING));
            outStream.write(Utilities.decrypt(this.frame.gameListPanel.getPassword().getBytes(Game.ENCODING)));
            outStream.write(lineBreak.getBytes(Game.ENCODING));
        } else {
            outStream.write((String.valueOf(0) + lineBreak).getBytes(Game.ENCODING));
        }
        outStream.write(String.valueOf("7.54\r\n").getBytes(Game.ENCODING));
        outStream.flush();
        return outStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadGame(File file) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry("metaData");
            InputStream iStream = zipFile.getInputStream(zipEntry);
            InputStreamReader iStreamReader = new InputStreamReader(iStream, Game.ENCODING);
            BufferedReader bReader = new BufferedReader(iStreamReader);
            String levelCount = bReader.readLine();
            int count = Integer.valueOf(levelCount);
            if (count <= 0) {
                throw new RuntimeException("Count value is invalid: " + count);
            }
            String author = bReader.readLine();
            String hasPassword = bReader.readLine();
            if (hasPassword.equals("1")) {
                char[] passwordChars = new char[8];
                for (int i = 0; i < passwordChars.length; ++i) {
                    passwordChars[i] = (char)bReader.read();
                }
                String password = String.valueOf(passwordChars);
                password = new String(Utilities.decrypt(password.getBytes(Game.ENCODING))).trim();
                final JPasswordField passwordField = TextBox.getPasswordTextBox(8, false, false);
                final int[] enterKeyUsed = new int[]{0};
                passwordField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        enterKeyUsed[0] = 1;
                        KeyEvent escapePressed = new KeyEvent(passwordField, 401, System.currentTimeMillis(), 0, 27, '\u001b');
                        passwordField.dispatchEvent(escapePressed);
                    }
                });
                int response = JOptionPane.showOptionDialog(this.frame, passwordField, "What is the password for the game?", 2, 3, null, new String[]{"OK", "Cancel"}, null);
                String answer = String.valueOf(String.valueOf(passwordField.getPassword()).trim().toCharArray());
                if (response != 0 && enterKeyUsed[0] == 0) {
                    return;
                }
                if (!answer.equals(password)) {
                    JOptionPane.showMessageDialog(this.frame, "Incorrect password.\r\nHint: Passwords are case-sensitive.", "Password", 0);
                    return;
                }
                this.frame.gameListPanel.withPassword(password);
            } else {
                this.frame.gameListPanel.withoutPassword();
            }
            bReader.close();
            iStreamReader.close();
            Level[] levels = new Level[count];
            for (int i = 0; i < count; ++i) {
                Level level;
                zipEntry = zipFile.getEntry(this.padStringToSize(String.valueOf(i), 3));
                iStream = zipFile.getInputStream(zipEntry);
                BufferedInputStream bStream = new BufferedInputStream(iStream);
                iStreamReader = new InputStreamReader((InputStream)bStream, Game.ENCODING);
                char[] levelChars = new char[(int)zipEntry.getSize()];
                iStreamReader.read(levelChars);
                iStreamReader.close();
                this.frame.levelPanel.level = level = new Level(this.frame, -1);
                level.createLevel(levelChars, i);
                levels[i] = level;
            }
            this.frame.levelPanel.removeGame();
            this.frame.levelPanel.levels = levels;
            this.frame.levelPanel.level = levels[0];
            this.frame.levelPanel.setLevelScheme();
            this.frame.gameListPanel.repopulate(0);
            this.frame.gameListPanel.setAuthorName(author);
            this.frame.levelPanel.updateSlider();
            this.frame.levelPanel.repaint();
            this.frame.updateColumnStatus();
            this.workingPath = file.getPath();
            this.hasWorkingPath = true;
            this.frame.levelPanel.modified = false;
            String filename = file.getName();
            this.lastAccessedFileName = filename.substring(0, filename.length() - MANDATORY_GAME_FILE_EXTENSION.length());
            return;
        }
        catch (FileNotFoundException e) {
            this.frame.levelPanel.removeGame();
            JOptionPane.showMessageDialog(this.frame, "The game \"" + file.getName() + "\" could not be found.", "Loading Error", 0);
            e.printStackTrace();
            return;
        }
        catch (Exception e) {
            this.frame.levelPanel.removeGame();
            JOptionPane.showMessageDialog(this.frame, "There was a problem loading the game. Make sure you have the latest version of the program.", "Loading Error", 0);
            e.printStackTrace();
            return;
        }
        finally {
            try {
                zipFile.close();
            }
            catch (Exception e) {}
        }
    }

    private String ensureFileExtension(String path, String ext) {
        if (path.length() < ext.length()) {
            return path + ext;
        }
        if (path.subSequence(path.length() - ext.length(), path.length()).equals(ext)) {
            return path;
        }
        return path + ext;
    }

    private String padStringToSize(String string, int size) {
        while (string.length() < size) {
            string = "0" + string;
        }
        return string;
    }

    public class GameData {
        public char[][] levels;
        public String author;
        public String filename;
        public int startingLevel;

        public GameData(char[][] levels, String author, int startingLevel, String filename) {
            this.levels = levels;
            this.author = author;
            this.startingLevel = startingLevel;
            this.filename = filename;
        }
    }
}

