/*
 * Decompiled with CFR 0.152.
 */
package supermario.builder;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.ImageIcon;
import supermario.builder.BuilderFrame;
import supermario.builder.Button;
import supermario.builder.ImageBuilder;
import supermario.builder.ItemFitting;
import supermario.builder.Warp;
import supermario.game.Game;
import supermario.game.LevelLoader;

public final class Item {
    private BuilderFrame frame;
    public char character;
    public String name;
    public Button button;
    public Warp warp;
    public int tilesWidth;
    public int tilesHeight;
    public int checkpointType;
    public int oscOffset;
    public int coinCount;
    public int displayWarpNumber;
    public int fireballColor;
    public int warpPipeColor;
    public boolean inserted;
    public boolean draggable;
    public boolean immobile;
    public boolean flip;
    public boolean flippable;
    public boolean shifted;
    public boolean shiftable;
    public boolean speedBoost;
    public boolean platformRepeatable;
    public boolean singlePlatform;
    public boolean poison;
    public boolean redPiranha;
    public boolean superSpring;
    public int oldXTile;
    public int oldYTile;
    public int xTile;
    public int yTile;
    private int xPixel;
    private int yPixel;
    public static final int ANY_ROW = -1;
    public static final int RANDOM_COIN_COUNT = 0;
    public int requiredRow;
    public int horizontalDrawOffset;
    public int verticalDrawOffset;
    public static final int PLATFORM_PADDING = 0;
    public static final int REQUIRES_BACKGROUND = 0;
    public static final int REQUIRES_SHIFTABLE_BACKGROUND = 1;
    public static final int REQUIRES_IMAGE_TILES = 2;
    public static final int REQUIRES_REP_PLATFORM = 3;
    public static final int REQUIRES_FIREBAR = 4;
    public static final int REQUIRES_FLYING_KOOPA_V = 5;
    public static final int REQUIRES_FLYING_KOOPA_H = 6;
    public static final int REQUIRES_OSC_H_PLATFORM = 7;
    public static final int REQUIRES_BRIDGE = 8;
    public static final int REQUIRES_LEFT_FACING_PIPE = 9;
    public static final int REQUIRES_RIGHT_FACING_PIPE = 10;
    public static final int REQUIRES_UP_FACING_PIPE = 11;
    public static final int REQUIRES_DOWN_FACING_PIPE = 12;
    public static final int REQUIRES_WARP_ZONE_PIPE = 13;
    public static final int REQUIRES_ZIG_ZAG_FISH = 14;
    public static final int REQUIRES_COLUMN_INSERTION = 15;
    public static final int REQUIRES_COLUMN_REMOVAL = 16;
    public static final int REQUIRES_BEANSTALK_ARRIVAL = 17;
    public static final int REQUIRES_CONTENTS_BLOCK = 18;
    public static final int REQUIRES_BEANSTALK_BLOCK = 19;
    public static final int REQUIRES_ENDING_SPACE = 20;
    public static final int REQUIRES_HAMMER_BRO = 21;
    public static final int REQUIRES_FALLING_PLATFORM = 22;
    public static final int REQUIRES_PULLEY_PLATFORM = 23;
    public static final int REQUIRES_OSC_V_PLATFORM = 24;
    public static final int REQUIRES_INF_CORRIDOR = 25;
    public static final int REQUIRES_INVISIBLE_BLOCK = 26;
    public static final int REQUIRES_INVISIBLE_CONTENTS_BLOCK = 27;
    public static final int REQUIRES_INVISIBLE_BEANSTALK_BLOCK = 28;
    public int spaceRequirement;
    public int propertiesType;

    public Item(BuilderFrame frame, char character, String name, Button button, int requiredRow, int spaceRequirement, int horizontalDrawOffset, int verticalDrawOffset, boolean draggable, boolean immobile, int propertiesType) {
        this.frame = frame;
        this.character = character;
        this.name = name;
        this.button = button;
        if (button.placedImage == null) {
            this.tilesWidth = this.button.iconImage.getIconWidth() / 8;
            this.tilesHeight = this.button.iconImage.getIconHeight() / 8;
        } else {
            this.tilesWidth = this.button.placedImage.getIconWidth() / 8;
            this.tilesHeight = this.button.placedImage.getIconHeight() / 8;
        }
        this.requiredRow = requiredRow;
        this.spaceRequirement = spaceRequirement;
        this.horizontalDrawOffset = horizontalDrawOffset;
        this.verticalDrawOffset = verticalDrawOffset;
        this.draggable = draggable;
        this.immobile = immobile;
        this.propertiesType = propertiesType;
        this.coinCount = 0;
        this.fireballColor = 0;
        this.warpPipeColor = 0;
        this.checkpointType = 1;
        if (this.isWarpable()) {
            this.warp = new Warp(false, false, -1, -1, -1, -1, this);
        }
        this.flippable = LevelLoader.isFlippableEnemy(character);
        this.shiftable = LevelLoader.isShiftableBackground(character);
        this.platformRepeatable = LevelLoader.isRepeatablePlatform(character);
    }

    public Item copy() {
        Item itemCopy = new Item(this.frame, this.character, this.name, this.button, this.requiredRow, this.spaceRequirement, this.horizontalDrawOffset, this.verticalDrawOffset, this.draggable, this.immobile, this.propertiesType);
        itemCopy.inserted = this.inserted;
        itemCopy.flip = this.flip;
        itemCopy.flippable = this.flippable;
        itemCopy.coinCount = this.coinCount;
        itemCopy.oscOffset = this.oscOffset;
        itemCopy.checkpointType = this.checkpointType;
        itemCopy.fireballColor = this.fireballColor;
        itemCopy.displayWarpNumber = this.displayWarpNumber;
        itemCopy.warpPipeColor = this.warpPipeColor;
        itemCopy.shifted = this.shifted;
        itemCopy.speedBoost = this.speedBoost;
        itemCopy.singlePlatform = this.singlePlatform;
        itemCopy.poison = this.poison;
        itemCopy.redPiranha = this.redPiranha;
        itemCopy.superSpring = this.superSpring;
        if (this.isWarpable()) {
            itemCopy.warp = this.warp;
            itemCopy.warp.item = itemCopy;
            this.warp = new Warp(false, false, -1, -1, -1, -1, this);
        }
        return itemCopy;
    }

    public static void transferProperties(Item from, Item to) {
        to.flip = from.flip;
        to.flippable = from.flippable;
        to.coinCount = from.coinCount;
        to.oscOffset = from.oscOffset;
        to.checkpointType = from.checkpointType;
        to.fireballColor = from.fireballColor;
        to.displayWarpNumber = from.displayWarpNumber;
        to.warpPipeColor = from.warpPipeColor;
        to.shifted = from.shifted;
        to.speedBoost = from.speedBoost;
        to.singlePlatform = from.singlePlatform;
        to.poison = from.poison;
        to.redPiranha = from.redPiranha;
    }

    public boolean isWarpable() {
        if (this.character == '!' || this.character == '\u2663') {
            return true;
        }
        if (LevelLoader.isSideOpeningPipe(this.character)) {
            return true;
        }
        if (this.character == '~' || this.character == ';') {
            return true;
        }
        if (this.character == '\u0110' || this.character == '\u00bf') {
            return true;
        }
        if (this.character == '\u0108' || this.character == '\u03e4') {
            return true;
        }
        if (this.character == 'G' || this.character == 'N' || this.character == '\u25c4') {
            return true;
        }
        if (this.character == '\u03d8' || this.character == '\u03dc') {
            return true;
        }
        return this.character == '\u00bd';
    }

    public void insertInLevel(int xTile, int yTile) {
        this.frame.levelPanel.modified = true;
        this.xTile = xTile;
        this.yTile = yTile;
        this.replace(true);
    }

    private boolean onlyFillsImageTiles() {
        if (this.spaceRequirement == 2 || this.spaceRequirement == 19) {
            return true;
        }
        if (this.spaceRequirement == 9 || this.spaceRequirement == 10 || this.spaceRequirement == 11 || this.spaceRequirement == 12) {
            return true;
        }
        return this.spaceRequirement == 13 || this.spaceRequirement == 28;
    }

    private void replace(boolean add) {
        if (this.spaceRequirement == 0) {
            this.setItemInRect(add, ItemFitting.Rect.tempRect.setBounds(this.xTile, this.yTile, this.xTile, this.yTile));
        } else if (this.spaceRequirement == 1) {
            this.setItemInRect(add, ItemFitting.Rect.tempRect.setBounds(this.xTile, this.yTile, this.xTile + 1, this.yTile));
        } else if (this.onlyFillsImageTiles()) {
            this.setItemInRect(add, ItemFitting.Rect.tempRect.setBounds(this.xTile, this.yTile, this.xTile + this.tilesWidth - 1, this.yTile + this.tilesHeight - 1));
        } else if (this.spaceRequirement == 21) {
            this.setItemInRect(add, ItemFitting.Rect.tempRect.setBounds(this.xTile - 2, this.yTile, this.xTile - 2 + this.tilesWidth - 1, this.yTile + this.tilesHeight - 1));
        } else if (this.spaceRequirement == 18 || this.spaceRequirement == 26 || this.spaceRequirement == 27) {
            this.setItemInRect(add, ItemFitting.Rect.tempRect.setBounds(this.xTile, this.yTile, this.xTile + this.tilesWidth - 1, this.yTile + this.tilesWidth - 1));
        } else if (this.spaceRequirement == 17) {
            this.setItemInRect(add, ItemFitting.Rect.tempRect.setBounds(this.xTile, this.yTile, this.xTile + this.tilesWidth - 1, Game.yTiles - 1));
            this.setItemInRect(add, ItemFitting.Rect.tempRect.setBounds(this.xTile + 2, this.yTile, this.xTile + 3, this.yTile + 5));
        } else if (this.spaceRequirement == 3) {
            int width = this.button.placedImage.getIconWidth() / 8;
            this.setItemInRect(add, ItemFitting.Rect.tempRect.setBounds(this.xTile, 0, this.xTile + width - 1, 0));
        } else if (this.spaceRequirement == 22 || this.spaceRequirement == 24) {
            int width = this.button.placedImage.getIconWidth() / 8;
            this.setItemInRect(add, ItemFitting.Rect.tempRect.setBounds(this.xTile, this.yTile, this.xTile + width - 1, this.yTile));
        } else if (this.spaceRequirement == 23) {
            int width = Item.getPulleyWidth(this.character);
            int imageWidth = this.button.placedImage.getIconWidth() / 8;
            this.setItemInRect(add, ItemFitting.Rect.tempRect.setBounds(this.xTile, this.yTile, this.xTile + width - 1, this.yTile));
            this.setItemInRect(add, ItemFitting.Rect.tempRect.setBounds(this.xTile + imageWidth - width, this.yTile + 4, this.xTile + imageWidth - 1, this.yTile + 4));
            this.setItemInRect(add, ItemFitting.Rect.tempRect.setBounds(this.xTile + width / 2, this.yTile - 8, this.xTile + imageWidth - width / 2 - 1, this.yTile - 8));
        } else if (this.spaceRequirement == 4) {
            this.setItemInRect(add, ItemFitting.Rect.tempRect.setBounds(this.xTile, this.yTile, this.xTile + 1, this.yTile + 1));
        } else if (this.spaceRequirement == 14) {
            this.setItemInRect(add, ItemFitting.Rect.tempRect.setBounds(this.xTile, this.yTile - 2, this.xTile + 1, this.yTile + 3));
        } else if (this.spaceRequirement == 5) {
            this.setItemInRect(add, ItemFitting.Rect.tempRect.setBounds(this.xTile, this.yTile - 7, this.xTile + this.tilesWidth - 1, this.yTile + 3 - 1 + 7));
        } else if (this.spaceRequirement == 6) {
            this.setItemInRect(add, ItemFitting.Rect.tempRect.setBounds(this.xTile - 6, this.yTile - 1, this.xTile + 2 + 6 - 1, this.yTile + 3));
        } else if (this.spaceRequirement == 7) {
            this.setItemInRect(add, ItemFitting.Rect.tempRect.setBounds(this.xTile - 6, this.yTile, this.xTile - 6 + this.button.placedImage.getIconWidth() / 8 - 1, this.yTile));
        } else if (this.spaceRequirement == 8) {
            this.setItemInRect(add, ItemFitting.Rect.tempRect.setBounds(this.xTile, this.yTile, this.xTile, this.yTile));
        } else if (this.spaceRequirement == 20) {
            if (this.frame.levelPanel.level.levelEndType != 0) {
                this.setItemInRect(add, ItemFitting.Rect.tempRect.setBounds(this.xTile, 0, this.frame.levelPanel.level.items[0].length, this.frame.levelPanel.level.items.length));
            }
        } else if (this.spaceRequirement == 25) {
            int displacement = 56;
            this.setItemInRect(add, ItemFitting.Rect.tempRect.setBounds(this.xTile - displacement, this.yTile, this.xTile - displacement + 2 - 1, this.yTile + this.tilesHeight - 1));
            this.setItemInRect(add, ItemFitting.Rect.tempRect.setBounds(this.xTile, this.yTile, this.xTile + 7, this.yTile + this.tilesHeight - 1));
            this.setItemInRect(add, ItemFitting.Rect.tempRect.setBounds(this.xTile - displacement + 2, this.yTile + 3, this.xTile - 1, this.yTile + 3));
        }
    }

    private void setItemInRect(boolean add, ItemFitting.Rect rect) {
        int levelLength = this.frame.levelPanel.level.items[0].length;
        for (int i = rect.y1; i <= rect.y2; ++i) {
            for (int j = rect.x1; j <= rect.x2; ++j) {
                if (j < 0 || j >= levelLength || i < 0 || i >= Game.yTiles) continue;
                this.frame.levelPanel.level.items[i][j] = add ? this : null;
            }
        }
    }

    public void removeFromLevel() {
        this.replace(false);
    }

    public static int getPulleyWidth(char c) {
        if (c == '\u0398') {
            return 4;
        }
        if (c == '\u25ac') {
            return 6;
        }
        throw new RuntimeException("Wrong character given: " + c);
    }

    public static boolean isPulleyLeftSide(Item tempItem, int xTile) {
        return xTile - tempItem.xTile <= Item.getPulleyWidth(tempItem.character);
    }

    public void drawAtMouse(Graphics2D g2D, int xPixel, int yPixel, double scaleFactor, double TILE_SIZE, boolean drawFitRect) {
        if (this.requiredRow != -1) {
            yPixel = (int)Math.round((double)(this.requiredRow * 8) * scaleFactor);
        }
        if (this.spaceRequirement == 15 || this.spaceRequirement == 16) {
            if (this.frame.levelPanel.columnOperationPossible()) {
                if (this.spaceRequirement == 15) {
                    g2D.setColor(Color.WHITE);
                } else if (this.spaceRequirement == 16) {
                    if (this.frame.levelPanel.level.items[0].length <= Game.xTiles || ItemFitting.isInReservedColumn(this.frame.levelPanel.level, this.xTile, this.yTile)) {
                        return;
                    }
                    g2D.setColor(Color.RED);
                }
                Composite oldComposite = g2D.getComposite();
                g2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                g2D.fillRect(xPixel, 0, (int)Math.ceil(TILE_SIZE * scaleFactor), this.frame.levelPanel.getHeight());
                g2D.setComposite(oldComposite);
            }
        } else if (!this.flip) {
            int xOffset = 0;
            if (this.shiftable && this.shifted) {
                xOffset = (int)Math.round((double)(this.button.placedImage.getIconWidth() - 8) * scaleFactor);
            }
            if (this.character == '\u00fd' && this.shifted) {
                int width = (int)Math.round((double)this.button.placedImage.getIconWidth() * scaleFactor);
                int height = (int)Math.round((double)this.button.placedImage.getIconHeight() * scaleFactor);
                g2D.drawImage(this.getImage(), Math.round(xPixel + width), yPixel, xPixel, yPixel + height, 0, 0, this.button.placedImage.getIconWidth(), this.button.placedImage.getIconHeight(), null);
            } else if (this.poison) {
                int w = (int)Math.ceil((double)this.button.placedImage.getIconWidth() * scaleFactor);
                int halfH = (int)Math.ceil((double)this.button.placedImage.getIconHeight() * scaleFactor / 2.0);
                g2D.drawImage(this.frame.game.textures.poisonMushroom.getImage(), xPixel, (int)Math.round((double)yPixel - (double)this.verticalDrawOffset * scaleFactor), xPixel + w, (int)Math.round((double)yPixel - (double)this.verticalDrawOffset * scaleFactor + (double)halfH), 0, 0, 16, 16, null);
                g2D.drawImage(this.getImage(), xPixel, yPixel, xPixel + w, yPixel + halfH, 0, 16, 16, 32, null);
            } else {
                g2D.drawImage(this.getImage(), (int)Math.round((double)xPixel - (double)this.horizontalDrawOffset * scaleFactor - (double)xOffset), (int)Math.round((double)yPixel - (double)this.verticalDrawOffset * scaleFactor), (int)Math.ceil((double)this.button.placedImage.getIconWidth() * scaleFactor), (int)Math.ceil((double)this.button.placedImage.getIconHeight() * scaleFactor), null);
            }
            if (this.character == '\u00f7') {
                this.drawInfiniteCorridorTickMarks(g2D, xPixel, yPixel, TILE_SIZE, scaleFactor, TILE_SIZE, true);
            }
            if (this.warp != null && this.warp.outgoing && !LevelLoader.isBeanstalkBlock(this.character) && this.character != '\u0108') {
                this.drawOutgoingWarpIndicator(g2D, xPixel, yPixel, scaleFactor);
            }
            if (LevelLoader.isOscSprite(this.character)) {
                if (LevelLoader.isFlyingKoopa(this.character)) {
                    this.drawOscKoopaIndicator(g2D, xPixel, yPixel, scaleFactor, false);
                } else {
                    this.drawOscPlatformIndicator(g2D, xPixel, yPixel, scaleFactor, false);
                }
            }
        } else {
            int width = (int)Math.round((double)this.button.placedImage.getIconWidth() * scaleFactor);
            int height = (int)Math.round((double)this.button.placedImage.getIconHeight() * scaleFactor);
            g2D.drawImage(this.getImage(), xPixel + width, (int)Math.ceil((double)yPixel - (double)this.verticalDrawOffset * scaleFactor), xPixel, (int)Math.ceil((double)yPixel - (double)this.verticalDrawOffset * scaleFactor + (double)height), 0, 0, this.button.placedImage.getIconWidth(), this.button.placedImage.getIconHeight(), null);
        }
        if (drawFitRect) {
            this.drawFitRect(g2D, xPixel, yPixel, scaleFactor, TILE_SIZE);
        }
    }

    public void drawInLevel(Graphics2D g2D, double leftMostX, double scaleFactor, double TILE_SIZE, boolean includeHighlights) {
        int width;
        this.xPixel = (int)Math.round((double)this.xTile * TILE_SIZE * scaleFactor - leftMostX * scaleFactor - (double)this.horizontalDrawOffset * scaleFactor);
        this.yPixel = (int)Math.round((double)this.yTile * TILE_SIZE * scaleFactor - (double)this.verticalDrawOffset * scaleFactor);
        if (!this.flip) {
            int xOffset = 0;
            if (this.shiftable && this.shifted) {
                xOffset = (int)Math.round((double)(this.button.placedImage.getIconWidth() - 8) * scaleFactor);
            }
            if (this.character == '\u00fd' && this.shifted) {
                width = (int)Math.round((double)this.button.placedImage.getIconWidth() * scaleFactor);
                int height = (int)Math.round((double)this.button.placedImage.getIconHeight() * scaleFactor);
                g2D.drawImage(this.getImage(), Math.round(this.xPixel + width), this.yPixel, this.xPixel, this.yPixel + height, 0, 0, this.button.placedImage.getIconWidth(), this.button.placedImage.getIconHeight(), null);
            } else if (this.spaceRequirement == 18 || this.spaceRequirement == 27) {
                Composite oldComposite = g2D.getComposite();
                g2D.setComposite(AlphaComposite.getInstance(3, 0.6f));
                int w = (int)Math.ceil((double)this.button.placedImage.getIconWidth() * scaleFactor);
                int halfH = (int)Math.ceil((double)this.button.placedImage.getIconHeight() * scaleFactor / 2.0);
                if (this.poison) {
                    g2D.drawImage(this.frame.game.textures.poisonMushroom.getImage(), this.xPixel, this.yPixel, this.xPixel + w, this.yPixel + halfH, 0, 0, 16, 16, null);
                } else {
                    g2D.drawImage(this.getImage(), this.xPixel, this.yPixel, this.xPixel + w, this.yPixel + halfH, 0, 0, 16, 16, null);
                }
                g2D.setComposite(oldComposite);
                g2D.drawImage(this.getImage(), this.xPixel, this.yPixel + halfH, this.xPixel + w, this.yPixel + halfH * 2, 0, 16, 16, 32, null);
            } else {
                g2D.drawImage(this.getImage(), this.xPixel - xOffset, this.yPixel, (int)Math.ceil((double)this.button.placedImage.getIconWidth() * scaleFactor), (int)Math.ceil((double)this.button.placedImage.getIconHeight() * scaleFactor), null);
            }
            if (this.character == '\u00f7') {
                this.drawInfiniteCorridorTickMarks(g2D, this.xPixel, this.yPixel, TILE_SIZE, scaleFactor, leftMostX, false);
            }
            if (this.warp != null && this.warp.outgoing && !LevelLoader.isBeanstalkBlock(this.character) && this.character != '\u0108') {
                this.drawOutgoingWarpIndicator(g2D, this.xPixel, this.yPixel, scaleFactor);
            }
            if (LevelLoader.isOscSprite(this.character) && includeHighlights) {
                if (LevelLoader.isFlyingKoopa(this.character)) {
                    this.drawOscKoopaIndicator(g2D, this.xPixel, this.yPixel, scaleFactor, true);
                } else {
                    this.drawOscPlatformIndicator(g2D, this.xPixel, this.yPixel, scaleFactor, true);
                }
            }
        } else {
            int width2 = (int)Math.round((double)this.button.placedImage.getIconWidth() * scaleFactor);
            int height = (int)Math.round((double)this.button.placedImage.getIconHeight() * scaleFactor);
            g2D.drawImage(this.getImage(), this.xPixel + width2, this.yPixel, this.xPixel, this.yPixel + height, 0, 0, this.button.placedImage.getIconWidth(), this.button.placedImage.getIconHeight(), null);
        }
        if (includeHighlights) {
            if (this.spaceRequirement == 0 || this.spaceRequirement == 1) {
                if (this.character == '\u00be' || this.character == '\u00e5' || this.character == 'g' || this.character == '\u00b5' || this.character == 'f') {
                    return;
                }
                g2D.setColor(Color.WHITE);
                Composite oldComposite = g2D.getComposite();
                g2D.setComposite(AlphaComposite.getInstance(3, 0.25f));
                width = (int)Math.ceil(8.0 * scaleFactor);
                if (this.spaceRequirement == 1) {
                    width *= 2;
                }
                g2D.fillRect(this.xPixel, this.yPixel, width, (int)Math.ceil(8.0 * scaleFactor));
                g2D.setComposite(oldComposite);
            } else if (this.spaceRequirement == 3) {
                g2D.setColor(Color.WHITE);
                Composite oldComposite = g2D.getComposite();
                g2D.setComposite(AlphaComposite.getInstance(3, 0.25f));
                width = (int)Math.ceil((double)(8 * this.tilesWidth) * scaleFactor);
                g2D.fillRect(this.xPixel, 0, width, (int)Math.ceil(8.0 * scaleFactor));
                g2D.setComposite(oldComposite);
            }
        }
    }

    private void drawOscPlatformIndicator(Graphics2D g2D, int xPixel, int yPixel, double scaleFactor, boolean inLevel) {
        int offsetOffset = (int)Math.round((double)(this.oscOffset * 8) * scaleFactor);
        int circleSize = (int)Math.round(8.0 * scaleFactor);
        int arrowHOffset = 0;
        int arrowVOffset = 0;
        if (inLevel) {
            if (LevelLoader.isVOscPlatform(this.character)) {
                arrowVOffset = (int)Math.round((double)this.verticalDrawOffset * scaleFactor);
            } else if (LevelLoader.isHOscPlatform(this.character)) {
                arrowHOffset = (int)Math.round((double)this.horizontalDrawOffset * scaleFactor);
            }
        }
        Composite oldComposite = g2D.getComposite();
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        g2D.setColor(Color.BLUE);
        g2D.fillOval(xPixel + arrowHOffset + offsetOffset, yPixel + arrowVOffset, circleSize, circleSize);
        g2D.setComposite(oldComposite);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private void drawOscKoopaIndicator(Graphics2D g2D, int xPixel, int yPixel, double scaleFactor, boolean inLevel) {
        if (this.oscOffset == 0) {
            return;
        }
        ImageIcon image = null;
        image = this.character == '\u00ac' || this.character == '*' ? this.frame.game.textures.lightKoopa4 : (this.character == '\u00b1' || this.character == '-' ? this.frame.game.textures.darkKoopa4 : this.frame.game.textures.redKoopa4);
        double hOffset = 0.0;
        double vOffset = 0.0;
        if (inLevel) {
            hOffset = (double)this.horizontalDrawOffset * scaleFactor;
            vOffset = (double)this.verticalDrawOffset * scaleFactor;
        }
        boolean reverseImage = false;
        if (LevelLoader.isHOscKoopa(this.character)) {
            if (this.oscOffset == 1) {
                hOffset += (double)(-this.horizontalDrawOffset) * scaleFactor;
                reverseImage = true;
            } else if (this.oscOffset == 2) {
                hOffset += (double)image.getIconWidth() * scaleFactor;
                reverseImage = true;
            } else if (this.oscOffset == 3) {
                hOffset += (double)(this.button.placedImage.getIconWidth() / 2 - image.getIconWidth() / 2) * scaleFactor;
            }
        } else if (this.oscOffset == 1) {
            vOffset += (double)this.verticalDrawOffset * scaleFactor;
        } else if (this.oscOffset == 2) {
            vOffset += (double)(-image.getIconHeight() / 2) * scaleFactor;
        } else if (this.oscOffset == 3) {
            vOffset += (double)(-this.verticalDrawOffset) * scaleFactor;
        }
        Composite oldComposite = g2D.getComposite();
        AffineTransform oldTransform = g2D.getTransform();
        g2D.setComposite(AlphaComposite.getInstance(3, 0.4f));
        g2D.translate((double)xPixel + hOffset, (double)yPixel + vOffset);
        g2D.scale(scaleFactor, scaleFactor);
        if (reverseImage) {
            g2D.scale(-1.0, 1.0);
            g2D.translate(-image.getIconWidth(), 0);
        }
        g2D.drawImage(image.getImage(), 0, 0, null);
        g2D.setTransform(oldTransform);
        g2D.setComposite(oldComposite);
    }

    private void drawOutgoingWarpIndicator(Graphics2D g2D, int xPixel, int yPixel, double scaleFactor) {
        Composite oldComposite = g2D.getComposite();
        g2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        g2D.setStroke(new BasicStroke((int)Math.round(2.0 * scaleFactor)));
        g2D.setColor(Color.BLUE);
        if (LevelLoader.isUpwardOpeningPipe(this.character)) {
            g2D.drawRect(xPixel, yPixel, (int)Math.round((double)(this.tilesWidth * 8) * scaleFactor), (int)Math.round(16.0 * scaleFactor));
        } else if (LevelLoader.isDownwardOpeningPipe(this.character)) {
            g2D.drawRect(xPixel, (int)Math.round((double)yPixel + 16.0 * scaleFactor), (int)Math.round((double)(this.tilesWidth * 8) * scaleFactor), (int)Math.round(16.0 * scaleFactor));
        } else if (LevelLoader.isLeftOpeningPipe(this.character)) {
            g2D.drawRect(xPixel, yPixel, (int)Math.round(16.0 * scaleFactor), (int)Math.round((double)(8 * this.tilesHeight) * scaleFactor));
        } else if (LevelLoader.isRightOpeningPipe(this.character)) {
            g2D.drawRect((int)Math.round((double)xPixel + (double)(8 * this.tilesWidth) * scaleFactor - 16.0 * scaleFactor), yPixel, (int)Math.round(16.0 * scaleFactor), (int)Math.round((double)(8 * this.tilesHeight) * scaleFactor));
        }
        g2D.setComposite(oldComposite);
    }

    private void drawInfiniteCorridorTickMarks(Graphics2D g2D, int xPixel, int yPixel, double TILE_SIZE, double scaleFactor, double leftMostX, boolean atMouse) {
        g2D.setColor(Color.WHITE);
        if (atMouse) {
            g2D.fillRect((int)Math.round((double)xPixel - (double)(Game.xTiles / 2 - 1 + 2) * TILE_SIZE * scaleFactor - scaleFactor), yPixel, 3, (int)Math.ceil((double)this.tilesHeight * TILE_SIZE * scaleFactor));
            g2D.fillRect((int)Math.round((double)xPixel - (double)(Game.xTiles / 2 - 1) * TILE_SIZE * scaleFactor - (double)this.horizontalDrawOffset * scaleFactor), yPixel, 3, (int)Math.ceil((double)this.tilesHeight * TILE_SIZE * scaleFactor));
            g2D.fillRect((int)Math.round((double)xPixel + (double)(Game.xTiles / 2 + 1 + 4) * TILE_SIZE * scaleFactor - (double)this.horizontalDrawOffset * scaleFactor), yPixel, 3, (int)Math.ceil((double)this.tilesHeight * TILE_SIZE * scaleFactor));
            int trapWidth = 8;
            g2D.fillRect((int)Math.round((double)xPixel + (double)(Game.xTiles / 2 - 1 + trapWidth + 2) * TILE_SIZE * scaleFactor), yPixel, 3, (int)Math.ceil((double)this.tilesHeight * TILE_SIZE * scaleFactor));
        } else {
            g2D.fillRect((int)Math.round((double)(this.xTile - Game.xTiles / 2 + 1 - 2) * TILE_SIZE * scaleFactor - leftMostX * scaleFactor), yPixel, 3, (int)Math.ceil((double)this.tilesHeight * TILE_SIZE * scaleFactor));
            g2D.fillRect((int)Math.round((double)(this.xTile - Game.xTiles / 2 + 1) * TILE_SIZE * scaleFactor - (leftMostX + (double)this.horizontalDrawOffset) * scaleFactor), yPixel, 3, (int)Math.ceil((double)this.tilesHeight * TILE_SIZE * scaleFactor));
            g2D.fillRect((int)Math.round((double)(this.xTile + Game.xTiles / 2 + 1 + 4) * TILE_SIZE * scaleFactor - (leftMostX + (double)this.horizontalDrawOffset) * scaleFactor), yPixel, 3, (int)Math.ceil((double)this.tilesHeight * TILE_SIZE * scaleFactor));
            int trapWidth = 8;
            g2D.fillRect((int)Math.round((double)(this.xTile + Game.xTiles / 2 - 1 + trapWidth + 2) * TILE_SIZE * scaleFactor - leftMostX * scaleFactor), yPixel, 3, (int)Math.ceil((double)this.tilesHeight * TILE_SIZE * scaleFactor));
        }
    }

    private Image getImage() {
        if (this.speedBoost) {
            if (this.button.placedImage == this.frame.textures.displayFirebarDarkLong) {
                return this.frame.textures.displayFirebarDarkLongFast.getImage();
            }
            if (this.button.placedImage == this.frame.textures.displayFirebarDarkShort) {
                return this.frame.textures.displayFirebarDarkShortFast.getImage();
            }
            if (this.button.placedImage == this.frame.textures.displayFirebarLightShort) {
                return this.frame.textures.displayFirebarLightShortFast.getImage();
            }
            if (this.button.placedImage == this.frame.textures.displayFirebarLightLong) {
                return this.frame.textures.displayFirebarLightLongFast.getImage();
            }
            if (this.button.placedImage == this.frame.textures.displayFirebarStoneShort) {
                return this.frame.textures.displayFirebarStoneShortFast.getImage();
            }
            if (this.button.placedImage == this.frame.textures.displayFirebarStoneLong) {
                return this.frame.textures.displayFirebarStoneLongFast.getImage();
            }
            if (this.button.placedImage == this.frame.textures.displayFirebarWaterShort) {
                return this.frame.textures.displayFirebarWaterShortFast.getImage();
            }
            if (this.button.placedImage == this.frame.textures.displayFirebarWaterLong) {
                return this.frame.textures.displayFirebarWaterLongFast.getImage();
            }
            return null;
        }
        if (this.singlePlatform) {
            if (this.button.placedImage == this.frame.textures.displayPlatformExtraShortRepDown) {
                return this.frame.textures.displayPlatformExtraShortRepDownSingle.getImage();
            }
            if (this.button.placedImage == this.frame.textures.displayPlatformExtraShortRepUp) {
                return this.frame.textures.displayPlatformExtraShortRepUpSingle.getImage();
            }
            if (this.button.placedImage == this.frame.textures.displayPlatformShortRepDown) {
                return this.frame.textures.displayPlatformShortRepDownSingle.getImage();
            }
            if (this.button.placedImage == this.frame.textures.displayPlatformShortRepUp) {
                return this.frame.textures.displayPlatformShortRepUpSingle.getImage();
            }
            if (this.button.placedImage == this.frame.textures.displayPlatformLongRepUp) {
                return this.frame.textures.displayPlatformLongRepUpSingle.getImage();
            }
            if (this.button.placedImage == this.frame.textures.displayPlatformLongRepDown) {
                return this.frame.textures.displayPlatformLongRepDownSingle.getImage();
            }
            return null;
        }
        if (this.character == '.' && this.fireballColor != 2) {
            if (this.fireballColor == 0) {
                return this.frame.textures.displayLavaballRed.getImage();
            }
            if (this.fireballColor == 1) {
                return this.frame.textures.displayLavaballBlue.getImage();
            }
            return null;
        }
        if (this.character == '\u0108' && this.warpPipeColor != 0) {
            if (this.warpPipeColor == 1) {
                return this.frame.game.textures.warpZonePipeGreen.getImage();
            }
            if (this.warpPipeColor == 2) {
                return this.frame.game.textures.warpZonePipeWhite.getImage();
            }
            if (this.warpPipeColor == 3) {
                return this.frame.game.textures.warpZonePipeBlue.getImage();
            }
            return null;
        }
        if (this.button.placedImage == this.frame.textures.displayFlagEndingGreen) {
            if (this.frame.levelPanel.level.pipeColor == 2 || this.frame.levelPanel.level.pipeColor == 0 && this.frame.levelPanel.level.levelType == 4) {
                return this.frame.textures.displayFlagEndingWhite.getImage();
            }
            return this.button.placedImage.getImage();
        }
        if (this.frame.game.textures.customTextChars.containsKey(Character.valueOf(this.character))) {
            return this.frame.game.textures.symbols.get(this.frame.game.textures.customTextChars.get(Character.valueOf(this.character))).getImage();
        }
        if (this.redPiranha) {
            return ImageBuilder.createPipeImage(LevelLoader.getPipeType(this.character), this.frame.pipesPanel.getCurrentPipeColor(), 0, true).getImage();
        }
        if (this.superSpring) {
            if (this.button.iconImage == this.frame.game.textures.springRed) {
                return this.frame.game.textures.springGreenLight.getImage();
            }
            if (this.button.iconImage == this.frame.game.textures.springBlue) {
                return this.frame.game.textures.springGreenDark.getImage();
            }
            if (this.button.iconImage == this.frame.game.textures.springGray) {
                return this.frame.game.textures.springGreenStone.getImage();
            }
            throw new IllegalStateException("Unknown super spring image type needed.");
        }
        return this.button.placedImage.getImage();
    }

    private void drawFitRect(Graphics2D g2D, int xPixel, int yPixel, double scaleFactor, double TILE_SIZE) {
        g2D.setColor(Color.RED);
        Composite oldComposite = g2D.getComposite();
        g2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        if (this.spaceRequirement == 0) {
            g2D.fillRect(xPixel, yPixel, (int)Math.ceil(TILE_SIZE * scaleFactor), (int)Math.ceil(TILE_SIZE * scaleFactor));
        } else if (this.spaceRequirement == 1) {
            g2D.fillRect(xPixel, yPixel, (int)Math.ceil(TILE_SIZE * 2.0 * scaleFactor), (int)Math.ceil(TILE_SIZE * scaleFactor));
        } else if (this.spaceRequirement == 2) {
            g2D.fillRect(xPixel, yPixel, (int)Math.ceil(TILE_SIZE * (double)this.tilesWidth * scaleFactor), (int)Math.ceil(TILE_SIZE * (double)this.tilesHeight * scaleFactor));
        } else if (this.spaceRequirement == 21) {
            int blockSize = (int)Math.ceil(TILE_SIZE * 2.0 * scaleFactor);
            g2D.fillRect(xPixel - blockSize, yPixel, (int)Math.ceil(TILE_SIZE * (double)this.tilesWidth * scaleFactor), (int)Math.ceil(TILE_SIZE * (double)this.tilesHeight * scaleFactor));
        } else if (this.spaceRequirement == 18) {
            int blockSize = (int)Math.ceil(TILE_SIZE * (double)this.tilesWidth * scaleFactor);
            g2D.fillRect(xPixel, yPixel - blockSize, blockSize, blockSize * 2);
        } else if (this.spaceRequirement == 26) {
            int blockSize = (int)Math.ceil(TILE_SIZE * (double)this.tilesWidth * scaleFactor);
            g2D.fillRect(xPixel, yPixel, blockSize, blockSize * 2);
        } else if (this.spaceRequirement == 27) {
            int blockSize = (int)Math.ceil(TILE_SIZE * (double)this.tilesWidth * scaleFactor);
            g2D.fillRect(xPixel, yPixel - blockSize, blockSize, blockSize * 3);
        } else if (this.spaceRequirement == 17) {
            int width = (int)Math.ceil(TILE_SIZE * (double)this.tilesWidth * scaleFactor);
            g2D.fillRect(xPixel, yPixel, width, (int)Math.ceil(TILE_SIZE * (double)this.tilesHeight * scaleFactor));
            g2D.fillRect(xPixel + width, yPixel, (int)Math.ceil(TILE_SIZE * scaleFactor * 2.0), (int)Math.ceil(TILE_SIZE * 6.0 * scaleFactor));
        } else if (this.spaceRequirement == 3) {
            int padding = (int)Math.ceil(0.0 * TILE_SIZE * scaleFactor);
            int width = (int)Math.ceil((double)this.button.placedImage.getIconWidth() * scaleFactor + (double)(padding * 2));
            g2D.fillRect(xPixel - padding, 0, width, this.frame.levelPanel.getHeight());
        } else if (this.spaceRequirement == 22) {
            int padding = (int)Math.ceil(0.0 * TILE_SIZE * scaleFactor);
            int width = (int)Math.ceil((double)this.button.placedImage.getIconWidth() * scaleFactor + (double)(padding * 2));
            g2D.fillRect(xPixel - padding, yPixel, width, this.frame.levelPanel.getHeight() - yPixel);
        } else if (this.spaceRequirement == 23) {
            int width = (int)Math.ceil((double)Item.getPulleyWidth(this.character) * TILE_SIZE * scaleFactor);
            int aboveArea = (int)Math.ceil(6.0 * TILE_SIZE * scaleFactor);
            int padding = (int)Math.ceil(0.0 * TILE_SIZE * scaleFactor);
            int imageSize = (int)Math.ceil((double)this.button.placedImage.getIconWidth() * scaleFactor);
            int height = (int)Math.ceil((double)Game.yTiles * TILE_SIZE * scaleFactor - (double)(yPixel - aboveArea));
            g2D.fillRect(xPixel - padding, yPixel - aboveArea, width + padding * 2, height);
            g2D.fillRect(xPixel + imageSize - width - padding, yPixel - aboveArea, width + padding * 2, height);
            g2D.fillRect(xPixel + width / 2, yPixel - (int)Math.ceil(8.0 * TILE_SIZE * scaleFactor), (int)Math.ceil((double)this.button.placedImage.getIconWidth() * scaleFactor) - width, (int)Math.ceil(TILE_SIZE * scaleFactor));
        } else if (this.spaceRequirement == 24) {
            int padding = (int)Math.ceil(0.0 * TILE_SIZE * scaleFactor);
            int yOffset = (int)Math.ceil(4.0 * TILE_SIZE * scaleFactor);
            int height = (int)Math.ceil((double)this.button.placedImage.getIconHeight() * scaleFactor + 2.0 * (4.0 * TILE_SIZE) * scaleFactor);
            int width = (int)Math.ceil((double)this.button.placedImage.getIconWidth() * scaleFactor + (double)(padding * 2));
            g2D.fillRect(xPixel - padding, yPixel - (int)Math.ceil((double)this.verticalDrawOffset * scaleFactor) - yOffset, width, height);
        } else if (this.spaceRequirement == 4) {
            g2D.fillRect(xPixel, yPixel, (int)Math.ceil(TILE_SIZE * 2.0 * scaleFactor), (int)Math.ceil(TILE_SIZE * 2.0 * scaleFactor));
        } else if (this.spaceRequirement == 14) {
            g2D.fillRect(xPixel, (int)Math.ceil((double)yPixel - TILE_SIZE * 2.0 * scaleFactor), (int)Math.ceil(TILE_SIZE * 2.0 * scaleFactor), (int)Math.ceil(TILE_SIZE * 2.0 * scaleFactor * 3.0));
        } else if (this.spaceRequirement == 5) {
            int flyHeight = (int)Math.ceil(7.0 * TILE_SIZE * scaleFactor);
            g2D.fillRect(xPixel, yPixel - flyHeight, (int)Math.ceil(TILE_SIZE * (double)this.tilesWidth * scaleFactor), (int)Math.ceil((double)(flyHeight * 2) + TILE_SIZE * 3.0 * scaleFactor));
        } else if (this.spaceRequirement == 6) {
            int flyWidth = (int)Math.ceil(6.0 * TILE_SIZE * scaleFactor);
            int blockExtension = (int)Math.ceil(TILE_SIZE * scaleFactor);
            g2D.fillRect(xPixel - flyWidth, yPixel - blockExtension, (int)Math.ceil((double)(flyWidth * 2) + TILE_SIZE * 2.0 * scaleFactor), (int)Math.ceil(TILE_SIZE * (double)this.tilesHeight * scaleFactor) + blockExtension * 2);
        } else if (this.spaceRequirement == 7) {
            int flyWidth = (int)Math.ceil(6.0 * TILE_SIZE * scaleFactor);
            int padding = (int)Math.ceil(0.0 * TILE_SIZE * scaleFactor);
            g2D.fillRect(xPixel - flyWidth - padding, yPixel - (int)Math.ceil(TILE_SIZE * scaleFactor * 4.0), (int)Math.ceil((double)this.tilesWidth * TILE_SIZE * scaleFactor + (double)(padding * 2)), (int)Math.ceil(TILE_SIZE * scaleFactor * 9.0));
        } else if (this.spaceRequirement == 8) {
            g2D.fillRect(xPixel, yPixel, (int)Math.ceil(TILE_SIZE * scaleFactor), (int)Math.ceil(TILE_SIZE * scaleFactor));
        } else if (this.spaceRequirement == 9) {
            g2D.fillRect((int)Math.round((double)xPixel - 2.0 * TILE_SIZE * scaleFactor), yPixel, (int)Math.round((double)(2 + this.tilesWidth) * TILE_SIZE * scaleFactor), (int)Math.round(4.0 * TILE_SIZE * scaleFactor));
        } else if (this.spaceRequirement == 10) {
            g2D.fillRect(xPixel, yPixel, (int)Math.ceil((double)(2 + this.tilesWidth) * TILE_SIZE * scaleFactor), (int)Math.ceil(4.0 * TILE_SIZE * scaleFactor));
        } else if (this.spaceRequirement == 11 || this.spaceRequirement == 13) {
            g2D.fillRect(xPixel, (int)Math.round((double)yPixel - 4.0 * TILE_SIZE * scaleFactor), (int)Math.ceil(TILE_SIZE * (double)this.tilesWidth * scaleFactor), (int)Math.ceil(TILE_SIZE * (double)(4 + this.tilesHeight) * scaleFactor));
        } else if (this.spaceRequirement == 12) {
            g2D.fillRect(xPixel, yPixel, (int)Math.ceil(TILE_SIZE * (double)this.tilesWidth * scaleFactor), (int)Math.ceil(TILE_SIZE * (double)(4 + this.tilesHeight) * scaleFactor));
        } else if (this.spaceRequirement == 19) {
            double blockSize = TILE_SIZE * 2.0 * scaleFactor;
            int height = (int)Math.ceil((double)yPixel + blockSize);
            g2D.fillRect(xPixel, 0, (int)Math.ceil(blockSize), height);
        } else if (this.spaceRequirement == 28) {
            double blockSize = TILE_SIZE * 2.0 * scaleFactor;
            int height = (int)Math.ceil((double)yPixel + blockSize * 2.0);
            g2D.fillRect(xPixel, 0, (int)Math.ceil(blockSize), height);
        } else if (this.spaceRequirement == 25) {
            int displacement = 56;
            int trapTiles = 8;
            g2D.fillRect(xPixel, yPixel, (int)Math.ceil((double)trapTiles * TILE_SIZE * scaleFactor), (int)Math.ceil(TILE_SIZE * (double)this.tilesHeight * scaleFactor));
            g2D.fillRect(xPixel - (int)Math.ceil((double)displacement * TILE_SIZE * scaleFactor), yPixel, (int)Math.ceil(TILE_SIZE * 2.0 * scaleFactor), (int)Math.ceil(TILE_SIZE * (double)this.tilesHeight * scaleFactor));
            g2D.fillRect(xPixel - (int)Math.ceil((double)(displacement - 2) * TILE_SIZE * scaleFactor), yPixel + (int)Math.ceil((double)(this.tilesHeight - 1) * TILE_SIZE * scaleFactor), (int)Math.ceil((double)(displacement - 2) * TILE_SIZE * scaleFactor), (int)Math.ceil(TILE_SIZE * scaleFactor));
        }
        g2D.setComposite(oldComposite);
    }

    public void drawBlockingRectangle(Graphics2D g2D, double scaleFactor, double TILE_SIZE) {
        g2D.setColor(Color.WHITE);
        Composite oldComposite = g2D.getComposite();
        g2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
        if (this.spaceRequirement == 0) {
            g2D.fillRect(this.xPixel, this.yPixel, (int)Math.ceil(TILE_SIZE * scaleFactor), (int)Math.ceil(TILE_SIZE * scaleFactor));
        } else if (this.spaceRequirement == 1) {
            g2D.fillRect(this.xPixel, this.yPixel, (int)Math.ceil(TILE_SIZE * 2.0 * scaleFactor), (int)Math.ceil(TILE_SIZE * scaleFactor));
        } else if (this.spaceRequirement == 2) {
            g2D.fillRect(this.xPixel, this.yPixel, (int)Math.ceil(TILE_SIZE * (double)this.tilesWidth * scaleFactor), (int)Math.ceil(TILE_SIZE * (double)this.tilesHeight * scaleFactor));
        } else if (this.spaceRequirement == 21) {
            g2D.fillRect(this.xPixel, this.yPixel, (int)Math.ceil(TILE_SIZE * (double)this.tilesWidth * scaleFactor), (int)Math.ceil(TILE_SIZE * (double)this.tilesHeight * scaleFactor));
        } else if (this.spaceRequirement == 4) {
            g2D.fillRect(this.xPixel, (int)Math.ceil((double)this.yPixel + TILE_SIZE * (double)(this.tilesHeight - 2) * scaleFactor), (int)Math.ceil(TILE_SIZE * 2.0 * scaleFactor), (int)Math.ceil(TILE_SIZE * 2.0 * scaleFactor));
        } else if (this.spaceRequirement == 14) {
            g2D.fillRect(this.xPixel, this.yPixel, (int)Math.ceil(TILE_SIZE * 2.0 * scaleFactor), (int)Math.ceil(TILE_SIZE * 2.0 * scaleFactor * 3.0));
        } else if (this.spaceRequirement == 5) {
            int flyHeight = (int)Math.ceil(7.0 * TILE_SIZE * scaleFactor);
            g2D.fillRect(this.xPixel, this.yPixel, (int)Math.ceil(TILE_SIZE * (double)this.tilesWidth * scaleFactor), (int)Math.ceil((double)(flyHeight * 2) + TILE_SIZE * 3.0 * scaleFactor));
        } else if (this.spaceRequirement == 6) {
            int flyWidth = (int)Math.ceil(6.0 * TILE_SIZE * scaleFactor);
            int blockExtension = (int)Math.ceil(TILE_SIZE * scaleFactor);
            g2D.fillRect(this.xPixel, this.yPixel - blockExtension, (int)Math.ceil((double)(flyWidth * 2) + TILE_SIZE * 2.0 * scaleFactor), (int)Math.ceil(TILE_SIZE * (double)this.tilesHeight * scaleFactor) + blockExtension * 2);
        } else if (this.spaceRequirement == 8) {
            g2D.fillRect(this.xPixel, (int)Math.ceil((double)this.yPixel + TILE_SIZE * scaleFactor), (int)Math.ceil(TILE_SIZE * scaleFactor), (int)Math.ceil(TILE_SIZE * scaleFactor));
        } else if (this.spaceRequirement == 25) {
            int displacement = 56;
            int trapTiles = 8;
            g2D.fillRect((int)Math.ceil((double)this.xPixel + (double)displacement * TILE_SIZE * scaleFactor), this.yPixel, (int)Math.ceil((double)trapTiles * TILE_SIZE * scaleFactor), (int)Math.ceil(TILE_SIZE * (double)this.tilesHeight * scaleFactor));
            g2D.fillRect(this.xPixel, this.yPixel, (int)Math.ceil(TILE_SIZE * 2.0 * scaleFactor), (int)Math.ceil(TILE_SIZE * (double)this.tilesHeight * scaleFactor));
            g2D.fillRect((int)Math.ceil((double)this.xPixel + TILE_SIZE * scaleFactor * 2.0), this.yPixel + (int)Math.ceil((double)(this.tilesHeight - 1) * TILE_SIZE * scaleFactor), (int)Math.ceil((double)(displacement - 2) * TILE_SIZE * scaleFactor), (int)Math.ceil(TILE_SIZE * scaleFactor));
        } else if (this.spaceRequirement == 3) {
            int padding = (int)Math.ceil(0.0 * TILE_SIZE * scaleFactor);
            int width = (int)Math.ceil((double)this.button.placedImage.getIconWidth() * scaleFactor + (double)(padding * 2));
            g2D.fillRect(this.xPixel - padding, 0, width, this.frame.levelPanel.getHeight());
        } else if (this.spaceRequirement == 22) {
            int padding = (int)Math.ceil(0.0 * TILE_SIZE * scaleFactor);
            int width = (int)Math.ceil((double)this.button.placedImage.getIconWidth() * scaleFactor + (double)(padding * 2));
            g2D.fillRect(this.xPixel - padding, this.yPixel, width, this.frame.levelPanel.getHeight() - this.yPixel);
        } else if (this.spaceRequirement == 24) {
            int padding = (int)Math.ceil(0.0 * TILE_SIZE * scaleFactor);
            int yOffset = (int)Math.ceil(4.0 * TILE_SIZE * scaleFactor);
            int height = (int)Math.ceil((double)this.button.placedImage.getIconHeight() * scaleFactor + 2.0 * (4.0 * TILE_SIZE) * scaleFactor);
            int width = (int)Math.ceil((double)this.button.placedImage.getIconWidth() * scaleFactor + (double)(padding * 2));
            g2D.fillRect(this.xPixel - padding, this.yPixel - yOffset, width, height);
        } else if (this.spaceRequirement == 7) {
            int flyWidth = (int)Math.ceil(6.0 * TILE_SIZE * scaleFactor);
            g2D.fillRect(this.xPixel - flyWidth + (int)Math.ceil(((double)this.horizontalDrawOffset - 0.0 * TILE_SIZE) * scaleFactor), this.yPixel - (int)Math.ceil(TILE_SIZE * scaleFactor * 4.0), (int)Math.ceil((double)(this.tilesWidth + 0) * TILE_SIZE * scaleFactor), (int)Math.ceil(TILE_SIZE * scaleFactor * 9.0));
        } else if (this.spaceRequirement == 23) {
            int width = (int)Math.ceil((double)Item.getPulleyWidth(this.character) * TILE_SIZE * scaleFactor);
            int blockSize = (int)Math.ceil((5.0 + TILE_SIZE) * scaleFactor);
            int padding = (int)Math.ceil(0.0 * TILE_SIZE * scaleFactor);
            int imageSize = (int)Math.ceil((double)this.button.placedImage.getIconWidth() * scaleFactor);
            int height = (int)Math.ceil((double)Game.yTiles * TILE_SIZE * scaleFactor - (double)this.yPixel);
            int tile = (int)Math.ceil(TILE_SIZE * scaleFactor);
            g2D.fillRect(this.xPixel - padding, this.yPixel + blockSize, width + padding * 2, height);
            g2D.fillRect(this.xPixel + imageSize - width - padding, this.yPixel + blockSize, width + padding * 2, height);
            g2D.fillRect(this.xPixel + width / 2, this.yPixel - tile + (int)Math.round(5.0 * scaleFactor), imageSize - width, tile);
        } else if (this.character == '!' || this.character == '\u2021') {
            g2D.fillRect((int)Math.round((double)this.xPixel - 2.0 * TILE_SIZE * scaleFactor), this.yPixel, (int)Math.round((double)(2 + this.tilesWidth) * TILE_SIZE * scaleFactor), (int)Math.round(4.0 * TILE_SIZE * scaleFactor));
        } else if (this.character == '\u2663' || this.character == '\u00ee') {
            g2D.fillRect(Math.round(this.xPixel), this.yPixel, (int)Math.round((double)(2 + this.tilesWidth) * TILE_SIZE * scaleFactor), (int)Math.round(4.0 * TILE_SIZE * scaleFactor));
        } else if (this.character == '~' || this.character == ';' || this.character == '\u0108') {
            g2D.fillRect(this.xPixel, (int)Math.round((double)this.yPixel - 4.0 * TILE_SIZE * scaleFactor), (int)Math.ceil(TILE_SIZE * (double)this.tilesWidth * scaleFactor), (int)Math.ceil(TILE_SIZE * (double)(4 + this.tilesHeight) * scaleFactor));
        } else if (this.character == '\u0110' || this.character == '\u00bf') {
            g2D.fillRect(this.xPixel, this.yPixel, (int)Math.ceil(TILE_SIZE * (double)this.tilesWidth * scaleFactor), (int)Math.ceil(TILE_SIZE * (double)(4 + this.tilesHeight) * scaleFactor));
        } else if (this.spaceRequirement == 18 || this.spaceRequirement == 26) {
            int blockSize = (int)Math.ceil(TILE_SIZE * (double)this.tilesWidth * scaleFactor);
            g2D.fillRect(this.xPixel, this.yPixel, blockSize, blockSize * 2);
        } else if (this.spaceRequirement == 27) {
            int blockSize = (int)Math.ceil(TILE_SIZE * (double)this.tilesWidth * scaleFactor);
            g2D.fillRect(this.xPixel, this.yPixel, blockSize, blockSize * 3);
        } else if (this.spaceRequirement == 19) {
            int blockSize = (int)Math.ceil(TILE_SIZE * (double)this.tilesWidth * scaleFactor);
            g2D.fillRect(this.xPixel, 0, blockSize, this.yPixel + blockSize);
        } else if (this.spaceRequirement == 28) {
            int blockSize = (int)Math.ceil(TILE_SIZE * (double)this.tilesWidth * scaleFactor);
            g2D.fillRect(this.xPixel, 0, blockSize, this.yPixel + blockSize * 2);
        } else if (this.spaceRequirement == 17) {
            int width = (int)Math.ceil(TILE_SIZE * (double)this.tilesWidth * scaleFactor);
            g2D.fillRect(this.xPixel, this.yPixel, width, (int)Math.ceil(TILE_SIZE * (double)this.tilesHeight * scaleFactor));
            g2D.fillRect(this.xPixel + width, this.yPixel, (int)Math.ceil(TILE_SIZE * scaleFactor * 2.0), (int)Math.ceil(TILE_SIZE * 6.0 * scaleFactor));
        } else if (this.spaceRequirement == 20) {
            g2D.fillRect(this.xPixel, 0, (int)Math.ceil(4.0 * TILE_SIZE * scaleFactor), (int)Math.ceil(TILE_SIZE * (double)Game.yTiles * scaleFactor));
        }
        g2D.setComposite(oldComposite);
    }

    public void drawNumber(Graphics2D g2D, int value, double xCenter, double yCenter, double scaleFactor, double TILE_SIZE) {
        char[] chars = String.valueOf(value).toCharArray();
        Image currentImage = null;
        int blockSize = (int)Math.round(TILE_SIZE * scaleFactor);
        for (int i = 0; i < chars.length; ++i) {
            currentImage = this.frame.game.textures.symbols.get(Character.valueOf(chars[i])).getImage();
            if (this.frame.levelPanel.level.levelType == 4 || this.frame.levelPanel.level.levelType == 2 || this.frame.levelPanel.level.pipeColor == 2) {
                Composite oldComposite = g2D.getComposite();
                g2D.setColor(Color.BLACK);
                g2D.setComposite(AlphaComposite.getInstance(3, 0.6f));
                g2D.fillRect((int)Math.round(xCenter - (double)chars.length * TILE_SIZE * scaleFactor / 2.0 + (double)i * TILE_SIZE * scaleFactor), (int)Math.round(yCenter - TILE_SIZE / 2.0 * scaleFactor), blockSize, blockSize);
                g2D.setComposite(oldComposite);
            }
            g2D.drawImage(currentImage, (int)Math.round(xCenter - (double)chars.length * TILE_SIZE * scaleFactor / 2.0 + (double)i * TILE_SIZE * scaleFactor), (int)Math.round(yCenter - TILE_SIZE / 2.0 * scaleFactor), blockSize, blockSize, null);
        }
    }
}

