/*
 * Decompiled with CFR 0.152.
 */
package supermario.builder;

import java.util.LinkedList;
import supermario.builder.Item;
import supermario.builder.Level;
import supermario.game.Game;
import supermario.game.LevelLoader;

public class ItemFitting {
    private static Item[][] items;
    private static Item item;
    private static int s;
    private static char c;
    private static int itemX;
    private static int itemY;
    private static LinkedList<Item> blockItems;
    private static int levelLength;
    private static Rect testRect;
    private static final Rect rect;
    private static final Rect rect2;
    private static final Rect rect3;

    public static boolean itemCanFit(Level level, Item item, int x, int y, LinkedList<Item> blockItems) {
        boolean triggered = false;
        blockItems.clear();
        if (item == null || level == null) {
            return false;
        }
        ItemFitting.setValues(level, item, x, y, blockItems);
        y = itemY;
        if (!ItemFitting.tileIsInLevelArea(x, y)) {
            return false;
        }
        if (s == 15 || s == 16) {
            return true;
        }
        rect.setRectAsUseless();
        rect2.setRectAsUseless();
        rect3.setRectAsUseless();
        if (ItemFitting.isInReservedItemTiles()) {
            triggered = true;
        }
        if (ItemFitting.inReservedAreas(rect)) {
            triggered = true;
        }
        if (!rect.isRectSetAsUseless() && ItemFitting.inReservedAreas(rect2)) {
            triggered = true;
        }
        if (!rect.isRectSetAsUseless() && ItemFitting.inReservedAreas(rect3)) {
            triggered = true;
        }
        if (!ItemFitting.isWithinItemConstraints(x, y)) {
            triggered = true;
        }
        if (triggered && item.character == 'k' && blockItems.size() == 1 && blockItems.getFirst().character == 'k') {
            triggered = false;
        }
        return !triggered;
    }

    private static void addBlockingItem(Item i) {
        if (!blockItems.contains(i)) {
            blockItems.add(i);
        }
    }

    private static boolean inReservedAreas(Rect r) {
        testRect = r;
        boolean triggered = false;
        if (ItemFitting.isInPipePaddingArea()) {
            triggered = true;
        }
        if (ItemFitting.isInBeanstalkBlockArea()) {
            triggered = true;
        }
        if (ItemFitting.isInContentsBlockArea()) {
            triggered = true;
        }
        if (ItemFitting.isInInvisibleBlockArea()) {
            triggered = true;
        }
        if (ItemFitting.isInPlatformMotionArea()) {
            triggered = true;
        }
        if (ItemFitting.isInPlatformPaddingArea()) {
            triggered = true;
        }
        if (ItemFitting.isTooCloseToBeanstalkBlock()) {
            triggered = true;
        }
        return triggered;
    }

    public static boolean isInReservedColumn(Level level, int x, int y) {
        levelLength = level.items[0].length;
        item = null;
        testRect.setBounds(x, 0, x, Game.yTiles - 1);
        return ItemFitting.isInPipePaddingArea() || ItemFitting.isInPlatformPaddingArea() && x < levelLength - 1;
    }

    public static boolean itemAllowsPartialInsertion(Item i) {
        char c = i.character;
        if (c == 'h' || c == '\"' || c == '\'' || c == '\u260e' || c == '\u2193' || c == '\u2660' || c == 'j') {
            return true;
        }
        if (c == '\u010e' || c == 'T' || c == '#' || c == 'S' || c == '`' || c == 'U' || c == '@') {
            return true;
        }
        if (LevelLoader.isBlockBrickBoxTypeItem(c)) {
            return true;
        }
        return s == 15 || s == 16 || s == 6 || s == 5 || s == 7 || s == 14;
    }

    private static void setValues(Level level, Item item, int x, int y, LinkedList<Item> blockItems) {
        items = level.items;
        levelLength = level.items[0].length;
        ItemFitting.item = item;
        s = item.spaceRequirement;
        c = item.character;
        itemX = x;
        itemY = item.requiredRow != -1 ? item.requiredRow : y;
        ItemFitting.blockItems = blockItems;
    }

    private static boolean isInReservedItemTiles() {
        boolean triggered = false;
        if (s == 0) {
            return ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX, itemY, itemX, itemY));
        }
        if (s == 1) {
            return ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX, itemY, itemX + 1, itemY));
        }
        if (s == 2) {
            return ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX, itemY, itemX + ItemFitting.item.tilesWidth - 1, itemY + ItemFitting.item.tilesHeight - 1));
        }
        if (s == 21) {
            return ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX - 2, itemY, itemX + 3, itemY + 2));
        }
        if (s == 18) {
            return ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX, itemY, itemX + 1, itemY + 1));
        }
        if (s == 26) {
            return ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX, itemY, itemX + 1, itemY + 1));
        }
        if (s == 27) {
            return ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX, itemY, itemX + 1, itemY + 1));
        }
        if (s == 17) {
            if (ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX, itemY, itemX + 3, itemY + 5))) {
                triggered = true;
            }
            if (ItemFitting.areaHasUnavailableTile(rect2.setBounds(itemX, itemY + 6, itemX + 1, itemY + 10))) {
                triggered = true;
            }
            return triggered;
        }
        if (s == 9) {
            return ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX, itemY, itemX + ItemFitting.item.tilesWidth - 1, itemY + ItemFitting.item.tilesHeight - 1));
        }
        if (s == 10) {
            return ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX, itemY, itemX + ItemFitting.item.tilesWidth - 1, itemY + ItemFitting.item.tilesHeight - 1));
        }
        if (s == 11 || s == 13) {
            return ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX, itemY, itemX + ItemFitting.item.tilesWidth - 1, itemY + ItemFitting.item.tilesHeight - 1));
        }
        if (s == 12) {
            return ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX, itemY, itemX + ItemFitting.item.tilesWidth - 1, itemY + ItemFitting.item.tilesHeight - 1));
        }
        if (s == 19 || s == 28) {
            return ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX, itemY, itemX + ItemFitting.item.tilesWidth - 1, itemY + ItemFitting.item.tilesHeight - 1));
        }
        if (s == 3) {
            return ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX, 0, itemX + ItemFitting.item.tilesWidth - 1, 0));
        }
        if (s == 22) {
            return ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX, itemY, itemX + ItemFitting.item.tilesWidth - 1, itemY));
        }
        if (s == 24) {
            return ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX, itemY, ItemFitting.item.tilesWidth - 1, itemY));
        }
        if (s == 4) {
            return ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX, itemY, itemX + ItemFitting.item.tilesWidth - 1, itemY + 1));
        }
        if (s == 14) {
            return ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX, itemY - 2, itemX + 1, itemY + 3));
        }
        if (s == 5) {
            return ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX, itemY - 7, itemX + 1, itemY + 2 + 7));
        }
        if (s == 6) {
            return ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX - 6, itemY - 1, itemX + 1 + 6, itemY + 3));
        }
        if (s == 7) {
            return ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX - 6, itemY, itemX - 6 + ItemFitting.item.tilesWidth - 1, itemY));
        }
        if (s == 8) {
            return ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX, itemY, itemX, itemY));
        }
        if (s == 23) {
            int pWidth = Item.getPulleyWidth(c);
            int tilesWidth = ItemFitting.item.button.placedImage.getIconWidth() / 8;
            if (ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX, itemY, itemX + pWidth - 1, itemY))) {
                triggered = true;
            }
            if (ItemFitting.areaHasUnavailableTile(rect2.setBounds(itemX + pWidth / 2, itemY - 8, itemX + tilesWidth - pWidth / 2, itemY - 8))) {
                triggered = true;
            }
            if (ItemFitting.areaHasUnavailableTile(rect3.setBounds(itemX + tilesWidth - pWidth, itemY + 4, itemX + tilesWidth - 1, itemY + 4))) {
                triggered = true;
            }
            return triggered;
        }
        if (s == 25) {
            if (ItemFitting.areaHasUnavailableTile(rect.setBounds(itemX - 56, itemY, itemX - 56 + 1, itemY + 3))) {
                triggered = true;
            }
            if (ItemFitting.areaHasUnavailableTile(rect2.setBounds(itemX - 56 + 2, itemY + 3, itemX - 1, itemY + 3))) {
                triggered = true;
            }
            if (ItemFitting.areaHasUnavailableTile(rect3.setBounds(itemX, itemY, itemX + 7, itemY + 3))) {
                triggered = true;
            }
            return triggered;
        }
        throw new RuntimeException("Unreachable statement: " + s);
    }

    private static boolean isWithinItemConstraints(int x, int y) {
        boolean triggered = false;
        if (s == 0) {
            triggered = c == 'i' && ItemFitting.isAdjacentToItem(itemX, itemY, 'i');
        } else if (s == 1) {
            triggered = !ItemFitting.tileIsWithinXBounds(0, levelLength - 2);
        } else {
            if (s == 2) {
                if (LevelLoader.isMarioPlacementItem(c) && !ItemFitting.tileIsWithinYBounds(0, Game.yTiles - ItemFitting.item.tilesHeight - 1)) {
                    return false;
                }
                if (LevelLoader.isBlockBrickBoxTypeItem(c) && !ItemFitting.tileIsWithinXBounds(0, levelLength - 2)) {
                    return false;
                }
                return c != 'j' || ItemFitting.tileIsWithinXBounds(0, levelLength - 2);
            }
            if (s == 21) {
                triggered = !ItemFitting.tileIsWithinXBounds(2, levelLength - 4);
            } else if (s == 18) {
                if (LevelLoader.isBlockBrickBoxTypeItem(c) && !ItemFitting.tileIsWithinXBounds(0, levelLength - 2)) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsNotAllowedInContentsBlockArea(Rect.tempRect.setBounds(x, y - 2, x + 1, y - 1))) {
                    triggered = true;
                }
            } else if (s == 26) {
                if (LevelLoader.isBlockBrickBoxTypeItem(c) && !ItemFitting.tileIsWithinXBounds(0, levelLength - 2)) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsNotAllowedInInvisibleBlockArea(Rect.tempRect.setBounds(x, y + 2, x + 1, y + 3))) {
                    triggered = true;
                }
            } else if (s == 27) {
                if (LevelLoader.isBlockBrickBoxTypeItem(c) && !ItemFitting.tileIsWithinXBounds(0, levelLength - 2)) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsNotAllowedInContentsBlockArea(Rect.tempRect.setBounds(x, y - 2, x + 1, y - 1))) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsNotAllowedInInvisibleBlockArea(Rect.tempRect.setBounds(x, y + 2, x + 1, y + 3))) {
                    triggered = true;
                }
            } else if (s == 17) {
                triggered = !ItemFitting.tileIsWithinXBounds(0, levelLength - 4);
            } else if (s == 9) {
                if (!ItemFitting.tileIsWithinXBounds(2, levelLength - 1)) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsNotAllowedInPipePaddingArea(Rect.tempRect.setBounds(x - 2, y, x - 1, y + 3))) {
                    triggered = true;
                }
                if (ItemFitting.isInRepeatingPlatformColumn(Rect.tempRect.setBounds(x - 2, y, x - 1, y + 3))) {
                    triggered = true;
                }
            } else if (s == 10) {
                if (!ItemFitting.tileIsWithinXBounds(0, levelLength - 5)) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsNotAllowedInPipePaddingArea(Rect.tempRect.setBounds(x + 3, y, x + 4, y + 3))) {
                    triggered = true;
                }
                if (ItemFitting.isInRepeatingPlatformColumn(Rect.tempRect.setBounds(x + 3, y, x + 4, y + 3))) {
                    triggered = true;
                }
            } else if (s == 11) {
                if (!ItemFitting.tileIsWithinYBounds(1, Game.yTiles - 1)) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsNotAllowedInPipePaddingArea(Rect.tempRect.setBounds(x, y - 4, x + 3, y - 1))) {
                    triggered = true;
                }
            } else if (s == 13) {
                if (!ItemFitting.tileIsWithinYBounds(4, Game.yTiles - 4)) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsNotAllowedInPipePaddingArea(Rect.tempRect.setBounds(x, y - 4, x + 3, y - 1))) {
                    triggered = true;
                }
            } else if (s == 12) {
                if (!ItemFitting.tileIsWithinYBounds(0, Game.yTiles - 8)) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsNotAllowedInPipePaddingArea(Rect.tempRect.setBounds(x, y + 4, x + 3, y + 7))) {
                    triggered = true;
                }
            } else if (s == 19) {
                if (!ItemFitting.tileIsWithinXBounds(0, levelLength - 2)) {
                    triggered = true;
                }
                if (!ItemFitting.tileIsWithinYBounds(3, Game.yTiles - 1)) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsNotAllowedInBeanstalkBlockArea(Rect.tempRect.setBounds(x, 0, x + 1, y - 1))) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsNotAllowedInBeanstalkBlockArea(Rect.tempRect.setBounds(x, 0, x + 1, y))) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsTooCloseToBeanstalkBlock(Rect.tempRect.setBounds(x, y - 3, x + 1, y - 1))) {
                    triggered = true;
                }
            } else if (s == 28) {
                if (!ItemFitting.tileIsWithinXBounds(0, levelLength - 2)) {
                    triggered = true;
                }
                if (!ItemFitting.tileIsWithinYBounds(3, Game.yTiles - 1)) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsNotAllowedInBeanstalkBlockArea(Rect.tempRect.setBounds(x, 0, x + 1, y - 1))) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsNotAllowedInInvisibleBlockArea(Rect.tempRect.setBounds(x, y + 2, x + 1, y + 3))) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsTooCloseToBeanstalkBlock(Rect.tempRect.setBounds(x, y - 3, x + 1, y - 1))) {
                    triggered = true;
                }
            } else if (s == 3) {
                if (ItemFitting.areaHasItemsNotAllowedInPlatformMotionArea(Rect.tempRect.setBounds(x, 0, x + ItemFitting.item.tilesWidth - 1, Game.yTiles - 1))) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsNotAllowedInPlatformPaddingArea(Rect.tempRect.setBounds(x - 0, 0, x + ItemFitting.item.tilesWidth - 1 + 0, Game.yTiles - 1))) {
                    triggered = true;
                }
                testRect = Rect.tempRect.setBounds(x, 0, x + ItemFitting.item.tilesWidth - 1, Game.yTiles - 1);
                if (ItemFitting.isInPipePaddingArea()) {
                    triggered = true;
                }
            } else if (s == 22) {
                if (ItemFitting.areaHasItemsNotAllowedInPlatformMotionArea(Rect.tempRect.setBounds(x, y + 1, x + ItemFitting.item.tilesWidth - 1, Game.yTiles - 1))) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsNotAllowedInPlatformPaddingArea(Rect.tempRect.setBounds(x - 0, y, x + ItemFitting.item.tilesWidth - 1 + 0, Game.yTiles - 1))) {
                    triggered = true;
                }
            } else if (s == 24) {
                if (!ItemFitting.tileIsWithinXBounds(0, levelLength - ItemFitting.item.tilesWidth)) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsNotAllowedInPlatformMotionArea(Rect.tempRect.setBounds(x, y - 9, x + ItemFitting.item.tilesWidth - 1, y + 9))) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsNotAllowedInPlatformPaddingArea(Rect.tempRect.setBounds(x - 0, y - 9 - 4, x + ItemFitting.item.tilesWidth - 1 + 0, y + 9 + 4))) {
                    triggered = true;
                }
            } else if (s == 4) {
                triggered = false;
            } else if (s == 14) {
                if (!ItemFitting.tileIsWithinXBounds(0, levelLength - 2)) {
                    triggered = true;
                }
                if (!ItemFitting.tileIsWithinYBounds(0, Game.yTiles - 2)) {
                    triggered = true;
                }
            } else if (s == 5) {
                if (!ItemFitting.tileIsWithinXBounds(0, levelLength - 2)) {
                    triggered = true;
                }
                if (!ItemFitting.tileIsWithinYBounds(0, Game.yTiles - 3)) {
                    triggered = true;
                }
            } else if (s == 6) {
                if (!ItemFitting.tileIsWithinXBounds(0, levelLength - 2)) {
                    triggered = true;
                }
                if (!ItemFitting.tileIsWithinYBounds(0, Game.yTiles - 3)) {
                    triggered = true;
                }
            } else if (s == 7) {
                if (!ItemFitting.tileIsWithinXBounds(0, levelLength - 6)) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsNotAllowedInPlatformPaddingArea(Rect.tempRect.setBounds(x - 6 - 0, y - 4, x - 6 + ItemFitting.item.tilesWidth - 1 + 0, y + 4))) {
                    triggered = true;
                }
            } else if (s == 8) {
                triggered = false;
            } else if (s == 23) {
                int pWidth = Item.getPulleyWidth(c);
                int tilesWidth = ItemFitting.item.button.placedImage.getIconWidth() / 8;
                if (!ItemFitting.tileIsWithinXBounds(0, levelLength - tilesWidth)) {
                    triggered = true;
                }
                if (!ItemFitting.tileIsWithinYBounds(8, Game.yTiles - 1 - 4)) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsNotAllowedInPlatformMotionArea(Rect.tempRect.setBounds(x, y - 6, x + pWidth - 1, Game.yTiles - 1))) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsNotAllowedInPlatformPaddingArea(Rect.tempRect.setBounds(x - 0, y - 6, x + pWidth - 1 + 0, Game.yTiles - 1))) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsNotAllowedInPlatformMotionArea(Rect.tempRect.setBounds(x + tilesWidth - pWidth, y - 6, x + tilesWidth - 1, Game.yTiles - 1))) {
                    triggered = true;
                }
                if (ItemFitting.areaHasItemsNotAllowedInPlatformPaddingArea(Rect.tempRect.setBounds(x + tilesWidth - pWidth - 0, y - 6, x + tilesWidth - 1 + 0, Game.yTiles - 1))) {
                    triggered = true;
                }
            } else if (s == 25) {
                if (!ItemFitting.tileIsWithinYBounds(0, Game.yTiles - ItemFitting.item.tilesHeight - 1)) {
                    triggered = true;
                }
                if (!ItemFitting.tileIsWithinXBounds(56, levelLength - 8)) {
                    triggered = true;
                }
            } else {
                throw new RuntimeException("Unknown requirement specified: " + s);
            }
        }
        return !triggered;
    }

    private static boolean isInPlatformMotionArea() {
        if (ItemFitting.isAllowedInPlatformMotionArea(item)) {
            return false;
        }
        boolean triggered = false;
        for (int i = ItemFitting.testRect.y1; i <= ItemFitting.testRect.y2; ++i) {
            for (int j = ItemFitting.testRect.x1; j <= ItemFitting.testRect.x2; ++j) {
                int y;
                if (ItemFitting.tileIsInLevelArea(j, i) && items[0][j] != null && ItemFitting.items[0][j].spaceRequirement == 3) {
                    ItemFitting.addBlockingItem(items[0][j]);
                    triggered = true;
                }
                for (y = i - 9; y <= i + 9; ++y) {
                    if (!ItemFitting.tileIsInLevelArea(j, y) || items[y][j] == null || ItemFitting.items[y][j].spaceRequirement != 24) continue;
                    ItemFitting.addBlockingItem(items[y][j]);
                    triggered = true;
                }
                for (y = 0; y <= i; ++y) {
                    if (!ItemFitting.tileIsInLevelArea(j, y) || items[y][j] == null || ItemFitting.items[y][j].spaceRequirement != 22) continue;
                    ItemFitting.addBlockingItem(items[y][j]);
                    triggered = true;
                }
                for (y = i; y <= i + 6; ++y) {
                    if (!ItemFitting.tileIsInLevelArea(j, y) || items[y][j] == null || ItemFitting.items[y][j].spaceRequirement != 23 || y < ItemFitting.items[y][j].yTile - 6 || !Item.isPulleyLeftSide(items[y][j], j)) continue;
                    ItemFitting.addBlockingItem(items[y][j]);
                    triggered = true;
                }
                for (y = i; y >= 2; --y) {
                    if (!ItemFitting.tileIsInLevelArea(j, y) || items[y][j] == null || ItemFitting.items[y][j].spaceRequirement != 23 || y < ItemFitting.items[y][j].yTile || !Item.isPulleyLeftSide(items[y][j], j)) continue;
                    ItemFitting.addBlockingItem(items[y][j]);
                    triggered = true;
                }
                for (y = i; y <= i + 10; ++y) {
                    if (!ItemFitting.tileIsInLevelArea(j, y) || items[y][j] == null || ItemFitting.items[y][j].spaceRequirement != 23 || y < ItemFitting.items[y][j].yTile - 6 || Item.isPulleyLeftSide(items[y][j], j)) continue;
                    ItemFitting.addBlockingItem(items[y][j]);
                    triggered = true;
                }
                for (y = i; y >= 2; --y) {
                    if (!ItemFitting.tileIsInLevelArea(j, y) || items[y][j] == null || ItemFitting.items[y][j].spaceRequirement != 23 || y < ItemFitting.items[y][j].yTile || Item.isPulleyLeftSide(items[y][j], j)) continue;
                    ItemFitting.addBlockingItem(items[y][j]);
                    triggered = true;
                }
            }
        }
        return triggered;
    }

    private static boolean isAllowedInPlatformMotionArea(Item i) {
        if (i == null) {
            return false;
        }
        int s = i.spaceRequirement;
        char c = i.character;
        return s == 0 || s == 1 || c == 'h';
    }

    private static boolean isInRepeatingPlatformColumn(Rect r) {
        boolean triggered = false;
        for (int i = r.x1; i <= r.x2; ++i) {
            if (!ItemFitting.tileIsInLevelArea(i, 0) || items[0][i] == null || ItemFitting.items[0][i].spaceRequirement != 3) continue;
            ItemFitting.addBlockingItem(items[0][i]);
            triggered = true;
        }
        return triggered;
    }

    private static boolean areaHasItemsNotAllowedInPlatformMotionArea(Rect r) {
        boolean triggered = false;
        for (int i = r.y1; i <= r.y2; ++i) {
            for (int j = r.x1; j <= r.x2; ++j) {
                if (!ItemFitting.tileIsInLevelArea(j, i) || items[i][j] == null || ItemFitting.isAllowedInPlatformMotionArea(items[i][j])) continue;
                ItemFitting.addBlockingItem(items[i][j]);
                triggered = true;
            }
        }
        return triggered;
    }

    private static boolean isInPlatformPaddingArea() {
        if (ItemFitting.isAllowedInPlatformPaddingArea(item)) {
            return false;
        }
        boolean triggered = false;
        for (int i = ItemFitting.testRect.y1; i <= ItemFitting.testRect.y2; ++i) {
            for (int j = ItemFitting.testRect.x1 - 0; j <= ItemFitting.testRect.x2 + 0; ++j) {
                int y;
                if (ItemFitting.tileIsInLevelArea(j, i) && items[0][j] != null && ItemFitting.items[0][j].spaceRequirement == 3) {
                    ItemFitting.addBlockingItem(items[0][j]);
                    triggered = true;
                }
                for (y = i - 9 - 4; y <= i + 9 + 4; ++y) {
                    if (!ItemFitting.tileIsInLevelArea(j, y) || items[y][j] == null || ItemFitting.items[y][j].spaceRequirement != 24) continue;
                    ItemFitting.addBlockingItem(items[y][j]);
                    triggered = true;
                }
                for (y = 0; y <= i; ++y) {
                    if (!ItemFitting.tileIsInLevelArea(j, y) || items[y][j] == null || ItemFitting.items[y][j].spaceRequirement != 22) continue;
                    ItemFitting.addBlockingItem(items[y][j]);
                    triggered = true;
                }
                for (y = i - 4; y <= i + 4; ++y) {
                    if (!ItemFitting.tileIsInLevelArea(j, y) || items[y][j] == null || ItemFitting.items[y][j].spaceRequirement != 7) continue;
                    ItemFitting.addBlockingItem(items[y][j]);
                    triggered = true;
                }
                for (y = i; y <= i + 6; ++y) {
                    if (!ItemFitting.tileIsInLevelArea(j, y) || items[y][j] == null || ItemFitting.items[y][j].spaceRequirement != 23 || y < ItemFitting.items[y][j].yTile - 6 || !Item.isPulleyLeftSide(items[y][j], j)) continue;
                    ItemFitting.addBlockingItem(items[y][j]);
                    triggered = true;
                }
                for (y = i; y >= 2; --y) {
                    if (!ItemFitting.tileIsInLevelArea(j, y) || items[y][j] == null || ItemFitting.items[y][j].spaceRequirement != 23 || y < ItemFitting.items[y][j].yTile || !Item.isPulleyLeftSide(items[y][j], j)) continue;
                    ItemFitting.addBlockingItem(items[y][j]);
                    triggered = true;
                }
                for (y = i; y <= i + 10; ++y) {
                    if (!ItemFitting.tileIsInLevelArea(j, y) || items[y][j] == null || ItemFitting.items[y][j].spaceRequirement != 23 || y < ItemFitting.items[y][j].yTile - 6 || Item.isPulleyLeftSide(items[y][j], j)) continue;
                    ItemFitting.addBlockingItem(items[y][j]);
                    triggered = true;
                }
                for (y = i; y >= 2; --y) {
                    if (!ItemFitting.tileIsInLevelArea(j, y) || items[y][j] == null || ItemFitting.items[y][j].spaceRequirement != 23 || y < ItemFitting.items[y][j].yTile || Item.isPulleyLeftSide(items[y][j], j)) continue;
                    ItemFitting.addBlockingItem(items[y][j]);
                    triggered = true;
                }
            }
        }
        return triggered;
    }

    private static boolean isAllowedInPlatformPaddingArea(Item i) {
        return i != null && !i.immobile;
    }

    private static boolean areaHasItemsNotAllowedInPlatformPaddingArea(Rect r) {
        boolean triggered = false;
        for (int i = r.y1; i <= r.y2; ++i) {
            for (int j = r.x1; j <= r.x2; ++j) {
                if (!ItemFitting.tileIsInLevelArea(j, i) || items[i][j] == null || ItemFitting.isAllowedInPlatformPaddingArea(items[i][j])) continue;
                ItemFitting.addBlockingItem(items[i][j]);
                triggered = true;
            }
        }
        return triggered;
    }

    private static boolean isInPipePaddingArea() {
        if (ItemFitting.isAllowedInPipePaddingArea(item)) {
            return false;
        }
        boolean triggered = false;
        for (int i = ItemFitting.testRect.y1; i <= ItemFitting.testRect.y2; ++i) {
            for (int j = ItemFitting.testRect.x1; j <= ItemFitting.testRect.x2; ++j) {
                int x;
                int y;
                for (y = i + 1; y <= i + 4; ++y) {
                    if (!ItemFitting.tileIsInLevelArea(j, y) || items[y][j] == null || !LevelLoader.isUpwardOpeningPipe(ItemFitting.items[y][j].character)) continue;
                    ItemFitting.addBlockingItem(items[y][j]);
                    triggered = true;
                }
                for (y = i - 1; y >= i - 4; --y) {
                    if (!ItemFitting.tileIsInLevelArea(j, y) || items[y][j] == null || !LevelLoader.isDownwardOpeningPipe(ItemFitting.items[y][j].character)) continue;
                    ItemFitting.addBlockingItem(items[y][j]);
                    triggered = true;
                }
                for (x = j + 1; x <= j + 2; ++x) {
                    if (!ItemFitting.tileIsInLevelArea(x, i) || items[i][x] == null || !LevelLoader.isLeftOpeningPipe(ItemFitting.items[i][x].character)) continue;
                    ItemFitting.addBlockingItem(items[i][x]);
                    triggered = true;
                }
                for (x = j - 1; x >= j - 2; --x) {
                    if (!ItemFitting.tileIsInLevelArea(x, i) || items[i][x] == null || !LevelLoader.isRightOpeningPipe(ItemFitting.items[i][x].character)) continue;
                    ItemFitting.addBlockingItem(items[i][x]);
                    triggered = true;
                }
            }
        }
        return triggered;
    }

    private static boolean isAllowedInPipePaddingArea(Item i) {
        return i != null && !i.immobile;
    }

    private static boolean areaHasItemsNotAllowedInPipePaddingArea(Rect r) {
        boolean triggered = false;
        for (int i = r.y1; i <= r.y2; ++i) {
            for (int j = r.x1; j <= r.x2; ++j) {
                if (!ItemFitting.tileIsInLevelArea(j, i) || items[i][j] == null || ItemFitting.isAllowedInPipePaddingArea(items[i][j])) continue;
                ItemFitting.addBlockingItem(items[i][j]);
                triggered = true;
            }
        }
        return triggered;
    }

    private static boolean isTooCloseToBeanstalkBlock() {
        if (ItemFitting.isAllowedTooCloseToBeanstalk(item)) {
            return false;
        }
        boolean triggered = false;
        for (int i = ItemFitting.testRect.y1; i <= ItemFitting.testRect.y2; ++i) {
            for (int j = ItemFitting.testRect.x1; j <= ItemFitting.testRect.x2; ++j) {
                for (int y = i; y <= i + 3; ++y) {
                    if (!ItemFitting.tileIsInLevelArea(j, y) || items[y][j] == null || !LevelLoader.isBeanstalkBlock(ItemFitting.items[y][j].character)) continue;
                    ItemFitting.addBlockingItem(items[y][j]);
                    triggered = true;
                }
            }
        }
        return triggered;
    }

    private static boolean isAllowedTooCloseToBeanstalk(Item i) {
        return i.character == 'k' || i.character == '\u0292';
    }

    private static boolean isInBeanstalkBlockArea() {
        if (ItemFitting.isAllowedInBeanstalkBlockArea(item)) {
            return false;
        }
        boolean triggered = false;
        for (int i = ItemFitting.testRect.y1; i <= ItemFitting.testRect.y2; ++i) {
            for (int j = ItemFitting.testRect.x1; j <= ItemFitting.testRect.x2; ++j) {
                for (int y = i; y <= Game.yTiles - 1; ++y) {
                    if (!ItemFitting.tileIsInLevelArea(j, y) || items[y][j] == null || !LevelLoader.isBeanstalkBlock(ItemFitting.items[y][j].character)) continue;
                    ItemFitting.addBlockingItem(items[y][j]);
                    triggered = true;
                }
            }
        }
        return triggered;
    }

    private static boolean isAllowedInBeanstalkBlockArea(Item i) {
        return i != null && !i.immobile;
    }

    private static boolean areaHasItemsNotAllowedInBeanstalkBlockArea(Rect r) {
        boolean triggered = false;
        for (int i = r.y1; i <= r.y2; ++i) {
            for (int j = r.x1; j <= r.x2; ++j) {
                if (!ItemFitting.tileIsInLevelArea(j, i) || items[i][j] == null || ItemFitting.isAllowedInBeanstalkBlockArea(items[i][j])) continue;
                ItemFitting.addBlockingItem(items[i][j]);
                triggered = true;
            }
        }
        return triggered;
    }

    private static boolean areaHasItemsTooCloseToBeanstalkBlock(Rect r) {
        boolean triggered = false;
        for (int i = r.y1; i <= r.y2; ++i) {
            for (int j = r.x1; j <= r.x2; ++j) {
                if (!ItemFitting.tileIsInLevelArea(j, i) || items[i][j] == null || ItemFitting.items[i][j].character == 'k' || ItemFitting.items[i][j].character == '\u0292') continue;
                ItemFitting.addBlockingItem(items[i][j]);
                triggered = true;
            }
        }
        return triggered;
    }

    private static boolean isInContentsBlockArea() {
        if (ItemFitting.isAllowedInContentsBlockArea(item)) {
            return false;
        }
        boolean triggered = false;
        for (int i = ItemFitting.testRect.y1; i <= ItemFitting.testRect.y2; ++i) {
            for (int j = ItemFitting.testRect.x1; j <= ItemFitting.testRect.x2; ++j) {
                for (int y = i + 1; y <= i + 2; ++y) {
                    if (!ItemFitting.tileIsInLevelArea(j, y) || items[y][j] == null || !ItemFitting.isContentsBlockTypeItem(items[y][j])) continue;
                    ItemFitting.addBlockingItem(items[y][j]);
                    triggered = true;
                }
            }
        }
        return triggered;
    }

    private static boolean isAllowedInContentsBlockArea(Item i) {
        return i != null && !i.immobile;
    }

    private static boolean areaHasItemsNotAllowedInContentsBlockArea(Rect r) {
        boolean triggered = false;
        for (int i = r.y1; i <= r.y2; ++i) {
            for (int j = r.x1; j <= r.x2; ++j) {
                if (!ItemFitting.tileIsInLevelArea(j, i) || items[i][j] == null || ItemFitting.isAllowedInContentsBlockArea(items[i][j])) continue;
                ItemFitting.addBlockingItem(items[i][j]);
                triggered = true;
            }
        }
        return triggered;
    }

    private static boolean isInInvisibleBlockArea() {
        if (ItemFitting.isAllowedInInvisibleBlockArea(item)) {
            return false;
        }
        boolean triggered = false;
        for (int i = ItemFitting.testRect.y1; i <= ItemFitting.testRect.y2; ++i) {
            for (int j = ItemFitting.testRect.x1; j <= ItemFitting.testRect.x2; ++j) {
                for (int y = i - 1; y >= i - 2; --y) {
                    if (!ItemFitting.tileIsInLevelArea(j, y) || items[y][j] == null || !ItemFitting.isInvisibleTypeItem(items[y][j])) continue;
                    ItemFitting.addBlockingItem(items[y][j]);
                    triggered = true;
                }
            }
        }
        return triggered;
    }

    private static boolean isAllowedInInvisibleBlockArea(Item i) {
        return i == null || !i.immobile;
    }

    private static boolean areaHasItemsNotAllowedInInvisibleBlockArea(Rect r) {
        boolean triggered = false;
        for (int i = r.y1; i <= r.y2; ++i) {
            for (int j = r.x1; j <= r.x2; ++j) {
                if (!ItemFitting.tileIsInLevelArea(j, i) || items[i][j] == null || ItemFitting.isAllowedInInvisibleBlockArea(items[i][j])) continue;
                ItemFitting.addBlockingItem(items[i][j]);
                triggered = true;
            }
        }
        return triggered;
    }

    private static boolean tileIsInLevelArea(int x, int y) {
        return x >= 0 && x < levelLength && y >= 0 && y < Game.yTiles;
    }

    private static boolean tileIsWithinXBounds(int leftMostX, int rightMostX) {
        return itemX >= leftMostX && itemX <= rightMostX;
    }

    private static boolean tileIsWithinYBounds(int topMostY, int bottomMostY) {
        return itemY >= topMostY && itemY <= bottomMostY;
    }

    private static boolean areaHasUnavailableTile(Rect r) {
        boolean triggered = false;
        for (int i = r.y1; i <= r.y2; ++i) {
            for (int j = r.x1; j <= r.x2; ++j) {
                if (!ItemFitting.tileIsInLevelArea(j, i) && !ItemFitting.itemAllowsPartialInsertion(item)) {
                    triggered = true;
                    continue;
                }
                if (!ItemFitting.tileIsInLevelArea(j, i) || items[i][j] == null) continue;
                ItemFitting.addBlockingItem(items[i][j]);
                triggered = true;
            }
        }
        return triggered;
    }

    public static boolean isInvisibleTypeItem(Item i) {
        return i.spaceRequirement == 27 || i.spaceRequirement == 26 || i.spaceRequirement == 28;
    }

    public static boolean isContentsBlockTypeItem(Item i) {
        return i.spaceRequirement == 18 || i.spaceRequirement == 28 || i.spaceRequirement == 27;
    }

    private static boolean isAdjacentToItem(int x, int y, char c) {
        for (int i = y - 1; i <= y + 1; ++i) {
            for (int j = x - 1; j <= x + 1; ++j) {
                if (j == x && i == y || !ItemFitting.tileIsInLevelArea(j, i) || items[i][j] == null || ItemFitting.items[i][j].character != c) continue;
                return true;
            }
        }
        return false;
    }

    static {
        testRect = new Rect();
        rect = new Rect();
        rect2 = new Rect();
        rect3 = new Rect();
    }

    public static class Rect {
        public static Rect tempRect = new Rect();
        public int x1;
        public int x2;
        public int y1;
        public int y2;

        public Rect setBounds(int x1, int y1, int x2, int y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            return this;
        }

        public void setRectAsUseless() {
            this.y2 = -1;
            this.y1 = -1;
            this.x2 = -1;
            this.x1 = -1;
        }

        public boolean isRectSetAsUseless() {
            return this.x1 == -1 && this.x2 == -1 && this.y1 == -1 && this.y2 == -1;
        }
    }
}

