/*
 * Decompiled with CFR 0.152.
 */
package supermario.builder;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.CharArrayWriter;
import java.util.Iterator;
import java.util.LinkedList;
import supermario.builder.BuilderFrame;
import supermario.builder.Item;
import supermario.builder.ItemFitting;
import supermario.builder.Warp;
import supermario.game.Game;
import supermario.game.LevelLoader;

public class Level {
    private BuilderFrame frame;
    public LinkedList<Warp> incomingWarps;
    public LinkedList<Warp> outgoingWarps;
    public Item[][] items;
    public double leftMostX;
    public String name1;
    public String name2;
    public boolean hasLakitu;
    public boolean hasFlyingFish;
    public boolean hasBullets;
    public boolean timedLevel;
    public boolean blackAndWhite;
    public boolean autoScrolling;
    public int levelNumber;
    public int levelType;
    public int levelEndType;
    public int nextLevelNumber;
    public int cliffDestLevel;
    public int cliffDestID;
    public int levelTime;
    public int pipeColor;
    public int texturePack;
    public Item marioStartItem;
    public Item endItem;
    public static final int NEXT_LEVEL_NOTHING = -1;
    public static final int BLANK_LEVEL = -1;
    public static final int DEFAULT_MARIO_START_X_TILE = 3;
    public static final int DEFAULT_MARIO_START_Y_TILE = Game.yTiles - 4 - 3;
    public static final int LEVEL_END_NOTHING = 0;
    public static final int LEVEL_END_FLAG_SM_CASTLE = 1;
    public static final int LEVEL_END_FLAG_LG_CASTLE = 2;
    public static final int LEVEL_END_BOWSER_1 = 3;
    public static final int LEVEL_END_BOWSER_2 = 4;
    public static final int LEVEL_END_BOWSER_3 = 5;
    public static final int LEVEL_END_BOWSER_4 = 6;
    public static final int LEVEL_END_BOWSER_5 = 7;
    public static final int LEVEL_END_BOWSER_6 = 8;
    public static final int LEVEL_END_BOWSER_7 = 9;
    public static final int LEVEL_END_BOWSER_8 = 10;
    public static final int MAX_LEVEL_LENGTH = 1000000;
    public static final int INSERT_AT_START = -1;
    public static final int INSERT_AT_END = -2;
    public static final int LEVEL_END_ITEM_WIDTH = 4;

    public Level(BuilderFrame frame, int copyIndex) {
        this.frame = frame;
        this.incomingWarps = new LinkedList();
        this.outgoingWarps = new LinkedList();
        if (copyIndex == -1) {
            this.items = new Item[Game.yTiles][Game.xTiles];
            this.marioStartItem = frame.miscPanel.mario.item.copy();
            this.marioStartItem.xTile = 3;
            this.marioStartItem.yTile = DEFAULT_MARIO_START_Y_TILE;
            this.marioStartItem.inserted = true;
            this.pipeColor = 0;
            this.texturePack = 0;
        } else {
            frame.levelPanel.level = this;
            Level copy = frame.levelPanel.levels[copyIndex];
            this.items = copy.levelEndType != 0 ? new Item[Game.yTiles][copy.items[0].length - 4] : new Item[Game.yTiles][copy.items[0].length];
            for (int i = 0; i < Game.yTiles; ++i) {
                for (int j = 0; j < this.items[0].length; ++j) {
                    Item tempItem = copy.items[i][j];
                    if (tempItem == null || tempItem.xTile != j || tempItem.yTile != i) continue;
                    Item newItem = tempItem.copy();
                    if (tempItem.isWarpable()) {
                        tempItem.warp = newItem.warp;
                        tempItem.warp.item = tempItem;
                        newItem.warp = new Warp(false, false, -1, -1, -1, -1, newItem);
                        frame.levelPanel.assignMandatoryWarpData(newItem);
                    }
                    newItem.insertInLevel(j, i);
                    if (newItem.character != 'k') continue;
                    this.marioStartItem = newItem;
                }
            }
            this.pipeColor = copy.pipeColor;
            this.hasLakitu = copy.hasLakitu;
            this.hasFlyingFish = copy.hasFlyingFish;
            this.hasBullets = copy.hasBullets;
            this.blackAndWhite = copy.blackAndWhite;
            this.levelType = copy.levelType;
            this.timedLevel = copy.timedLevel;
            this.levelTime = copy.levelTime;
            this.autoScrolling = copy.autoScrolling;
            this.texturePack = copy.texturePack;
        }
        this.name1 = "";
        this.name2 = "";
        this.nextLevelNumber = -1;
        this.cliffDestLevel = -1;
    }

    public String getTitle() {
        String number = String.valueOf(this.levelNumber + 1);
        while (number.length() < 3) {
            number = "0" + number;
        }
        return number + " " + this.name1 + " " + this.name2;
    }

    public Warp getLevelWarp(boolean cliffDeath) {
        if (cliffDeath) {
            return new Warp(false, true, this.levelNumber, 0, this.cliffDestLevel, this.cliffDestID, this.frame.miscPanel.mario.item);
        }
        return new Warp(false, true, this.levelNumber, 0, this.nextLevelNumber, 0, this.frame.miscPanel.mario.item);
    }

    public int getLevelEndIndex() {
        if (this.levelEndType == 0) {
            return 0;
        }
        if (this.levelType == 0 || this.levelType == 4) {
            if (this.levelEndType == 1) {
                return 1;
            }
            if (this.levelEndType == 2) {
                return 2;
            }
        } else if (this.levelType == 2) {
            if (this.levelEndType == 3) {
                return 1;
            }
            if (this.levelEndType == 4) {
                return 2;
            }
            if (this.levelEndType == 5) {
                return 3;
            }
            if (this.levelEndType == 6) {
                return 4;
            }
            if (this.levelEndType == 7) {
                return 5;
            }
            if (this.levelEndType == 8) {
                return 6;
            }
            if (this.levelEndType == 9) {
                return 7;
            }
            if (this.levelEndType == 10) {
                return 8;
            }
        }
        return 0;
    }

    public int getWarpsIndex(int warpID) {
        int index = 0;
        Iterator warpsIter = this.incomingWarps.iterator();
        while (warpsIter.hasNext()) {
            if (((Warp)warpsIter.next()).sourceWarpID == warpID) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getNextAvailableWarpID() {
        if (this.incomingWarps.size() == 0) {
            return 1;
        }
        int expectedID = 1;
        for (Warp warp : this.incomingWarps) {
            if (warp.sourceWarpID > expectedID) {
                return expectedID;
            }
            ++expectedID;
        }
        return expectedID;
    }

    public boolean insertIncomingWarp(Warp warp) {
        if (this.incomingWarps.size() >= 999) {
            return false;
        }
        if (this.incomingWarps.size() == 0) {
            this.incomingWarps.add(warp);
        } else {
            int index = 0;
            Iterator warpsIter = this.incomingWarps.iterator();
            while (warpsIter.hasNext()) {
                if (((Warp)warpsIter.next()).sourceWarpID > warp.sourceWarpID) {
                    this.incomingWarps.add(index, warp);
                    return true;
                }
                ++index;
            }
            this.incomingWarps.addLast(warp);
        }
        return true;
    }

    public void reassignWarpSourceLevelNumbers() {
        for (Warp tempWarp : this.incomingWarps) {
            tempWarp.sourceLevelNumber = this.levelNumber;
        }
        for (Warp tempWarp : this.outgoingWarps) {
            tempWarp.sourceLevelNumber = this.levelNumber;
        }
    }

    public String[] getIncomingWarpIDList() {
        if (this.incomingWarps.size() == 0) {
            return new String[0];
        }
        String[] names = new String[this.incomingWarps.size()];
        int index = 0;
        for (Warp tempWarp : this.incomingWarps) {
            String name = tempWarp.sourceWarpID + " (x:" + tempWarp.item.xTile + " y:" + tempWarp.item.yTile + ")";
            names[index++] = name;
        }
        return names;
    }

    public void insertAtColumn(int columnNumber) {
        int j;
        int i;
        int j2;
        if (this.items[0].length >= 1000000) {
            return;
        }
        Item[][] newItems = new Item[this.items.length][this.items[0].length + 1];
        if (columnNumber == -2 && this.levelEndType != 0) {
            int i2;
            ++this.items[0][this.items[0].length - 4].xTile;
            for (i2 = 0; i2 < newItems.length; ++i2) {
                for (j2 = 0; j2 < this.items[0].length - 4; ++j2) {
                    newItems[i2][j2] = this.items[i2][j2];
                }
            }
            for (i2 = 0; i2 < newItems.length; ++i2) {
                for (j2 = this.items[0].length - 4 + 1; j2 <= this.items[0].length; ++j2) {
                    newItems[i2][j2] = this.items[i2][this.items[0].length - 4];
                }
            }
        } else if (columnNumber >= this.items[0].length || columnNumber == -2) {
            for (int i3 = 0; i3 < newItems.length; ++i3) {
                for (j2 = 0; j2 < this.items[0].length; ++j2) {
                    newItems[i3][j2] = this.items[i3][j2];
                }
            }
        } else if (columnNumber == -1) {
            LinkedList<Item> itemsToShift = new LinkedList<Item>();
            for (i = 0; i < newItems.length; ++i) {
                for (j = 0; j < this.items[0].length; ++j) {
                    newItems[i][j + 1] = this.items[i][j];
                    if (this.items[i][j] == null || this.items[i][j].yTile != i || this.items[i][j].xTile != j) continue;
                    itemsToShift.add(this.items[i][j]);
                }
            }
            while (itemsToShift.size() > 0) {
                ++((Item)itemsToShift.remove()).xTile;
            }
        } else {
            for (int i4 = 0; i4 < newItems.length; ++i4) {
                for (j2 = 0; j2 < columnNumber; ++j2) {
                    newItems[i4][j2] = this.items[i4][j2];
                }
            }
            LinkedList<Item> itemsToShift = new LinkedList<Item>();
            for (i = 0; i < newItems.length; ++i) {
                for (j = columnNumber; j < this.items[0].length; ++j) {
                    newItems[i][j + 1] = this.items[i][j];
                    if (this.items[i][j] == null || this.items[i][j].yTile != i || this.items[i][j].xTile != j) continue;
                    itemsToShift.add(this.items[i][j]);
                }
            }
            while (itemsToShift.size() > 0) {
                ++((Item)itemsToShift.remove()).xTile;
            }
        }
        this.items = newItems;
        for (int i5 = 0; i5 < this.items.length; ++i5) {
            Item item = this.items[i5][this.items[0].length - 2];
            if (item == null || !ItemFitting.itemAllowsPartialInsertion(item)) continue;
            item.insertInLevel(item.xTile, item.yTile);
        }
        this.frame.updateColumnStatus();
    }

    public void removeAtColumn(int columnNumber) {
        Item[][] newItems = new Item[this.items.length][this.items[0].length - 1];
        if (columnNumber == -2) {
            columnNumber = this.levelEndType == 0 ? this.items[0].length - 1 : this.items[0].length - 1 - 4;
        }
        if (columnNumber > newItems[0].length) {
            columnNumber = newItems[0].length;
        }
        for (int i = 0; i < newItems.length; ++i) {
            for (int j = 0; j < columnNumber; ++j) {
                newItems[i][j] = this.items[i][j];
            }
        }
        LinkedList<Item> itemsToShift = new LinkedList<Item>();
        for (int i = 0; i < newItems.length; ++i) {
            for (int j = columnNumber + 1; j < this.items[0].length; ++j) {
                newItems[i][j - 1] = this.items[i][j];
                if (this.items[i][j] == null || this.items[i][j].yTile != i || this.items[i][j].xTile != j) continue;
                itemsToShift.add(this.items[i][j]);
            }
        }
        while (itemsToShift.size() > 0) {
            --((Item)itemsToShift.remove()).xTile;
        }
        this.items = newItems;
        this.frame.updateColumnStatus();
    }

    public int getLevelEndTypeIndexFromEndType(int endType) {
        if (endType == 0 || this.levelType == 5 || this.levelType == 6 || this.levelType == 1 || this.levelType == 3) {
            return 0;
        }
        if (this.levelType == 0 || this.levelType == 4) {
            if (endType == 1) {
                return 1;
            }
            if (endType == 2) {
                return 2;
            }
        } else if (this.levelType == 2) {
            return endType - 2;
        }
        return 0;
    }

    public void changeLevelEndType(int endTypeComboIndex, boolean expansionAllowed) {
        int newEndType = 0;
        if (this.levelType == 0 || this.levelType == 4) {
            if (endTypeComboIndex == 0) {
                newEndType = 0;
            } else if (endTypeComboIndex == 1) {
                newEndType = 1;
            } else if (endTypeComboIndex == 2) {
                newEndType = 2;
            }
        } else if (this.levelType == 1 || this.levelType == 3) {
            newEndType = 0;
        } else if (this.levelType == 2) {
            if (endTypeComboIndex == 0) {
                newEndType = 0;
            } else if (endTypeComboIndex == 1) {
                newEndType = 3;
            } else if (endTypeComboIndex == 2) {
                newEndType = 4;
            } else if (endTypeComboIndex == 3) {
                newEndType = 5;
            } else if (endTypeComboIndex == 4) {
                newEndType = 6;
            } else if (endTypeComboIndex == 5) {
                newEndType = 7;
            } else if (endTypeComboIndex == 6) {
                newEndType = 8;
            } else if (endTypeComboIndex == 7) {
                newEndType = 9;
            } else if (endTypeComboIndex == 8) {
                newEndType = 10;
            }
        }
        if (expansionAllowed) {
            if (this.levelEndType == 0 && newEndType != 0) {
                for (int i = 0; i < this.items.length; ++i) {
                    Item item = this.items[i][this.items[0].length - 1];
                    if (item == null || !ItemFitting.itemAllowsPartialInsertion(item) || item.xTile + item.tilesWidth - 1 < this.items[0].length) continue;
                    item.removeFromLevel();
                }
                Item[][] newItems = new Item[this.items.length][this.items[0].length + 4];
                for (int i = 0; i < newItems.length; ++i) {
                    for (int j = 0; j < this.items[0].length; ++j) {
                        newItems[i][j] = this.items[i][j];
                    }
                }
                this.items = newItems;
                this.frame.levelPanel.placeLevel();
                this.frame.levelPanel.updateSlider();
            } else if (this.levelEndType != 0 && newEndType == 0) {
                Item[][] newItems = new Item[this.items.length][this.items[0].length - 4];
                for (int i = 0; i < newItems.length; ++i) {
                    for (int j = 0; j < newItems[0].length; ++j) {
                        newItems[i][j] = this.items[i][j];
                    }
                }
                this.items = newItems;
                this.frame.levelPanel.placeLevel();
                this.frame.levelPanel.updateSlider();
            }
        }
        this.levelEndType = newEndType;
        this.endItem = null;
        if (newEndType == 1) {
            this.endItem = this.frame.miscPanel.levelEndingSmFlag.item.copy();
            this.endItem.insertInLevel(this.items[0].length - 4, 0);
        } else if (newEndType == 2) {
            this.endItem = this.frame.miscPanel.levelEndingLgFlag.item.copy();
            this.endItem.insertInLevel(this.items[0].length - 4, 0);
        } else if (newEndType == 3) {
            this.endItem = this.frame.miscPanel.levelEndingBowserBattle.item.copy();
            this.endItem.character = (char)9830;
            this.endItem.insertInLevel(this.items[0].length - 4, 0);
        } else if (newEndType == 4) {
            this.endItem = this.frame.miscPanel.levelEndingBowserBattle.item.copy();
            this.endItem.character = (char)188;
            this.endItem.insertInLevel(this.items[0].length - 4, 0);
        } else if (newEndType == 5) {
            this.endItem = this.frame.miscPanel.levelEndingBowserBattle.item.copy();
            this.endItem.character = (char)215;
            this.endItem.insertInLevel(this.items[0].length - 4, 0);
        } else if (newEndType == 6) {
            this.endItem = this.frame.miscPanel.levelEndingBowserBattle.item.copy();
            this.endItem.character = (char)216;
            this.endItem.insertInLevel(this.items[0].length - 4, 0);
        } else if (newEndType == 7) {
            this.endItem = this.frame.miscPanel.levelEndingBowserBattle.item.copy();
            this.endItem.character = (char)222;
            this.endItem.insertInLevel(this.items[0].length - 4, 0);
        } else if (newEndType == 8) {
            this.endItem = this.frame.miscPanel.levelEndingBowserBattle.item.copy();
            this.endItem.character = (char)223;
            this.endItem.insertInLevel(this.items[0].length - 4, 0);
        } else if (newEndType == 9) {
            this.endItem = this.frame.miscPanel.levelEndingBowserBattle.item.copy();
            this.endItem.character = (char)240;
            this.endItem.insertInLevel(this.items[0].length - 4, 0);
        } else if (newEndType == 10) {
            this.endItem = this.frame.miscPanel.levelEndingBowserBattle.item.copy();
            this.endItem.character = (char)255;
            this.endItem.insertInLevel(this.items[0].length - 4, 0);
        }
        this.frame.levelPanel.repaint();
    }

    public void matchItemsToLevelType() {
        for (int i = 0; i < this.items.length; ++i) {
            for (int j = 0; j < this.items[0].length; ++j) {
                if (this.items[i][j] == null || this.items[i][j].yTile != i || this.items[i][j].xTile != j) continue;
                this.matchItem(this.items[i][j]);
            }
        }
    }

    private void matchItem(Item item) {
        Item newItem = null;
        char c = item.character;
        int day = 0;
        int night = 4;
        int castle = 2;
        int under = 1;
        if ((c == '$' || c == '\u02e6') && this.levelType == under) {
            newItem = this.frame.enemiesPanel.darkGoomba.item.copy();
        } else if (!(c != '%' && c != '\u02e6' || this.levelType != day && this.levelType != night)) {
            newItem = this.frame.enemiesPanel.lightGoomba.item.copy();
        } else if ((c == '$' || c == '%') && this.levelType == castle) {
            newItem = this.frame.enemiesPanel.grayGoomba.item.copy();
        } else if (c == '^' && this.levelType == under) {
            newItem = this.frame.enemiesPanel.darkKoopaNormal.item.copy();
        } else if (c == '&' && this.levelType == under) {
            newItem = this.frame.enemiesPanel.darkKoopaBouncing.item.copy();
        } else if (c == '*' && this.levelType == under) {
            newItem = this.frame.enemiesPanel.darkKoopaFlyingV.item.copy();
        } else if (c == '\u00ac' && this.levelType == under) {
            newItem = this.frame.enemiesPanel.darkKoopaFlyingH.item.copy();
        } else if (c == '(' && (this.levelType == day || this.levelType == night)) {
            newItem = this.frame.enemiesPanel.darkKoopaNormal.item.copy();
        } else if (c == ')' && (this.levelType == day || this.levelType == night)) {
            newItem = this.frame.enemiesPanel.lightKoopaBouncing.item.copy();
        } else if (c == '-' && (this.levelType == day || this.levelType == night)) {
            newItem = this.frame.enemiesPanel.lightKoopaFlyingV.item.copy();
        } else if (c == '\u00b1' && (this.levelType == day || this.levelType == night)) {
            newItem = this.frame.enemiesPanel.lightKoopaFlyingH.item.copy();
        } else if ((c == ':' || c == '\u02e7') && this.levelType == under) {
            newItem = this.frame.enemiesPanel.darkBeetle.item.copy();
        } else if (!(c != '\u00f4' && c != '\u02e7' || this.levelType != day && this.levelType != night)) {
            newItem = this.frame.enemiesPanel.lightBeetle.item.copy();
        } else if ((c == ':' || c == '\u00f4') && this.levelType == castle) {
            newItem = this.frame.enemiesPanel.grayBeetle.item.copy();
        } else if (c == '}' && this.levelType == under) {
            newItem = this.frame.enemiesPanel.darkHammerBro.item.copy();
        } else if (c == '\u00f6' && (this.levelType == day || this.levelType == night || this.levelType == castle)) {
            newItem = this.frame.enemiesPanel.lightHammerBro.item.copy();
        } else if (c == 'A' && this.levelType == castle) {
            newItem = this.frame.blocksPanel.stoneBrickNothing.item.copy();
        } else if (c == 'A' && this.levelType == under) {
            newItem = this.frame.blocksPanel.darkBrickNothing.item.copy();
        } else if (c == 'G' && this.levelType == castle) {
            newItem = this.frame.blocksPanel.stoneBrickBeanstalk.item.copy();
        } else if (c == 'G' && this.levelType == under) {
            newItem = this.frame.blocksPanel.darkBrickBeanstalk.item.copy();
        } else if (c == 'C' && this.levelType == castle) {
            newItem = this.frame.blocksPanel.stoneBrickCoins.item.copy();
        } else if (c == 'C' && this.levelType == under) {
            newItem = this.frame.blocksPanel.darkBrickCoins.item.copy();
        } else if (c == 'D' && this.levelType == castle) {
            newItem = this.frame.blocksPanel.stoneBrickGrow.item.copy();
        } else if (c == 'D' && this.levelType == under) {
            newItem = this.frame.blocksPanel.darkBrickGrow.item.copy();
        } else if (c == 'E' && this.levelType == castle) {
            newItem = this.frame.blocksPanel.stoneBrickLife.item.copy();
        } else if (c == 'E' && this.levelType == under) {
            newItem = this.frame.blocksPanel.darkBrickLife.item.copy();
        } else if (c == 'B' && this.levelType == castle) {
            newItem = this.frame.blocksPanel.stoneBrickCoin.item.copy();
        } else if (c == 'B' && this.levelType == under) {
            newItem = this.frame.blocksPanel.darkBrickCoin.item.copy();
        } else if (c == 'F' && this.levelType == castle) {
            newItem = this.frame.blocksPanel.stoneBrickStar.item.copy();
        } else if (c == 'F' && this.levelType == under) {
            newItem = this.frame.blocksPanel.darkBrickStar.item.copy();
        } else if (c == 'H' && this.levelType == castle) {
            newItem = this.frame.blocksPanel.stoneBrickNothing.item.copy();
        } else if (c == 'H' && (this.levelType == day || this.levelType == night)) {
            newItem = this.frame.blocksPanel.lightBrickNothing.item.copy();
        } else if (c == 'N' && this.levelType == castle) {
            newItem = this.frame.blocksPanel.stoneBrickBeanstalk.item.copy();
        } else if (c == 'N' && (this.levelType == day || this.levelType == night)) {
            newItem = this.frame.blocksPanel.lightBrickBeanstalk.item.copy();
        } else if (c == 'J' && this.levelType == castle) {
            newItem = this.frame.blocksPanel.stoneBrickCoins.item.copy();
        } else if (c == 'J' && (this.levelType == day || this.levelType == night)) {
            newItem = this.frame.blocksPanel.lightBrickCoins.item.copy();
        } else if (c == 'K' && this.levelType == castle) {
            newItem = this.frame.blocksPanel.stoneBrickGrow.item.copy();
        } else if (c == 'K' && (this.levelType == day || this.levelType == night)) {
            newItem = this.frame.blocksPanel.lightBrickGrow.item.copy();
        } else if (c == 'L' && this.levelType == castle) {
            newItem = this.frame.blocksPanel.stoneBrickLife.item.copy();
        } else if (c == 'L' && (this.levelType == day || this.levelType == night)) {
            newItem = this.frame.blocksPanel.lightBrickLife.item.copy();
        } else if (c == 'I' && this.levelType == castle) {
            newItem = this.frame.blocksPanel.stoneBrickCoin.item.copy();
        } else if (c == 'I' && (this.levelType == day || this.levelType == night)) {
            newItem = this.frame.blocksPanel.lightBrickCoins.item.copy();
        } else if (c == 'M' && this.levelType == castle) {
            newItem = this.frame.blocksPanel.stoneBrickStar.item.copy();
        } else if (c == 'M' && (this.levelType == day || this.levelType == night)) {
            newItem = this.frame.blocksPanel.lightBrickStar.item.copy();
        } else if (c == '\u2022' && (this.levelType == day || this.levelType == night)) {
            newItem = this.frame.blocksPanel.lightBrickNothing.item.copy();
        } else if (c == '\u2022' && this.levelType == under) {
            newItem = this.frame.blocksPanel.darkBrickNothing.item.copy();
        } else if (c == '\u25c4' && (this.levelType == day || this.levelType == night)) {
            newItem = this.frame.blocksPanel.lightBrickBeanstalk.item.copy();
        } else if (c == '\u25c4' && this.levelType == under) {
            newItem = this.frame.blocksPanel.darkBrickBeanstalk.item.copy();
        } else if (c == '\u2640' && (this.levelType == day || this.levelType == night)) {
            newItem = this.frame.blocksPanel.lightBrickCoins.item.copy();
        } else if (c == '\u2640' && this.levelType == under) {
            newItem = this.frame.blocksPanel.darkBrickCoins.item.copy();
        } else if (c == '\u266b' && (this.levelType == day || this.levelType == night)) {
            newItem = this.frame.blocksPanel.lightBrickGrow.item.copy();
        } else if (c == '\u266b' && this.levelType == under) {
            newItem = this.frame.blocksPanel.darkBrickGrow.item.copy();
        } else if (c == '\u263c' && (this.levelType == day || this.levelType == night)) {
            newItem = this.frame.blocksPanel.lightBrickLife.item.copy();
        } else if (c == '\u263c' && this.levelType == under) {
            newItem = this.frame.blocksPanel.darkBrickLife.item.copy();
        } else if (c == '\u25d8' && (this.levelType == day || this.levelType == night)) {
            newItem = this.frame.blocksPanel.lightBrickCoin.item.copy();
        } else if (c == '\u25d8' && this.levelType == under) {
            newItem = this.frame.blocksPanel.darkBrickCoin.item.copy();
        } else if (c == '\u25ba' && (this.levelType == day || this.levelType == night)) {
            newItem = this.frame.blocksPanel.lightBrickStar.item.copy();
        } else if (c == '\u25ba' && this.levelType == under) {
            newItem = this.frame.blocksPanel.darkBrickStar.item.copy();
        } else if ((c == 'q' || c == '\u045e') && this.levelType == under) {
            newItem = this.frame.solidsPanel.darkBlock.item.copy();
        } else if (!(c != 'r' && c != '\u045e' || this.levelType != day && this.levelType != night)) {
            newItem = this.frame.solidsPanel.lightBlock.item.copy();
        } else if ((c == 'q' || c == 'r') && this.levelType == castle) {
            newItem = this.frame.solidsPanel.stoneBlock.item.copy();
        }
        if (newItem != null) {
            newItem.flip = item.flip;
            newItem.coinCount = item.coinCount;
            newItem.oscOffset = item.oscOffset;
            newItem.checkpointType = item.checkpointType;
            newItem.fireballColor = item.fireballColor;
            newItem.speedBoost = item.speedBoost;
            item.removeFromLevel();
            newItem.insertInLevel(item.xTile, item.yTile);
            this.frame.levelPanel.repaint();
        }
    }

    public BufferedImage getLevelImage() throws Exception {
        int j;
        int i;
        int width = this.items[0].length * 8;
        int height = this.items.length * 8;
        BufferedImage image = new BufferedImage(width, height, 5);
        Graphics2D g2D = (Graphics2D)image.getGraphics();
        if (this.levelType == 0 || this.levelType == 5) {
            g2D.setColor(this.frame.game.textures.skyBlue);
            g2D.fillRect(0, 0, width, height);
        } else if (this.levelType == 1 || this.levelType == 4 || this.levelType == 2 || this.levelType == 6) {
            g2D.setColor(this.frame.game.textures.black);
            g2D.fillRect(0, 0, width, height);
        } else if (this.levelType == 3) {
            g2D.setColor(this.frame.game.textures.skyBlue);
            g2D.fillRect(0, 0, width, (int)Math.ceil(32.0));
            g2D.setColor(this.frame.game.textures.waterBlue);
            g2D.fillRect(0, Math.round(32.0f), width, (int)Math.ceil(height - 32));
            double offset = this.leftMostX % 8.0;
            for (double i2 = -offset; i2 < (double)((width / 8 + 1) * 8); i2 += 8.0) {
                g2D.drawImage(this.frame.game.textures.waves.getImage(), (int)Math.round(i2), Math.round(24.0f), (int)Math.ceil(this.frame.game.textures.waves.getIconWidth()), (int)Math.ceil(this.frame.game.textures.waves.getIconHeight()), null);
            }
        }
        for (i = 0; i < this.items.length; ++i) {
            for (j = 0; j < this.items[0].length; ++j) {
                if (this.items[i][j] == null || this.items[i][j].yTile != i || this.items[i][j].xTile != j || this.items[i][j].spaceRequirement != 0 && this.items[i][j].spaceRequirement != 1) continue;
                this.items[i][j].drawInLevel(g2D, 0.0, 1.0, 8.0, false);
            }
        }
        for (i = 0; i < this.items.length; ++i) {
            for (j = 0; j < this.items[0].length; ++j) {
                if (this.items[i][j] == null || this.items[i][j].yTile != i || this.items[i][j].xTile != j || this.items[i][j].spaceRequirement == 0 || this.items[i][j].spaceRequirement == 1) continue;
                this.items[i][j].drawInLevel(g2D, this.leftMostX, 1.0, 8.0, false);
            }
        }
        return image;
    }

    public byte[] getLevelBytes() throws Exception {
        return String.valueOf(this.getLevelChars()).getBytes(Game.ENCODING);
    }

    public char[] getLevelChars() throws Exception {
        String lineBreak = "\r\n";
        char[][] charData = this.getCharData();
        charData = this.expandLevelSizeForEnding(charData);
        this.assignWarpsToCharData(charData);
        CharArrayWriter cWriter = new CharArrayWriter();
        for (int i = 0; i < Game.yTiles; ++i) {
            cWriter.write(charData[i]);
            cWriter.write(lineBreak);
        }
        cWriter.write(String.valueOf(this.levelType));
        String present = "1";
        String missing = "x";
        if (this.hasLakitu) {
            cWriter.write(present);
        } else {
            cWriter.write(missing);
        }
        if (this.hasFlyingFish) {
            cWriter.write(present);
        } else {
            cWriter.write(missing);
        }
        if (this.hasBullets) {
            cWriter.write(present);
        } else {
            cWriter.write(missing);
        }
        if (this.blackAndWhite) {
            cWriter.write(present);
        } else {
            cWriter.write(missing);
        }
        cWriter.write(lineBreak);
        if (this.cliffDestLevel == -1) {
            cWriter.write("xxxxxx");
        } else {
            cWriter.write(this.padStringToSize(String.valueOf(this.cliffDestLevel), 3, '0', true));
            cWriter.write(this.padStringToSize(String.valueOf(this.cliffDestID), 3, '0', true));
        }
        cWriter.write(lineBreak);
        cWriter.write(this.padStringToSize(this.name1, 8, ' ', false));
        cWriter.write(lineBreak);
        cWriter.write(this.padStringToSize(this.name2, 8, ' ', false));
        cWriter.write(lineBreak);
        if (this.timedLevel) {
            cWriter.write("1" + lineBreak);
            cWriter.write(this.padStringToSize(String.valueOf(this.levelTime), 4, '0', true) + lineBreak);
        } else {
            cWriter.write("0" + lineBreak);
            cWriter.write("xxxx" + lineBreak);
        }
        cWriter.write(String.valueOf(this.pipeColor));
        cWriter.write(String.valueOf(this.autoScrolling ? 1 : 0));
        cWriter.write(String.valueOf(this.texturePack));
        return cWriter.toCharArray();
    }

    private char[][] expandLevelSizeForEnding(char[][] charData) throws Exception {
        if (this.levelEndType != 0) {
            int j;
            int i;
            int endingSize = 0;
            if (this.levelEndType >= 3 && this.levelEndType <= 10) {
                endingSize = 68;
            } else if (this.levelEndType == 1 || this.levelEndType == 2) {
                endingSize = 28;
            }
            char[][] newCharData = new char[Game.yTiles][this.items[0].length - 4 + endingSize];
            for (i = 0; i < charData.length; ++i) {
                for (j = 0; j < charData[0].length; ++j) {
                    newCharData[i][j] = charData[i][j];
                }
            }
            for (i = 0; i < newCharData.length; ++i) {
                for (j = charData[0].length; j < newCharData[0].length; ++j) {
                    newCharData[i][j] = 120;
                }
            }
            return newCharData;
        }
        return charData;
    }

    private char[][] getCharData() throws Exception {
        char[][] charData = new char[Game.yTiles][this.items[0].length];
        for (int i = 0; i < Game.yTiles; ++i) {
            for (int j = 0; j < this.items[0].length; ++j) {
                if (this.items[i][j] == null) {
                    charData[i][j] = 48;
                    continue;
                }
                if (this.items[i][j].yTile == i && this.items[i][j].xTile == j) {
                    charData[i][j] = this.items[i][j].character;
                    if (!this.addAnySupplementalInfo(charData, this.items[i][j], j, i)) continue;
                    ++j;
                    continue;
                }
                if (charData[i][j] != '\u0000') continue;
                charData[i][j] = 120;
            }
        }
        return charData;
    }

    private boolean addAnySupplementalInfo(char[][] charData, Item item, int xTile, int yTile) throws Exception {
        if (item.flippable) {
            charData[yTile][xTile + 1] = item.flip ? 120 : 48;
            return true;
        }
        if (item.shiftable) {
            charData[yTile][xTile + 1] = item.shifted ? 48 : 120;
            return true;
        }
        if (item.character == ',' || item.character == '<') {
            charData[yTile][xTile + 1] = !item.flip && !item.speedBoost ? 50 : (!item.flip && item.speedBoost ? 51 : (item.flip && !item.speedBoost ? 48 : 49));
            return true;
        }
        if (item.platformRepeatable) {
            charData[yTile][xTile + 1] = item.singlePlatform ? 48 : 120;
            return true;
        }
        if (LevelLoader.isPowerupBlock(item.character)) {
            charData[yTile][xTile + 1] = item.poison ? 48 : 120;
            return true;
        }
        if (item.redPiranha) {
            if (LevelLoader.isSideOpeningPipe(item.character)) {
                charData[yTile][xTile + 1] = 48;
                return true;
            }
            charData[yTile + 1][xTile] = 48;
            return false;
        }
        if (item.superSpring) {
            charData[yTile][xTile + 1] = 48;
            return true;
        }
        if (LevelLoader.multiCoinBlock(item.character)) {
            charData[yTile][xTile + 1] = String.valueOf(item.coinCount).toCharArray()[0];
            return true;
        }
        if (item.character == '.') {
            charData[yTile][xTile + 1] = String.valueOf(item.fireballColor).toCharArray()[0];
            return true;
        }
        if (LevelLoader.isOscSprite(item.character)) {
            charData[yTile][xTile + 1] = String.valueOf(item.oscOffset).toCharArray()[0];
            return true;
        }
        if (item.character == '\u0292') {
            charData[yTile][xTile + 1] = String.valueOf(item.checkpointType).toCharArray()[0];
            return true;
        }
        return false;
    }

    private void assignWarpsToCharData(char[][] charData) throws Exception {
        if (this.nextLevelNumber >= 0) {
            char[] destLevelChars = this.padStringToSize(String.valueOf(this.nextLevelNumber), 3, '0', true).toCharArray();
            charData[1][this.items[0].length - 3] = destLevelChars[0];
            charData[1][this.items[0].length - 2] = destLevelChars[1];
            charData[1][this.items[0].length - 1] = destLevelChars[2];
            charData[2][this.items[0].length - 3] = 48;
            charData[2][this.items[0].length - 2] = 48;
            charData[2][this.items[0].length - 1] = 48;
        }
        Iterator incomingWarpsIter = this.incomingWarps.iterator();
        while (incomingWarpsIter.hasNext()) {
            this.assignWarpID(charData, (Warp)incomingWarpsIter.next());
        }
        for (Warp tempWarp : this.outgoingWarps) {
            if (tempWarp.item.character == '\u0108') {
                tempWarp.sourceWarpID = tempWarp.item.displayWarpNumber;
                charData[tempWarp.item.yTile + 1][tempWarp.item.xTile] = String.valueOf(tempWarp.item.warpPipeColor).toCharArray()[0];
            }
            this.assignWarpDestination(charData, tempWarp);
        }
    }

    private void assignWarpID(char[][] charData, Warp warp) throws Exception {
        char[] warpIDChars = this.padStringToSize(String.valueOf(warp.sourceWarpID), 3, '0', true).toCharArray();
        int xTile = warp.item.xTile;
        int yTile = warp.item.yTile;
        char warpChar = warp.item.character;
        if (warpChar == ';' || warpChar == '~' || warpChar == '\u00bf' || warpChar == '\u0110') {
            charData[yTile][xTile + 1] = warpIDChars[0];
            charData[yTile][xTile + 2] = warpIDChars[1];
            charData[yTile][xTile + 3] = warpIDChars[2];
        } else if (warpChar == '\u03e4') {
            charData[yTile + 1][xTile] = warpIDChars[0];
            charData[yTile + 2][xTile] = warpIDChars[1];
            charData[yTile + 3][xTile] = warpIDChars[2];
            charData[yTile + 3][xTile + 1] = 120;
            charData[yTile + 2][xTile + 1] = 120;
            charData[yTile + 1][xTile + 1] = 120;
        } else if (warpChar == '\u00bd') {
            charData[yTile + 1][xTile] = warpIDChars[0];
            charData[yTile + 2][xTile] = warpIDChars[1];
            charData[yTile + 3][xTile] = warpIDChars[2];
            charData[yTile + 3][xTile + 1] = 120;
            charData[yTile + 2][xTile + 1] = 120;
            charData[yTile + 1][xTile + 1] = 120;
        } else if (LevelLoader.isSideOpeningPipe(warpChar)) {
            charData[yTile + 1][xTile] = warpIDChars[0];
            charData[yTile + 1][xTile + 1] = warpIDChars[1];
            charData[yTile + 1][xTile + 2] = warpIDChars[2];
        }
    }

    private void assignWarpDestination(char[][] charData, Warp warp) throws Exception {
        char[] destLevelChars = this.padStringToSize(String.valueOf(warp.destLevelNumber), 3, '0', true).toCharArray();
        char[] destIDChars = this.padStringToSize(String.valueOf(warp.destWarpID), 3, '0', true).toCharArray();
        int xTile = warp.item.xTile;
        int yTile = warp.item.yTile;
        char warpChar = warp.item.character;
        if (LevelLoader.isBeanstalkBlock(warpChar)) {
            charData[yTile - 3][xTile] = destLevelChars[0];
            charData[yTile - 2][xTile] = destLevelChars[1];
            charData[yTile - 1][xTile] = destLevelChars[2];
            charData[yTile - 3][xTile + 1] = destIDChars[0];
            charData[yTile - 2][xTile + 1] = destIDChars[1];
            charData[yTile - 1][xTile + 1] = destIDChars[2];
        } else if (warpChar == ';' || warpChar == '~' || warpChar == '\u0108' || warpChar == '\u0110' || warpChar == '\u00bf') {
            if (warpChar == '\u0108') {
                char[] displayIDChars = warp.item.displayWarpNumber == -1 ? new char[]{'x', 'x', 'x'} : this.padStringToSize(String.valueOf(warp.item.displayWarpNumber), 3, '0', true).toCharArray();
                charData[yTile][xTile + 1] = displayIDChars[0];
                charData[yTile][xTile + 2] = displayIDChars[1];
                charData[yTile][xTile + 3] = displayIDChars[2];
            }
            charData[yTile + 1][xTile + 1] = destLevelChars[0];
            charData[yTile + 1][xTile + 2] = destLevelChars[1];
            charData[yTile + 1][xTile + 3] = destLevelChars[2];
            charData[yTile + 2][xTile + 1] = destIDChars[0];
            charData[yTile + 2][xTile + 2] = destIDChars[1];
            charData[yTile + 2][xTile + 3] = destIDChars[2];
        } else if (LevelLoader.isSideOpeningPipe(warpChar)) {
            charData[yTile + 2][xTile] = destLevelChars[0];
            charData[yTile + 2][xTile + 1] = destLevelChars[1];
            charData[yTile + 2][xTile + 2] = destLevelChars[2];
            charData[yTile + 3][xTile] = destIDChars[0];
            charData[yTile + 3][xTile + 1] = destIDChars[1];
            charData[yTile + 3][xTile + 2] = destIDChars[2];
        }
    }

    private String padStringToSize(String string, int size, char padChar, boolean padAtStart) {
        while (string.length() < size) {
            if (padAtStart) {
                string = padChar + string;
                continue;
            }
            string = string + padChar;
        }
        return string;
    }

    public void createLevel(char[] levelChars, int levelNumber) throws Exception {
        this.levelNumber = levelNumber;
        int lineLength = this.getLineLength(levelChars);
        this.setLevelType(levelChars, lineLength);
        this.setLevelNames(levelChars, lineLength);
        this.hasBullets = this.hasBulletThrower(levelChars, lineLength);
        this.hasFlyingFish = this.hasFlyingFish(levelChars, lineLength);
        this.hasLakitu = this.hasSpinyThrower(levelChars, lineLength);
        this.blackAndWhite = this.isBlackAndWhite(levelChars, lineLength);
        if (this.isTimedLevel(levelChars, lineLength)) {
            this.timedLevel = true;
            this.levelTime = this.getLevelTimeLimit(levelChars, lineLength);
        } else {
            this.timedLevel = false;
        }
        this.pipeColor = this.getPipeColor(levelChars, lineLength);
        this.autoScrolling = this.hasAutoScrolling(levelChars, lineLength);
        this.texturePack = this.getTexturePack(levelChars, lineLength);
        this.cliffDestLevel = this.getCliffDestLevel(levelChars, lineLength);
        if (this.cliffDestLevel != -1) {
            this.cliffDestID = this.getCliffDestID(levelChars, lineLength);
        }
        char[][] levelChars2D = this.getLevelChars2D(levelChars, lineLength);
        this.createItems(levelChars2D, levelNumber);
    }

    private int getLineLength(char[] chars) throws Exception {
        int lineLength = -1;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '\r') continue;
            lineLength = i;
            break;
        }
        if (lineLength == -1 || lineLength < Game.xTiles) {
            throw new RuntimeException("Line length is invalid: " + lineLength);
        }
        return lineLength;
    }

    private char[][] getLevelChars2D(char[] levelChars, int lineLength) throws Exception {
        char[][] levelChars2D = new char[Game.yTiles][lineLength];
        int x = 0;
        for (int i = 0; i < Game.yTiles; ++i) {
            for (int j = 0; j < lineLength; ++j) {
                levelChars2D[i][j] = levelChars[x++];
            }
            x += 2;
        }
        return levelChars2D;
    }

    private void createItems(char[][] levelChars2D, int levelNumber) throws Exception {
        this.levelEndType = 0;
        this.items = new Item[Game.yTiles][levelChars2D[0].length];
        for (int i = 0; i < levelChars2D.length; ++i) {
            for (int j = 0; j < levelChars2D[0].length; ++j) {
                Item item;
                char followingChar = '0';
                if (j + 1 < levelChars2D[0].length) {
                    followingChar = levelChars2D[i][j + 1];
                    if (levelChars2D[i][j] == '\u0108' || LevelLoader.isVerticalOpeningPipe(levelChars2D[i][j])) {
                        followingChar = levelChars2D[i + 1][j];
                    }
                }
                if ((item = this.getItem(levelChars2D, levelChars2D[i][j], followingChar, j, i)) == null) continue;
                if (item.isWarpable()) {
                    this.setWarpInfo(levelChars2D, item, j, i, levelNumber);
                }
                item.inserted = true;
                item.insertInLevel(j, i);
            }
        }
        if (this.levelEndType != 0) {
            if (this.levelEndType == 1) {
                this.reduceItemWidthBy(24);
                this.changeLevelEndType(1, false);
            } else if (this.levelEndType == 2) {
                this.reduceItemWidthBy(24);
                this.changeLevelEndType(2, false);
            } else if (this.levelEndType >= 3 && this.levelEndType <= 10) {
                this.reduceItemWidthBy(64);
                this.changeLevelEndType(this.levelEndType - 2, false);
            }
        }
    }

    private void reduceItemWidthBy(int x) throws Exception {
        Item[][] newItems = new Item[Game.yTiles][this.items[0].length - x];
        for (int i = 0; i < Game.yTiles; ++i) {
            for (int j = 0; j < newItems[0].length; ++j) {
                newItems[i][j] = this.items[i][j];
            }
        }
        this.items = newItems;
    }

    private void setWarpInfo(char[][] chars, Item item, int x, int y, int levelNumber) throws Exception {
        boolean incoming = false;
        boolean outgoing = false;
        int sourceID = -1;
        int destLevel = -1;
        int destID = -1;
        char[] sourceIDChars = new char[3];
        char[] destLevelChars = new char[3];
        char[] destIDChars = new char[3];
        if (item.character == '~' || item.character == ';' || item.character == '\u0110' || item.character == '\u00bf') {
            sourceIDChars[0] = chars[y][x + 1];
            sourceIDChars[1] = chars[y][x + 2];
            sourceIDChars[2] = chars[y][x + 3];
            destLevelChars[0] = chars[y + 1][x + 1];
            destLevelChars[1] = chars[y + 1][x + 2];
            destLevelChars[2] = chars[y + 1][x + 3];
            destIDChars[0] = chars[y + 2][x + 1];
            destIDChars[1] = chars[y + 2][x + 2];
            destIDChars[2] = chars[y + 2][x + 3];
        } else if (item.character == '\u0108') {
            sourceIDChars[2] = 120;
            sourceIDChars[1] = 120;
            sourceIDChars[0] = 120;
            char[] displayLevelChars = new char[]{chars[y][x + 1], chars[y][x + 2], chars[y][x + 3]};
            String displayLevelValue = String.valueOf(displayLevelChars);
            item.displayWarpNumber = displayLevelValue.equals("xxx") ? -1 : Integer.valueOf(String.valueOf(displayLevelChars));
            destLevelChars[0] = chars[y + 1][x + 1];
            destLevelChars[1] = chars[y + 1][x + 2];
            destLevelChars[2] = chars[y + 1][x + 3];
            destIDChars[2] = 48;
            destIDChars[1] = 48;
            destIDChars[0] = 48;
        } else if (LevelLoader.isSideOpeningPipe(item.character)) {
            sourceIDChars[0] = chars[y + 1][x];
            sourceIDChars[1] = chars[y + 1][x + 1];
            sourceIDChars[2] = chars[y + 1][x + 2];
            destLevelChars[0] = chars[y + 2][x];
            destLevelChars[1] = chars[y + 2][x + 1];
            destLevelChars[2] = chars[y + 2][x + 2];
            destIDChars[0] = chars[y + 3][x];
            destIDChars[1] = chars[y + 3][x + 1];
            destIDChars[2] = chars[y + 3][x + 2];
        } else if (LevelLoader.isBeanstalkBlock(item.character)) {
            sourceIDChars[2] = 120;
            sourceIDChars[1] = 120;
            sourceIDChars[0] = 120;
            destLevelChars[0] = chars[y - 3][x];
            destLevelChars[1] = chars[y - 2][x];
            destLevelChars[2] = chars[y - 1][x];
            destIDChars[0] = chars[y - 3][x + 1];
            destIDChars[1] = chars[y - 2][x + 1];
            destIDChars[2] = chars[y - 1][x + 1];
        } else if (item.character == '\u03e4') {
            sourceIDChars[0] = chars[y + 1][x];
            sourceIDChars[1] = chars[y + 2][x];
            sourceIDChars[2] = chars[y + 3][x];
            destLevelChars[2] = 120;
            destLevelChars[1] = 120;
            destLevelChars[0] = 120;
            destIDChars[2] = 120;
            destIDChars[1] = 120;
            destIDChars[0] = 120;
        } else if (item.character == '\u00bd') {
            sourceIDChars[0] = chars[y + 1][x];
            sourceIDChars[1] = chars[y + 2][x];
            sourceIDChars[2] = chars[y + 3][x];
            destLevelChars[2] = 120;
            destLevelChars[1] = 120;
            destLevelChars[0] = 120;
            destIDChars[2] = 120;
            destIDChars[1] = 120;
            destIDChars[0] = 120;
        }
        if (sourceIDChars[0] != 'x') {
            incoming = true;
            sourceID = Integer.valueOf(String.valueOf(sourceIDChars));
        }
        if (destLevelChars[0] != 'x') {
            outgoing = true;
            destLevel = Integer.valueOf(String.valueOf(destLevelChars));
            destID = Integer.valueOf(String.valueOf(destIDChars));
        }
        Warp warp = new Warp(outgoing, incoming, levelNumber, sourceID, destLevel, destID, item);
        if (incoming) {
            this.insertIncomingWarp(warp);
        }
        if (outgoing) {
            this.outgoingWarps.add(warp);
        }
        item.warp = warp;
    }

    private Item getItem(char[][] levelChars, char c, char fc, int xTile, int yTile) throws Exception {
        if (Character.isDigit(c) || c == 'x') {
            return null;
        }
        if (c == '\u00ab') {
            Item i = this.frame.backgroundPanel.singleCloud.item.copy();
            i.shifted = this.getShift(fc);
            return i;
        }
        if (c == '\u00a9') {
            Item i = this.frame.backgroundPanel.doubleCloud.item.copy();
            i.shifted = this.getShift(fc);
            return i;
        }
        if (c == '\u00a6') {
            Item i = this.frame.backgroundPanel.tripleCloud.item.copy();
            i.shifted = this.getShift(fc);
            return i;
        }
        if (c == '\u00a5') {
            Item i = this.frame.backgroundPanel.singleBush.item.copy();
            i.shifted = this.getShift(fc);
            return i;
        }
        if (c == '\u00a4') {
            Item i = this.frame.backgroundPanel.doubleBush.item.copy();
            i.shifted = this.getShift(fc);
            return i;
        }
        if (c == '\u00a3') {
            Item i = this.frame.backgroundPanel.tripleBush.item.copy();
            i.shifted = this.getShift(fc);
            return i;
        }
        if (c == '\u00fd') {
            Item i = this.frame.backgroundPanel.bridgeChain.item.copy();
            i.shifted = this.getShift(fc);
            return i;
        }
        if (c == '\u00a2') {
            Item i = this.frame.backgroundPanel.tallTrimmedBush.item.copy();
            return i;
        }
        if (c == '\u00a1') {
            Item i = this.frame.backgroundPanel.shortTrimmedBush.item.copy();
            return i;
        }
        if (c == '\u2192') {
            Item i = this.frame.backgroundPanel.shortSnowyBush.item.copy();
            return i;
        }
        if (c == '\u2190') {
            Item i = this.frame.backgroundPanel.tallSnowyBush.item.copy();
            return i;
        }
        if (c == 'i') {
            return this.frame.backgroundPanel.picketFence.item.copy();
        }
        if (c == 'a') {
            return this.frame.backgroundPanel.castleWall.item.copy();
        }
        if (c == 'b') {
            Item i = this.frame.backgroundPanel.smallHill.item.copy();
            i.shifted = this.getShift(fc);
            return i;
        }
        if (c == 'c') {
            Item i = this.frame.backgroundPanel.bigHill.item.copy();
            i.shifted = this.getShift(fc);
            return i;
        }
        if (c == 'd') {
            Item i = this.frame.backgroundPanel.smallCastle.item.copy();
            i.shifted = this.getShift(fc);
            return i;
        }
        if (c == 'e') {
            Item i = this.frame.backgroundPanel.largeCastle.item.copy();
            i.shifted = this.getShift(fc);
            return i;
        }
        if (c == 'f') {
            return this.frame.solidsPanel.treeBark.item.copy();
        }
        if (c == '\u2660') {
            return this.frame.solidsPanel.mushroomBark.item.copy();
        }
        if (c == 'g') {
            return this.frame.backgroundPanel.lavaTop.item.copy();
        }
        if (c == '\u00b5') {
            return this.frame.backgroundPanel.lavaBottom.item.copy();
        }
        if (c == '\u00be') {
            return this.frame.backgroundPanel.waterTop.item.copy();
        }
        if (c == '\u00e5') {
            return this.frame.backgroundPanel.waterBottom.item.copy();
        }
        if (c == '\u00f1') {
            Item i = this.frame.pipesPanel.warpZoneMessage.item.copy();
            i.shifted = this.getShift(fc);
            return i;
        }
        if (c == 'h') {
            return this.frame.miscPanel.coin.item.copy();
        }
        if (c == '\u0292') {
            Item i = this.frame.miscPanel.checkpoint.item.copy();
            i.checkpointType = this.getCheckpointType(fc);
            return i;
        }
        if (c == '\u00bd') {
            return this.frame.miscPanel.thinAirWarp.item.copy();
        }
        if (c == '\u00f7') {
            return this.frame.miscPanel.infiniteCorridor.item.copy();
        }
        if (c == '\u03e4') {
            return this.frame.miscPanel.beanstalkArrival.item.copy();
        }
        if (c == 'j') {
            Item i = this.frame.miscPanel.spring.item.copy();
            i.superSpring = this.getSuperSpring(fc);
            return i;
        }
        if (c == 'k') {
            Item item = this.frame.miscPanel.mario.item.copy();
            item.xTile = xTile;
            item.yTile = yTile;
            this.marioStartItem = item;
            return item;
        }
        if (c == 'l') {
            return this.frame.solidsPanel.lightGround.item.copy();
        }
        if (c == 'm') {
            return this.frame.solidsPanel.darkGround.item.copy();
        }
        if (c == 'n') {
            return this.frame.solidsPanel.stoneGround.item.copy();
        }
        if (c == 'o') {
            return this.frame.solidsPanel.seaGround.item.copy();
        }
        if (c == '\u00a7') {
            return this.frame.solidsPanel.seaStone.item.copy();
        }
        if (c == 'p') {
            return this.frame.solidsPanel.cloudGround.item.copy();
        }
        if (c == 'q') {
            return this.frame.solidsPanel.lightBlock.item.copy();
        }
        if (c == 'r') {
            return this.frame.solidsPanel.darkBlock.item.copy();
        }
        if (c == '\u045e') {
            return this.frame.solidsPanel.stoneBlock.item.copy();
        }
        if (c == 's') {
            return this.frame.solidsPanel.lightMetal.item.copy();
        }
        if (c == 't') {
            return this.frame.solidsPanel.darkMetal.item.copy();
        }
        if (c == 'u') {
            return this.frame.solidsPanel.stoneMetal.item.copy();
        }
        if (c == 'v') {
            return this.frame.solidsPanel.treeTopLeft.item.copy();
        }
        if (c == 'w') {
            return this.frame.solidsPanel.treeTopRight.item.copy();
        }
        if (c == 'y') {
            return this.frame.solidsPanel.treeTopMiddle.item.copy();
        }
        if (c == '\u25cb') {
            return this.frame.solidsPanel.mushroomTopLeft.item.copy();
        }
        if (c == '\u25d9') {
            return this.frame.solidsPanel.mushroomTopRight.item.copy();
        }
        if (c == '\u2642') {
            return this.frame.solidsPanel.mushroomTopMiddle.item.copy();
        }
        if (c == '\u2193') {
            return this.frame.solidsPanel.mushroomBarkTop.item.copy();
        }
        if (c == 'z') {
            return this.frame.solidsPanel.coral.item.copy();
        }
        if (c == '\u25b2') {
            return this.frame.solidsPanel.bridge.item.copy();
        }
        if (c == '\u00e6') {
            return this.frame.solidsPanel.bowserBridge.item.copy();
        }
        if (c == 'A') {
            return this.frame.blocksPanel.lightBrickNothing.item.copy();
        }
        if (c == 'B') {
            return this.frame.blocksPanel.lightBrickCoin.item.copy();
        }
        if (c == 'C') {
            Item i = this.frame.blocksPanel.lightBrickCoins.item.copy();
            i.coinCount = fc == 'x' ? 5 : Integer.valueOf(String.valueOf(fc));
            return i;
        }
        if (c == 'D') {
            Item i = this.frame.blocksPanel.lightBrickGrow.item.copy();
            i.poison = this.getPoison(fc);
            return i;
        }
        if (c == 'E') {
            return this.frame.blocksPanel.lightBrickLife.item.copy();
        }
        if (c == 'F') {
            return this.frame.blocksPanel.lightBrickStar.item.copy();
        }
        if (c == 'G') {
            return this.frame.blocksPanel.lightBrickBeanstalk.item.copy();
        }
        if (c == 'H') {
            return this.frame.blocksPanel.darkBrickNothing.item.copy();
        }
        if (c == 'I') {
            return this.frame.blocksPanel.darkBrickCoin.item.copy();
        }
        if (c == 'J') {
            Item i = this.frame.blocksPanel.darkBrickCoins.item.copy();
            i.coinCount = fc == 'x' ? 5 : Integer.valueOf(String.valueOf(fc));
            return i;
        }
        if (c == 'K') {
            Item i = this.frame.blocksPanel.darkBrickGrow.item.copy();
            i.poison = this.getPoison(fc);
            return i;
        }
        if (c == 'L') {
            return this.frame.blocksPanel.darkBrickLife.item.copy();
        }
        if (c == 'M') {
            return this.frame.blocksPanel.darkBrickStar.item.copy();
        }
        if (c == 'N') {
            return this.frame.blocksPanel.darkBrickBeanstalk.item.copy();
        }
        if (c == '\u2022') {
            return this.frame.blocksPanel.stoneBrickNothing.item.copy();
        }
        if (c == '\u25d8') {
            return this.frame.blocksPanel.stoneBrickCoin.item.copy();
        }
        if (c == '\u2640') {
            Item i = this.frame.blocksPanel.stoneBrickCoins.item.copy();
            i.coinCount = fc == 'x' ? 5 : Integer.valueOf(String.valueOf(fc));
            return i;
        }
        if (c == '\u266b') {
            Item i = this.frame.blocksPanel.stoneBrickGrow.item.copy();
            i.poison = this.getPoison(fc);
            return i;
        }
        if (c == '\u263c') {
            return this.frame.blocksPanel.stoneBrickLife.item.copy();
        }
        if (c == '\u25ba') {
            return this.frame.blocksPanel.stoneBrickStar.item.copy();
        }
        if (c == '\u25c4') {
            return this.frame.blocksPanel.stoneBrickBeanstalk.item.copy();
        }
        if (c == 'O') {
            return this.frame.blocksPanel.questionBoxCoin.item.copy();
        }
        if (c == 'P') {
            Item i = this.frame.blocksPanel.questionBoxGrow.item.copy();
            i.poison = this.getPoison(fc);
            return i;
        }
        if (c == 'Q') {
            return this.frame.blocksPanel.questionBoxLife.item.copy();
        }
        if (c == 'R') {
            return this.frame.blocksPanel.questionBoxStar.item.copy();
        }
        if (c == '\u03d8') {
            return this.frame.blocksPanel.questionBoxBeanstalk.item.copy();
        }
        if (c == 'W') {
            return this.frame.blocksPanel.questionBoxInvisibleCoin.item.copy();
        }
        if (c == 'X') {
            Item i = this.frame.blocksPanel.questionBoxInvisibleGrow.item.copy();
            i.poison = this.getPoison(fc);
            return i;
        }
        if (c == 'Y') {
            return this.frame.blocksPanel.questionBoxInvisibleLife.item.copy();
        }
        if (c == 'Z') {
            return this.frame.blocksPanel.questionBoxInvisibleStar.item.copy();
        }
        if (c == '\u03dc') {
            return this.frame.blocksPanel.questionBoxInvisibleBeanstalk.item.copy();
        }
        if (c == '`') {
            return this.frame.pipesPanel.sideSection.item.copy();
        }
        if (c == '~') {
            return this.frame.pipesPanel.topWOChomp.item.copy();
        }
        if (c == ';') {
            Item i = this.frame.pipesPanel.topWChomp.item.copy();
            i.redPiranha = this.getRedPiranha(fc);
            return i;
        }
        if (c == '\u0110') {
            return this.frame.pipesPanel.bottomWOChomp.item.copy();
        }
        if (c == '\u00bf') {
            Item i = this.frame.pipesPanel.bottomWChomp.item.copy();
            i.redPiranha = this.getRedPiranha(fc);
            return i;
        }
        if (c == '!') {
            return this.frame.pipesPanel.leftWOChomp.item.copy();
        }
        if (c == '\u2021') {
            Item i = this.frame.pipesPanel.leftWChomp.item.copy();
            i.redPiranha = this.getRedPiranha(fc);
            return i;
        }
        if (c == '\u2663') {
            return this.frame.pipesPanel.rightWOChomp.item.copy();
        }
        if (c == '\u00ee') {
            Item i = this.frame.pipesPanel.rightWChomp.item.copy();
            i.redPiranha = this.getRedPiranha(fc);
            return i;
        }
        if (c == '@') {
            return this.frame.pipesPanel.topSection.item.copy();
        }
        if (c == '#') {
            return this.frame.pipesPanel.leftConnector.item.copy();
        }
        if (c == 'S') {
            return this.frame.pipesPanel.rightConnector.item.copy();
        }
        if (c == 'T') {
            return this.frame.pipesPanel.doubleConnector.item.copy();
        }
        if (c == 'U') {
            return this.frame.pipesPanel.topConnector.item.copy();
        }
        if (c == '\u010e') {
            return this.frame.pipesPanel.bottomConnector.item.copy();
        }
        if (c == '\u0108') {
            Item i = this.frame.pipesPanel.warpZonePipe.item.copy();
            if (fc == 'x') {
                fc = (char)48;
            }
            i.warpPipeColor = Integer.valueOf(String.valueOf(fc));
            return i;
        }
        if (c == '$') {
            Item i = this.frame.enemiesPanel.lightGoomba.item.copy();
            i.flip = this.getFlip(fc);
            return i;
        }
        if (c == '%') {
            Item i = this.frame.enemiesPanel.darkGoomba.item.copy();
            i.flip = this.getFlip(fc);
            return i;
        }
        if (c == '\u02e6') {
            Item i = this.frame.enemiesPanel.grayGoomba.item.copy();
            i.flip = this.getFlip(fc);
            return i;
        }
        if (c == '^') {
            Item i = this.frame.enemiesPanel.lightKoopaNormal.item.copy();
            i.flip = this.getFlip(fc);
            return i;
        }
        if (c == '&') {
            Item i = this.frame.enemiesPanel.lightKoopaBouncing.item.copy();
            i.flip = this.getFlip(fc);
            return i;
        }
        if (c == '*') {
            Item i = this.frame.enemiesPanel.lightKoopaFlyingV.item.copy();
            i.oscOffset = this.getOscOffset(fc);
            return i;
        }
        if (c == '\u00ac') {
            Item i = this.frame.enemiesPanel.lightKoopaFlyingH.item.copy();
            i.oscOffset = this.getOscOffset(fc);
            return i;
        }
        if (c == '(') {
            Item i = this.frame.enemiesPanel.darkKoopaNormal.item.copy();
            i.flip = this.getFlip(fc);
            return i;
        }
        if (c == ')') {
            Item i = this.frame.enemiesPanel.darkKoopaBouncing.item.copy();
            i.flip = this.getFlip(fc);
            return i;
        }
        if (c == '-') {
            Item i = this.frame.enemiesPanel.darkKoopaFlyingV.item.copy();
            i.oscOffset = this.getOscOffset(fc);
            return i;
        }
        if (c == '\u00b1') {
            Item i = this.frame.enemiesPanel.darkKoopaFlyingH.item.copy();
            i.oscOffset = this.getOscOffset(fc);
            return i;
        }
        if (c == '_') {
            Item i = this.frame.enemiesPanel.redKoopaNormal.item.copy();
            i.flip = this.getFlip(fc);
            return i;
        }
        if (c == '=') {
            Item i = this.frame.enemiesPanel.redKoopaBouncing.item.copy();
            i.flip = this.getFlip(fc);
            return i;
        }
        if (c == '+') {
            Item i = this.frame.enemiesPanel.redKoopaFlyingV.item.copy();
            i.oscOffset = this.getOscOffset(fc);
            return i;
        }
        if (c == '\u00ae') {
            Item i = this.frame.enemiesPanel.redKoopaFlyingH.item.copy();
            i.oscOffset = this.getOscOffset(fc);
            return i;
        }
        if (c == '[') {
            return this.frame.enemiesPanel.squid.item.copy();
        }
        if (c == '{') {
            Item i = this.frame.enemiesPanel.redFish.item.copy();
            i.flip = this.getFlip(fc);
            return i;
        }
        if (c == ']') {
            Item i = this.frame.enemiesPanel.grayFishStraight.item.copy();
            i.flip = this.getFlip(fc);
            return i;
        }
        if (c == '|') {
            Item i = this.frame.enemiesPanel.grayFishZigZag.item.copy();
            i.flip = this.getFlip(fc);
            return i;
        }
        if (c == '}') {
            return this.frame.enemiesPanel.lightHammerBro.item.copy();
        }
        if (c == '\u00f6') {
            return this.frame.enemiesPanel.darkHammerBro.item.copy();
        }
        if (c == '\\') {
            Item i = this.frame.enemiesPanel.spiny.item.copy();
            i.flip = this.getFlip(fc);
            return i;
        }
        if (c == ':') {
            Item i = this.frame.enemiesPanel.lightBeetle.item.copy();
            i.flip = this.getFlip(fc);
            return i;
        }
        if (c == '\u00f4') {
            Item i = this.frame.enemiesPanel.darkBeetle.item.copy();
            i.flip = this.getFlip(fc);
            return i;
        }
        if (c == '\u02e7') {
            Item i = this.frame.enemiesPanel.grayBeetle.item.copy();
            i.flip = this.getFlip(fc);
            return i;
        }
        if (c == '\'') {
            return this.frame.enemiesPanel.tallCannon.item.copy();
        }
        if (c == '\u260e') {
            return this.frame.enemiesPanel.cannonBase.item.copy();
        }
        if (c == '\"') {
            return this.frame.enemiesPanel.shortCannon.item.copy();
        }
        if (c == ',') {
            Item i = this.frame.enemiesPanel.firebarShort.item.copy();
            i.flip = this.getFirebarFlip(fc);
            i.speedBoost = this.getFirebarFast(fc);
            return i;
        }
        if (c == '<') {
            Item i = this.frame.enemiesPanel.firebarLong.item.copy();
            i.flip = this.getFirebarFlip(fc);
            i.speedBoost = this.getFirebarFast(fc);
            return i;
        }
        if (c == '.') {
            Item i = this.frame.enemiesPanel.lavaBall.item.copy();
            if (fc == 'x') {
                i.fireballColor = 0;
                return i;
            }
            int fcInt = Integer.valueOf(String.valueOf(fc));
            if (fcInt == 0) {
                i.fireballColor = 0;
            } else if (fcInt == 1) {
                i.fireballColor = 1;
            } else if (fcInt == 2) {
                i.fireballColor = 2;
            }
            return i;
        }
        if (c == '>') {
            Item i = this.frame.platformsPanel.longRepUp.item.copy();
            i.singlePlatform = this.getRepPlatformSingle(fc);
            return i;
        }
        if (c == '/') {
            Item i = this.frame.platformsPanel.longRepDown.item.copy();
            i.singlePlatform = this.getRepPlatformSingle(fc);
            return i;
        }
        if (c == '?') {
            Item i = this.frame.platformsPanel.longOscV.item.copy();
            i.oscOffset = this.getOscOffset(fc);
            return i;
        }
        if (c == '\u263a') {
            Item i = this.frame.platformsPanel.longOscH.item.copy();
            i.oscOffset = this.getOscOffset(fc);
            return i;
        }
        if (c == '\u25bc') {
            return this.frame.platformsPanel.longFalling.item.copy();
        }
        if (c == '\u2194') {
            Item i = this.frame.platformsPanel.shortRepUp.item.copy();
            i.singlePlatform = this.getRepPlatformSingle(fc);
            return i;
        }
        if (c == '\u2191') {
            Item i = this.frame.platformsPanel.shortRepDown.item.copy();
            i.singlePlatform = this.getRepPlatformSingle(fc);
            return i;
        }
        if (c == '\u266a') {
            Item i = this.frame.platformsPanel.shortOscV.item.copy();
            i.oscOffset = this.getOscOffset(fc);
            return i;
        }
        if (c == '\u2195') {
            Item i = this.frame.platformsPanel.shortOscH.item.copy();
            i.oscOffset = this.getOscOffset(fc);
            return i;
        }
        if (c == '\u203c') {
            return this.frame.platformsPanel.shortFalling.item.copy();
        }
        if (c == '\u00b6') {
            Item i = this.frame.platformsPanel.extraShortRepUp.item.copy();
            i.singlePlatform = this.getRepPlatformSingle(fc);
            return i;
        }
        if (c == 'V') {
            Item i = this.frame.platformsPanel.extraShortRepDown.item.copy();
            i.singlePlatform = this.getRepPlatformSingle(fc);
            return i;
        }
        if (c == '\u25ac') {
            return this.frame.platformsPanel.longPulley.item.copy();
        }
        if (c == '\u0398') {
            return this.frame.platformsPanel.shortPulley.item.copy();
        }
        if (c == '\u263b') {
            return this.frame.platformsPanel.carrierLong.item.copy();
        }
        if (c == '\u00e7') {
            return this.frame.platformsPanel.carrierShort.item.copy();
        }
        if (c == '\u2665') {
            this.levelEndType = 1;
            this.setNextLevelNumber(levelChars, xTile);
            return null;
        }
        if (c == '\u21a8') {
            this.levelEndType = 2;
            this.setNextLevelNumber(levelChars, xTile);
            return null;
        }
        if (c == '\u2666') {
            this.levelEndType = 3;
            this.setNextLevelNumber(levelChars, xTile);
            return null;
        }
        if (c == '\u00bc') {
            this.levelEndType = 4;
            this.setNextLevelNumber(levelChars, xTile);
            return null;
        }
        if (c == '\u00d7') {
            this.levelEndType = 5;
            this.setNextLevelNumber(levelChars, xTile);
            return null;
        }
        if (c == '\u00d8') {
            this.levelEndType = 6;
            this.setNextLevelNumber(levelChars, xTile);
            return null;
        }
        if (c == '\u00de') {
            this.levelEndType = 7;
            this.setNextLevelNumber(levelChars, xTile);
            return null;
        }
        if (c == '\u00df') {
            this.levelEndType = 8;
            this.setNextLevelNumber(levelChars, xTile);
            return null;
        }
        if (c == '\u00f0') {
            this.levelEndType = 9;
            this.setNextLevelNumber(levelChars, xTile);
            return null;
        }
        if (c == '\u00ff') {
            this.levelEndType = 10;
            this.setNextLevelNumber(levelChars, xTile);
            return null;
        }
        if (this.frame.game.textures.customTextChars.containsKey(Character.valueOf(c))) {
            return this.frame.pipesPanel.customTextItems.get(Character.valueOf(c)).copy();
        }
        throw new RuntimeException("Unknown item character when loading a level: " + c);
    }

    private void setNextLevelNumber(char[][] chars, int x) {
        char[] destLevelChars = new char[]{chars[1][x + 1], chars[1][x + 2], chars[1][x + 3]};
        this.nextLevelNumber = Integer.valueOf(String.valueOf(destLevelChars));
    }

    private boolean getFlip(char c) {
        return c != '0';
    }

    private boolean getPoison(char c) {
        return c == '0';
    }

    private boolean getSuperSpring(char c) {
        return c == '0';
    }

    private boolean getRedPiranha(char c) {
        return c == '0';
    }

    private int getCheckpointType(char fc) {
        if (fc == '0' || fc == 'x') {
            return 0;
        }
        return 1;
    }

    private boolean getShift(char c) {
        return c == '0';
    }

    private boolean getRepPlatformSingle(char c) {
        return c == '0';
    }

    private int getOscOffset(char c) {
        if (c == 'x' || c == '0') {
            return 0;
        }
        if (c == '1') {
            return 1;
        }
        if (c == '2') {
            return 2;
        }
        if (c == '3') {
            return 3;
        }
        return 0;
    }

    private boolean getFirebarFlip(char c) {
        return c == '0' || c == '1';
    }

    private boolean getFirebarFast(char c) {
        return c == '1' || c == '3';
    }

    private void setLevelType(char[] levelChars, int lineLength) throws Exception {
        char levelTypeChar = levelChars[(lineLength + 2) * Game.yTiles];
        if (levelTypeChar == '0') {
            this.levelType = 0;
        } else if (levelTypeChar == '1') {
            this.levelType = 1;
        } else if (levelTypeChar == '2') {
            this.levelType = 2;
        } else if (levelTypeChar == '3') {
            this.levelType = 3;
        } else if (levelTypeChar == '4') {
            this.levelType = 4;
        } else if (levelTypeChar == '5') {
            this.levelType = 5;
        } else if (levelTypeChar == '6') {
            this.levelType = 6;
        } else {
            throw new RuntimeException("Level type character is invalid in file");
        }
    }

    private void setLevelNames(char[] chars, int lineLength) throws Exception {
        int nameIndex;
        char[] levelName1Chars = new char[8];
        char[] levelName2Chars = new char[8];
        int x = 0;
        for (int i = nameIndex = (lineLength + 2) * Game.yTiles + 2 + 5 + 8; i < nameIndex + 8; ++i) {
            levelName1Chars[x] = chars[i];
            levelName2Chars[x++] = chars[i + 8 + 2];
        }
        this.name1 = String.valueOf(levelName1Chars).trim();
        this.name2 = String.valueOf(levelName2Chars).trim();
    }

    private boolean hasBulletThrower(char[] chars, int lineLength) throws Exception {
        char hasBulletChar = chars[(lineLength + 2) * Game.yTiles + 3];
        return hasBulletChar == '1';
    }

    private boolean hasFlyingFish(char[] chars, int lineLength) throws Exception {
        char hasFishChar = chars[(lineLength + 2) * Game.yTiles + 2];
        return hasFishChar == '1';
    }

    private boolean hasSpinyThrower(char[] chars, int lineLength) throws Exception {
        char hasThrowerChar = chars[(lineLength + 2) * Game.yTiles + 1];
        return hasThrowerChar == '1';
    }

    private boolean isBlackAndWhite(char[] chars, int lineLength) throws Exception {
        char blackAndWhiteChar = chars[(lineLength + 2) * Game.yTiles + 4];
        return blackAndWhiteChar == '1';
    }

    private boolean isTimedLevel(char[] chars, int lineLength) throws Exception {
        char isTimedChar = chars[(lineLength + 2) * Game.yTiles + 7 + 8 + 10 + 10];
        return isTimedChar == '1';
    }

    private int getLevelTimeLimit(char[] chars, int lineLength) throws Exception {
        char[] timeChars = new char[4];
        for (int i = 0; i < timeChars.length; ++i) {
            timeChars[i] = chars[(lineLength + 2) * Game.yTiles + 7 + 8 + 10 + 10 + 3 + i];
        }
        return Integer.valueOf(String.valueOf(timeChars));
    }

    private int getPipeColor(char[] chars, int lineLength) throws Exception {
        int pipeColorChar = 48;
        try {
            pipeColorChar = chars[(lineLength + 2) * Game.yTiles + 7 + 8 + 10 + 10 + 3 + 6];
        }
        catch (Exception e) {
            // empty catch block
        }
        if (pipeColorChar == 49) {
            return 1;
        }
        if (pipeColorChar == 50) {
            return 2;
        }
        if (pipeColorChar == 51) {
            return 3;
        }
        if (pipeColorChar == 52) {
            return 4;
        }
        return 0;
    }

    private boolean hasAutoScrolling(char[] chars, int lineLength) {
        try {
            char as = chars[(lineLength + 2) * Game.yTiles + 7 + 8 + 10 + 10 + 3 + 6 + 1];
            return as == '1';
        }
        catch (Exception e) {
            return false;
        }
    }

    private int getTexturePack(char[] chars, int lineLength) {
        int texturePackChar = 48;
        try {
            texturePackChar = chars[(lineLength + 2) * Game.yTiles + 7 + 8 + 10 + 10 + 3 + 6 + 2];
        }
        catch (Exception e) {
            // empty catch block
        }
        if (texturePackChar == 48) {
            return 0;
        }
        if (texturePackChar == 49) {
            return 1;
        }
        return 0;
    }

    private int getCliffDestLevel(char[] chars, int lineLength) throws Exception {
        char[] destLevelChars = new char[3];
        int startingPoint = (lineLength + 2) * Game.yTiles + 5 + 2;
        destLevelChars[0] = chars[startingPoint];
        destLevelChars[1] = chars[startingPoint + 1];
        destLevelChars[2] = chars[startingPoint + 2];
        if (destLevelChars[0] == 'x') {
            return -1;
        }
        return Integer.valueOf(String.valueOf(destLevelChars));
    }

    private int getCliffDestID(char[] chars, int lineLength) throws Exception {
        char[] destIDChars = new char[3];
        int startingPoint = (lineLength + 2) * Game.yTiles + 5 + 2 + 3;
        destIDChars[0] = chars[startingPoint];
        destIDChars[1] = chars[startingPoint + 1];
        destIDChars[2] = chars[startingPoint + 2];
        return Integer.valueOf(String.valueOf(destIDChars));
    }
}

