/*
 * Decompiled with CFR 0.152.
 */
package supermario.builder;

import java.awt.Font;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;

public class TextBox
extends JTextField {
    private static Font textFont = new Font("Monospaced", 0, 12);

    public TextBox(int charLimit, boolean numbersOnly, boolean upperCaseRequired, boolean customTextField) {
        this.setHorizontalAlignment(0);
        this.setFont(textFont);
        this.setColumns(charLimit + 1);
        PlainDocument document = new PlainDocument();
        NESTextDocumentFilter filter = new NESTextDocumentFilter(this, charLimit, numbersOnly, upperCaseRequired, customTextField, true);
        PlainDocument absDoc = document;
        absDoc.setDocumentFilter(filter);
        this.setDocument(document);
    }

    public static JPasswordField getPasswordTextBox(int charLimit, boolean numbersOnly, boolean upperCaseRequired) {
        JPasswordField passwordField = new JPasswordField();
        passwordField.setEchoChar('*');
        passwordField.setHorizontalAlignment(0);
        passwordField.setFont(textFont);
        passwordField.setColumns(charLimit + 1);
        PlainDocument document = new PlainDocument();
        NESTextDocumentFilter filter = new NESTextDocumentFilter(passwordField, charLimit, numbersOnly, upperCaseRequired, false, false);
        PlainDocument absDoc = document;
        absDoc.setDocumentFilter(filter);
        passwordField.setDocument(document);
        return passwordField;
    }

    private static class NESTextDocumentFilter
    extends DocumentFilter {
        private JTextField textField;
        private int charLimit;
        private boolean numbersOnly;
        private boolean upperCaseRequired;
        private boolean spaceAllowed;
        private boolean customTextField;
        private static final char[] limitedChars = new char[]{'!', '@', '#', '$', '%', '&', '*', '(', ')', '-', '+', '=', '\"', ',', '.', '\'', '~', ';', ':', '\\', '/', '^', '?', '<', '>', '|', '[', ']', '{', '}', '_'};

        public NESTextDocumentFilter(JTextField textField, int charLimit, boolean numbersOnly, boolean upperCaseRequired, boolean customTextField, boolean spaceAllowed) {
            this.textField = textField;
            this.charLimit = charLimit;
            this.numbersOnly = numbersOnly;
            this.upperCaseRequired = upperCaseRequired;
            this.customTextField = customTextField;
            this.spaceAllowed = spaceAllowed;
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            fb.insertString(offset, string, attr);
        }

        private boolean isSpecialCharacter(char ch) {
            if (ch == '~' || ch == '`' || ch == '!' || ch == '@' || ch == '#' || ch == '$' || ch == '%' || ch == '^' || ch == '&' || ch == '*' || ch == '(' || ch == ')') {
                return true;
            }
            if (ch == '_' || ch == '-' || ch == '+' || ch == '=' || ch == '{' || ch == '[' || ch == '}' || ch == ']' || ch == '|' || ch == '\\') {
                return true;
            }
            return ch == ':' || ch == ';' || ch == '\"' || ch == '\'' || ch == '<' || ch == ',' || ch == '>' || ch == '.' || ch == '?' || ch == '/';
        }

        private boolean isLimitedSpecialCharacter(char ch) {
            for (int i = 0; i < limitedChars.length; ++i) {
                if (limitedChars[i] != ch) continue;
                return true;
            }
            return false;
        }

        private boolean isLetter(char ch) {
            return String.valueOf(ch).matches("[a-zA-z]{1}");
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String string, AttributeSet attr) throws BadLocationException {
            String oldText = this.textField.getText();
            if (this.upperCaseRequired) {
                string = string.toUpperCase();
            }
            if (this.customTextField) {
                char c;
                if (string != null && string.length() == 1 && (Character.isDigit(c = string.charAt(0)) || this.isLetter(c) || this.isLimitedSpecialCharacter(c))) {
                    fb.replace(0, oldText.length(), string, attr);
                }
                if (this.customTextField) {
                    this.textField.getCaret().setVisible(false);
                }
            } else {
                StringBuilder sbNew = new StringBuilder(string);
                int removed = 0;
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (!(this.numbersOnly && !Character.isDigit(c) || !this.spaceAllowed && c == ' ') && (this.isLetter(c) || this.isSpecialCharacter(c) || Character.isDigit(c) || c == ' ')) continue;
                    sbNew.deleteCharAt(i - removed);
                    ++removed;
                }
                if (oldText.length() + sbNew.length() - length > this.charLimit) {
                    int overage = oldText.length() + sbNew.length() - length - this.charLimit;
                    sbNew.delete(sbNew.length() - overage, sbNew.length());
                }
                StringBuilder sbFinal = new StringBuilder(oldText);
                sbFinal.replace(offset, offset + length, sbNew.toString());
                fb.replace(0, oldText.length(), sbFinal.toString(), attr);
                this.textField.getCaret().setDot(offset + sbNew.length());
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            if (!this.customTextField) {
                super.remove(fb, offset, length);
            }
        }
    }
}

