/*
 * Decompiled with CFR 0.152.
 */
package supermario.debug;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyListener;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import supermario.Utilities;
import supermario.builder.BuilderFrame;
import supermario.game.Game;

public abstract class DebugTool
extends JPanel
implements WindowListener,
KeyListener {
    final int LEFT = 17;
    final int CENTER = 10;
    final int RIGHT = 13;
    final Color backgroundColor = Color.WHITE;
    protected Game game;
    protected JFrame frame;

    public DebugTool(Game game, String title) {
        this.game = game;
        this.frame = new JFrame(title);
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(this);
        this.frame.setResizable(false);
        Utilities.setIcon(this.frame);
        this.frame.addKeyListener(this);
        this.frame.setFocusable(true);
        this.addKeyListener(this);
        this.setFocusable(true);
        this.setLayout(new GridBagLayout());
        this.initComponents();
        this.frame.getContentPane().add(this);
    }

    public void packFrame() {
        this.frame.pack();
    }

    protected GridBagConstraints constraints(int x, int y, int width, int height, int pos) {
        Insets insets = new Insets(1, 5, 1, 5);
        return new GridBagConstraints(x, y, width, height, 1.0, 1.0, pos, 0, insets, 0, 0);
    }

    protected GridBagConstraints constraintsWithInsets(int x, int y, int width, int height, int pos, int left, int right, int top, int bottom) {
        Insets insets = new Insets(top, left, bottom, right);
        return new GridBagConstraints(x, y, width, height, 1.0, 1.0, pos, 0, insets, 0, 0);
    }

    public abstract void initComponents();

    public void showConsole(BuilderFrame bFrame, Component focusPoint) {
        if (!this.isShowing()) {
            this.frame.pack();
            this.frame.setLocationRelativeTo(bFrame);
            this.frame.setVisible(true);
            this.frame.setLocationRelativeTo(focusPoint);
        } else {
            this.requestFocus();
        }
    }

    public abstract void hideConsole();
}

