/*
 * Decompiled with CFR 0.152.
 */
package supermario.debug;

import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;

public class TextBox
extends JTextField
implements DocumentListener {
    private int type;
    private double[] stored;
    private int textColumns;

    public TextBox(int charLimit, boolean allowsPeriod, int type, double[] stored) {
        this.type = type;
        this.stored = stored;
        this.textColumns = charLimit + 1;
        this.setHorizontalAlignment(0);
        this.setColumns(this.textColumns);
        PlainDocument document = new PlainDocument();
        NESTextDocumentFilter filter = new NESTextDocumentFilter(charLimit, allowsPeriod);
        PlainDocument absDoc = document;
        absDoc.setDocumentFilter(filter);
        this.setDocument(document);
    }

    public double getDouble() {
        String value = this.getText();
        if (value.isEmpty() || value.equals(".")) {
            return 0.0;
        }
        return Double.parseDouble(value);
    }

    public int getInt() {
        String value = this.getText();
        if (value.isEmpty()) {
            return 0;
        }
        return Integer.valueOf(value);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (this.stored[this.type] != this.getDouble()) {
            this.setFont(this.getFont().deriveFont(1));
        } else {
            this.setFont(this.getFont().deriveFont(0));
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.getText().isEmpty() && this.stored[this.type] != this.getDouble()) {
            this.setFont(this.getFont().deriveFont(1));
        } else {
            this.setFont(this.getFont().deriveFont(0));
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private class NESTextDocumentFilter
    extends DocumentFilter {
        private int charLimit;
        private boolean allowsPeriod;

        public NESTextDocumentFilter(int charLimit, boolean allowPeriod) {
            this.charLimit = charLimit;
            this.allowsPeriod = allowPeriod;
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            fb.insertString(offset, string, attr);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String string, AttributeSet attr) throws BadLocationException {
            String oldText = TextBox.this.getText();
            boolean hasPeriod = oldText.contains(".");
            String replaced = oldText.substring(offset, offset + length);
            if (string.equals(".") && oldText.contains(".") && !replaced.contains(".")) {
                return;
            }
            StringBuilder sbNew = new StringBuilder(string);
            int removed = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if ((c != '.' || !this.allowsPeriod || hasPeriod && !replaced.contains(".")) && !Character.isDigit(c)) {
                    sbNew.deleteCharAt(i - removed);
                    ++removed;
                    continue;
                }
                if (c != '.') continue;
                hasPeriod = true;
            }
            if (oldText.length() + sbNew.length() - length > this.charLimit) {
                int overage = oldText.length() + sbNew.length() - length - this.charLimit;
                sbNew.delete(sbNew.length() - overage, sbNew.length());
            }
            StringBuilder sbFinal = new StringBuilder(oldText);
            sbFinal.replace(offset, offset + length, sbNew.toString());
            fb.replace(0, oldText.length(), sbFinal.toString(), attr);
            TextBox.this.getCaret().setDot(offset + sbNew.length());
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            super.remove(fb, offset, length);
        }
    }
}

