/*
 * Decompiled with CFR 0.152.
 */
package supermario.game;

import java.awt.Color;
import java.awt.Graphics2D;
import supermario.game.Game;
import supermario.game.Textures;
import supermario.game.sprites.Mario;

public class Animation {
    private Game game;
    private Textures t;
    private boolean finished;
    private boolean preBlanking;
    private boolean blanking;
    private boolean bigCastle;
    private boolean blueSky;
    private boolean playedWarpSound;
    private int marioIndex;
    private double lastImageChangeDelay;
    private double marioX;
    private double preBlankDelayTime;
    private double blankDelayTime;
    private final long PRE_BLANK_DELAY = 1500L;
    private final long BLANK_DELAY = 400L;
    private final int MARIO_MAX_X = 160;
    private final double MARIO_X_SPEED = Mario.MAX_WALKING_SPEED / 2.0;

    public Animation(Game game) {
        this.game = game;
        this.t = game.textures;
        this.finished = true;
    }

    public void prepare(boolean bigCastle, boolean blueSky, int texturePack) {
        this.bigCastle = bigCastle;
        this.blueSky = blueSky;
        this.game.texturePacks.setTexturePack(texturePack);
        this.lastImageChangeDelay = 0.0;
        this.finished = false;
        this.preBlanking = false;
        this.blanking = false;
        this.playedWarpSound = false;
        this.marioX = 40.0;
        this.game.audio.playMusic(6);
        this.setNextMarioIndex();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void update(double delta) {
        int roundedMarioX;
        if (this.preBlanking) {
            this.preBlankDelayTime += delta;
        }
        if (this.blanking) {
            this.blankDelayTime += delta;
            if (this.blankDelayTime > 400.0) {
                this.finished = true;
                return;
            }
        }
        this.lastImageChangeDelay += delta;
        if (this.lastImageChangeDelay > 125.0) {
            this.lastImageChangeDelay %= 125.0;
            this.setNextMarioIndex();
        }
        if ((roundedMarioX = (int)Math.round(this.marioX)) > 160 - this.game.mario.width && !this.playedWarpSound) {
            this.game.audio.play(5);
            this.playedWarpSound = true;
        }
        if (roundedMarioX > 160) {
            if (!this.preBlanking && !this.blanking) {
                this.game.audio.stopMusic(false);
                this.preBlanking = true;
                this.preBlankDelayTime = 0.0;
            } else if (this.preBlanking && this.preBlankDelayTime > 1500.0) {
                this.preBlanking = false;
                this.blanking = true;
                this.blankDelayTime = 0.0;
            }
        }
        this.marioX += this.MARIO_X_SPEED / 1000.0 * delta * (this.playedWarpSound ? 0.7 : 1.0);
    }

    private void setNextMarioIndex() {
        this.marioIndex = this.game.mario.isLarge() ? (this.game.mario.hasFlower() ? (this.marioIndex == 33 ? 34 : (this.marioIndex == 34 ? 35 : 33)) : (this.marioIndex == 2 ? 3 : (this.marioIndex == 3 ? 4 : 2))) : (this.marioIndex == 17 ? 18 : (this.marioIndex == 18 ? 19 : 17));
    }

    public void draw(Graphics2D g2D) {
        if (this.blanking) {
            g2D.setColor(Color.BLACK);
            g2D.fillRect(0, 0, Game.renderWidth, Game.renderHeight);
            return;
        }
        if (this.blueSky) {
            g2D.setColor(this.t.skyBlue);
        } else {
            g2D.setColor(Color.BLACK);
        }
        g2D.fillRect(0, 0, Game.renderWidth, Game.renderHeight);
        for (int i = 0; i < Game.xTiles; i += 2) {
            g2D.drawImage(this.t.lightGround.getImage(), i * 8, Game.yTiles * 8 - 24, null);
            g2D.drawImage(this.t.lightGround.getImage(), i * 8, Game.yTiles * 8 - 8, null);
        }
        if (this.bigCastle) {
            g2D.drawImage(this.t.largeCastle.getImage(), 0, Game.renderHeight - 24 - this.t.largeCastle.getIconHeight(), null);
        } else {
            g2D.drawImage(this.t.smallCastle.getImage(), 0, Game.renderHeight - 24 - this.t.smallCastle.getIconHeight(), null);
            g2D.drawImage(this.t.doubleCloud.getImage(), 56, 40, null);
        }
        g2D.drawImage(this.t.singleCloud.getImage(), 152, 104, null);
        int roundedMarioX = (int)Math.round(this.marioX);
        if (roundedMarioX < 160) {
            this.drawMario(g2D, roundedMarioX);
        }
        if (this.blueSky) {
            g2D.drawImage(this.t.greenPipes[0].getImage(), 160, 168, null);
            g2D.drawImage(this.t.greenPipes[5].getImage(), 184, 168, null);
            g2D.drawImage(this.t.greenPipes[6].getImage(), 192, 168, null);
            g2D.drawImage(this.t.greenPipes[2].getImage(), 192, 136, null);
        } else {
            g2D.drawImage(this.t.whitePipes[0].getImage(), 160, 168, null);
            g2D.drawImage(this.t.whitePipes[5].getImage(), 184, 168, null);
            g2D.drawImage(this.t.whitePipes[6].getImage(), 192, 168, null);
            g2D.drawImage(this.t.whitePipes[2].getImage(), 192, 136, null);
        }
    }

    private void drawMario(Graphics2D g2D, int xPos) {
        if (this.game.mario.asLuigi && this.marioIndex < this.game.mario.luigiImages.length) {
            this.game.mario.images = this.game.mario.luigiImages;
        }
        g2D.drawImage(this.game.mario.images[this.marioIndex].getImage(), xPos, Game.renderHeight - 24 - this.game.mario.height, null);
        this.game.mario.images = this.game.mario.marioImages;
    }
}

