/*
 * Decompiled with CFR 0.152.
 */
package supermario.game;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import supermario.builder.IO;
import supermario.game.Game;
import supermario.game.LevelLoader;
import supermario.game.Warp;

public final class GameLoader {
    public static final String metaDataFileName = "metaData";
    private LevelData[] levelDataArray;
    private int levelsCount;
    private boolean validGame;
    private String gameAuthor;
    public static final int AUTHOR_MAX_CHARS = 20;

    public GameLoader(String filename) {
        this.validGame = true;
        this.gameAuthor = "ANONYMOUS";
        this.loadGame(filename);
    }

    public GameLoader(IO.GameData gameData) throws Exception {
        this.gameAuthor = gameData.author;
        this.levelsCount = gameData.levels.length;
        this.levelDataArray = new LevelData[gameData.levels.length];
        for (int i = 0; i < gameData.levels.length; ++i) {
            this.levelDataArray[i] = new LevelData(i, gameData.levels[i]);
        }
    }

    public int levelCount() {
        return this.levelsCount;
    }

    public boolean validGame() {
        return this.validGame;
    }

    public String getGameAuthor() {
        return this.gameAuthor;
    }

    public void loadGame(String filename) {
        try {
            ZipFile zipFile = new ZipFile(filename);
            this.loadMetaData(zipFile);
            if (!this.validGame) {
                return;
            }
            this.levelDataArray = new LevelData[this.levelsCount];
            for (int i = 0; i < this.levelDataArray.length; ++i) {
                this.levelDataArray[i] = this.getLevelData(zipFile, i);
            }
            zipFile.close();
        }
        catch (Exception e) {
            this.validGame = false;
            e.printStackTrace();
        }
    }

    public LevelLoader loadLevel(Game game, int levelNumber) {
        if (levelNumber < 0 || levelNumber >= this.levelDataArray.length) {
            throw new RuntimeException("Level request outside bounds of game: " + levelNumber);
        }
        return new LevelLoader(game, this.levelDataArray[levelNumber].levelChars, levelNumber);
    }

    public LinkedList<Warp> getLevelWarps(int levelNumber) {
        return this.levelDataArray[levelNumber].warps;
    }

    private void loadMetaData(ZipFile zipFile) {
        try {
            ZipEntry zipEntry = zipFile.getEntry(metaDataFileName);
            InputStream iStream = zipFile.getInputStream(zipEntry);
            InputStreamReader inputStreamReader = new InputStreamReader(iStream, Game.ENCODING);
            BufferedReader bReader = new BufferedReader(inputStreamReader);
            String levelCount = bReader.readLine();
            this.levelsCount = Integer.valueOf(levelCount);
            String author = bReader.readLine().trim();
            if (author.length() > 0) {
                this.gameAuthor = author;
            } else if (author.length() > 20) {
                this.gameAuthor = author.substring(0, 20);
            }
            bReader.close();
            inputStreamReader.close();
        }
        catch (Exception e) {
            this.validGame = false;
            e.printStackTrace();
        }
    }

    private LevelData getLevelData(ZipFile zipFile, int levelNumber) {
        if (levelNumber < 0 || levelNumber >= this.levelDataArray.length) {
            this.validGame = false;
            throw new RuntimeException("Level request outside bounds of game: " + levelNumber);
        }
        LevelData levelData = null;
        try {
            String levelName = this.getLevelName(levelNumber);
            ZipEntry zipEntry = zipFile.getEntry(levelName);
            char[] levelChars = new char[(int)zipEntry.getSize()];
            InputStream iStream = zipFile.getInputStream(zipEntry);
            BufferedInputStream bStream = new BufferedInputStream(iStream);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bStream, Game.ENCODING);
            inputStreamReader.read(levelChars);
            inputStreamReader.close();
            bStream.close();
            iStream.close();
            levelData = new LevelData(levelNumber, levelChars);
        }
        catch (Exception e) {
            this.validGame = false;
            e.printStackTrace();
        }
        return levelData;
    }

    private String getLevelName(int levelNum) {
        String levelName = String.valueOf(levelNum);
        while (levelName.length() < 3) {
            levelName = "0" + levelName;
        }
        return levelName;
    }

    private class LevelData {
        public char[] levelChars;
        private LinkedList<Warp> warps;
        private int levelNumber;

        public LevelData(int levelNumber, char[] level) throws Exception {
            this.levelNumber = levelNumber;
            this.levelChars = level;
            this.findWarps();
        }

        private void findWarps() throws Exception {
            this.warps = new LinkedList();
            int lineLength = this.getLineLength();
            for (int i = 0; i < (lineLength + 2) * Game.yTiles; ++i) {
                if (!this.isPossibleWarp(this.levelChars[i])) continue;
                this.handlePossibleWarp(i, lineLength);
            }
        }

        private boolean isPossibleWarp(char c) {
            if (LevelLoader.isBowserEnding(c)) {
                return true;
            }
            if (c == '\u2665' || c == '\u21a8') {
                return true;
            }
            if (c == 'k') {
                return true;
            }
            if (LevelLoader.isSideOpeningPipe(c)) {
                return true;
            }
            if (c == '~' || c == ';' || c == '\u0108') {
                return true;
            }
            if (c == '\u0110' || c == '\u00bf') {
                return true;
            }
            if (LevelLoader.isBeanstalkBlock(c)) {
                return true;
            }
            if (c == '\u03e4') {
                return true;
            }
            return c == '\u00bd';
        }

        private void handlePossibleWarp(int location, int lineLength) throws Exception {
            int offset = 0;
            int nl = lineLength + 2;
            int type = -1;
            if (this.levelChars[location] == '!' || this.levelChars[location] == '\u2021') {
                type = 1;
            } else if (this.levelChars[location] == '\u2663' || this.levelChars[location] == '\u00ee') {
                type = 2;
            } else if (this.levelChars[location] == '~' || this.levelChars[location] == ';') {
                type = 3;
            } else if (this.levelChars[location] == '\u0110' || this.levelChars[location] == '\u00bf') {
                type = 4;
            } else if (this.levelChars[location] == '\u0108') {
                type = 5;
            } else if (LevelLoader.isBowserEnding(this.levelChars[location]) || this.levelChars[location] == '\u21a8' || this.levelChars[location] == '\u2665') {
                type = 6;
            } else if (this.levelChars[location] == 'k') {
                type = 0;
            } else if (LevelLoader.isBeanstalkBlock(this.levelChars[location])) {
                type = 7;
            } else if (this.levelChars[location] == '\u03e4') {
                type = 8;
            } else if (this.levelChars[location] == '\u00bd') {
                type = 9;
            } else {
                throw new RuntimeException("Invalid warp type being handled as warp: " + this.levelChars[location] + " at " + location);
            }
            if (type == 0) {
                this.warps.add(new Warp(false, false, this.levelNumber, 0, -1, -1, this.getXTileFromLocation(location, nl), this.getYTileFromLocation(location, nl), type));
            } else if (type == 7) {
                char[] destLevelChars = new char[]{this.levelChars[location - nl * 3], this.levelChars[location - nl * 2], this.levelChars[location - nl]};
                char[] destIDChars = new char[]{this.levelChars[location - nl * 3 + 1], this.levelChars[location - nl * 2 + 1], this.levelChars[location - nl + 1]};
                int destLevelNum = Integer.valueOf(String.valueOf(destLevelChars));
                int destIDNum = Integer.valueOf(String.valueOf(destIDChars));
                this.warps.add(new Warp(true, false, this.levelNumber, -1, destLevelNum, destIDNum, this.getXTileFromLocation(location, nl), this.getYTileFromLocation(location, nl), type));
            } else if (type == 8) {
                char[] warpIDChars = new char[]{this.levelChars[location + nl * 1], this.levelChars[location + nl * 2], this.levelChars[location + nl * 3]};
                int warpIDNum = Integer.valueOf(String.valueOf(warpIDChars));
                this.warps.add(new Warp(false, true, this.levelNumber, warpIDNum, -1, -1, this.getXTileFromLocation(location, nl), this.getYTileFromLocation(location, nl), type));
            } else if (type == 9) {
                char[] warpIDChars = new char[]{this.levelChars[location + nl * 1], this.levelChars[location + nl * 2], this.levelChars[location + nl * 3]};
                int warpIDNum = Integer.valueOf(String.valueOf(warpIDChars));
                this.warps.add(new Warp(false, true, this.levelNumber, warpIDNum, -1, -1, this.getXTileFromLocation(location, nl), this.getYTileFromLocation(location, nl), type));
            } else {
                int destIDNum;
                int destLevelNum;
                int warpIDNum;
                if (LevelLoader.isSideOpeningPipe(this.levelChars[location])) {
                    offset = nl - 1;
                }
                char[] warpIDChars = new char[]{this.levelChars[offset + location + 1], this.levelChars[offset + location + 2], this.levelChars[offset + location + 3]};
                char[] destLevelChars = new char[]{this.levelChars[offset + location + 1 + nl], this.levelChars[offset + location + 2 + nl], this.levelChars[offset + location + 3 + nl]};
                char[] destIDChars = new char[]{this.levelChars[offset + location + 1 + 2 * nl], this.levelChars[offset + location + 2 + 2 * nl], this.levelChars[offset + location + 3 + 2 * nl]};
                boolean outgoing = false;
                boolean incoming = false;
                if (warpIDChars[0] == 'x') {
                    incoming = false;
                    warpIDNum = -1;
                } else {
                    if (type != 5) {
                        incoming = true;
                    }
                    warpIDNum = Integer.valueOf(String.valueOf(warpIDChars));
                }
                if (destLevelChars[0] == 'x') {
                    outgoing = false;
                    destLevelNum = -1;
                    destIDNum = -1;
                } else {
                    outgoing = true;
                    destLevelNum = Integer.valueOf(String.valueOf(destLevelChars));
                    destIDNum = Integer.valueOf(String.valueOf(destIDChars));
                }
                if (outgoing || incoming) {
                    int xTile = this.getXTileFromLocation(location, nl);
                    int yTile = this.getYTileFromLocation(location, nl);
                    this.warps.add(new Warp(outgoing, incoming, this.levelNumber, warpIDNum, destLevelNum, destIDNum, xTile, yTile, type));
                }
            }
        }

        private int getXTileFromLocation(int location, int nl) {
            return location % nl;
        }

        private int getYTileFromLocation(int location, int nl) {
            return location / nl;
        }

        private int getLineLength() {
            int lineLength = -1;
            for (int i = 0; i < this.levelChars.length; ++i) {
                if (this.levelChars[i] != '\r') continue;
                lineLength = i;
                break;
            }
            if (lineLength == -1) {
                GameLoader.this.validGame = false;
                try {
                    throw new RuntimeException("Line length is invalid. Can't find warps");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return lineLength;
        }
    }
}

