/*
 * Decompiled with CFR 0.152.
 */
package supermario.game;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URLDecoder;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import supermario.game.Controllers;
import supermario.game.Game;

public class Input
implements KeyListener {
    private Game game;
    private final String configFile = "mario.cfg";
    public static final int CANCEL_INPUT_SELECTED = -1;
    public boolean leftDown;
    public boolean rightDown;
    public boolean upDown;
    public boolean downDown;
    public boolean jumpDown;
    public boolean startDown;
    public boolean runDown;
    public boolean defUpDown;
    public boolean defDownDown;
    public boolean defStartDown;
    private boolean escapeReleased = true;
    public final int defaultUp = 38;
    public final int defaultDown = 40;
    public final int defaultLeft = 37;
    public final int defaultRight = 39;
    public final int defaultJump = 88;
    public final int defaultRun = 90;
    public final int defaultStart = 10;
    private int upKey;
    private int downKey;
    private int leftKey;
    private int rightKey;
    private int jumpKey;
    private int runKey;
    private int startKey;
    public boolean showGrid;
    public boolean autoScroll;
    public boolean screenMarker;
    public boolean stretchButtons;
    public boolean godModeTesting;
    public boolean superMarioTesting;
    public boolean extraLivesCheat;
    public boolean fireMarioTesting;
    public boolean unlimitedFireballsTesting;
    public boolean lockDragRow;
    public boolean lockDragColumn;
    private static final int FEATURE_ON = 49;
    private static final int FEATURE_OFF = 48;
    public float loadedVolume;
    public boolean hidePhysicsWarning;
    private int[] newControls;
    public File jarFile;
    public String jarDirectory;
    private String sessionDirectory;
    public Controllers controllers;
    public boolean promptingForController;
    public long lastMouseEvent;
    private long lastCodePress = System.currentTimeMillis();
    public static final int MAX_DELAY_CHEAT_KEY = 333;
    private LinkedList<Integer> cheatCode = new LinkedList();

    public Input(Game game) {
        this.game = game;
        this.loadConfiguration();
        this.controllers = new Controllers(game);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCustomConfig() {
        FileInputStream fStream = null;
        InputStreamReader iStreamReader = null;
        BufferedReader bReader = null;
        try {
            fStream = new FileInputStream(new File("CustomDimensions.txt"));
            iStreamReader = new InputStreamReader((InputStream)fStream, Game.ENCODING);
            bReader = new BufferedReader(iStreamReader);
            String xDim = bReader.readLine();
            String yDim = bReader.readLine();
            Game.xTiles = Integer.parseInt(xDim);
            Game.yTiles = Integer.parseInt(yDim);
            Game.overlayXOffset = (Game.xTiles - 32) / 2;
            Game.overlayYOffset = Game.yTiles - 28;
            Game.renderWidth = Game.xTiles * 8;
            Game.renderHeight = Game.yTiles * 8;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fStream != null) {
                    fStream.close();
                }
                if (iStreamReader != null) {
                    iStreamReader.close();
                }
                if (bReader != null) {
                    bReader.close();
                }
            }
            catch (Exception e2) {}
        }
    }

    private void loadConfiguration() {
        try {
            this.jarFile = new File(URLDecoder.decode(Game.class.getProtectionDomain().getCodeSource().getLocation().getFile(), Game.ENCODING));
            this.jarDirectory = URLDecoder.decode(this.jarFile.getParent(), Game.ENCODING);
            FileInputStream fStream = null;
            try {
                fStream = new FileInputStream(new File("mario.cfg"));
            }
            catch (FileNotFoundException e) {
                this.sessionDirectory = this.jarDirectory;
                this.useDefaultSettings();
                return;
            }
            InputStreamReader iStreamReader = new InputStreamReader((InputStream)fStream, Game.ENCODING);
            BufferedReader bReader = new BufferedReader(iStreamReader);
            try {
                String loadedDirectory;
                this.sessionDirectory = loadedDirectory = bReader.readLine();
                File file = new File(this.sessionDirectory);
                if (!file.exists()) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                this.sessionDirectory = this.jarDirectory;
            }
            this.newControls = new int[7];
            this.newControls[0] = bReader.read();
            this.newControls[1] = bReader.read();
            this.newControls[2] = bReader.read();
            this.newControls[3] = bReader.read();
            this.newControls[4] = bReader.read();
            this.newControls[5] = bReader.read();
            this.newControls[6] = bReader.read();
            char gridChar = (char)bReader.read();
            this.showGrid = gridChar != '0';
            char autoScrollChar = (char)bReader.read();
            this.autoScroll = autoScrollChar != '0';
            char screenMarkerChar = (char)bReader.read();
            this.screenMarker = screenMarkerChar != '0';
            char stretchButtonsChar = (char)bReader.read();
            this.stretchButtons = stretchButtonsChar == '1';
            char godModeTestingChar = (char)bReader.read();
            this.godModeTesting = godModeTestingChar == '1';
            char superMarioTestingChar = (char)bReader.read();
            this.superMarioTesting = superMarioTestingChar == '1';
            char fireMarioTestingChar = (char)bReader.read();
            this.fireMarioTesting = fireMarioTestingChar == '1';
            char unlimitedFireballTestingChar = (char)bReader.read();
            this.unlimitedFireballsTesting = unlimitedFireballTestingChar == '1';
            char lockDragRowChar = (char)bReader.read();
            this.lockDragRow = lockDragRowChar == '1';
            char lockDragColChar = (char)bReader.read();
            this.lockDragColumn = lockDragColChar == '1';
            int volChar = bReader.read();
            this.loadedVolume = volChar == -1 || (char)volChar == 'M' ? 1.0f : (float)Integer.valueOf(String.valueOf((char)volChar)).intValue() / 10.0f;
            char hidePhysicsWarningChar = (char)bReader.read();
            this.hidePhysicsWarning = hidePhysicsWarningChar == '1';
            bReader.close();
            iStreamReader.close();
            fStream.close();
            if (!this.noControlConflicts(this.newControls)) {
                throw new Exception();
            }
            this.setControls(this.newControls);
        }
        catch (Exception e) {
            this.useDefaultSettings();
        }
    }

    private void useDefaultSettings() {
        this.upKey = 38;
        this.downKey = 40;
        this.leftKey = 37;
        this.rightKey = 39;
        this.jumpKey = 88;
        this.runKey = 90;
        this.startKey = 10;
        this.showGrid = false;
        this.autoScroll = true;
        this.screenMarker = false;
        this.stretchButtons = false;
        this.godModeTesting = false;
        this.superMarioTesting = false;
        this.fireMarioTesting = false;
        this.lockDragRow = false;
        this.lockDragColumn = false;
        this.loadedVolume = 1.0f;
        this.hidePhysicsWarning = false;
    }

    public void writeConfiguration() {
        try {
            FileOutputStream fStream = new FileOutputStream("mario.cfg");
            OutputStreamWriter oStreamWriter = new OutputStreamWriter((OutputStream)fStream, Game.ENCODING);
            BufferedWriter bWriter = new BufferedWriter(oStreamWriter);
            bWriter.write(this.sessionDirectory + "\r\n");
            bWriter.write(this.upKey);
            bWriter.write(this.downKey);
            bWriter.write(this.leftKey);
            bWriter.write(this.rightKey);
            bWriter.write(this.runKey);
            bWriter.write(this.jumpKey);
            bWriter.write(this.startKey);
            if (this.showGrid) {
                bWriter.write(49);
            } else {
                bWriter.write(48);
            }
            if (this.autoScroll) {
                bWriter.write(49);
            } else {
                bWriter.write(48);
            }
            if (this.screenMarker) {
                bWriter.write(49);
            } else {
                bWriter.write(48);
            }
            if (this.stretchButtons) {
                bWriter.write(49);
            } else {
                bWriter.write(48);
            }
            if (this.godModeTesting) {
                bWriter.write(49);
            } else {
                bWriter.write(48);
            }
            if (this.superMarioTesting) {
                bWriter.write(49);
            } else {
                bWriter.write(48);
            }
            if (this.fireMarioTesting) {
                bWriter.write(49);
            } else {
                bWriter.write(48);
            }
            if (this.unlimitedFireballsTesting) {
                bWriter.write(49);
            } else {
                bWriter.write(48);
            }
            if (this.lockDragRow) {
                bWriter.write(49);
            } else {
                bWriter.write(48);
            }
            if (this.lockDragColumn) {
                bWriter.write(49);
            } else {
                bWriter.write(48);
            }
            if (this.game.audio.isValid()) {
                int vol = (int)Math.round(this.game.audio.getVolume() * 10.0);
                if (vol == 10) {
                    bWriter.write(77);
                } else {
                    bWriter.write(String.valueOf(vol).charAt(0));
                }
            }
            if (this.hidePhysicsWarning) {
                bWriter.write(49);
            } else {
                bWriter.write(48);
            }
            bWriter.close();
            oStreamWriter.close();
            fStream.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public String getSessionDirectory() {
        return this.sessionDirectory;
    }

    public void setSessionDirectory(String path) {
        this.sessionDirectory = path;
        this.writeConfiguration();
    }

    public void loseAllKeyPresses() {
        this.downDown = false;
        this.runDown = false;
        this.startDown = false;
        this.jumpDown = false;
        this.upDown = false;
        this.rightDown = false;
        this.leftDown = false;
        this.defStartDown = false;
        this.defUpDown = false;
        this.defDownDown = false;
        if (this.controllers != null && this.controllers.valid && this.controllers.inUse) {
            this.controllers.loseAllKeyPresses();
        }
        this.game.enterReleased = true;
        this.escapeReleased = true;
        if (this.game.menu != null) {
            this.game.menu.enterReleased = true;
        }
        this.game.downHold = false;
        this.game.upHold = false;
    }

    public void cancelControlSetting() {
        this.escapeReleased = false;
        this.newControls = null;
        this.game.inputSelection = false;
        if (this.controllers.gettingControls) {
            if (this.controllers.inUse) {
                this.controllers.restoreControls();
                this.controllers.controlsSet = true;
            } else {
                this.controllers.controlsSet = false;
                this.controllers.removeDeviceListener();
            }
            this.controllers.gettingControls = false;
        }
    }

    private boolean reservedKeyboardKey(int key) {
        if (key == 49 || key == 50 || key == 51) {
            return true;
        }
        if (key == 52 || key == 53 || key == 54) {
            return true;
        }
        if (key == 55 || key == 56 || key == 57 || key == 48) {
            return true;
        }
        return key == 112;
    }

    private boolean noControlConflicts(int[] controls) {
        for (int i = 0; i < controls.length; ++i) {
            for (int j = 0; j < controls.length; ++j) {
                if ((controls[i] != controls[j] || i == j) && controls[i] != -1 && !this.reservedKeyboardKey(controls[i])) continue;
                return false;
            }
        }
        if (this.reservedKey(controls[0]) && controls[0] != 38) {
            return false;
        }
        if (this.reservedKey(controls[1]) && controls[1] != 40) {
            return false;
        }
        if (this.reservedKey(controls[2]) && controls[2] != 37) {
            return false;
        }
        if (this.reservedKey(controls[3]) && controls[3] != 39) {
            return false;
        }
        return !this.reservedKey(controls[6]) || controls[6] == 10;
    }

    private void setControls(int[] keys) {
        this.upKey = keys[0];
        this.downKey = keys[1];
        this.leftKey = keys[2];
        this.rightKey = keys[3];
        this.runKey = keys[4];
        this.jumpKey = keys[5];
        this.startKey = keys[6];
        this.writeConfiguration();
    }

    private boolean previouslyEnteredNewControl(int key, int thisIndex) {
        for (int i = 0; i < thisIndex; ++i) {
            if (this.newControls[i] != key) continue;
            return true;
        }
        return false;
    }

    private boolean keyIsUsed(int k) {
        return this.upKey == k || this.downKey == k || this.leftKey == k || this.rightKey == k || this.runKey == k || this.jumpKey == k || this.startKey == k;
    }

    public void addCheatKey(int code) {
        long oldLastCodePress = this.lastCodePress;
        this.lastCodePress = System.currentTimeMillis();
        if (this.lastCodePress - oldLastCodePress > 333L) {
            this.cheatCode.clear();
        }
        if (this.isDirectionalKey(code)) {
            this.cheatCode.add(this.convertCheatCodeToDefault(code));
            this.checkForCheat();
        }
    }

    private int convertCheatCodeToDefault(int code) {
        if (code == this.defaultUp || code == this.upKey) {
            return this.defaultUp;
        }
        if (code == this.defaultDown || code == this.downKey) {
            return this.downKey;
        }
        if (code == this.defaultLeft || code == this.leftKey) {
            return this.leftKey;
        }
        if (code == this.rightKey || code == this.rightKey) {
            return this.rightKey;
        }
        throw new IllegalStateException("Unknown cheat code key entered");
    }

    private boolean isDirectionalKey(int code) {
        if (code == this.defaultUp || code == this.upKey) {
            return true;
        }
        if (code == this.defaultDown || code == this.downKey) {
            return true;
        }
        if (code == this.defaultLeft || code == this.leftKey) {
            return true;
        }
        return code == this.rightKey || code == this.rightKey;
    }

    private void checkForCheat() {
        boolean extraLives;
        int up = this.defaultUp;
        int dn = this.defaultDown;
        int lf = this.defaultLeft;
        int rt = this.defaultRight;
        Integer[] codes = new Integer[this.cheatCode.size()];
        codes = this.cheatCode.toArray(codes);
        if (this.cheatCode.size() == 5) {
            boolean godMode = this.cheatMatch(codes, new int[]{up, dn, lf, rt, lf});
            if (godMode) {
                this.game.mario.godMode = !this.game.mario.godMode;
                this.game.audio.play(this.game.mario.godMode ? 12 : 17);
            }
        } else if (this.cheatCode.size() == 6) {
            boolean fireballs = this.cheatMatch(codes, new int[]{up, dn, up, dn, rt, rt});
            if (fireballs) {
                this.game.mario.unlimitedFireballs = !this.game.mario.unlimitedFireballs;
                this.game.audio.play(this.game.mario.unlimitedFireballs ? 12 : 17);
            }
        } else if (this.cheatCode.size() == 8 && (extraLives = this.cheatMatch(codes, new int[]{up, up, dn, dn, up, up, dn, dn}))) {
            this.extraLivesCheat = !this.extraLivesCheat;
            this.game.audio.play(this.extraLivesCheat ? 12 : 17);
        }
    }

    private boolean cheatMatch(Integer[] codes, int[] keys) {
        if (codes.length != keys.length) {
            return false;
        }
        for (int i = 0; i < codes.length; ++i) {
            if (codes[i] == keys[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        boolean upWasPressed = this.upDown;
        boolean downWasPressed = this.downDown;
        boolean leftWasPressed = this.leftDown;
        boolean rightWasPressed = this.rightDown;
        if (!this.game.inputSelection) {
            if (key == 49) {
                this.game.setFrameSize(1);
            } else if (key == 50) {
                this.game.setFrameSize(2);
            } else if (key == 51) {
                this.game.setFrameSize(3);
            } else if (key == 52) {
                this.game.setFrameSize(4);
            } else if (key == 53) {
                this.game.setFrameSize(5);
            } else if (key == 54) {
                this.game.setFrameSize(6);
            } else if (key == 55) {
                this.game.setFrameSize(7);
            } else if (key == 56) {
                this.game.setFrameSize(8);
            } else if (key == 57) {
                this.game.setFrameSize(9);
            } else if (key == 48) {
                if (this.game.isFullScreen) {
                    this.game.switchToWindowed = true;
                } else {
                    this.game.switchToFullScreen = true;
                }
            } else if (key == 77 && !this.keyIsUsed(key)) {
                if (this.game.audio.isMuted()) {
                    this.game.audio.unmuteAudio();
                } else {
                    this.game.audio.muteAudio();
                }
            }
        }
        if (this.game.inputSelection && !this.controllers.gettingControls && key != 27) {
            if (!(this.game.controllerSelectionIndex != 0 || this.reservedKeyboardKey(key) || this.reservedKey(key) && key != 38)) {
                this.newControls = new int[7];
                this.newControls[0] = key;
                ++this.game.controllerSelectionIndex;
            } else if (!(this.game.controllerSelectionIndex != 1 || this.reservedKeyboardKey(key) || this.previouslyEnteredNewControl(key, 1) || this.reservedKey(key) && key != 40)) {
                this.newControls[1] = key;
                ++this.game.controllerSelectionIndex;
            } else if (!(this.game.controllerSelectionIndex != 2 || this.reservedKeyboardKey(key) || this.previouslyEnteredNewControl(key, 2) || this.reservedKey(key) && key != 37)) {
                this.newControls[2] = key;
                ++this.game.controllerSelectionIndex;
            } else if (!(this.game.controllerSelectionIndex != 3 || this.reservedKeyboardKey(key) || this.previouslyEnteredNewControl(key, 3) || this.reservedKey(key) && key != 39)) {
                this.newControls[3] = key;
                ++this.game.controllerSelectionIndex;
            } else if (!(this.game.controllerSelectionIndex != 4 || this.reservedKeyboardKey(key) || this.previouslyEnteredNewControl(key, 4) || this.reservedKey(key))) {
                this.newControls[4] = key;
                ++this.game.controllerSelectionIndex;
            } else if (!(this.game.controllerSelectionIndex != 5 || this.reservedKeyboardKey(key) || this.previouslyEnteredNewControl(key, 5) || this.reservedKey(key))) {
                this.newControls[5] = key;
                ++this.game.controllerSelectionIndex;
            } else if (!(this.game.controllerSelectionIndex != 6 || this.reservedKeyboardKey(key) || this.previouslyEnteredNewControl(key, 6) || this.reservedKey(key) && key != 10)) {
                this.newControls[6] = key;
                this.setControls(this.newControls);
                this.controllers.inUse = false;
                this.game.inputSelection = false;
            } else {
                this.game.audio.play(8);
            }
            return;
        }
        if (this.game.inputSelection && key == 27 && this.escapeReleased) {
            this.cancelControlSetting();
            return;
        }
        if (!this.game.inputSelection && this.game.settingOptions && key == 27 && this.escapeReleased) {
            this.escapeReleased = false;
            if (this.game.getGameState() == 1) {
                this.game.level.resume(true);
            }
            this.game.settingOptions = false;
            return;
        }
        if (key == 27 && this.escapeReleased) {
            this.escapeReleased = false;
            if (this.game.getGameState() == 1) {
                if (this.game.level.paused) {
                    this.game.level.resume(true);
                } else {
                    this.game.level.pause();
                }
            } else if (this.game.getGameState() != 0 && this.game.getGameState() == 2) {
                this.game.skipTransition();
            }
        }
        if (key == this.leftKey || key == 37) {
            this.leftDown = true;
        } else if (key == this.rightKey || key == 39) {
            this.rightDown = true;
        } else if (key == this.upKey || key == 38) {
            this.upDown = true;
            if (key == 38) {
                this.defUpDown = true;
            }
        } else if (key == this.downKey || key == 40) {
            this.downDown = true;
            if (key == 40) {
                this.defDownDown = true;
            }
        } else if (key == this.jumpKey) {
            this.jumpDown = true;
        } else if (key == this.runKey) {
            this.runDown = true;
        } else if (key == this.startKey || key == 10) {
            this.startDown = true;
            if (key == 10) {
                this.defStartDown = true;
            }
        }
        if (this.game.getGameState() == 1 && key == 112 && (!this.game.takingSnapshot || this.game.snapshotTrans < 0.5f)) {
            this.game.takeSnapshot = true;
        }
        if (this.game.getGameState() == 0 && !this.game.inputSelection && (!upWasPressed && this.upDown || !downWasPressed && this.downDown || !leftWasPressed && this.leftDown || !rightWasPressed && this.rightDown)) {
            this.addCheatKey(key);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == this.leftKey || key == 37) {
            this.leftDown = false;
        } else if (key == this.rightKey || key == 39) {
            this.rightDown = false;
        } else if (key == this.upKey || key == 38) {
            this.upDown = false;
            if (key == 38) {
                this.defUpDown = false;
            }
        } else if (key == this.downKey || key == 40) {
            this.downDown = false;
            if (key == 40) {
                this.defDownDown = false;
            }
        } else if (key == this.jumpKey) {
            this.jumpDown = false;
        } else if (key == this.runKey) {
            this.runDown = false;
        } else if (key == this.startKey || key == 10) {
            this.startDown = false;
            if (key == 10) {
                this.defStartDown = false;
            }
        } else if (key == 27) {
            this.escapeReleased = true;
        }
    }

    private boolean reservedKey(int key) {
        return key == 38 || key == 40 || key == 37 || key == 39 || key == 10;
    }

    public int promptForControllers() {
        Object[] deviceList = this.controllers.getDevicesList();
        String answer = (String)JOptionPane.showInputDialog(this.game, "Select an input device:", "Game Controller", -1, null, deviceList, "Keyboard");
        if (answer == null) {
            return -1;
        }
        for (int i = 0; i < deviceList.length; ++i) {
            if (!answer.equals(deviceList[i])) continue;
            return i;
        }
        return -1;
    }
}

