/*
 * Decompiled with CFR 0.152.
 */
package supermario.game;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import supermario.Utilities;
import supermario.game.Game;
import supermario.game.Textures;

public final class Menu {
    private Game game;
    private Textures textures;
    public int selectorIndex;
    public int mouseHoveredIndex;
    public static final int NO_OPTION_HOVERED_BY_MOUSE = -1;
    public static final int PLAY_A_GAME_OPTION = 0;
    public static final int MAKE_A_GAME_OPTION = 1;
    public static final int SETTINGS_OPTION = 2;
    public static final int EXIT_OPTION = 3;
    public static final int BACK_OPTION = 4;
    public static final int FULLSCREEN_OPTION = 5;
    public static final int SET_CONTROLS_OPTION = 6;
    public static final int MUTE_OPTION = 7;
    public static final int TOGGLE_PLAYER_OPTION = 8;
    public static final int ABOUT_OPTION = 9;
    public boolean enterReleased;
    public boolean upReleased;
    public boolean downReleased;
    private static final String author = String.valueOf(new char[]{'B', 'Y', ' ', 'A', 'N', 'D', 'R', 'E', 'W', ' ', 'K', 'E', 'L', 'L', 'O', 'G', 'G'});
    private static final String disclaimer = String.valueOf(new char[]{'\u00a9', '1', '9', '8', '5', ' ', 'N', 'I', 'N', 'T', 'E', 'N', 'D', 'O'});
    private static final String play = String.valueOf(new char[]{'P', 'L', 'A', 'Y', ' ', 'A', ' ', 'G', 'A', 'M', 'E'});
    private static final String play1Game = String.valueOf(new char[]{'M', 'A', 'R', 'I', 'O', ' ', 'G', 'A', 'M', 'E'});
    private static final String play2Game = String.valueOf(new char[]{'L', 'U', 'I', 'G', 'I', ' ', 'G', 'A', 'M', 'E'});
    private static final String make = String.valueOf(new char[]{'M', 'A', 'K', 'E', ' ', 'A', ' ', 'G', 'A', 'M', 'E'});
    private static final String settings = String.valueOf(new char[]{'S', 'E', 'T', 'T', 'I', 'N', 'G', 'S'});
    private static final String exit = String.valueOf(new char[]{'E', 'X', 'I', 'T'});
    public static final String back = String.valueOf(new char[]{'B', 'A', 'C', 'K'});
    public static final String resume = String.valueOf(new char[]{'R', 'E', 'S', 'U', 'M', 'E', ' ', 'G', 'A', 'M', 'E'});
    public static final String fullScreen = String.valueOf(new char[]{'G', 'O', ' ', 'F', 'U', 'L', 'L', 'S', 'C', 'R', 'E', 'E', 'N'});
    public static final String windowed = String.valueOf(new char[]{'G', 'O', ' ', 'W', 'I', 'N', 'D', 'O', 'W', 'E', 'D'});
    public static final String controls = String.valueOf(new char[]{'S', 'E', 'T', ' ', 'C', 'O', 'N', 'T', 'R', 'O', 'L', 'S'});
    public static final String mute = String.valueOf(new char[]{'M', 'U', 'T', 'E'});
    public static final String unmute = String.valueOf(new char[]{'U', 'N', 'M', 'U', 'T', 'E'});
    public static final String noAudio = String.valueOf(new char[]{'(', 'N', 'O', ' ', 'A', 'U', 'D', 'I', 'O', ')'});
    public static final String retryLvl = String.valueOf(new char[]{'R', 'E', 'T', 'R', 'Y', ' ', 'L', 'V', 'L'});
    public static final String retryCkPt = String.valueOf(new char[]{'R', 'E', 'T', 'R', 'Y', ' ', 'A', 'T', ' ', 'C', 'H', 'K', ' ', 'P', 'T'});
    public static final String quitTest = String.valueOf(new char[]{'Q', 'U', 'I', 'T', ' ', 'T', 'E', 'S', 'T'});
    public static final String quitGame = String.valueOf(new char[]{'Q', 'U', 'I', 'T', ' ', 'G', 'A', 'M', 'E'});
    public static final String pressUp = String.valueOf(new char[]{'P', 'R', 'E', 'S', 'S', ' ', 'U', 'P'});
    public static final String pressDown = String.valueOf(new char[]{'P', 'R', 'E', 'S', 'S', ' ', 'D', 'O', 'W', 'N'});
    public static final String pressLeft = String.valueOf(new char[]{'P', 'R', 'E', 'S', 'S', ' ', 'L', 'E', 'F', 'T'});
    public static final String pressRight = String.valueOf(new char[]{'P', 'R', 'E', 'S', 'S', ' ', 'R', 'I', 'G', 'H', 'T'});
    public static final String pressB = String.valueOf(new char[]{'P', 'R', 'E', 'S', 'S', ' ', 'B', ' ', '(', 'R', 'U', 'N', ')'});
    public static final String pressA = String.valueOf(new char[]{'P', 'R', 'E', 'S', 'S', ' ', 'A', ' ', '(', 'J', 'U', 'M', 'P', ')'});
    public static final String pressStart = String.valueOf(new char[]{'P', 'R', 'E', 'S', 'S', ' ', 'S', 'T', 'A', 'R', 'T'});
    public static final String pressCancel = String.valueOf(new char[]{'E', 'S', 'C', 'A', 'P', 'E', ' ', 'T', 'O', ' ', 'C', 'A', 'N', 'C', 'E', 'L'});
    public static final String vol = String.valueOf(new char[]{'V', 'O', 'L'});

    public Menu(Game game) {
        this.game = game;
        this.textures = game.textures;
        this.mouseHoveredIndex = -1;
    }

    public void update(double delta) {
        if (!this.enterReleased && !this.game.input.startDown) {
            this.enterReleased = true;
        }
        if (!this.upReleased && !this.game.input.upDown) {
            this.upReleased = true;
        }
        if (!this.downReleased && !this.game.input.downDown) {
            this.downReleased = true;
        }
        if (!this.game.inputSelection && this.enterReleased && !this.game.settingOptions && !this.game.input.promptingForController) {
            if (this.game.input.startDown && this.selectorIndex == 0) {
                this.game.playAGame();
            } else if (this.game.input.startDown && this.selectorIndex == 1) {
                if (this.game.isAutoStartBuild()) {
                    this.game.mario.asLuigi = true;
                    this.game.playAGame();
                } else {
                    this.game.switchToBuilder();
                }
            } else if (this.game.input.startDown && this.selectorIndex == 2) {
                this.game.settingOptions(true);
                this.enterReleased = false;
            } else if (this.game.input.startDown && this.selectorIndex == 3) {
                System.exit(0);
            } else if (this.game.input.upDown && !this.game.input.downDown && this.upReleased) {
                --this.selectorIndex;
                this.upReleased = false;
            } else if (this.game.input.downDown && !this.game.input.upDown && this.downReleased) {
                ++this.selectorIndex;
                this.downReleased = false;
            }
            if (this.selectorIndex < 0) {
                this.selectorIndex = 0;
            } else if (this.selectorIndex > 3) {
                this.selectorIndex = 3;
            }
        }
    }

    public void draw(Graphics2D g2D) {
        g2D.setColor(this.textures.skyBlue);
        g2D.fillRect(0, 0, Game.renderWidth, Game.renderHeight);
        Utilities.drawAtTile(g2D, this.textures.title.getImage(), 5, 3);
        if (this.game.inputSelection) {
            int width;
            int xStartPos;
            String text = "Keyboard:";
            if (this.game.input.controllers.gettingControls) {
                text = this.game.input.controllers.getDevicesList()[this.game.input.controllers.selectedDevice + 1] + ":";
            }
            if ((xStartPos = Game.renderWidth / 2 - (width = Math.round(text.length() * 8)) / 2) < 0) {
                xStartPos = 0;
            }
            Utilities.drawTextAtPixels(g2D, text, xStartPos, 120, this.textures.pink, 1.0f);
        } else if (this.game.isAutoStartBuild()) {
            Utilities.drawTextAtTiles(g2D, disclaimer, 13, 14, this.textures.pink, 1.0f);
        } else {
            Utilities.drawTextAtTiles(g2D, author, 10, 14, this.textures.pink, 1.0f);
        }
        Utilities.drawAtTile(g2D, this.textures.bigHill.getImage(), 0, Game.yTiles - 8);
        Utilities.drawAtTile(g2D, this.textures.tripleBush.getImage(), 23, Game.yTiles - 5);
        for (int i = 0; i < this.game.getWidth() / 8 + 1; ++i) {
            Utilities.drawAtTile(g2D, this.textures.lightGround.getImage(), i * 2, Game.yTiles - 3);
            Utilities.drawAtTile(g2D, this.textures.lightGround.getImage(), i * 2, Game.yTiles - 1);
        }
        Image image = this.textures.marioSmStand.getImage();
        if (this.game.mario.asLuigi) {
            image = this.textures.luigiSmStand.getImage();
        }
        g2D.drawImage(image, 40, 168 + this.game.mario.avoidedCollisionRowsOnBottom, null);
        if (!this.game.settingOptions) {
            int selectorPos = 17 + 2 * this.selectorIndex;
            g2D.drawImage(this.textures.selector.getImage(), 72, 8 * selectorPos, null);
            if (this.game.isAutoStartBuild()) {
                Utilities.drawTextAtTiles(g2D, play1Game, 11, 17);
                Utilities.drawTextAtTiles(g2D, play2Game, 11, 19);
            } else {
                Utilities.drawTextAtTiles(g2D, play, 11, 17);
                Utilities.drawTextAtTiles(g2D, make, 11, 19);
            }
            Utilities.drawTextAtTiles(g2D, settings, 11, 21);
            Utilities.drawTextAtTiles(g2D, exit, 11, 23);
        }
        if (this.mouseHoveredIndex != -1) {
            Composite oldComposite = g2D.getComposite();
            g2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setColor(Color.WHITE);
            if (this.mouseHoveredIndex == 0 || this.mouseHoveredIndex == 4) {
                g2D.fillRoundRect(80, 136, 120, 8, 8, 8);
            } else if (this.mouseHoveredIndex == 1 || this.mouseHoveredIndex == 5) {
                g2D.fillRoundRect(80, 152, 120, 8, 8, 8);
            } else if (this.mouseHoveredIndex == 2 || this.mouseHoveredIndex == 6) {
                g2D.fillRoundRect(80, 168, 120, 8, 8, 8);
            } else if (this.mouseHoveredIndex == 3 || this.mouseHoveredIndex == 7 && this.game.audio.isValid()) {
                int unmuteExtraTiles = this.game.audio.isMuted() && this.game.settingOptions ? 2 : 0;
                g2D.fillRoundRect(80, 184, (6 + unmuteExtraTiles) * 8, 8, 8, 8);
            } else if (this.mouseHoveredIndex == 8 && !this.game.isAutoStartBuild()) {
                g2D.fillRoundRect(40, 185, 16, 16, 8, 8);
            } else if (this.mouseHoveredIndex == 9) {
                g2D.fillRoundRect(100, 112, 120, 8, 8, 8);
            }
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2D.setComposite(oldComposite);
        }
    }

    public int handleMainMenuMouse(Point mousePos) {
        int barHeight;
        int barWidth;
        double scaleFactor;
        int height;
        if (this.game.getGameState() != 0 || this.game.inputSelection) {
            return -1;
        }
        int width = this.game.getWidth();
        if (width > (height = this.game.getHeight())) {
            scaleFactor = (double)height / (double)Game.renderHeight;
            barWidth = (int)Math.round(((double)width - (double)Game.renderWidth * scaleFactor) / 2.0);
            barHeight = 0;
        } else {
            scaleFactor = (double)width / (double)Game.renderWidth;
            barHeight = (int)Math.round(((double)height - (double)Game.renderHeight * scaleFactor) / 2.0);
            barWidth = 0;
        }
        int unmuteExtraTiles = this.game.audio.isMuted() && this.game.settingOptions ? 2 : 0;
        Rectangle firstOption = new Rectangle((int)Math.round((double)barWidth + 88.0 * scaleFactor), (int)Math.round((double)barHeight + 132.0 * scaleFactor), (int)Math.round(104.0 * scaleFactor), (int)Math.round(8.0 * scaleFactor * 2.0));
        Rectangle secondOption = new Rectangle((int)Math.round((double)barWidth + 88.0 * scaleFactor), (int)Math.round((double)barHeight + 148.0 * scaleFactor), (int)Math.round(104.0 * scaleFactor), (int)Math.round(8.0 * scaleFactor * 2.0));
        Rectangle thirdOption = new Rectangle((int)Math.round((double)barWidth + 88.0 * scaleFactor), (int)Math.round((double)barHeight + 164.0 * scaleFactor), (int)Math.round(104.0 * scaleFactor), (int)Math.round(8.0 * scaleFactor * 2.0));
        Rectangle fourthOption = new Rectangle((int)Math.round((double)barWidth + 88.0 * scaleFactor), (int)Math.round((double)barHeight + 180.0 * scaleFactor), (int)Math.round((double)((4 + unmuteExtraTiles) * 8) * scaleFactor), (int)Math.round(8.0 * scaleFactor * 2.0));
        Rectangle playerOption = new Rectangle((int)Math.round((double)barWidth + 40.0 * scaleFactor), (int)Math.round((double)barHeight + 184.0 * scaleFactor), (int)Math.round(16.0 * scaleFactor), (int)Math.round(8.0 * scaleFactor * 2.0));
        Rectangle aboutOption = new Rectangle((int)Math.round((double)barWidth + 104.0 * scaleFactor), (int)Math.round((double)barHeight + 112.0 * scaleFactor), (int)Math.round(112.0 * scaleFactor), (int)Math.round(8.0 * scaleFactor * 1.0));
        Rectangle mouseRect = new Rectangle(mousePos.x, mousePos.y, 1, 1);
        if (mouseRect.intersects(firstOption)) {
            if (!this.game.settingOptions) {
                return 0;
            }
            return 4;
        }
        if (mouseRect.intersects(secondOption)) {
            if (!this.game.settingOptions) {
                return 1;
            }
            return 5;
        }
        if (mouseRect.intersects(thirdOption)) {
            if (!this.game.settingOptions) {
                return 2;
            }
            return 6;
        }
        if (mouseRect.intersects(fourthOption)) {
            if (!this.game.settingOptions) {
                return 3;
            }
            return 7;
        }
        if (mouseRect.intersects(playerOption) && !this.game.isAutoStartBuild()) {
            return 8;
        }
        if (mouseRect.intersects(aboutOption)) {
            return 9;
        }
        return -1;
    }
}

