/*
 * Decompiled with CFR 0.152.
 */
package supermario.game;

import supermario.Utilities;
import supermario.game.Game;

public class Runtime
extends Thread {
    public static final double MIN_FRAME_DELAY = 10.0;
    public static final double MAX_FRAME_DELAY = 20.0;
    public static final double MOUSE_HIDE_DELAY = 2000.0;
    private Game game;
    private boolean running;
    private boolean paused;

    public Runtime(Game game) {
        this.game = game;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopGameLoop() {
        this.running = false;
        this.paused = false;
        Runtime runtime = this;
        synchronized (runtime) {
            this.notify();
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void pause() {
        if (!this.running || this.paused) {
            throw new IllegalStateException("Can't pause a game loop that isn't running");
        }
        this.paused = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpause() {
        if (!this.running || !this.paused) {
            throw new IllegalStateException("Can't resume a game loop that isn't paused");
        }
        this.paused = false;
        Runtime runtime = this;
        synchronized (runtime) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        double lastTime = System.nanoTime();
        while (this.running) {
            double delta;
            double startTime;
            if (this.paused) {
                Runtime runtime = this;
                synchronized (runtime) {
                    try {
                        this.wait();
                        if (!this.running) {
                            return;
                        }
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
            }
            if (((startTime = (double)System.nanoTime()) - (double)this.game.input.lastMouseEvent) / 1000000.0 > 2000.0) {
                this.game.hideCursor();
            }
            if ((delta = (startTime - lastTime) / 1000000.0) > 20.0) {
                delta = 20.0;
            }
            this.game.update(delta);
            this.game.paint(this.game.getGraphics());
            if (this.game.takeSnapshot) {
                Utilities.takeSnapshot(this.game);
            }
            double delay = (double)System.nanoTime() - startTime;
            lastTime = startTime;
            if (!(delay < 1.0E7)) continue;
            double sleepTimeNanos = 1.0E7 - delay;
            int sleepMillis = (int)(sleepTimeNanos / 1000000.0);
            int sleepNanos = (int)(sleepTimeNanos % 1000000.0);
            try {
                Thread.sleep(sleepMillis, sleepNanos);
            }
            catch (InterruptedException e) {}
        }
    }
}

