/*
 * Decompiled with CFR 0.152.
 */
package supermario.game;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.Iterator;
import javax.swing.ImageIcon;
import supermario.game.Game;
import supermario.game.Level;
import supermario.game.Tile;
import supermario.game.interfaces.Block;
import supermario.game.interfaces.Enemy;
import supermario.game.interfaces.Friend;
import supermario.game.interfaces.Shelled;
import supermario.game.sprites.Mario;
import supermario.game.sprites.enemies.Bowser;
import supermario.game.sprites.enemies.GrayFish;
import supermario.game.sprites.enemies.HammerBro;
import supermario.game.sprites.enemies.Koopa;
import supermario.game.sprites.enemies.LavaBall;
import supermario.game.sprites.friends.FireballFriend;
import supermario.game.sprites.misc.BowserBattle;
import supermario.game.sprites.misc.Checkpoint;
import supermario.game.sprites.misc.Firebar;
import supermario.game.sprites.misc.Flag;
import supermario.game.sprites.misc.Pipe;
import supermario.game.sprites.misc.Platform;
import supermario.game.sprites.misc.Spring;

public abstract class Sprite {
    protected Game game;
    public int xTile;
    public int yTile;
    public int x;
    public int y;
    public double lastX;
    public double lastY;
    public double xPos;
    public double yPos;
    public double xVel;
    public double yVel;
    public double platformVel;
    public double xAcc;
    public double yAcc;
    public int width;
    public int height;
    public int tilesWidth;
    public int tilesHeight;
    public int spriteState;
    public ImageIcon[] images;
    public int imageIndex;
    public AffineTransform transform;
    public double ticks;
    public boolean flip;
    public boolean vFlip;
    public int avoidedCollisionRowsOnTop;
    public int avoidedCollisionRowsOnBottom;
    public int avoidedCollisionCols;
    public int avoidedUpsideDownCollisionRowsOnBottom;
    public boolean locked;
    public boolean visible;
    public boolean collidable;
    public boolean grounded;
    public boolean settled;
    public boolean bumped;
    public boolean justHit;
    public boolean bumpKilled;
    public boolean injected;
    public static final int COLLISION_ITERATIONS = 2;

    public Sprite(Game game, ImageIcon[] images) {
        this.game = game;
        this.setImages(images);
        this.transform = new AffineTransform();
        this.imageIndex = 0;
        this.visible = true;
        this.collidable = true;
    }

    public abstract Sprite reset();

    public abstract void update(double var1);

    public void releaseSprite(double delta, Tile tile) {
        if (this instanceof Firebar) {
            ((Firebar)this).activate(tile);
        } else if (this instanceof Koopa) {
            ((Koopa)this).flyingYCenter = this.y;
            ((Koopa)this).flyingXCenter = this.x;
        } else if (this instanceof LavaBall) {
            ((LavaBall)this).activate(tile.xTile, tile.yTile);
        } else if (this instanceof Pipe) {
            ((Pipe)this).activate(tile);
        } else if (this instanceof Platform) {
            ((Platform)this).activate();
        } else if (this instanceof BowserBattle) {
            ((BowserBattle)this).activate();
            this.game.level.levelEndPresent = true;
        } else if (this instanceof Flag) {
            this.game.level.levelEndPresent = true;
        } else if (this instanceof Spring) {
            ((Spring)this).activate();
        } else if (this instanceof HammerBro) {
            ((HammerBro)this).activate();
        } else if (this instanceof GrayFish) {
            ((GrayFish)this).activate();
        } else if (this instanceof Checkpoint) {
            ((Checkpoint)this).activate();
        }
        if (!(this instanceof Checkpoint || this instanceof Platform || this instanceof Spring)) {
            this.game.level.sprites.add(this);
            this.update(delta);
        }
        this.xTile = tile.xTile;
        this.yTile = tile.yTile;
    }

    public void draw(Graphics2D g2D) {
        if (!this.visible) {
            return;
        }
        this.transform.setToIdentity();
        this.transform.translate(this.x, this.y);
        if (this.flip) {
            this.transform.translate(this.width, 0.0);
            this.transform.scale(-1.0, 1.0);
        }
        if (this.vFlip) {
            this.transform.translate(0.0, this.height + this.avoidedUpsideDownCollisionRowsOnBottom);
            this.transform.scale(1.0, -1.0);
        }
        g2D.drawImage(this.images[this.imageIndex].getImage(), this.transform, null);
    }

    public void preUpdate(double delta) {
        this.lastX = this.x;
        this.lastY = this.y;
        this.ticks += delta;
        if (this.ticks > 8.988465674311579E307) {
            this.ticks = 8.988465674311579E307;
        }
    }

    public void finalizePosition() {
        this.x = (int)Math.round(this.xPos);
        this.y = (int)Math.round(this.yPos);
    }

    public final void setXY(int x, int y) {
        this.xPos = x;
        this.yPos = y + this.avoidedCollisionRowsOnBottom;
        this.x = x;
        this.y = y;
    }

    public final void setTileXY(int xTile, int yTile) {
        this.xPos = xTile * 8;
        this.yPos = yTile * 8 + this.avoidedCollisionRowsOnBottom;
        this.x = (int)this.xPos;
        this.y = (int)this.yPos;
    }

    public abstract Rectangle getRectangle();

    public int getXCenter() {
        return this.x + this.width / 2;
    }

    public void applyGravity(double deltaDouble, double magnitude) {
        this.yVel += magnitude * deltaDouble / 1000.0;
        if (this.game.level.levelType == 3) {
            if (this.yVel > Level.TERMINAL_VELOCITY_WATER) {
                this.yVel = Level.TERMINAL_VELOCITY_WATER;
            }
        } else if (this.yVel > Level.TERMINAL_VELOCITY) {
            this.yVel = Level.TERMINAL_VELOCITY;
        }
        this.yPos += this.yVel * deltaDouble / 1000.0;
    }

    public boolean isColliding() {
        this.finalizePosition();
        int xTile = (int)(this.xPos / 8.0);
        int yTile = (int)(this.yPos / 8.0);
        for (int i = 0; i <= this.tilesWidth; ++i) {
            for (int j = 0; j <= this.tilesHeight; ++j) {
                Tile tempTile;
                if (xTile + i >= this.game.level.xTiles || xTile + i <= 0 || yTile + j >= Game.yTiles || yTile + j <= 0 || (tempTile = this.game.level.tiles[yTile + j][xTile + i]).isPermeableTile() || tempTile.disabled || !tempTile.getRectangle().intersects(this.getRectangle())) continue;
                return true;
            }
        }
        return false;
    }

    public final void checkForCollisions() {
        this.finalizePosition();
        this.platformVel = 0.0;
        for (int k = 0; k < 2; ++k) {
            this.checkForCollisions(true);
            this.checkForCollisions(false);
        }
        if (!(this instanceof Bowser)) {
            this.checkForPlatformCollisions();
        }
        this.addAdditionalPlatformVelocity();
    }

    private void checkForPlatformCollisions() {
        Iterator platformsIter = this.game.level.platforms.iterator();
        while (platformsIter.hasNext()) {
            Platform platform;
            Rectangle platformRect;
            Rectangle spriteRect = this.getRectangle();
            if (!spriteRect.intersects(platformRect = (platform = (Platform)platformsIter.next()).getRectangle())) continue;
            if (platform.isHorizontallyOscillatingPlatform() || platform.type == 13) {
                this.resolveHorizontalMotionPlatformCollision(spriteRect, platform, platformRect);
            } else {
                this.resolveVerticalMotionPlatformCollision(spriteRect, platform, platformRect);
            }
            this.finalizePosition();
        }
    }

    private void addAdditionalPlatformVelocity() {
        this.platformVel = 0.0;
        Platform platform = this.onPlatform();
        if (platform != null && (platform.isHorizontallyOscillatingPlatform() || platform.type == 13)) {
            this.xPos += platform.xChange;
            this.platformVel = platform.xVel;
            this.checkForCollisions(true);
            this.checkForCollisions(false);
        }
    }

    private void resolveHorizontalMotionPlatformCollision(Rectangle spriteRect, Platform platform, Rectangle platformRect) {
        if (spriteRect.y + spriteRect.height < platformRect.y + platformRect.height && (Math.abs(this.xVel) >= 96.0 && this.lastY <= (double)this.y || this.lastX + platform.xChange + (double)this.width - (double)this.avoidedCollisionCols > (double)platformRect.x && this.lastX + platform.xChange + (double)this.avoidedCollisionCols < (double)(platformRect.x + platformRect.width))) {
            if (this instanceof Mario && platform.type == 13 && (this.yVel < 0.0 || this.yVel >= 0.0 && this.lastY + (double)this.height - (double)this.avoidedCollisionRowsOnBottom > (double)platform.y)) {
                return;
            }
            this.yPos = platform.yPos - (double)this.height + (double)this.avoidedCollisionRowsOnBottom;
            this.yVel = 0.0;
        } else if (spriteRect.y > platformRect.y && this.yVel < 0.0 && this.lastX + platform.xChange + (double)this.width - (double)this.avoidedCollisionCols >= (double)platformRect.x && this.lastX + platform.xChange + (double)this.avoidedCollisionCols <= (double)(platformRect.x + platformRect.width)) {
            if (this instanceof Mario) {
                if (platform.type == 13) {
                    return;
                }
                this.yPos = !this.game.mario.stateHeightHalved ? platform.yPos + (double)platformRect.height - (double)this.avoidedCollisionRowsOnTop : platform.yPos + (double)platformRect.height - (double)(this.height / 2);
                this.game.mario.jumpStopped(true);
                if (platform.isOnScreen()) {
                    this.game.audio.play(8);
                }
            } else {
                this.yPos = platform.yPos + (double)platformRect.height - (double)this.avoidedCollisionRowsOnTop;
            }
            this.yVel = this instanceof FireballFriend ? Math.abs(this.yVel) : 0.0;
        } else if (platform.type != 13 && !(this instanceof FireballFriend)) {
            this.xPos = this.x + this.width / 2 > platform.x + platform.width / 2 ? (double)(platform.x + platform.width - this.avoidedCollisionCols) : (double)(platform.x - this.width + this.avoidedCollisionCols);
            this.xVel = platform.xVel > 0.0 && this.xVel >= platform.xVel ? platform.xVel : (platform.xVel < 0.0 && this.xVel <= platform.xVel ? platform.xVel : 0.0);
        }
    }

    private void resolveVerticalMotionPlatformCollision(Rectangle spriteRect, Platform platform, Rectangle platformRect) {
        if (spriteRect.y + spriteRect.height <= platformRect.y + platformRect.height && this.lastX + (double)this.width - (double)this.avoidedCollisionCols > (double)platformRect.x && this.lastX + (double)this.avoidedCollisionCols < (double)(platformRect.x + platformRect.width)) {
            this.yPos = platform.yPos - (double)this.height + (double)this.avoidedCollisionRowsOnBottom;
            this.yVel = platform.yVel;
            if (this.yVel < 0.0) {
                this.yVel = 0.0;
            } else if (this.yVel <= 56.0) {
                this.yVel = 56.0;
            }
        } else if (spriteRect.y > platformRect.y && this.lastX + (double)this.width - (double)this.avoidedCollisionCols > (double)platformRect.x && this.lastX + (double)this.avoidedCollisionCols < (double)(platformRect.x + platformRect.width)) {
            if (this instanceof Mario) {
                this.yPos = !this.game.mario.stateHeightHalved ? platform.yPos + (double)platformRect.height - (double)this.avoidedCollisionRowsOnTop : platform.yPos + (double)platformRect.height - (double)(this.height / 2);
                if (platform.yVel > 0.0) {
                    this.yPos += 1.0;
                }
                this.game.mario.jumpStopped(true);
                if (platform.isOnScreen()) {
                    this.game.audio.play(8);
                }
            } else {
                this.yPos = platform.yPos + (double)platformRect.height - (double)this.avoidedCollisionRowsOnTop;
            }
            if (this instanceof FireballFriend) {
                this.yVel = Math.abs(this.yVel);
            } else if (platform.yVel < 0.0 && this.yVel < platform.yVel) {
                this.yVel = platform.yVel;
            } else if (platform.yVel > 0.0 && this.yVel < platform.yVel) {
                this.yVel = platform.yVel;
            }
        } else if (this.xVel < 0.0 && !(this instanceof FireballFriend)) {
            this.xPos = platformRect.x + platformRect.width - this.avoidedCollisionCols;
            if (this instanceof Mario) {
                this.xVel = 0.0;
            } else if (this instanceof Enemy) {
                ((Enemy)((Object)this)).xCollided();
            } else if (this instanceof Friend) {
                ((Friend)((Object)this)).xCollided();
            }
        } else if (this.xVel > 0.0 && !(this instanceof FireballFriend)) {
            this.xPos = platformRect.x - this.width + this.avoidedCollisionCols;
            if (this instanceof Mario) {
                this.xVel = 0.0;
            } else if (this instanceof Enemy) {
                ((Enemy)((Object)this)).xCollided();
            } else if (this instanceof Friend) {
                ((Friend)((Object)this)).xCollided();
            }
        }
    }

    public void checkForCollisions(boolean yOnly) {
        this.finalizePosition();
        int xTile = (int)(this.xPos / 8.0);
        int yTile = (int)(this.yPos / 8.0);
        for (int i = 0; i <= this.tilesWidth; ++i) {
            for (int j = this.tilesHeight; j >= 0; --j) {
                Rectangle spriteRect;
                Rectangle tempRect;
                if (xTile + i >= this.game.level.xTiles || xTile + i < 0 || yTile + j >= Game.yTiles || yTile + j < 0) continue;
                Tile tempTile = this.game.level.tiles[yTile + j][xTile + i];
                if (!tempTile.solid || tempTile.disabled || !(tempRect = tempTile.getRectangle()).intersects(spriteRect = this.getRectangle())) continue;
                boolean aboveTwoSolid = this.aboveTwoSolid(xTile + i, yTile + j);
                this.resolveCollision(spriteRect, tempTile, aboveTwoSolid, yOnly);
            }
        }
    }

    private boolean aboveTwoSolid(int xTile, int yTile) {
        if (yTile == 0) {
            return false;
        }
        if (yTile == 1 && !this.game.level.tiles[yTile - 1][xTile].isPermeableTile()) {
            return true;
        }
        return yTile >= 2 && (!this.game.level.tiles[yTile - 1][xTile].isPermeableTile() || !this.game.level.tiles[yTile - 2][xTile].isPermeableTile());
    }

    private void resolveCollision(Rectangle spriteRect, Tile tile, boolean aboveTwoSolid, boolean yOnly) {
        if (tile.isUnexposedHiddenTile()) {
            if (this instanceof Mario && this.yVel < 0.0 && spriteRect.y > tile.getRectangle().y) {
                this.bumpedAtTile(tile);
            } else if (this instanceof Shelled && ((Shelled)((Object)this)).isLaunched() && tile.sprite.isOnScreen()) {
                tile.bumped(this);
            }
        } else if (yOnly) {
            this.resolveYCollision(spriteRect, tile, aboveTwoSolid);
        } else if (!(this instanceof Bowser)) {
            this.resolveXCollision(tile);
        }
        this.finalizePosition();
    }

    private void resolveYCollision(Rectangle spriteRect, Tile tile, boolean aboveTwoSolid) {
        Rectangle tileRect = tile.getRectangle();
        double yDelta = (double)(spriteRect.y + spriteRect.height) - (this.lastY + (double)this.height - (double)this.avoidedCollisionRowsOnBottom);
        double continuousCollisionOffset = 0.0;
        if (yDelta > 1.0 && this instanceof Mario) {
            continuousCollisionOffset = yDelta - 1.0;
        }
        if (!aboveTwoSolid && (double)(spriteRect.y + spriteRect.height) - continuousCollisionOffset < (double)(tileRect.y + tileRect.height) && (this.yVel >= 232.0 || Math.abs(this.xVel) >= 96.0 && this.lastY <= (double)this.y || this.lastX + (double)this.width - (double)this.avoidedCollisionCols > (double)tileRect.x && this.lastX + (double)this.avoidedCollisionCols < (double)(tileRect.x + tileRect.width))) {
            if (this instanceof Mario) {
                if (!this.game.mario.willBePinchedOnTile(tile)) {
                    this.yPos = tileRect.y - 8 * this.tilesHeight + this.avoidedCollisionRowsOnBottom;
                    this.yVel = 0.0;
                }
            } else if (!(!(this instanceof Enemy) && !(this instanceof Friend) || this.isOnOneTile() && (this.xVel > 0.0 && this.lastX + (double)this.width - (double)this.avoidedCollisionCols <= (double)(tile.xTile * 8) || this.xVel < 0.0 && this.lastX + (double)this.avoidedCollisionCols >= (double)(tile.xTile * 8 + 8)))) {
                this.yPos = tileRect.y - 8 * this.tilesHeight + this.avoidedCollisionRowsOnBottom;
                this.yVel = 0.0;
            }
        } else if (spriteRect.y > tileRect.y && this.yVel < 0.0 && this.lastX + (double)this.width - (double)this.avoidedCollisionCols > (double)tileRect.x && this.lastX + (double)this.avoidedCollisionCols < (double)(tileRect.x + tileRect.width) && (tile.yTile >= Game.yTiles - 1 || this.game.level.tiles[tile.yTile + 1][tile.xTile].isPermeableTile())) {
            if (this instanceof Mario) {
                boolean movingOver = this.game.mario.moveOverTest(tile);
                if (!movingOver) {
                    this.bumpedAtTile(tile);
                }
            } else if (!(this instanceof Bowser) || !(tile.sprite instanceof Block)) {
                this.yVel = 0.0;
                this.yPos = tileRect.y + tileRect.height - this.avoidedCollisionRowsOnTop;
            }
        }
    }

    private void bumpedAtTile(Tile tile) {
        this.yPos = tile.getRectangle().y + tile.getRectangle().height;
        this.game.mario.jumpStopped(true);
        this.yPos = !this.game.mario.stateHeightHalved ? (this.yPos -= (double)this.game.mario.avoidedCollisionRowsOnTop) : (this.yPos -= (double)(this.height / 2));
        this.yVel = 64.0;
        Tile bumpedTile = this.game.mario.getTileToBump(tile);
        bumpedTile.bumped(this);
    }

    private void resolveXCollision(Tile tile) {
        Rectangle tileRect = tile.getRectangle();
        if (this.xVel + this.platformVel < 0.0) {
            if (tile.xTile < this.game.level.xTiles - this.tilesWidth && this.game.level.tiles[tile.yTile][tile.xTile + 1].isPermeableTile() && this.game.level.tiles[tile.yTile][tile.xTile + 2].isPermeableTile()) {
                this.xPos = tileRect.x + tileRect.width - this.avoidedCollisionCols;
                if (this instanceof Mario) {
                    this.game.mario.unignoreTilesAfterForcedMotion();
                    this.xVel = 0.0;
                } else if (this instanceof Enemy) {
                    ((Enemy)((Object)this)).xCollided();
                    if (this instanceof Shelled && ((Shelled)((Object)this)).isLaunched()) {
                        if (tile.yTile > 0 && this.game.level.tiles[tile.yTile - 1][tile.xTile].solid && this.yPos < (double)(tile.yTile * 8)) {
                            this.game.level.tiles[tile.yTile - 1][tile.xTile].bumped(this);
                        } else {
                            tile.bumped(this);
                        }
                    }
                } else if (this instanceof FireballFriend) {
                    FireballFriend fb = (FireballFriend)this;
                    if (!this.aboveTileSolid(tile) && fb.yPos + (double)fb.height < (double)(tile.yTile * 8 + 4)) {
                        fb.yPos = tile.yTile * 8 - fb.height;
                        fb.xPos = tile.xTile * 8 + 8 - fb.width;
                        fb.bounce();
                    } else {
                        fb.xCollided();
                    }
                } else if (this instanceof Friend) {
                    ((Friend)((Object)this)).xCollided();
                }
            }
        } else if (this.xVel + this.platformVel > 0.0 && tile.xTile >= this.tilesWidth && this.game.level.tiles[tile.yTile][tile.xTile - 1].isPermeableTile() && this.game.level.tiles[tile.yTile][tile.xTile - 2].isPermeableTile()) {
            this.xPos = tileRect.x - 8 * this.tilesWidth + this.avoidedCollisionCols;
            if (this instanceof Mario) {
                this.game.mario.unignoreTilesAfterForcedMotion();
                this.xVel = 0.0;
            } else if (this instanceof Enemy) {
                ((Enemy)((Object)this)).xCollided();
                if (this instanceof Shelled && ((Shelled)((Object)this)).isLaunched()) {
                    if (tile.yTile > 0 && this.game.level.tiles[tile.yTile - 1][tile.xTile].solid && this.yPos < (double)(tile.yTile * 8)) {
                        this.game.level.tiles[tile.yTile - 1][tile.xTile].bumped(this);
                    } else {
                        tile.bumped(this);
                    }
                }
            } else if (this instanceof FireballFriend) {
                FireballFriend fb = (FireballFriend)this;
                if (!this.aboveTileSolid(tile) && fb.yPos + (double)fb.height < (double)(tile.yTile * 8 + 4)) {
                    fb.yPos = tile.yTile * 8 - fb.height;
                    fb.xPos = tile.xTile * 8;
                    fb.bounce();
                } else {
                    fb.xCollided();
                }
            } else if (this instanceof Friend) {
                ((Friend)((Object)this)).xCollided();
            }
        }
    }

    private boolean aboveTileSolid(Tile tile) {
        if (tile.yTile <= 0) {
            return false;
        }
        return !this.game.level.tiles[tile.yTile - 1][tile.xTile].isPermeableTile();
    }

    public void checkForUnsettledTiles() {
        int maxX;
        Rectangle rect = this.getRectangle();
        if (rect.y + rect.height - this.avoidedCollisionRowsOnBottom + 1 >= Game.renderHeight) {
            return;
        }
        if (rect.y + rect.height - this.avoidedCollisionRowsOnBottom + 1 < 0) {
            return;
        }
        int minX = rect.x + this.avoidedCollisionCols;
        if (minX < 0) {
            minX = 0;
        }
        if ((maxX = rect.x + rect.width - this.avoidedCollisionCols * 2) > this.game.level.xTiles * 8) {
            maxX = this.game.level.xTiles * 8;
        }
        for (int i = minX; i < maxX; ++i) {
            Tile tempTile = this.game.level.getTileAtPixel(i, rect.y + rect.height - this.avoidedCollisionRowsOnBottom + 1);
            if (tempTile.sprite == null || tempTile.sprite.settled || !tempTile.sprite.justHit) continue;
            if (this instanceof Enemy) {
                ((Enemy)((Object)this)).bumpKilled(this.game.mario);
                break;
            }
            if (!(this instanceof Friend)) break;
            ((Friend)((Object)this)).bumped();
            break;
        }
    }

    public boolean isGrounded() {
        int maxX;
        if (this.onPlatform() != null) {
            return true;
        }
        Rectangle rect = this.getRectangle();
        if (rect.y + rect.height + 1 >= Game.renderHeight) {
            return false;
        }
        if (rect.y + rect.height < 0) {
            return false;
        }
        int minX = rect.x;
        if (minX < 0) {
            minX = 0;
        }
        if ((maxX = rect.x + rect.width) >= this.game.level.xTiles * 8) {
            maxX = this.game.level.xTiles * 8 - 1;
        }
        for (int i = minX; i < maxX; ++i) {
            Tile tempTile = this.game.level.getTileAtPixel(i, rect.y + rect.height + 1);
            if (tempTile.isPermeableTile()) continue;
            return true;
        }
        return false;
    }

    public Platform onPlatform() {
        Rectangle spriteRect = this.getRectangle();
        spriteRect.height += 4;
        for (Platform platform : this.game.level.platforms) {
            if (!platform.getRectangle().intersects(spriteRect) || spriteRect.y + spriteRect.height >= platform.y + platform.height || platform.type == 13 && this.yVel < 0.0) continue;
            return platform;
        }
        return null;
    }

    public boolean isOnOneTile() {
        int yRow = this.y + this.height - this.avoidedCollisionRowsOnBottom + 1;
        if (yRow >= Game.renderHeight) {
            return false;
        }
        int startingX = this.x + this.avoidedCollisionCols;
        int endingX = this.x + this.width - this.avoidedCollisionCols;
        if (startingX < 0) {
            startingX = 0;
        }
        if (endingX >= this.game.level.xTiles * 8) {
            endingX = this.game.level.xTiles * 8 - 1;
        }
        Tile markedTile = null;
        for (int i = startingX; i <= endingX; ++i) {
            Tile testedTile = this.game.level.getTileAtPixel(i, yRow);
            if (testedTile.isPermeableTile()) continue;
            if (markedTile != null && testedTile != markedTile) {
                return false;
            }
            markedTile = testedTile;
        }
        return markedTile != null;
    }

    public boolean isBetweenTwoSolidTiles() {
        int yStop;
        if (this.x <= 8 || this.x + this.width > this.game.level.xTiles * 8 - 8) {
            return false;
        }
        boolean rightSideBlocked = false;
        boolean leftSideBlocked = false;
        int yStart = this.y + this.avoidedCollisionRowsOnTop;
        if (yStart < 0) {
            yStart = 0;
        }
        if ((yStop = this.y + this.height - this.avoidedCollisionRowsOnBottom) > Game.renderHeight) {
            yStop = Game.renderHeight;
        }
        for (int i = yStart; i < yStop; ++i) {
            if (!this.game.level.getTileAtPixel(this.x - 4, i).isPermeableTile()) {
                leftSideBlocked = true;
            }
            if (this.game.level.getTileAtPixel(this.x + this.width + 4, i).isPermeableTile()) continue;
            rightSideBlocked = true;
        }
        return leftSideBlocked && rightSideBlocked;
    }

    public boolean isOnScreen() {
        return this.x + this.width >= this.game.level.leftMostX && this.x <= this.game.level.leftMostX + Game.renderWidth && this.y + this.height >= 0 && this.y < Game.renderHeight;
    }

    private void setImages(ImageIcon[] images) {
        this.images = images;
        this.width = images[0].getIconWidth();
        this.height = images[0].getIconHeight();
        this.tilesWidth = this.width / 8;
        this.tilesHeight = this.height / 8;
        if (images.length > 1) {
            for (int i = 1; i < images.length; ++i) {
                if (images[i] == null) {
                    throw new RuntimeException("Problem loading index " + i + " from " + this.toString());
                }
                if (images[i].getIconWidth() == this.width && images[i].getIconHeight() == this.height) continue;
                throw new RuntimeException("Sprite image dimensions aren't all equal");
            }
        }
    }
}

