/*
 * Decompiled with CFR 0.152.
 */
package supermario.game;

import javax.swing.ImageIcon;
import supermario.Utilities;
import supermario.game.Game;
import supermario.game.Textures;

public class TexturePacks {
    private Textures textures;
    public boolean validTextures;
    private int texturePack = 0;
    private ImageIcon selector;
    private ImageIcon smallHill;
    private ImageIcon bigHill;
    private ImageIcon smallCastle;
    private ImageIcon largeCastle;
    private ImageIcon singleBush;
    private ImageIcon doubleBush;
    private ImageIcon tripleBush;
    private ImageIcon singleCloud;
    private ImageIcon doubleCloud;
    private ImageIcon tripleCloud;
    private ImageIcon lightGround;
    private ImageIcon darkGround;
    private ImageIcon stoneGround;
    private ImageIcon castleWall;
    private ImageIcon picketFence;
    private ImageIcon bridge;
    private ImageIcon shortTrimmedBush;
    private ImageIcon tallTrimmedBush;
    private ImageIcon shortSnowyBush;
    private ImageIcon tallSnowyBush;
    private ImageIcon lightBrick;
    private ImageIcon darkBrick;
    private ImageIcon stoneBrick;
    private ImageIcon treeBark;
    private ImageIcon treeTopLeftEnd;
    private ImageIcon treeTopMiddle;
    private ImageIcon treeTopRightEnd;
    private ImageIcon platformLong;
    private ImageIcon platformShort;
    private ImageIcon platformExtraShort;
    private ImageIcon selectorBackup;
    private ImageIcon smallHillBackup;
    private ImageIcon bigHillBackup;
    private ImageIcon smallCastleBackup;
    private ImageIcon largeCastleBackup;
    private ImageIcon singleBushBackup;
    private ImageIcon doubleBushBackup;
    private ImageIcon tripleBushBackup;
    private ImageIcon singleCloudBackup;
    private ImageIcon doubleCloudBackup;
    private ImageIcon tripleCloudBackup;
    private ImageIcon lightGroundBackup;
    private ImageIcon darkGroundBackup;
    private ImageIcon stoneGroundBackup;
    private ImageIcon castleWallBackup;
    private ImageIcon picketFenceBackup;
    private ImageIcon bridgeBackup;
    private ImageIcon shortTrimmedBushBackup;
    private ImageIcon tallTrimmedBushBackup;
    private ImageIcon shortSnowyBushBackup;
    private ImageIcon tallSnowyBushBackup;
    private ImageIcon lightBrickBackup;
    private ImageIcon darkBrickBackup;
    private ImageIcon stoneBrickBackup;
    private ImageIcon treeBarkBackup;
    private ImageIcon treeTopLeftEndBackup;
    private ImageIcon treeTopMiddleBackup;
    private ImageIcon treeTopRightEndBackup;
    private ImageIcon platformLongBackup;
    private ImageIcon platformShortBackup;
    private ImageIcon platformExtraShortBackup;

    public TexturePacks(Textures textures) {
        this.textures = textures;
        this.validTextures = true;
        try {
            this.init();
        }
        catch (Exception e) {
            this.validTextures = false;
            e.printStackTrace();
        }
    }

    public int getTexturePack() {
        return this.texturePack;
    }

    public boolean setTexturePack(int newTexturePack) {
        if (newTexturePack == 0) {
            if (this.texturePack != 0) {
                this.switchToStandardTextures();
                return true;
            }
            return false;
        }
        if (newTexturePack == 1) {
            if (this.texturePack != 1) {
                this.switchToLostLevelsTextures();
                return true;
            }
            return false;
        }
        if (this.texturePack != 0) {
            this.switchToStandardTextures();
            return true;
        }
        return false;
    }

    private void switchToLostLevelsTextures() {
        this.texturePack = 1;
        this.textures.selector = this.selector;
        this.textures.smallHill = this.smallHill;
        this.textures.bigHill = this.bigHill;
        this.textures.smallCastle = this.smallCastle;
        this.textures.largeCastle = this.largeCastle;
        this.textures.singleBush = this.singleBush;
        this.textures.doubleBush = this.doubleBush;
        this.textures.tripleBush = this.tripleBush;
        this.textures.singleCloud = this.singleCloud;
        this.textures.doubleCloud = this.doubleCloud;
        this.textures.tripleCloud = this.tripleCloud;
        this.textures.lightGround = this.lightGround;
        this.textures.darkGround = this.darkGround;
        this.textures.stoneGround = this.stoneGround;
        this.textures.castleWall = this.castleWall;
        this.textures.picketFence = this.picketFence;
        this.textures.bridge = this.bridge;
        this.textures.shortTrimmedBush = this.shortTrimmedBush;
        this.textures.tallTrimmedBush = this.tallTrimmedBush;
        this.textures.shortSnowyBush = this.shortSnowyBush;
        this.textures.tallSnowyBush = this.tallSnowyBush;
        this.textures.treeBark = this.treeBark;
        this.textures.treeTopLeftEnd = this.treeTopLeftEnd;
        this.textures.treeTopMiddle = this.treeTopMiddle;
        this.textures.treeTopRightEnd = this.treeTopRightEnd;
        this.textures.lightBrick = this.lightBrick;
        this.textures.darkBrick = this.darkBrick;
        this.textures.stoneBrick = this.stoneBrick;
        this.textures.platformLong = this.platformLong;
        this.textures.platformShort = this.platformShort;
        this.textures.platformExtraShort = this.platformExtraShort;
    }

    private void switchToStandardTextures() {
        this.texturePack = 0;
        this.textures.selector = this.selectorBackup;
        this.textures.smallHill = this.smallHillBackup;
        this.textures.bigHill = this.bigHillBackup;
        this.textures.smallCastle = this.smallCastleBackup;
        this.textures.largeCastle = this.largeCastleBackup;
        this.textures.singleBush = this.singleBushBackup;
        this.textures.doubleBush = this.doubleBushBackup;
        this.textures.tripleBush = this.tripleBushBackup;
        this.textures.singleCloud = this.singleCloudBackup;
        this.textures.doubleCloud = this.doubleCloudBackup;
        this.textures.tripleCloud = this.tripleCloudBackup;
        this.textures.lightGround = this.lightGroundBackup;
        this.textures.darkGround = this.darkGroundBackup;
        this.textures.stoneGround = this.stoneGroundBackup;
        this.textures.castleWall = this.castleWallBackup;
        this.textures.picketFence = this.picketFenceBackup;
        this.textures.bridge = this.bridgeBackup;
        this.textures.shortTrimmedBush = this.shortTrimmedBushBackup;
        this.textures.tallTrimmedBush = this.tallTrimmedBushBackup;
        this.textures.shortSnowyBush = this.shortSnowyBushBackup;
        this.textures.tallSnowyBush = this.tallSnowyBushBackup;
        this.textures.treeBark = this.treeBarkBackup;
        this.textures.treeTopLeftEnd = this.treeTopLeftEndBackup;
        this.textures.treeTopMiddle = this.treeTopMiddleBackup;
        this.textures.treeTopRightEnd = this.treeTopRightEndBackup;
        this.textures.lightBrick = this.lightBrickBackup;
        this.textures.darkBrick = this.darkBrickBackup;
        this.textures.stoneBrick = this.stoneBrickBackup;
        this.textures.platformLong = this.platformLongBackup;
        this.textures.platformShort = this.platformShortBackup;
        this.textures.platformExtraShort = this.platformExtraShortBackup;
    }

    private void init() throws Exception {
        this.storeBackups();
        this.overlayInit();
        this.tilesInit();
        this.spritesInit();
    }

    private void storeBackups() {
        this.selectorBackup = this.textures.selector;
        this.smallHillBackup = this.textures.smallHill;
        this.bigHillBackup = this.textures.bigHill;
        this.smallCastleBackup = this.textures.smallCastle;
        this.largeCastleBackup = this.textures.largeCastle;
        this.singleBushBackup = this.textures.singleBush;
        this.doubleBushBackup = this.textures.doubleBush;
        this.tripleBushBackup = this.textures.tripleBush;
        this.singleCloudBackup = this.textures.singleCloud;
        this.doubleCloudBackup = this.textures.doubleCloud;
        this.tripleCloudBackup = this.textures.tripleCloud;
        this.lightGroundBackup = this.textures.lightGround;
        this.darkGroundBackup = this.textures.darkGround;
        this.stoneGroundBackup = this.textures.stoneGround;
        this.castleWallBackup = this.textures.castleWall;
        this.picketFenceBackup = this.textures.picketFence;
        this.bridgeBackup = this.textures.bridge;
        this.shortTrimmedBushBackup = this.textures.shortTrimmedBush;
        this.tallTrimmedBushBackup = this.textures.tallTrimmedBush;
        this.shortSnowyBushBackup = this.textures.shortSnowyBush;
        this.tallSnowyBushBackup = this.textures.tallSnowyBush;
        this.treeBarkBackup = this.textures.treeBark;
        this.treeTopLeftEndBackup = this.textures.treeTopLeftEnd;
        this.treeTopMiddleBackup = this.textures.treeTopMiddle;
        this.treeTopRightEndBackup = this.textures.treeTopRightEnd;
        this.lightBrickBackup = this.textures.lightBrick;
        this.darkBrickBackup = this.textures.darkBrick;
        this.stoneBrickBackup = this.textures.stoneBrick;
        this.platformLongBackup = this.textures.platformLong;
        this.platformShortBackup = this.textures.platformShort;
        this.platformExtraShortBackup = this.textures.platformExtraShort;
    }

    private void overlayInit() throws Exception {
        this.selector = this.image("overlay/selector.png");
    }

    private void tilesInit() throws Exception {
        this.smallHill = this.image("tiles/smallHill.png");
        this.bigHill = this.image("tiles/bigHill.png");
        this.smallCastle = this.image("tiles/smallCastle.png");
        this.largeCastle = this.image("tiles/largeCastle.png");
        this.singleBush = this.image("tiles/singleBush.png");
        this.doubleBush = this.image("tiles/doubleBush.png");
        this.tripleBush = this.image("tiles/tripleBush.png");
        this.singleCloud = this.image("tiles/singleCloud.png");
        this.doubleCloud = this.image("tiles/doubleCloud.png");
        this.tripleCloud = this.image("tiles/tripleCloud.png");
        this.lightGround = this.image("tiles/lightGround.png");
        this.darkGround = this.image("tiles/darkGround.png");
        this.stoneGround = this.image("tiles/stoneGround.png");
        this.castleWall = this.image("tiles/castleWall.png");
        this.picketFence = this.image("tiles/picketFence.png");
        this.bridge = this.image("tiles/bridge.png");
        this.shortTrimmedBush = this.image("tiles/shortTrimmedBush.png");
        this.tallTrimmedBush = this.image("tiles/tallTrimmedBush.png");
        this.shortSnowyBush = this.image("tiles/shortSnowyBush.png");
        this.tallSnowyBush = this.image("tiles/tallSnowyBush.png");
        this.lightBrick = this.image("tiles/brick/lightBrick.png");
        this.darkBrick = this.image("tiles/brick/darkBrick.png");
        this.stoneBrick = this.image("tiles/brick/stoneBrick.png");
        this.treeTopLeftEnd = this.image("tiles/tree/treeTopLeftEnd.png");
        this.treeTopMiddle = this.image("tiles/tree/treeTopMiddle.png");
        this.treeTopRightEnd = this.image("tiles/tree/treeTopRightEnd.png");
        this.treeBark = this.image("tiles/tree/treeBark.png");
    }

    private void spritesInit() throws Exception {
        this.platformLong = this.image("sprites/platforms/long.png");
        this.platformShort = this.image("sprites/platforms/short.png");
        this.platformExtraShort = this.image("sprites/platforms/extraShort.png");
    }

    private ImageIcon image(String imageName) throws Exception {
        ImageIcon image = null;
        try {
            byte[] imageBytes = Utilities.getBytes("lostLevelImages/" + imageName.substring(0, imageName.length() - 4), Game.class);
            Utilities.decrypt(imageBytes);
            image = new ImageIcon(imageBytes);
            if (image.getIconWidth() == -1) {
                this.validTextures = false;
                throw new RuntimeException("Invalid image: " + imageName);
            }
        }
        catch (Exception ex) {
            System.out.println("Problem with: " + imageName);
            throw new RuntimeException();
        }
        return image;
    }
}

