/*
 * Decompiled with CFR 0.152.
 */
package supermario.game;

import java.awt.Rectangle;
import javax.swing.ImageIcon;
import supermario.game.Game;
import supermario.game.Sprite;
import supermario.game.interfaces.Block;
import supermario.game.interfaces.Enemy;
import supermario.game.interfaces.EnemyHolder;
import supermario.game.interfaces.Friend;
import supermario.game.sprites.blocks.Brick;
import supermario.game.sprites.blocks.QuestionBox;
import supermario.game.sprites.blocks.SolidTestTile;
import supermario.game.sprites.enemies.Beetle;
import supermario.game.sprites.enemies.Goomba;
import supermario.game.sprites.enemies.GrayFish;
import supermario.game.sprites.enemies.HammerBro;
import supermario.game.sprites.enemies.Koopa;
import supermario.game.sprites.enemies.RedFish;
import supermario.game.sprites.enemies.Spiny;
import supermario.game.sprites.enemies.Squid;
import supermario.game.sprites.misc.ArrivalVine;
import supermario.game.sprites.misc.BowserBattle;
import supermario.game.sprites.misc.Cannon;
import supermario.game.sprites.misc.Checkpoint;
import supermario.game.sprites.misc.Flag;
import supermario.game.sprites.misc.InfiniteCorridor;
import supermario.game.sprites.misc.Pipe;
import supermario.game.sprites.misc.Platform;
import supermario.game.sprites.misc.Spring;

public class Tile {
    private Game game;
    public Sprite sprite;
    public ImageIcon image;
    public boolean solid;
    public boolean shiftOver;
    public boolean disabled;
    public boolean extendColor;
    public int rootXTile;
    public int rootYTile;
    public boolean removable;
    public int xTile;
    public int yTile;

    public Tile(Game game, int yTile, int xTile) {
        this.game = game;
        this.xTile = xTile;
        this.yTile = yTile;
    }

    public Tile(Game game, int yTile, int xTile, ImageIcon image, boolean shiftOver, boolean removable) {
        this.game = game;
        this.xTile = xTile;
        this.yTile = yTile;
        this.image = image;
        this.shiftOver = shiftOver;
        this.removable = removable;
    }

    public Tile(Game game, int yTile, int xTile, Sprite sprite) {
        this.game = game;
        this.xTile = xTile;
        this.yTile = yTile;
        this.setSprite(sprite);
    }

    public final void setSprite(Sprite sprite) {
        if (sprite == null) {
            return;
        }
        this.sprite = sprite;
        this.sprite.xTile = this.xTile;
        this.sprite.yTile = this.yTile;
        this.sprite.xPos = this.xTile * 8;
        this.sprite.yPos = this.yTile * 8 + this.sprite.avoidedCollisionRowsOnBottom;
        if (sprite instanceof ArrivalVine) {
            this.sprite.yPos = (Game.yTiles - 2) * 8;
        }
        this.sprite.finalizePosition();
        if (sprite instanceof Block) {
            ((Block)((Object)sprite)).setNormalYPosition(this.yTile * 8);
        }
    }

    public void update(double delta, int lastMobileEnemyTile) {
        if (this.sprite != null) {
            if (this.detachableSprite()) {
                if (!this.isMobileEnemy() || this.xTile <= lastMobileEnemyTile) {
                    if (this.sprite instanceof Pipe || this.sprite instanceof Cannon) {
                        this.flagTilesAsColorExtending();
                    }
                    this.sprite.releaseSprite(delta, this);
                    this.sprite = null;
                }
            } else if (this.sprite instanceof Block) {
                this.sprite.update(delta);
                if (this.sprite instanceof Brick && !this.sprite.visible) {
                    this.solid = false;
                }
                this.sprite.justHit = false;
            } else if (this.sprite instanceof ArrivalVine || this.sprite instanceof InfiniteCorridor || this.sprite instanceof SolidTestTile) {
                this.sprite.update(delta);
            }
        }
    }

    private void flagTilesAsColorExtending() {
        int t;
        boolean applies = true;
        if (this.sprite instanceof Pipe && (t = ((Pipe)this.sprite).type) != 11 && t != 2 && t != 3 && t != 6 && t != 7 && t != 4) {
            applies = false;
        }
        if (applies) {
            for (int i = this.xTile; i < this.xTile + this.sprite.tilesWidth; ++i) {
                for (int j = this.yTile; j < this.yTile + this.sprite.tilesHeight; ++j) {
                    if (j >= Game.yTiles || i >= this.game.level.tiles[0].length) continue;
                    this.game.level.tiles[j][i].extendColor = true;
                }
            }
        }
    }

    private boolean isMobileEnemy() {
        if (this.sprite == null) {
            return false;
        }
        return this.sprite instanceof Koopa || this.sprite instanceof Goomba || this.sprite instanceof Beetle || this.sprite instanceof GrayFish || this.sprite instanceof HammerBro || this.sprite instanceof RedFish || this.sprite instanceof Spiny || this.sprite instanceof Squid;
    }

    private boolean detachableSprite() {
        return this.sprite instanceof Checkpoint || this.sprite instanceof Enemy || this.sprite instanceof Friend || this.sprite instanceof EnemyHolder || this.sprite instanceof Pipe || this.sprite instanceof Platform || this.sprite instanceof Flag || this.sprite instanceof BowserBattle || this.sprite instanceof Spring;
    }

    public void bumped(Sprite bumper) {
        if (bumper.isOnScreen()) {
            if (this.sprite != null && this.sprite instanceof Block) {
                ((Block)((Object)this.sprite)).bumped(bumper);
            } else {
                this.game.audio.play(8);
            }
        }
    }

    public Rectangle getRectangle() {
        return new Rectangle(this.xTile * 8, this.yTile * 8, 8, 8);
    }

    public boolean isUnexposedHiddenTile() {
        if (this.sprite != null && this.sprite instanceof QuestionBox) {
            QuestionBox q = (QuestionBox)this.sprite;
            return q.hidden && !q.exposed;
        }
        return false;
    }

    public boolean isPermeableTile() {
        return !this.solid || this.isUnexposedHiddenTile();
    }
}

