/*
 * Decompiled with CFR 0.152.
 */
package supermario.game.sprites.blocks;

import java.awt.Rectangle;
import javax.swing.ImageIcon;
import supermario.Utilities;
import supermario.game.Game;
import supermario.game.Sprite;
import supermario.game.Warp;
import supermario.game.interfaces.Block;
import supermario.game.interfaces.Warpable;
import supermario.game.sprites.effects.BumpCoin;
import supermario.game.sprites.enemies.PoisonMushroom;
import supermario.game.sprites.friends.Flower;
import supermario.game.sprites.friends.Life;
import supermario.game.sprites.friends.Mushroom;
import supermario.game.sprites.friends.Star;
import supermario.game.sprites.misc.Beanstalk;

public class QuestionBox
extends Sprite
implements Block,
Warpable {
    public Warp warp;
    private boolean hit;
    private boolean metal;
    public boolean hidden;
    public boolean exposed;
    private int normalY;
    private int contents;
    private int shadowColor;
    public static int CONTENTS_COIN = 0;
    public static int CONTENTS_GROWTH = 2;
    public static int CONTENTS_EXTRA_LIFE = 3;
    public static int CONTENTS_STAR = 4;
    public static int CONTENTS_BEANSTALK = 5;
    public static int CONTENTS_POISON = 6;

    public QuestionBox(Game game, ImageIcon[] images, int shadowColor, int contents, boolean hidden) {
        super(game, images);
        this.shadowColor = shadowColor;
        this.contents = contents;
        this.hidden = hidden;
        this.exposed = false;
        if (hidden) {
            this.imageIndex = images.length - 1;
        } else if (shadowColor == 0) {
            this.imageIndex = 0;
        } else if (shadowColor == 1) {
            this.imageIndex = 3;
        } else if (shadowColor == 2) {
            this.imageIndex = 6;
        }
        this.settled = true;
    }

    @Override
    public Sprite reset() {
        return this;
    }

    @Override
    public void update(double delta) {
        this.ticks += delta;
        int pulseIndex = Utilities.getPulsingImageIndex();
        if (!this.hit && !this.hidden) {
            this.imageIndex = pulseIndex;
            if (this.shadowColor == 1) {
                this.imageIndex += 3;
            } else if (this.shadowColor == 2) {
                this.imageIndex += 6;
            }
        } else if (!this.hit && this.hidden) {
            this.imageIndex = this.images.length - 1;
        } else if (this.metal) {
            if (!this.hidden) {
                this.imageIndex = 9;
                if (this.shadowColor == 1) {
                    this.imageIndex = 10;
                } else if (this.shadowColor == 2) {
                    this.imageIndex = 11;
                }
            } else if (this.game.level.levelType == 0 || this.game.level.levelType == 4 || this.game.level.levelType == 3) {
                this.imageIndex = 9;
            } else if (this.game.level.levelType == 1) {
                this.imageIndex = 10;
            } else if (this.game.level.levelType == 2) {
                this.imageIndex = 11;
            }
        }
        if (this.hit && !this.settled) {
            this.applyGravity(delta, 80.0);
            if (this.yPos > (double)this.normalY) {
                this.yPos = this.normalY;
                this.settled = true;
                if (this.contents == CONTENTS_GROWTH && !this.game.mario.isLarge()) {
                    this.game.level.sprites.add(new Mushroom(this.game, new ImageIcon[]{this.game.textures.growMushroom}, this, false));
                } else if (this.contents == CONTENTS_GROWTH && this.game.mario.isLarge()) {
                    this.game.level.sprites.add(new Flower(this.game, this.game.textures.getFlowerTextures(), this));
                } else if (this.contents == CONTENTS_EXTRA_LIFE) {
                    this.game.level.sprites.add(new Life(this.game, new ImageIcon[]{this.game.textures.lightExtraLife, this.game.textures.darkExtraLife}, this));
                } else if (this.contents == CONTENTS_STAR) {
                    this.game.level.sprites.add(new Star(this.game, this.game.textures.getStarTextures(), this));
                } else if (this.contents == CONTENTS_BEANSTALK) {
                    this.game.level.sprites.add(new Beanstalk(this.game, this.game.textures.getBeanstalkTextures(), this));
                } else if (this.contents == CONTENTS_POISON) {
                    this.game.level.sprites.add(new PoisonMushroom(this.game, new ImageIcon[]{this.game.textures.poisonMushroom}, this));
                }
            }
        }
        this.y = (int)Math.round(this.yPos);
    }

    @Override
    public Rectangle getRectangle() {
        return null;
    }

    @Override
    public void bumped(Sprite sprite) {
        if (!this.isOnScreen()) {
            return;
        }
        if (this.settled && !this.metal) {
            this.hit = true;
            this.justHit = true;
            this.settled = false;
            this.metal = true;
            if (this.hidden) {
                this.exposed = true;
            }
            this.yVel = -36.0;
            if (this.contents == CONTENTS_COIN && this.isOnScreen()) {
                this.game.level.effects.add(new BumpCoin(this.game, this, sprite.isOnScreen()));
                this.game.mario.points += 200;
                ++this.game.mario.coins;
            }
        }
        if (sprite.isOnScreen()) {
            this.game.audio.play(8);
        }
    }

    @Override
    public void setNormalYPosition(int y) {
        this.normalY = y;
    }

    @Override
    public void setWarp(Warp warp) {
        this.warp = warp;
    }
}

