/*
 * Decompiled with CFR 0.152.
 */
package supermario.game.sprites.effects;

import java.awt.Graphics2D;
import javax.swing.ImageIcon;
import supermario.game.Game;
import supermario.game.interfaces.Effect;

public class AirBubble
implements Effect {
    private Game game;
    private ImageIcon image;
    private double yPos;
    private double yVel;
    private double ticks;
    private double theta;
    private int x;
    private int y;
    public static final int PERIOD = 1000;
    public static final int AMPLITUDE = 40;
    public static final int MIN_Y_VELOCITY = 16;

    public AirBubble(Game game) {
        this.game = game;
        this.image = game.textures.airBubble;
        this.yPos = game.mario.y + 8;
        this.x = game.mario.flip ? game.mario.x + 2 : game.mario.x + game.mario.width - 4;
        if (!game.mario.isLarge() || game.mario.spriteState == 11) {
            this.yPos += 8.0;
        }
        this.y = (int)Math.round(this.yPos);
    }

    @Override
    public void update(double delta) {
        this.ticks = (this.ticks + delta) % 1000.0;
        this.theta = this.ticks / 1000.0 * Math.PI - 1.5707963267948966;
        this.yVel = 40.0 * Math.cos(this.theta);
        if (this.yVel < 16.0) {
            this.yVel = 16.0;
        }
        this.yPos -= this.yVel * delta / 1000.0;
        this.y = (int)Math.round(this.yPos);
    }

    @Override
    public void draw(Graphics2D g2D) {
        g2D.drawImage(this.image.getImage(), this.x, this.y, null);
    }

    @Override
    public boolean isFinished() {
        return (double)this.y <= 28.0;
    }
}

