/*
 * Decompiled with CFR 0.152.
 */
package supermario.game.sprites.enemies;

import java.awt.Rectangle;
import javax.swing.ImageIcon;
import supermario.game.Game;
import supermario.game.Level;
import supermario.game.Sprite;
import supermario.game.interfaces.Enemy;
import supermario.game.interfaces.Shelled;
import supermario.game.sprites.effects.Points;

public class Bullet
extends Sprite
implements Enemy {
    public static double BULLET_SPEED = 80.0;
    public static double SHELL_KILLED_Y_VEL = -240.0;
    public static double BUMP_KILLED_GRAVITY = Level.GRAVITY / 5.0 * 3.0;
    private int shadowColor;

    public Bullet(Game game, ImageIcon[] images, int shadowColor, int x, int y, boolean headingLeft) {
        super(game, images);
        this.shadowColor = shadowColor;
        this.xPos = x;
        this.x = x;
        this.yPos = y;
        this.y = y;
        if (shadowColor == 0) {
            this.imageIndex = 0;
        } else if (shadowColor == 1) {
            this.imageIndex = 1;
        } else if (shadowColor == 2) {
            this.imageIndex = 2;
        }
        if (headingLeft) {
            this.flip = false;
            this.xVel = -BULLET_SPEED;
        } else {
            this.flip = true;
            this.xVel = BULLET_SPEED;
        }
    }

    @Override
    public Sprite reset() {
        return null;
    }

    @Override
    public void update(double delta) {
        this.preUpdate(delta);
        this.xPos += this.xVel * delta / 1000.0;
        if (this.bumpKilled) {
            this.applyGravity(delta, BUMP_KILLED_GRAVITY);
        }
        this.finalizePosition();
    }

    @Override
    public Rectangle getRectangle() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    @Override
    public Rectangle getSpriteContactRectangle() {
        return this.getRectangle();
    }

    @Override
    public void bumpKilled(Sprite killer) {
        this.smushed(killer);
    }

    @Override
    public void smushed(Sprite killer) {
        if (killer == this.game.mario) {
            if (this.game.mario.hasStar()) {
                this.game.audio.play(10);
            } else {
                this.game.audio.play(7);
            }
            this.game.mario.points += 200;
            this.game.level.effectsToAdd.add(new Points(this.game, this.x + this.width / 2, this.y, 1));
            this.yVel = 0.0;
        } else if (killer instanceof Shelled) {
            if (killer.isOnScreen()) {
                this.game.audio.play(10);
            }
            ((Shelled)((Object)killer)).shellKilled();
            this.yVel = SHELL_KILLED_Y_VEL;
        }
        this.xVel = 0.0;
        this.bumpKilled = true;
        this.collidable = false;
    }

    @Override
    public void xCollided() {
    }
}

