/*
 * Decompiled with CFR 0.152.
 */
package supermario.game.sprites.misc;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import supermario.game.Game;
import supermario.game.Sprite;
import supermario.game.Tile;
import supermario.game.interfaces.EnemyHolder;
import supermario.game.sprites.enemies.FireballEnemy;

public class Firebar
extends Sprite
implements EnemyHolder {
    public boolean clockwise;
    public boolean speedBoost;
    public boolean longFirebar;
    public ImageIcon metal;
    private int firebarCount;
    private static final int SHORT_FIREBALL_COUNT = 6;
    private static final int LONG_FIREBALL_COUNT = 12;
    public static double FIREBAR_PERIOD_SLOW = 3500.0;
    public static double FIREBAR_PERIOD_FAST = 2500.0;
    public static final double FIREBALL_IMAGE_CHANGE_DELAY = 70.0;

    public Firebar(Game game, ImageIcon[] images, boolean clockwise, boolean speedBoost, boolean longFirebar) {
        super(game, images);
        this.clockwise = clockwise;
        this.speedBoost = speedBoost;
        this.longFirebar = longFirebar;
        this.firebarCount = longFirebar ? 12 : 6;
        this.imageIndex = 0;
    }

    @Override
    public Sprite reset() {
        return new Firebar(this.game, this.images, this.clockwise, this.speedBoost, this.longFirebar);
    }

    public void activate(Tile tile) {
        this.setMetalType(tile);
        for (int i = 0; i < this.firebarCount; ++i) {
            this.game.level.sprites.add(new FireballEnemy(this.game, this, this.clockwise, this.speedBoost, 8 * i));
        }
    }

    private void setMetalType(Tile tile) {
        int levelType = this.game.level.levelType;
        if (levelType == 2) {
            this.metal = this.game.textures.stoneMetal;
        } else if (levelType == 0 || levelType == 4 || levelType == 5 || levelType == 6) {
            this.metal = this.game.textures.lightMetal;
        } else if (levelType == 1) {
            this.metal = this.game.textures.darkMetal;
        } else if (levelType == 3) {
            this.metal = null;
            tile.solid = false;
            this.game.level.tiles[tile.yTile][tile.xTile + 1].solid = false;
            this.game.level.tiles[tile.yTile + 1][tile.xTile].solid = false;
            this.game.level.tiles[tile.yTile + 1][tile.xTile + 1].solid = false;
        }
    }

    @Override
    public void update(double delta) {
    }

    @Override
    public void draw(Graphics2D g2D) {
        if (!this.visible || this.metal == null) {
            return;
        }
        this.transform.setToIdentity();
        this.transform.translate(this.x, this.y);
        g2D.drawImage(this.metal.getImage(), this.transform, null);
    }

    @Override
    public Rectangle getRectangle() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    @Override
    public void checkForUnsettledTiles() {
    }
}

