/*
 * Decompiled with CFR 0.152.
 */
package supermario.game.sprites.misc;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import supermario.game.Game;
import supermario.game.Sprite;
import supermario.game.Warp;
import supermario.game.interfaces.Warpable;

public class Flag
extends Sprite
implements Warpable {
    public Warp warp;
    public boolean caught;
    public boolean flagFinished;
    public boolean deductionSwitch;
    private double flagY;
    private double castleFlagY;
    private double normalCastleFlagY;
    private double timeStepDelta;
    private double secondsCollected;
    public double totalTimeLeft;
    private ImageIcon flag;
    private ImageIcon flagpole;
    private ImageIcon singleCloud;
    private ImageIcon singleBush;
    private ImageIcon smallHill;
    private ImageIcon castle;
    private ImageIcon lightGround;
    private ImageIcon castleFlag;
    private ImageIcon points;
    public boolean bigCastle;
    public int fireworksLeft;
    public int lastSecondLeftWholeNumber;
    public static final double FLAG_FALL_SPEED = 136.0;
    public static final int STATE_CATCH_FLAG = 0;
    public static final int STATE_SLIDE_DOWN_FLAG = 1;
    public static final int STATE_TURN_AROUND_AT_FLAG_BASE = 2;
    public static final int STATE_PLAY_VICTORY_MUSIC = 3;
    public static final int STATE_PREPARE_TO_WALK_TO_CASTLE = 4;
    public static final int STATE_WALK_TO_CASTLE = 5;
    public static final int STATE_DECIDE_ON_FIREWORKS = 6;
    public static final int STATE_SHOW_FIREWORKS = 7;
    public static final int STATE_RAISE_CASTLE_FLAG = 8;
    public static final int STATE_DEDUCT_TIME = 9;
    public static final int STATE_WARP_TO_NEXT_LEVEL = 10;
    public static final double EXCESS_TIME_MAX_LENGTH = 3000.0;
    public static final double TIME_DEDUCT_INTERVAL = 20.0;
    public static final double MINIMUM_TIME_STEP_DELTA = 0.6;
    public static final int POINTS_TO_SECONDS_EXCHANGE_RATE = 150;

    public Flag(Game game, boolean bigCastle, int pipeType) {
        super(game, new ImageIcon[]{game.textures.flag});
        this.bigCastle = bigCastle;
        this.flagpole = pipeType == 1 ? game.textures.flagpoleWhite : game.textures.flagpoleGreen;
        this.flag = game.textures.flag;
        this.singleCloud = game.textures.singleCloud;
        this.singleBush = game.textures.singleBush;
        this.smallHill = game.textures.smallHill;
        this.castle = bigCastle ? game.textures.largeCastle : game.textures.smallCastle;
        this.castleFlagY = this.normalCastleFlagY = 124.0;
        this.lightGround = game.textures.lightGround;
        this.castleFlag = game.textures.castleFlag;
        this.yPos = 0.0;
        this.y = 0;
        this.flagY = 40.0;
        this.flagFinished = false;
    }

    @Override
    public Sprite reset() {
        return null;
    }

    @Override
    public void update(double delta) {
        if (this.caught) {
            if (!this.flagFinished) {
                this.flagY += 136.0 * delta / 1000.0;
                if (this.flagY >= 168.0) {
                    this.flagY = 168.0;
                    this.flagFinished = true;
                }
            } else if (this.spriteState == 9) {
                this.ticks += delta;
                if (this.ticks >= 20.0) {
                    this.ticks %= 20.0;
                    if (this.deductionSwitch) {
                        this.game.mario.totalTime += this.timeStepDelta - 0.5;
                        this.secondsCollected += this.timeStepDelta - 0.5;
                    } else {
                        this.game.mario.totalTime += this.timeStepDelta + 0.5;
                        this.secondsCollected += this.timeStepDelta + 0.5;
                    }
                    boolean bl = this.deductionSwitch = !this.deductionSwitch;
                    if ((int)this.secondsCollected > this.lastSecondLeftWholeNumber) {
                        this.game.mario.points += 150;
                        ++this.lastSecondLeftWholeNumber;
                    }
                    if (this.secondsCollected >= this.totalTimeLeft) {
                        this.game.audio.stop(18);
                        this.spriteState = 8;
                    }
                }
            } else if (this.spriteState == 8 && this.normalCastleFlagY - this.castleFlagY < 20.0) {
                this.castleFlagY -= 34.0 * delta / 1000.0;
            }
        }
    }

    public void setPoints() {
        int pointsY = this.game.mario.y + this.game.mario.height - this.avoidedCollisionRowsOnBottom;
        if (pointsY >= 184) {
            this.game.mario.points += 100;
            this.points = this.game.textures.points100;
        } else if (pointsY >= 168) {
            this.game.mario.points += 200;
            this.points = this.game.textures.points200;
        } else if (pointsY >= 152) {
            this.game.mario.points += 400;
            this.points = this.game.textures.points400;
        } else if (pointsY >= 136) {
            this.game.mario.points += 500;
            this.points = this.game.textures.points500;
        } else if (pointsY >= 120) {
            this.game.mario.points += 800;
            this.points = this.game.textures.points800;
        } else if (pointsY >= 104) {
            this.game.mario.points += 1000;
            this.points = this.game.textures.points1000;
        } else if (pointsY >= 88) {
            this.game.mario.points += 2000;
            this.points = this.game.textures.points2000;
        } else {
            this.game.mario.points += 5000;
            this.points = this.game.textures.points5000;
        }
    }

    public void setExcessTime(int timeLeftInLevel) {
        this.totalTimeLeft = timeLeftInLevel;
        this.timeStepDelta = this.totalTimeLeft / 150.0;
        if (this.timeStepDelta < 0.6) {
            this.timeStepDelta = 0.6;
        }
    }

    public void setFireworks(int timeLeftInLevel) {
        int lastDigit;
        this.fireworksLeft = this.bigCastle ? 0 : ((lastDigit = timeLeftInLevel % 10) == 1 || lastDigit == 3 || lastDigit == 6 ? lastDigit : 0);
    }

    @Override
    public void draw(Graphics2D g2D) {
        this.transform.setToIdentity();
        this.transform.translate(this.x + 8, 32.0);
        g2D.drawImage(this.flagpole.getImage(), this.transform, null);
        this.transform.setToIdentity();
        this.transform.translate(this.x, (int)Math.round(this.flagY));
        g2D.drawImage(this.flag.getImage(), this.transform, null);
        this.transform.setToIdentity();
        this.transform.translate(this.x + 40, 32.0);
        g2D.drawImage(this.singleCloud.getImage(), this.transform, null);
        if (this.caught) {
            this.transform.setToIdentity();
            this.transform.translate(this.x + 16 + 2, 176 - ((int)Math.round(this.flagY) - 32));
            g2D.drawImage(this.points.getImage(), this.transform, null);
        }
        this.transform.setToIdentity();
        this.transform.translate(this.x + 128, 184.0);
        g2D.drawImage(this.singleBush.getImage(), this.transform, null);
        this.transform.setToIdentity();
        this.transform.translate(this.x + 168, 176.0);
        g2D.drawImage(this.smallHill.getImage(), this.transform, null);
        this.transform.setToIdentity();
        this.transform.translate(this.x + 104, this.castleFlagY);
        g2D.drawImage(this.castleFlag.getImage(), this.transform, null);
        this.transform.setToIdentity();
        this.transform.translate(this.x + 72, 0.0);
        if (this.bigCastle) {
            this.transform.translate(0.0, 24.0);
        } else {
            this.transform.translate(0.0, 120.0);
        }
        g2D.drawImage(this.castle.getImage(), this.transform, null);
        this.transform.setToIdentity();
        this.transform.translate(this.x, 200.0);
        int xTranslate = 16;
        for (int i = 0; i < Game.renderWidth / 8; ++i) {
            g2D.drawImage(this.lightGround.getImage(), this.transform, null);
            this.transform.translate(0.0, this.lightGround.getIconHeight());
            g2D.drawImage(this.lightGround.getImage(), this.transform, null);
            this.transform.translate(0.0, -this.lightGround.getIconHeight());
            this.transform.translate(xTranslate, 0.0);
        }
    }

    public Point getFireworkLocation() {
        if (this.fireworksLeft % 3 == 0) {
            return new Point(this.x + 120, 40);
        }
        if (this.fireworksLeft % 3 == 2) {
            return new Point(this.x + 56, 96);
        }
        if (this.fireworksLeft % 3 == 1) {
            return new Point(this.x + 176, 80);
        }
        return null;
    }

    @Override
    public Rectangle getRectangle() {
        return new Rectangle(this.x + 16 - 1, 24, 2, (Game.yTiles - 3 - 5) * 8);
    }

    @Override
    public void setWarp(Warp warp) {
        this.warp = warp;
    }
}

