/*
 * Decompiled with CFR 0.152.
 */
package supermario.game.sprites.misc;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import supermario.Utilities;
import supermario.game.Game;
import supermario.game.Sprite;
import supermario.game.sprites.misc.Pulley;

public class Platform
extends Sprite {
    public static final int PLATFORM_LONG_REP_UP = 0;
    public static final int PLATFORM_LONG_REP_DOWN = 1;
    public static final int PLATFORM_LONG_OSC_VERTICALLY = 2;
    public static final int PLATFORM_LONG_OSC_HORIZONTALLY = 3;
    public static final int PLATFORM_LONG_FALLING = 4;
    public static final int PLATFORM_SHORT_REP_UP = 5;
    public static final int PLATFORM_SHORT_REP_DOWN = 6;
    public static final int PLATFORM_SHORT_OSC_VERTICALLY = 7;
    public static final int PLATFORM_SHORT_OSC_HORIZONTALLY = 8;
    public static final int PLATFORM_SHORT_FALLING = 9;
    public static final int PLATFORM_EXTRA_SHORT_REP_UP = 10;
    public static final int PLATFORM_EXTRA_SHORT_REP_DOWN = 11;
    public static final int PLATFORM_CLOUD_CARRIER = 13;
    public static final int PLATFORM_PULLEY_LONG = 14;
    public static final int PLATFORM_PULLEY_SHORT = 15;
    public static double FALLING_PLATFORM_Y_VELOCITY = 136.0;
    public static double CLOUD_CARRIER_X_VELOCITY = 64.0;
    public static final int OSC_Y_AMPLITUDE = 9;
    public static final int OSC_X_AMPLITUDE = 6;
    public static int TOTAL_OSC_Y_PERIOD = 6000;
    public static int TOTAL_OSC_X_PERIOD = 4500;
    public static final int EXTRA_SHORT_PLATFORM_TILES = 3;
    public static final int SHORT_PLATFORM_TILES = 4;
    public static final int LONG_PLATFORM_TILES = 6;
    public static final int CARRIER_PLATFORM_TILES = 6;
    public double oscPeriod;
    public double oscYCenter;
    public double oscXCenter;
    public double xChange;
    public double yChange;
    public float startingOffset;
    public int type;
    public static double REPEATING_Y_VELOCITY = 64.0;
    public boolean carrierActive;
    public boolean carrierFinished;
    public boolean single;

    public Platform(Game game, ImageIcon[] images, int type, boolean single) {
        super(game, images);
        this.type = type;
        this.single = single;
        this.setRepeatingVelocity();
        if (type == 13) {
            this.xVel = 0.0;
            this.yVel = 0.0;
        }
        this.imageIndex = 0;
    }

    private void setRepeatingVelocity() {
        if (this.type == 0 || this.type == 5 || this.type == 10) {
            this.xVel = 0.0;
            this.yVel = -REPEATING_Y_VELOCITY;
        } else if (this.type == 1 || this.type == 6 || this.type == 11) {
            this.xVel = 0.0;
            this.yVel = REPEATING_Y_VELOCITY;
        } else if (this.type == 3 || this.type == 8) {
            this.yVel = 0.0;
        }
    }

    @Override
    public Sprite reset() {
        return new Platform(this.game, this.images, this.type, this.single);
    }

    public void activate() {
        if (!(this.single || this.type != 1 && this.type != 0 && this.type != 11 && this.type != 10 && this.type != 6 && this.type != 5)) {
            this.yPos = 0.0;
            Platform platform2 = new Platform(this.game, this.images, this.type, this.single);
            platform2.xPos = this.xPos;
            platform2.yPos = Game.renderHeight / 2;
            platform2.update(1.0);
            this.game.level.platforms.add(platform2);
            Platform platform3 = new Platform(this.game, this.images, this.type, this.single);
            platform3.xPos = this.xPos;
            platform3.yPos = Game.renderHeight;
            platform3.update(1.0);
            this.game.level.platforms.add(platform3);
        } else if (this.type == 7 || this.type == 2) {
            this.oscYCenter = this.yPos;
        } else if (this.type == 3 || this.type == 8) {
            this.oscXCenter = this.xPos;
        } else if (this.type == 14 || this.type == 15) {
            Platform sibling = new Platform(this.game, this.images, this.type, this.single);
            sibling.xPos = this.xPos + (double)this.width + 64.0;
            if (this.type == 15) {
                sibling.xPos += 16.0;
            }
            sibling.yPos = this.yPos + 32.0;
            sibling.finalizePosition();
            this.game.level.platforms.add(sibling);
            Pulley pulley = new Pulley(this.game, new ImageIcon[]{this.game.textures.pulley}, this, sibling);
            pulley.xPos = this.xPos + (double)(this.width / 2) - 8.0;
            pulley.yPos = this.yPos - 64.0 - 1.0;
            pulley.finalizePosition();
            this.game.level.pulleys.add(pulley);
            this.finalizePosition();
        }
        this.update(1.0);
        this.game.level.platformsToAdd.add(this);
    }

    @Override
    public void update(double delta) {
        this.lastX = this.x;
        this.lastY = this.yPos;
        if (this.isRepeatingPlatform()) {
            this.setRepeatingVelocity();
            this.xPos += this.xVel * delta / 1000.0;
            this.yPos += this.yVel * delta / 1000.0;
            this.checkForReposition();
        } else if (this.type == 14 || this.type == 15) {
            this.yPos += this.yVel * delta / 1000.0;
        } else if (this.isOscillatingPlatform()) {
            this.setOscillatingPosition();
        } else if (this.isFallingPlatform()) {
            Platform platform = this.game.mario.onPlatform();
            if (platform == this && this.marioStandingOnThisPlatform()) {
                this.yVel = FALLING_PLATFORM_Y_VELOCITY;
                this.yPos += this.yVel * delta / 1000.0;
            } else {
                this.yVel = 0.0;
            }
        } else if (this.type == 13) {
            Platform platform;
            if (!this.carrierActive && !this.carrierFinished && (platform = this.game.mario.onPlatform()) == this && this.marioStandingOnThisPlatform() && this.game.mario.yVel > 0.0 && this.game.mario.lastY + (double)this.game.mario.height - (double)this.game.mario.avoidedCollisionRowsOnBottom <= (double)platform.y) {
                this.carrierActive = true;
                this.xVel = CLOUD_CARRIER_X_VELOCITY;
            }
            if (this.carrierActive && !this.carrierFinished) {
                this.xPos += this.xVel * delta / 1000.0;
                this.xChange = (double)Math.round(this.xPos) - this.lastX;
                if (this.isColliding() || this.isInPathOfPlatform() || this.game.level.maxTravelX >= 0 && this.x + this.width > this.game.level.maxTravelX || this.x + this.width > this.game.level.xTiles * 8) {
                    this.carrierFinished = true;
                    this.xPos -= this.xVel * delta / 1000.0;
                    this.xVel = 0.0;
                    this.xChange = 0.0;
                }
            }
        }
        this.finalizePosition();
    }

    private boolean isInPathOfPlatform() {
        for (Platform p : this.game.level.platforms) {
            int lmp = this.leftMostPoint(p);
            if (this.x + this.width <= lmp || this.x >= lmp || !this.withinVerticalRange(p)) continue;
            return true;
        }
        return false;
    }

    private int leftMostPoint(Platform p) {
        if (p.isVerticalMotionPlatform() || p.isPulleyPlatform()) {
            return p.x - 16;
        }
        if (p.isHorizontallyOscillatingPlatform()) {
            return (p.xTile - 6 - 2) * 8;
        }
        return this.game.level.xTiles * 8;
    }

    private boolean withinVerticalRange(Platform p) {
        int padding = this.game.mario.tilesHeight;
        if (p.isRepeatingPlatform()) {
            return true;
        }
        if (p.isFallingPlatform() && this.yTile >= p.yTile - padding) {
            return true;
        }
        if (p.isVerticallyOscillatingPlatform() && this.yTile >= p.yTile - 9 - padding && this.yTile <= p.yTile + 9 + padding) {
            return true;
        }
        if (p.isPulleyPlatform() && this.yTile >= p.yTile - 6 - padding) {
            return true;
        }
        return p.isHorizontallyOscillatingPlatform() && this.yTile >= p.yTile - padding && this.yTile <= p.yTile + padding;
    }

    public boolean marioStandingOnThisPlatform() {
        if (this.game.mario.transitioning && this.game.mario.transitionState == 3) {
            return false;
        }
        Rectangle marioRect = this.game.mario.getRectangle();
        if (marioRect.y + marioRect.height <= this.y + this.height) {
            if (this.game.mario.lastX + (double)this.game.mario.width - (double)this.game.mario.avoidedCollisionCols > (double)this.x) {
                return this.game.mario.lastX + (double)this.game.mario.avoidedCollisionCols < (double)(this.x + this.width);
            }
            return false;
        }
        return false;
    }

    public void drawLine(Graphics2D g2D) {
        g2D.setColor(Color.WHITE);
        g2D.setStroke(new BasicStroke(2.0f));
        g2D.drawLine(this.getXCenter(), 0, this.getXCenter(), Game.renderHeight);
    }

    private void setOscillatingPosition() {
        if (this.type == 2 || this.type == 7) {
            this.oscPeriod = Utilities.getYPlatformOscillationPeriod();
            double theta = (this.oscPeriod + (double)((float)TOTAL_OSC_Y_PERIOD * this.startingOffset)) % (double)TOTAL_OSC_Y_PERIOD / (double)TOTAL_OSC_Y_PERIOD * Math.PI * 2.0;
            this.yPos = Math.round(this.oscYCenter + 72.0 * Math.sin(theta));
            this.yChange = this.yPos - this.lastY;
            this.yVel = 72.0 * Math.cos(theta);
        } else if (this.type == 3 || this.type == 8) {
            this.oscPeriod = Utilities.getXPlatformOscillationPeriod();
            double theta = (this.oscPeriod + (double)((float)TOTAL_OSC_X_PERIOD * this.startingOffset)) % (double)TOTAL_OSC_X_PERIOD / (double)TOTAL_OSC_X_PERIOD * Math.PI * 2.0;
            this.xPos = Math.round(this.oscXCenter + 48.0 * -Math.sin(theta));
            this.xChange = this.xPos - this.lastX;
            this.xVel = 48.0 * -Math.cos(theta);
        }
    }

    private void checkForReposition() {
        if (this.single) {
            if ((this.type == 1 || this.type == 6 || this.type == 11) && this.yPos > (double)(Game.renderHeight + this.game.mario.height)) {
                this.yPos = -this.height;
            } else if ((this.type == 0 || this.type == 5 || this.type == 10) && this.yPos < (double)(0 - this.height)) {
                this.yPos = Game.renderHeight + this.game.mario.height;
            }
        } else if ((this.type == 1 || this.type == 6 || this.type == 11) && this.yPos > (double)(Game.renderHeight + Game.renderHeight / 4)) {
            this.yPos = -Game.renderHeight / 4;
        } else if ((this.type == 0 || this.type == 5 || this.type == 10) && this.yPos < (double)(0 - this.height)) {
            this.yPos += (double)(Game.renderHeight / 2 * 3);
        }
    }

    public boolean isExtraShortPlatform() {
        return this.type == 11 || this.type == 10;
    }

    public boolean isRepeatingPlatform() {
        if (this.type == 1 || this.type == 6 || this.type == 11) {
            return true;
        }
        return this.type == 0 || this.type == 5 || this.type == 10;
    }

    public boolean isPulleyPlatform() {
        return this.type == 15 || this.type == 14;
    }

    public boolean isFallingPlatform() {
        return this.type == 4 || this.type == 9;
    }

    public boolean isOscillatingPlatform() {
        return this.type == 3 || this.type == 2 || this.type == 8 || this.type == 7;
    }

    public boolean isHorizontallyOscillatingPlatform() {
        return this.type == 3 || this.type == 8;
    }

    public boolean isVerticallyOscillatingPlatform() {
        return this.type == 2 || this.type == 7;
    }

    public boolean isVerticalMotionPlatform() {
        if (this.type == 11 || this.type == 10 || this.type == 4) {
            return true;
        }
        if (this.type == 1 || this.type == 0 || this.type == 9) {
            return true;
        }
        return this.type == 6 || this.type == 5 || this.type == 2 || this.type == 7;
    }

    @Override
    public Rectangle getRectangle() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }
}

